/**
 * @license
 * Copyright 2024 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
function e(e,t){return t.forEach((function(t){t&&"string"!=typeof t&&!Array.isArray(t)&&Object.keys(t).forEach((function(n){if("default"!==n&&!(n in e)){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})}}))})),Object.freeze(e)}class t{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class n{refCount(e){return s("refCount")}incRef(e){return s("incRef")}timerAvailable(){return!0}time(e){return s("time")}read(e){return s("read")}readSync(e){return s("readSync")}readToGPU(e,t){return s("readToGPU")}numDataIds(){return s("numDataIds")}disposeData(e,t){return s("disposeData")}write(e,t,n){return s("write")}move(e,t,n,r,a){return s("move")}createTensorFromGPUData(e,t,n){return s("createTensorFromGPUData")}memory(){return s("memory")}floatPrecision(){return s("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return s("dispose")}}function s(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,o(e,t,n)}function a(e,t,n){return Math.max(e,Math.min(t,n))}function i(e){return e%2==0?e:e+1}function o(e,t,n){const s=e[t];e[t]=e[n],e[n]=s}function l(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t}function u(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function c(e,t,n=""){u(f(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function h(e){u(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function p(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(null!==e[n]&&null!==t[n]&&e[n]!==t[n])return!1;return!0}function f(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function m(e){return e%1==0}function g(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]}function y(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function b(e,t=(e=>0),n,s){return new Promise(((r,a)=>{let i=0;const o=()=>{if(e())return void r();i++;const l=t(i);null!=n&&i>=n?a():null!=s?s(o,l):setTimeout(o,l)};o()}))}function x(e,t){let n=1,s=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${t}`);s=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===s){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const r=e.slice();return r[s]=t/n,r}function w(e,t){const n=t.length;return u((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),u(e.every((e=>m(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function v(e,t){const n=[],s=[],r=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||r?null:w(t,e).sort();let i=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[i]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[i]||a[i]>t)&&1===e[t]&&(n.push(e[t]),s.push(t)),a[i]<=t&&i++}1!==e[t]&&(n.push(e[t]),s.push(t))}return{newShape:n,keptDims:s}}function k(e,t){return N(e,t)}function N(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function I(e,t){for(let n=0;n<e.length;n++){const s=e[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${t} being uploaded contains ${s}.`)}}function S(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function T(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function C(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function $(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function E(e){return"string"==typeof e||e instanceof String}function A(e){return"boolean"==typeof e}function R(e){return"number"==typeof e}function _(e){return Array.isArray(e)?_(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":R(e)?"float32":E(e)?"string":A(e)?"bool":"float32"}function F(e){return!!(e&&e.constructor&&e.call&&e.apply)}function D(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function O(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let s=t-3;s>=0;--s)n[s]=n[s+1]*e[s+1];return n}function M(e,t,n,s=!1){const r=new Array;if(1===t.length){const a=t[0]*(s?2:1);for(let t=0;t<a;t++)r[t]=n[e+t]}else{const a=t[0],i=t.slice(1),o=i.reduce(((e,t)=>e*t))*(s?2:1);for(let t=0;t<a;t++)r[t]=M(e+t*o,i,n,s)}return r}function L(e,t,n=!1){if(0===e.length)return t[0];const s=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===s)return[];if(s!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return M(0,e,t,n)}function z(e,t){if(Array.isArray(e))return e;if("float32"===t)return e instanceof Float32Array?e:new Float32Array(e);if("int32"===t)return e instanceof Int32Array?e:new Int32Array(e);if("bool"===t||"string"===t)return Uint8Array.from(new Int32Array(e));throw new Error(`Unknown dtype ${t}`)}function P(e,t){const n=B(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function B(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function W(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return L(e,new Float32Array(n));if("int32"===t)return L(e,new Int32Array(n));if("bool"===t)return L(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)}function V(e){e.forEach((t=>{u(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function U(e,t,n){if(0===t)return 0;if(1===t)return e[0];let s=e[e.length-1];for(let t=0;t<e.length-1;++t)s+=n[t]*e[t];return s}function G(e,t,n){if(0===t)return[];if(1===t)return[e];const s=new Array(t);for(let t=0;t<s.length-1;++t)s[t]=Math.floor(e/n[t]),e-=s[t]*n[t];return s[s.length-1]=e,s}function H(e){return e&&e.then&&"function"==typeof e.then}class j{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=q,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(H(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getString(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){const n=t.toLowerCase();return"true"===n||"false"===n?"true"===n:""+ +n===n?+n:t}(0,n)}))}}}function q(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function K(){return Y}let X,Y=null;function Z(){if(null==X){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}X=e}return X}function J(e,t){const n=function(){const e=Z();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const s=t();return n.set(e,s),n.get(e)}}const Q="Abs",ee="Acos",te="Acosh",ne="Add",se="AddN",re="All",ae="Any",ie="ArgMax",oe="ArgMin",le="Asin",ue="Asinh",ce="Atan",he="Atanh",pe="Atan2",de="AvgPool",fe="AvgPoolGrad",me="AvgPool3D",ge="AvgPool3DGrad",ye="BatchMatMul",be="BatchToSpaceND",xe="Bincount",we="BitwiseAnd",ve="BroadcastTo",ke="BroadcastArgs",Ne="Cast",Ie="Ceil",Se="ClipByValue",Te="Complex",Ce="ComplexAbs",$e="Concat",Ee="Conv2D",Ae="Conv2DBackpropFilter",Re="Conv2DBackpropInput",_e="Conv3D",Fe="Conv3DBackpropFilterV2",De="Conv3DBackpropInputV2",Oe="Cos",Me="Cosh",Le="Cumprod",ze="Cumsum",Pe="CropAndResize",Be="DenseBincount",We="DepthToSpace",Ve="DepthwiseConv2dNative",Ue="DepthwiseConv2dNativeBackpropFilter",Ge="DepthwiseConv2dNativeBackpropInput",He="Diag",je="Dilation2D",qe="Dilation2DBackpropInput",Ke="Dilation2DBackpropFilter",Xe="Draw",Ye="RealDiv",Ze="Einsum",Je="Elu",Qe="EluGrad",et="Erf",tt="Equal",nt="Exp",st="ExpandDims",rt="Expm1",at="FFT",it="Fill",ot="FlipLeftRight",lt="Floor",ut="FloorDiv",ct="FusedBatchNorm",ht="GatherV2",pt="GatherNd",dt="Greater",ft="GreaterEqual",mt="Identity",gt="IFFT",yt="Imag",bt="IsFinite",xt="IsInf",wt="IsNan",vt="LeakyRelu",kt="Less",Nt="LessEqual",It="LinSpace",St="Log",Tt="Log1p",Ct="LogicalAnd",$t="LogicalNot",Et="LogicalOr",At="LogicalXor",Rt="LogSoftmax",_t="LowerBound",Ft="LRN",Dt="LRNGrad",Ot="MatrixBandPart",Mt="Max",Lt="Maximum",zt="MaxPool",Pt="MaxPoolGrad",Bt="MaxPool3D",Wt="MaxPool3DGrad",Vt="MaxPoolWithArgmax",Ut="Mean",Gt="Min",Ht="Minimum",jt="MirrorPad",qt="Mod",Kt="Multinomial",Xt="Multiply",Yt="Neg",Zt="NotEqual",Jt="NonMaxSuppressionV3",Qt="NonMaxSuppressionV4",en="NonMaxSuppressionV5",tn="OnesLike",nn="OneHot",sn="Pack",rn="PadV2",an="Pool",on="Pow",ln="Prelu",un="Prod",cn="RaggedGather",hn="RaggedRange",pn="RaggedTensorToTensor",dn="Range",fn="Real",mn="Reciprocal",gn="Relu",yn="Reshape",bn="ResizeNearestNeighbor",xn="ResizeNearestNeighborGrad",wn="ResizeBilinear",vn="ResizeBilinearGrad",kn="Relu6",Nn="Reverse",In="Round",Sn="Rsqrt",Tn="ScatterNd",Cn="TensorScatterUpdate",$n="SearchSorted",En="Select",An="Selu",Rn="Slice",_n="Sin",Fn="Sinh",Dn="Sign",On="Sigmoid",Mn="Softplus",Ln="Sqrt",zn="Sum",Pn="SpaceToBatchND",Bn="SplitV",Wn="Softmax",Vn="SparseFillEmptyRows",Un="SparseReshape",Gn="SparseSegmentMean",Hn="SparseSegmentSum",jn="SparseToDense",qn="SquaredDifference",Kn="Square",Xn="StaticRegexReplace",Yn="StridedSlice",Zn="StringNGrams",Jn="StringSplit",Qn="StringToHashBucketFast",es="Sub",ts="Tan",ns="Tanh",ss="Tile",rs="TopK",as="Transform",is="Transpose",os="Unique",ls="Unpack",us="UnsortedSegmentSum",cs="UpperBound",hs="ZerosLike",ps="Step",ds="FromPixels",fs="RotateWithOffset",ms="_FusedMatMul",gs="FusedConv2D",ys="FusedDepthwiseConv2D";function bs(...e){K().getBool("IS_TEST")||K().getBool("PROD")||console.warn(...e)}const xs=J("kernelRegistry",(()=>new Map)),ws=J("gradRegistry",(()=>new Map));function vs(e,t){const n=Es(e,t);return xs.get(n)}function ks(e){return ws.get(e)}function Ns(e){const t=xs.entries(),n=[];for(;;){const{done:s,value:r}=t.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===e&&n.push(i)}return n}function Is(e){const{kernelName:t,backendName:n}=e,s=Es(t,n);xs.has(s)&&bs(`The kernel '${t}' for backend '${n}' is already registered`),xs.set(s,e)}function Ss(e){const{kernelName:t}=e;ws.has(t)&&K().getBool("DEBUG")&&bs(`Overriding the gradient for '${t}'`),ws.set(t,e)}function Ts(e,t){const n=Es(e,t);if(!xs.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);xs.delete(n)}function Cs(e){if(!ws.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);ws.delete(e)}function $s(e,t){Ns(e).forEach((e=>{Is(Object.assign({},e,{backendName:t}))}))}function Es(e,t){return`${t}_${e}`}function As(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}var Rs="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function _s(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var Fs=Os,Ds=null;try{Ds=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function Os(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function Ms(e){return!0===(e&&e.__isLong__)}Os.prototype.__isLong__,Object.defineProperty(Os.prototype,"__isLong__",{value:!0}),Os.isLong=Ms;var Ls={},zs={};function Ps(e,t){var n,s,r;return t?(r=0<=(e>>>=0)&&e<256)&&(s=zs[e])?s:(n=Ws(e,(0|e)<0?-1:0,!0),r&&(zs[e]=n),n):(r=-128<=(e|=0)&&e<128)&&(s=Ls[e])?s:(n=Ws(e,e<0?-1:0,!1),r&&(Ls[e]=n),n)}function Bs(e,t){if(isNaN(e))return t?Ys:Xs;if(t){if(e<0)return Ys;if(e>=js)return tr}else{if(e<=-qs)return nr;if(e+1>=qs)return er}return e<0?Bs(-e,t).neg():Ws(e%Hs|0,e/Hs|0,t)}function Ws(e,t,n){return new Os(e,t,n)}Os.fromInt=Ps,Os.fromNumber=Bs,Os.fromBits=Ws;var Vs=Math.pow;function Us(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Xs;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return Us(e.substring(1),t,n).neg();for(var r=Bs(Vs(n,8)),a=Xs,i=0;i<e.length;i+=8){var o=Math.min(8,e.length-i),l=parseInt(e.substring(i,i+o),n);if(o<8){var u=Bs(Vs(n,o));a=a.mul(u).add(Bs(l))}else a=(a=a.mul(r)).add(Bs(l))}return a.unsigned=t,a}function Gs(e,t){return"number"==typeof e?Bs(e,t):"string"==typeof e?Us(e,t):Ws(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}Os.fromString=Us,Os.fromValue=Gs;var Hs=4294967296,js=Hs*Hs,qs=js/2,Ks=Ps(1<<24),Xs=Ps(0);Os.ZERO=Xs;var Ys=Ps(0,!0);Os.UZERO=Ys;var Zs=Ps(1);Os.ONE=Zs;var Js=Ps(1,!0);Os.UONE=Js;var Qs=Ps(-1);Os.NEG_ONE=Qs;var er=Ws(-1,2147483647,!1);Os.MAX_VALUE=er;var tr=Ws(-1,-1,!0);Os.MAX_UNSIGNED_VALUE=tr;var nr=Ws(0,-2147483648,!1);Os.MIN_VALUE=nr;var sr=Os.prototype;sr.toInt=function(){return this.unsigned?this.low>>>0:this.low},sr.toNumber=function(){return this.unsigned?(this.high>>>0)*Hs+(this.low>>>0):this.high*Hs+(this.low>>>0)},sr.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(nr)){var t=Bs(e),n=this.div(t),s=n.mul(t).sub(this);return n.toString(e)+s.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var r=Bs(Vs(e,6),this.unsigned),a=this,i="";;){var o=a.div(r),l=(a.sub(o.mul(r)).toInt()>>>0).toString(e);if((a=o).isZero())return l+i;for(;l.length<6;)l="0"+l;i=""+l+i}},sr.getHighBits=function(){return this.high},sr.getHighBitsUnsigned=function(){return this.high>>>0},sr.getLowBits=function(){return this.low},sr.getLowBitsUnsigned=function(){return this.low>>>0},sr.getNumBitsAbs=function(){if(this.isNegative())return this.eq(nr)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},sr.isZero=function(){return 0===this.high&&0===this.low},sr.eqz=sr.isZero,sr.isNegative=function(){return!this.unsigned&&this.high<0},sr.isPositive=function(){return this.unsigned||this.high>=0},sr.isOdd=function(){return 1==(1&this.low)},sr.isEven=function(){return 0==(1&this.low)},sr.equals=function(e){return Ms(e)||(e=Gs(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},sr.eq=sr.equals,sr.notEquals=function(e){return!this.eq(e)},sr.neq=sr.notEquals,sr.ne=sr.notEquals,sr.lessThan=function(e){return this.comp(e)<0},sr.lt=sr.lessThan,sr.lessThanOrEqual=function(e){return this.comp(e)<=0},sr.lte=sr.lessThanOrEqual,sr.le=sr.lessThanOrEqual,sr.greaterThan=function(e){return this.comp(e)>0},sr.gt=sr.greaterThan,sr.greaterThanOrEqual=function(e){return this.comp(e)>=0},sr.gte=sr.greaterThanOrEqual,sr.ge=sr.greaterThanOrEqual,sr.compare=function(e){if(Ms(e)||(e=Gs(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},sr.comp=sr.compare,sr.negate=function(){return!this.unsigned&&this.eq(nr)?nr:this.not().add(Zs)},sr.neg=sr.negate,sr.add=function(e){Ms(e)||(e=Gs(e));var t=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,a=e.high>>>16,i=65535&e.high,o=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=r+(65535&e.low))>>>16,u+=(c+=s+o)>>>16,l+=(u+=n+i)>>>16,l+=t+a,Ws((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},sr.subtract=function(e){return Ms(e)||(e=Gs(e)),this.add(e.neg())},sr.sub=sr.subtract,sr.multiply=function(e){if(this.isZero())return Xs;if(Ms(e)||(e=Gs(e)),Ds)return Ws(Ds.mul(this.low,this.high,e.low,e.high),Ds.get_high(),this.unsigned);if(e.isZero())return Xs;if(this.eq(nr))return e.isOdd()?nr:Xs;if(e.eq(nr))return this.isOdd()?nr:Xs;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(Ks)&&e.lt(Ks))return Bs(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,a=e.high>>>16,i=65535&e.high,o=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,p=0;return h+=(p+=r*l)>>>16,c+=(h+=s*l)>>>16,h&=65535,c+=(h+=r*o)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=s*o)>>>16,c&=65535,u+=(c+=r*i)>>>16,u+=t*l+n*o+s*i+r*a,Ws((h&=65535)<<16|(p&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},sr.mul=sr.multiply,sr.divide=function(e){if(Ms(e)||(e=Gs(e)),e.isZero())throw Error("division by zero");var t,n,s;if(Ds)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?Ws((this.unsigned?Ds.div_u:Ds.div_s)(this.low,this.high,e.low,e.high),Ds.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Ys:Xs;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return Ys;if(e.gt(this.shru(1)))return Js;s=Ys}else{if(this.eq(nr))return e.eq(Zs)||e.eq(Qs)?nr:e.eq(nr)?Zs:(t=this.shr(1).div(e).shl(1)).eq(Xs)?e.isNegative()?Zs:Qs:(n=this.sub(e.mul(t)),s=t.add(n.div(e)));if(e.eq(nr))return this.unsigned?Ys:Xs;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();s=Xs}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var r=Math.ceil(Math.log(t)/Math.LN2),a=r<=48?1:Vs(2,r-48),i=Bs(t),o=i.mul(e);o.isNegative()||o.gt(n);)o=(i=Bs(t-=a,this.unsigned)).mul(e);i.isZero()&&(i=Zs),s=s.add(i),n=n.sub(o)}return s},sr.div=sr.divide,sr.modulo=function(e){return Ms(e)||(e=Gs(e)),Ds?Ws((this.unsigned?Ds.rem_u:Ds.rem_s)(this.low,this.high,e.low,e.high),Ds.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},sr.mod=sr.modulo,sr.rem=sr.modulo,sr.not=function(){return Ws(~this.low,~this.high,this.unsigned)},sr.and=function(e){return Ms(e)||(e=Gs(e)),Ws(this.low&e.low,this.high&e.high,this.unsigned)},sr.or=function(e){return Ms(e)||(e=Gs(e)),Ws(this.low|e.low,this.high|e.high,this.unsigned)},sr.xor=function(e){return Ms(e)||(e=Gs(e)),Ws(this.low^e.low,this.high^e.high,this.unsigned)},sr.shiftLeft=function(e){return Ms(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Ws(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Ws(0,this.low<<e-32,this.unsigned)},sr.shl=sr.shiftLeft,sr.shiftRight=function(e){return Ms(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Ws(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Ws(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},sr.shr=sr.shiftRight,sr.shiftRightUnsigned=function(e){if(Ms(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?Ws(this.low>>>e|t<<32-e,t>>>e,this.unsigned):Ws(32===e?t:t>>>e-32,0,this.unsigned)},sr.shru=sr.shiftRightUnsigned,sr.shr_u=sr.shiftRightUnsigned,sr.toSigned=function(){return this.unsigned?Ws(this.low,this.high,!1):this},sr.toUnsigned=function(){return this.unsigned?this:Ws(this.low,this.high,!0)},sr.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},sr.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},sr.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},Os.fromBytes=function(e,t,n){return n?Os.fromBytesLE(e,t):Os.fromBytesBE(e,t)},Os.fromBytesLE=function(e,t){return new Os(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},Os.fromBytesBE=function(e,t){return new Os(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};var rr=_s(Fs);const ar=rr||e({__proto__:null,default:rr},[Fs]);function ir(e){return ar.fromString(e,!0,16)}const or=ir("c3a5c85c97cb3127"),lr=ir("b492b66fbe98f273"),ur=ir("9ae16a3b2f90404f");function cr(e){return e.xor(e.shru(47))}function hr(e,t,n){const s=e.slice(t,t+n);return ar.fromBytes(Array.from(s),!0,!0)}function pr(e,t){return hr(e,t,8)}function dr(e,t){return hr(e,t,4)}function fr(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function mr(e,t,n=ir("9ddfea08eb382d69")){let s=e.xor(t).mul(n);s=s.xor(s.shru(47));let r=t.xor(s).mul(n);return r=r.xor(r.shru(47)),r=r.mul(n),r}function gr(e,t,n,s){return function(e,t,n,s,r,a){r=r.add(e),a=fr(a.add(r).add(s),21);const i=r;return r=(r=r.add(t)).add(n),a=a.add(fr(r,44)),[r.add(s),a.add(i)]}(pr(e,t),pr(e,t+8),pr(e,t+16),pr(e,t+24),n,s)}function yr(e,t=e.length){const n=ar.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=ur.add(2*t),s=pr(e,0).add(ur),r=pr(e,t-8);return mr(fr(r,37).mul(n).add(s),fr(s,25).add(r).mul(n),n)}if(t>=4){const n=ur.add(2*t);return mr(dr(e,0).shl(3).add(t),dr(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),s=t+(e[t-1]<<2);return cr(ur.mul(n).xor(or.mul(s))).mul(ur)}return ur}(e,t):function(e,t=e.length){const n=ur.add(2*t),s=pr(e,0).mul(lr),r=pr(e,8),a=pr(e,t-8).mul(n),i=pr(e,t-16).mul(ur);return mr(fr(s.add(r),43).add(fr(a,30)).add(i),s.add(fr(r.add(ur),18)).add(a),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=ur.add(2*t),s=pr(e,0).mul(ur),r=pr(e,8),a=pr(e,t-8).mul(n),i=pr(e,t-16).mul(ur),o=fr(s.add(r),43).add(fr(a,30)).add(i),l=mr(o,s.add(fr(r.add(ur),18)).add(a),n),u=pr(e,16).mul(n),c=pr(e,24),h=o.add(pr(e,t-32)).mul(n),p=l.add(pr(e,t-24)).mul(n);return mr(fr(u.add(c),43).add(fr(h,30)).add(p),u.add(fr(c.add(s),18)).add(h),n)}(e,t);let s=n,r=n.mul(lr).add(113),a=cr(r.mul(ur).add(113)).mul(ur),i=[ar.UZERO,ar.UZERO],o=[ar.UZERO,ar.UZERO];s=s.mul(ur).add(pr(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{s=fr(s.add(r).add(i[0]).add(pr(e,l+8)),37).mul(lr),r=fr(r.add(i[1]).add(pr(e,l+48)),42).mul(lr),s=s.xor(o[1]),r=r.add(i[0]).add(pr(e,l+40)),a=fr(a.add(o[0]),33).mul(lr),i=gr(e,l,i[1].mul(lr),s.add(o[0])),o=gr(e,l+32,a.add(o[1]),r.add(pr(e,l+16))),[a,s]=[s,a],l+=64}while(l!==u);const h=lr.add(a.and(255).shl(1));return l=c,o[0]=o[0].add(t-1&63),i[0]=i[0].add(o[0]),o[0]=o[0].add(i[0]),s=fr(s.add(r).add(i[0]).add(pr(e,l+8)),37).mul(h),r=fr(r.add(i[1]).add(pr(e,l+48)),42).mul(h),s=s.xor(o[1].mul(9)),r=r.add(i[0].mul(9).add(pr(e,l+40))),a=fr(a.add(o[0]),33).mul(h),i=gr(e,l,i[1].mul(h),s.add(o[0])),o=gr(e,l+32,a.add(o[1]),r.add(pr(e,l+16))),[a,s]=[s,a],mr(mr(i[0],o[0],h).add(cr(r).mul(or)).add(a),mr(i[1],o[1],h).add(s),h)}function br(e,t){return"string"===t?kr(e):xr([e],t)}function xr(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=Sr(e)),K().getBool("DEBUG")&&I(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function wr(){return K().platform.now()}function vr(e,t){return K().platform.fetch(e,t)}function kr(e,t="utf-8"){return t=t||"utf-8",K().platform.encode(e,t)}function Nr(e,t="utf-8"){return t=t||"utf-8",K().platform.decode(e,t)}function Ir(e){return null!=K().platform.isTypedArray?K().platform.isTypedArray(e):As(e)}function Sr(e,t=[],n=!1){if(null==t&&(t=[]),"boolean"==typeof e||"number"==typeof e||"string"==typeof e||H(e)||null==e||Ir(e)&&n)t.push(e);else if(Array.isArray(e)||Ir(e))for(let s=0;s<e.length;++s)Sr(e[s],t,n);else{let s=-1;for(const t of Object.keys(e))/^([1-9]+[0-9]*|0)$/.test(t)&&(s=Math.max(s,Number(t)));for(let r=0;r<=s;r++)Sr(e[r],t,n)}return t}var Tr=Object.freeze({__proto__:null,arraysEqual:f,arraysEqualWithNull:d,assert:u,assertNonNegativeIntegerDimensions:V,assertNonNull:h,assertShapesMatch:c,bytesFromStringArray:$,bytesPerElement:C,checkConversionForErrors:I,clamp:a,computeStrides:O,convertBackendValuesAndArrayBuffer:z,createScalarValue:br,createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},decodeString:Nr,distSquared:function(e,t){let n=0;for(let s=0;s<e.length;s++){const r=Number(e[s])-Number(t[s]);n+=r*r}return n},encodeString:kr,fetch:vr,fingerPrint64:yr,flatten:Sr,getArrayFromDType:N,getTypedArrayFromDType:k,hasEncodingLoss:T,hexToLong:ir,indexToLoc:G,inferDtype:_,inferFromImplicitShape:x,isBoolean:A,isFunction:F,isInt:m,isNumber:R,isPromise:H,isScalarShape:function(e){return 0===e.length},isString:E,isTypedArray:Ir,isValidDtype:S,locToIndex:U,makeOnesTypedArray:P,makeZerosNestedTypedArray:W,makeZerosTypedArray:B,nearestDivisor:D,nearestLargerEven:i,now:wr,parseAxisParam:w,randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},repeatedTry:b,rightPad:y,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,s=0;for(;n>0;)s=Math.random()*n|0,n--,o(e,n,s),o(t,n,s)},sizeFromShape:p,sizeToSquarishShape:g,squeezeShape:v,sum:l,swap:o,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},toNestedArray:L,toTypedArray:xr});class Cr{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new Er)}profileKernel(e,t,n){let s;const r=()=>{s=n()};let a;const i=wr();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(r);else{r();for(const e of s)e.dataSync();a=Promise.resolve({kernelMs:wr()-i})}if(K().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<s.length;t++){const n=s[t];n.data().then((t=>{$r(t,n.dtype,e)}))}return{kernelName:e,outputs:s,inputs:t,timeMs:a.then((e=>e.kernelMs)),extraInfo:a.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:s,inputs:r,extraInfo:a}=e;n.forEach((e=>{Promise.all([e.data(),s,a]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],r,n[2])}))}))}}function $r(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const s=e[t];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class Er{logKernelProfile(e,t,n,s,r,a){const i="number"==typeof s?y(`${s}ms`,9):s.error,o=y(e,25),l=t.rank,u=t.size,c=y(t.shape.toString(),14);let h="";for(const e in r){const n=r[e];if(null!=n){const s=n.shape||t.shape,r=s.length;h+=`${e}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function Ar(e,t,n,s){const r=O(t),a=function(e,t,n,s){const r=p(t),a=s[s.length-1],i=new Array(a).fill(0),o=t.length,l="complex64"===n?Dr(e):e;if(o>1)for(let e=0;e<r/a;e++){const t=e*a;for(let e=0;e<a;e++)i[e]=Math.max(i[e],Rr(l[t+e],0,n).length)}return i}(e,t,n,r),i=t.length,o=Fr(e,t,n,r,a),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${i}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(o.map((e=>"    "+e)).join("\n")),l.join("\n")}function Rr(e,t,n){let s;return s=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:E(e)?`'${e}'`:"bool"===n?_r(e):parseFloat(e.toFixed(7)).toString(),y(s,t)}function _r(e){return 0===e?"false":"true"}function Fr(e,t,n,s,r,a=!0){const i="complex64"===n?2:1,o=t[0],l=t.length;if(0===l){if("complex64"===n){return[Rr(Dr(e)[0],0,n)]}return"bool"===n?[_r(e[0])]:[e[0].toString()]}if(1===l){if(o>20){const t=3*i;let s=Array.from(e.slice(0,t)),a=Array.from(e.slice((o-3)*i,o*i));return"complex64"===n&&(s=Dr(s),a=Dr(a)),["["+s.map(((e,t)=>Rr(e,r[t],n))).join(", ")+", ..., "+a.map(((e,t)=>Rr(e,r[o-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?Dr(e):Array.from(e)).map(((e,t)=>Rr(e,r[t],n))).join(", ")+"]"]}const u=t.slice(1),c=s.slice(1),h=s[0]*i,p=[];if(o>20){for(let t=0;t<3;t++){const s=t*h,a=s+h;p.push(...Fr(e.slice(s,a),u,n,c,r,!1))}p.push("...");for(let t=o-3;t<o;t++){const s=t*h,a=s+h;p.push(...Fr(e.slice(s,a),u,n,c,r,t===o-1))}}else for(let t=0;t<o;t++){const s=t*h,a=s+h;p.push(...Fr(e.slice(s,a),u,n,c,r,t===o-1))}const d=2===l?",":"";p[0]="["+(o>0?p[0]+d:"");for(let e=1;e<p.length-1;e++)p[e]=" "+p[e]+d;let f=",\n";for(let e=2;e<l;e++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(a?"":f),p}function Dr(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class Or{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=p(e),null!=n){const e=n.length;u(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||N(t,this.size),this.strides=O(e)}set(e,...t){0===t.length&&(t=[0]),u(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return Mr().makeTensor(this.values,this.shape,this.dtype)}}let Mr=null,Lr=null,zr=null;class Pr{constructor(e,t,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=p(e),this.strides=O(e),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return Lr.buffer(this.shape,this.dtype,e)}bufferSync(){return Lr.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return L(this.shape,e,"complex64"===this.dtype)}arraySync(){return L(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=Mr().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>Nr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),Mr().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=Mr().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>Nr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await Mr().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(this.kerasMask&&this.kerasMask.dispose(),Mr().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return Lr.print(this,e)}clone(){return this.throwIfDisposed(),Lr.clone(this)}toString(e=!1){return Ar(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),Lr.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),Mr().makeVariable(this,e,t,n)}}function Br(){return J("Tensor",(()=>Pr))}Object.defineProperty(Pr,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),Br();class Wr extends Pr{constructor(e,t,n,s){super(e.shape,e.dtype,e.dataId,s),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!f(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);Mr().disposeTensor(this),this.dataId=e.dataId,Mr().incRef(this,null)}dispose(){Mr().disposeVariable(this),this.isDisposedInternal=!0}}var Vr,Ur,Gr,Hr,jr;Object.defineProperty(Wr,Symbol.hasInstance,{value:e=>e instanceof Pr&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}(Vr||(Vr={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Ur||(Ur={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Gr||(Gr={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Hr||(Hr={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(jr||(jr={}));const qr={float32:Hr,int32:Ur,bool:Gr,complex64:jr};function Kr(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return qr[e][t]}function Xr(e){return Kr(e,"int32")}function Yr(e){return null!=e&&"object"==typeof e&&"texture"in e&&e.texture instanceof WebGLTexture}function Zr(e){return"undefined"!=typeof GPUBuffer&&null!=e&&"object"==typeof e&&"buffer"in e&&e.buffer instanceof GPUBuffer}function Jr(e,t){if(e.dtype===t.dtype)return[e,t];const n=Kr(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Qr(e,t){u(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function ea(e,t){return t.some((t=>t.id===e.id))}function ta(e){const t=[];return na(e,t,new Set),t}function na(e,t,n){if(null==e)return;if(e instanceof Pr)return void t.push(e);if(s=e,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=e;for(const e in r){const s=r[e];n.has(s)||(n.add(s),na(s,t,n))}}var sa=Object.freeze({__proto__:null,assertTypesMatch:Qr,getTensorsInContainer:ta,isTensorInList:ea,makeTypesMatch:Jr});function ra(e){return null!=e.kernelName}class aa{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class ia{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new aa}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(bs(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new Cr(this.backendInstance),!0}setupRegisteredKernels(){Ns(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){Ns(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const s=t.factory();if(!s||s instanceof n||"function"!=typeof s.then)return this.registry[e]=s,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=s.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,bs(`Initialization of backend ${e} failed`),bs(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return bs(`Initialization of backend ${e} failed`),bs(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),s=n.backend,r=this.readSync(t),a=s.refCount(t);s.disposeData(t,!0),n.backend=e,e.move(t,r,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,s=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=e}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return ia.nextTensorId++}nextVariableId(){return ia.nextVariableId++}clone(e){const t=la.runKernel("Identity",{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return la.runKernel("Cast",t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=vs(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const s=this.backend.numDataIds();let r=0;n.forEach((e=>{r+="complex64"===e.dtype?3:1}));const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-t-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const s=this.isTapeOn(),r=this.state.numBytes,a=this.state.numTensors;let i,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=ra(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(ra(e)){const{kernelName:t,inputs:r,attrs:a}=e;null==this.backendName&&this.backend;const l=vs(t,this.backendName);u(null!=l,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),i=()=>{const e=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:a,backend:this.backend});const i=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,i);const u=i.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(s){const e=this.getTensorsForGradient(t,r,u);n=this.saveTensorsForBackwardMode(e)}return u}}else{const{forwardFunc:t}=e,r=e=>{s&&(n=e.map((e=>this.keep(this.clone(e)))))};i=()=>{const e=this.backend.numDataIds();o=this.tidy((()=>t(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,e,n),n}}const{inputs:c,attrs:h}=e,p=ra(e)?null:e.backwardsFunc;let d;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(d=this.profiler.profileKernel(l,c,(()=>i())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(d),t=d.outputs):t=i()})),s&&this.addTapeNode(l,c,t,p,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:d.timeMs,extraInfo:d.extraInfo}),Array.isArray(o)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const s=ks(e);if(null!=s){const e=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(u(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),a=Object.keys(t).map((e=>t[e]))):a=e.map((e=>t[e]));const i=n.filter(((e,t)=>r[t]));return a.concat(i)}return[]}makeTensor(e,t,n,s){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=e;"string"===n&&E(e[0])&&(r=e.map((e=>kr(e))));const a=s.write(r,t,n),i=new Pr(t,n,a,this.nextTensorId());if(this.trackTensor(i,s),"string"===n){const e=this.state.tensorInfo.get(a),t=$(r);this.state.numBytes+=t-e.bytes,e.bytes=t}return i}makeTensorFromDataId(e,t,n,s){const r={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:s,dtype:r}=e,a=new Pr(s,r,n,this.nextTensorId());return this.trackTensor(a,t),a}makeVariable(e,t=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==e.dtype&&(e=e.cast(s));const r=new Wr(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*C(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof Wr||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*C(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:r},o=ks(e);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],s=B(e.size,e.dtype);return this.makeTensor(s,e.shape,e.dtype)}return e})),s(e.length>1?e:e[0],r,a))),this.state.activeTape.push(i)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=ta(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==s.id||this.track(e)}))}gradients(e,t,n,s=!1){if(u(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));u(r instanceof Pr,(()=>"The result y returned by f() must be a tensor."));const a=function(e,t,n){const s={},r={};for(let e=0;e<t.length;e++)s[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],i=a.inputs;for(const e in i){const n=i[e];let o=!1;for(let e=0;e<t.length;e++)if(s[n.id]){a.outputs.forEach((e=>s[e.id]=!0)),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let t=e.length-1;t>=0;t--){const n=e[t],s=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in s)a[s[e].id]=!0,i[n.id]=!0;break}}const o=[];for(let t=0;t<e.length;t++){const n=e[t];if(r[n.id]&&i[n.id]){const e={};for(const t in n.inputs){const r=n.inputs[t];s[r.id]&&(e[t]=r)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,o.push(t)}}return o}(this.state.activeTape,t,r);if(!s&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[r.id]=null==n?function(e){const t=P(p(e),"float32");return la.makeTensor(t,e,"float32")}(r.shape):n,function(e,t,n,s){for(let r=t.length-1;r>=0;r--){const a=t[r],i=[];if(a.outputs.forEach((t=>{const n=e[t.id];null!=n?i.push(n):i.push(null)})),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const t in a.inputs){if(!(t in o))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[t]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[t];if(!f(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==e[i.id])e[i.id]=r;else{const t=e[i.id];e[i.id]=s(t,r),t.dispose()}}}}(e,a,(e=>this.tidy(e)),ua);const s=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(e){return u(F(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;u(t.every((e=>e instanceof Pr)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};t.forEach(((e,t)=>{s[t]=e}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=e(...t,r),u(n.value instanceof Pr,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),u(F(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,s)=>{const r=n.gradFunc(e,s),a=Array.isArray(r)?r:[r];u(a.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),u(a.every((e=>e instanceof Pr)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const i={};return a.forEach(((e,t)=>{i[t]=()=>e})),i},inputs:s})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=wr(),n=await this.backend.time(e);return n.wallMs=wr()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new aa;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function oa(){const e=Z();if(null==e._tfengine){const t=new j(e);e._tfengine=new ia(t)}var t;return t=e._tfengine.ENV,Y=t,Mr=()=>e._tfengine,e._tfengine}ia.nextTensorId=0,ia.nextVariableId=0;const la=oa();function ua(e,t){const n={a:e,b:t};return la.runKernel("Add",n)}let ca;function ha(e){if(void 0!==ca)return ca;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1}function pa(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var da=Object.freeze({__proto__:null,isBrowser:pa,isMobile:ha,mockIsMobile:function(e){ca=e}});const fa=K();function ma(e,t){let n=e;if(Ir(e))return"string"===t?[]:[e.length];if(Yr(e)){const t=e.channels||"RGBA";return[e.height,e.width*t.length]}if(Zr(e))return[e.buffer.size/(null==t?4:C(t))];if(!Array.isArray(e))return[];const s=[];for(;Array.isArray(n)||Ir(n)&&"string"!==t;)s.push(n.length),n=n[0];return Array.isArray(e)&&K().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&ga(e,s,[]),s}function ga(e,t,n){if(n=n||[],!Array.isArray(e)&&!Ir(e))return void u(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));u(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),u(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const s=t.slice(1);for(let t=0;t<e.length;++t)ga(e[t],s,n.concat(t))}function ya(e,t,n,s){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`)}}function ba(e,t,n,s="numeric"){if(e instanceof Br())return ya(s,e.dtype,t,n),e;let r=_(e);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),ya(s,r,t,n),null==e||!Ir(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const s=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=ma(e,r);Ir(e)||Array.isArray(e)||(e=[e]);const i="string"!==r?xr(e,r):Sr(e,[],!0);return la.makeTensor(i,a,r)}function xa(e,t,n,s="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,r)=>ba(e,`${t}[${r}]`,n,s)))}fa.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),fa.registerFlag("IS_BROWSER",(()=>pa())),fa.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node)),fa.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),fa.registerFlag("IS_SAFARI",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Safari/.test(navigator.userAgent)&&/Apple/.test(navigator.vendor))),fa.registerFlag("PROD",(()=>!1)),fa.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>fa.getBool("DEBUG"))),fa.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),fa.registerFlag("IS_TEST",(()=>!1)),fa.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>fa.getBool("DEBUG"))),fa.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),fa.registerFlag("CANVAS2D_WILL_READ_FREQUENTLY_FOR_GPU",(()=>!1)),fa.registerFlag("USE_SETTIMEOUTCUSTOM",(()=>!1));const wa="__op";function va(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const s=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...e)=>{la.startScope(n);try{const t=s(...e);return H(t)&&console.error("Cannot return a Promise inside of tidy."),la.endScope(t),t}catch(e){throw la.endScope(null),e}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const ka=va({complex_:function(e,t){const n=ba(e,"real","complex"),s=ba(t,"imag","complex");c(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return la.runKernel("Complex",r)}});function Na(e,t,n,s){if(null==s)s=_(e);else if("complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(Zr(e)||Yr(e)){if("float32"!==s&&"int32"!==s)throw new Error(`Creating tensor from GPU data only supports 'float32'|'int32' dtype, while the dtype is ${s}.`);return la.backend.createTensorFromGPUData(e,t||n,s)}if(!Ir(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){V(t);const e=p(t),s=p(n);u(e===s,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${s}`));for(let e=0;e<n.length;++e){const s=n[e],r=e!==n.length-1||s!==p(t.slice(e));u(n[e]===t[e]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return Ir(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==s?xr(e,s):Sr(e,[],!0),la.makeTensor(e,t,s)}function Ia(e,t,n){return Na(e,t,ma(e,n),n)}const Sa={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};class Ta{static join(e){return new Ta(e).slice()}constructor(e){if(this.shards=[],this.previousShardIndex=0,null==e)return;if(e instanceof Array||(e=[e]),0===(e=e.map((e=>Ir(e)?e.buffer:e))).length)return;this.bufferUniformSize=e[0].byteLength;let t=0;for(let n=0;n<e.length;n++){const s=e[n];n!==e.length-1&&s.byteLength!==this.bufferUniformSize&&(this.bufferUniformSize=void 0);const r=t+s.byteLength;this.shards.push({buffer:s,start:t,end:r}),t=r}0===this.shards.length&&(this.byteLength=0),this.byteLength=this.shards[this.shards.length-1].end}slice(e=0,t=this.byteLength){if(0===this.shards.length)return new ArrayBuffer(0);if(e=isNaN(Number(e))?0:e,t=isNaN(Number(t))?0:t,e=Math.max(0,e),(t=Math.min(this.byteLength,t))<=e)return new ArrayBuffer(0);const n=this.findShardForByte(e);if(-1===n)throw new Error(`Could not find start shard for byte ${e}`);const s=new ArrayBuffer(t-e),r=new Uint8Array(s);let a=0;for(let s=n;s<this.shards.length;s++){const n=this.shards[s],i=e+a-n.start,o=a,l=Math.min(t,n.end)-n.start,u=new Uint8Array(n.buffer,i,l-i);if(r.set(u,o),a+=u.length,t<n.end)break}return s}findShardForByte(e){if(0===this.shards.length||e<0||e>=this.byteLength)return-1;if(null!=this.bufferUniformSize)return this.previousShardIndex=Math.floor(e/this.bufferUniformSize),this.previousShardIndex;function t(t){return e<t.start?-1:e>=t.end?1:0}if(0===t(this.shards[this.previousShardIndex]))return this.previousShardIndex;const n=function(e,t){let n=0,s=e.length;for(;n<=s;){const r=Math.floor((s-n)/2)+n,a=t(e[r]);if(0===a)return r;a<0?s=r:n=r+1}return-1}(this.shards,t);return-1===n?-1:(this.previousShardIndex=n,this.previousShardIndex)}}function Ca(){K().set("PROD",!0)}function $a(){K().set("DEBUG",!0)}function Ea(){K().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")}function Aa(e){K().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function Ra(){la.disposeVariables()}function _a(){return la}function Fa(){return la.memory()}function Da(e){return la.profile(e)}function Oa(e,t){return la.tidy(e,t)}function Ma(e){ta(e).forEach((e=>e.dispose()))}function La(e){return la.keep(e)}function za(e){return la.time(e)}function Pa(e){return la.setBackend(e)}function Ba(){return la.ready()}function Wa(){return la.backendName}function Va(e){la.removeBackend(e)}function Ua(e){return la.findBackend(e)}function Ga(e){return la.findBackendFactory(e)}function Ha(e,t,n=1){return la.registerBackend(e,t,n)}function ja(){return la.backend}function qa(e,t){K().setPlatform(e,t)}zr=Aa;async function Ka(e,t){const n=[],s=[],r=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(e)?e[a].tensor:e[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const e=new Promise((async e=>{const t=await o.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,s=new Uint8Array(n);let r=0;for(let e=0;e<t.length;e++){const n=t[e],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}e(s)}));s.push(e)}else s.push(o.data());null!=t&&(l.group=t),n.push(l)}return{data:ti(await Promise.all(s)),specs:n}}function Xa(e,t){const n=new Ta(e),s={};let r=0;for(const e of t){const t=Ya(e,((e,t)=>n.slice(r+e,r+t)));s[e.name]=Ja(e,n.slice(r,r+t)),r+=t}return s}function Ya(e,t){const n=p(e.shape);let s;if("quantization"in e){const t=e.quantization;s=Sa[t.dtype]}else{if("string"===e.dtype){let e=0;for(let s=0;s<n;s++)e+=4+new Uint32Array(t(e,e+4))[0];return e}s=Sa[e.dtype]}return n*s}async function Za(e,t){const n=p(e.shape);let s;if("quantization"in e){const t=e.quantization;s=Sa[t.dtype]}else{if("string"===e.dtype){let e=0;for(let s=0;s<n;s++)e+=4+new Uint32Array(await t(e,e+4))[0];return e}s=Sa[e.dtype]}return n*s}function Ja(e,t){const n=e.name,s=e.dtype,r=e.shape,a=p(r);let i,o=0;if("quantization"in e){const r=e.quantization;if("uint8"===r.dtype||"uint16"===r.dtype){if(!("min"in r)||!("scale"in r))throw new Error(`Weight ${e.name} with quantization ${r.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==r.dtype)throw new Error(`Weight ${e.name} has unknown quantization dtype ${r.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==s)throw new Error(`Weight ${e.name} is quantized with ${r.dtype} which only supports weights of type float32 not ${s}.`)}const l=Sa[r.dtype],u="uint8"===r.dtype?new Uint8Array(t):new Uint16Array(t);if("float32"===s)if("uint8"===r.dtype||"uint16"===r.dtype){i=new Float32Array(u.length);for(let e=0;e<u.length;e++){const t=u[e];i[e]=t*r.scale+r.min}}else{if("float16"!==r.dtype)throw new Error(`Unsupported quantization type ${r.dtype} for weight type float32.`);{const e=function(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=e[n[i>>10]+(1023&i)]+t[i>>10];a[r]=o}return new Float32Array(r)}}();i=e(u)}}else{if("int32"!==s)throw new Error(`Unsupported dtype in weight '${n}': ${s}`);if("uint8"!==r.dtype&&"uint16"!==r.dtype)throw new Error(`Unsupported quantization type ${r.dtype} for weight type int32.`);i=new Int32Array(u.length);for(let e=0;e<u.length;e++){const t=u[e];i[e]=Math.round(t*r.scale+r.min)}}o+=a*l}else if("string"===s){const n=p(e.shape);i=[];for(let e=0;e<n;e++){const e=new Uint32Array(t.slice(o,o+4))[0];o+=4;const n=new Uint8Array(t.slice(o,o+e));i.push(n),o+=e}}else{const e=Sa[s];if("float32"===s)i=new Float32Array(t);else if("int32"===s)i=new Int32Array(t);else{if("bool"!==s){if("complex64"===s){i=new Float32Array(t);const e=new Float32Array(i.length/2),n=new Float32Array(i.length/2);for(let t=0;t<e.length;t++)e[t]=i[2*t],n[t]=i[2*t+1];const s=Ia(e,r,"float32"),a=Ia(n,r,"float32"),o=ka(s,a);return s.dispose(),a.dispose(),o}throw new Error(`Unsupported dtype in weight '${n}': ${s}`)}i=new Uint8Array(t)}o+=a*e}return Ia(i,r,s)}async function Qa(e,t,n){let s=new Uint8Array(t);for(;s.byteLength<n;){const{done:t,value:r}=await e.read();if(t&&null==r){const e=n-s.byteLength;throw new Error(`Reader is done but ${e} bytes are still expected`)}const a=new Uint8Array(s.length+r.byteLength);a.set(s,0),a.set(new Uint8Array(r),s.length),s=a}return s.buffer}async function ei(e,t){const n={},s=e.getReader();let r=new ArrayBuffer(0);for(const e of t){const t=await Za(e,(async(e,t)=>(r=await Qa(s,r,t),r.slice(e,t))));r=await Qa(s,r,t);const a=r.slice(0,t);r=r.slice(t);const i=Ja(e,a);if(n[e.name]=i,"webgpu"===Wa()){const e=ja();"uploadToGPU"in e&&p(i.shape)>=K().get("WEBGPU_CPU_HANDOFF_SIZE_THRESHOLD")&&e.uploadToGPU(i.dataId)}}return n}function ti(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const s=new Uint8Array(t);let r=0;return n.forEach((e=>{s.set(new Uint8Array(e.buffer),r),r+=e.byteLength})),s.buffer}const ni="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function si(e){return ni?Buffer.byteLength(e,"utf8"):new Blob([e]).size}function ri(e){return Ta.join(e)}function ai(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function ii(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.initializerSignature&&(n.initializerSignature=e.initializerSignature),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}function oi(e,t,n){const s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(s.trainingConfig=e.trainingConfig),null!=e.weightsManifest){if(!t)throw new Error("modelJSON has weightsManifest but weightSpecs is null");if(!n)throw new Error("modelJSON has weightsManifest but weightData is null");s.weightSpecs=t,s.weightData=n}return null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer),null!=e.initializerSignature&&(s.initializerSignature=e.initializerSignature),s}async function li(e,t){let n,s;return null!=e.weightsManifest&&([n,s]=await t(e.weightsManifest)),oi(e,n,s)}function ui(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:si(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:si(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:new Ta(e.weightData).byteLength}}function ci(e){const t=[];for(const n of e)t.push(...n.weights);return t}class hi{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==hi.instance&&(hi.instance=new hi),hi.instance}static registerSaveRouter(e){hi.getInstance().saveRouters.push(e)}static registerLoadRouter(e){hi.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return hi.getHandlers(e,"save")}static getLoadHandlers(e,t){return hi.getHandlers(e,"load",t)}static getHandlers(e,t,n){const s=[];return("load"===t?hi.getInstance().loadRouters:hi.getInstance().saveRouters).forEach((t=>{const r=t(e,n);null!==r&&s.push(r)})),s}}const pi=e=>hi.getSaveHandlers(e),di=(e,t)=>hi.getLoadHandlers(e,t);function fi(){if(!K().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function mi(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class gi{constructor(e){if(this.indexedDB=fi(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>mi(s),s.onsuccess=()=>{const r=s.result;if(null==t){const t=r.transaction("models_store","readonly"),s=t.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(s.result.modelArtifacts)},s.onerror=e=>(r.close(),n(s.error)),t.oncomplete=()=>r.close()}else{t.weightData=Ta.join(t.weightData);const s=ui(t),a=r.transaction("model_info_store","readwrite");let i,o,l=a.objectStore("model_info_store");try{i=l.put({modelPath:this.modelPath,modelArtifactsInfo:s})}catch(e){return n(e)}i.onsuccess=()=>{o=r.transaction("models_store","readwrite");const i=o.objectStore("models_store");let u;try{u=i.put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:s})}catch(e){return n(e)}u.onsuccess=()=>e({modelArtifactsInfo:s}),u.onerror=e=>{l=a.objectStore("model_info_store");const t=l.delete(this.modelPath);t.onsuccess=()=>(r.close(),n(u.error)),t.onerror=e=>(r.close(),n(u.error))}},i.onerror=e=>(r.close(),n(i.error)),a.oncomplete=()=>{null==o?r.close():o.oncomplete=()=>r.close()}}},s.onerror=e=>n(s.error)}))}}gi.URL_SCHEME="indexeddb://";const yi=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(gi.URL_SCHEME)?(t=e.slice(gi.URL_SCHEME.length),new gi(t)):null;var t};hi.registerSaveRouter(yi),hi.registerLoadRouter(yi);class bi{constructor(){this.indexedDB=fi()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>mi(n),n.onsuccess=()=>{const s=n.result,r=s.transaction("model_info_store","readonly"),a=r.objectStore("model_info_store").getAll();a.onsuccess=()=>{const t={};for(const e of a.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},a.onerror=e=>(s.close(),t(a.error)),r.oncomplete=()=>s.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(gi.URL_SCHEME)?t.slice(gi.URL_SCHEME.length):t,new Promise(((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>mi(s),s.onsuccess=()=>{const r=s.result,a=r.transaction("model_info_store","readwrite"),i=a.objectStore("model_info_store"),o=i.get(e);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const s=i.delete(e),a=()=>{l=r.transaction("models_store","readwrite");const s=l.objectStore("models_store").delete(e);s.onsuccess=()=>t(o.result.modelArtifactsInfo),s.onerror=e=>n(o.error)};s.onsuccess=a,s.onerror=e=>(a(),r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=e=>n(s.error)}))}}const xi="tensorflowjs_models",wi="info",vi="model_topology",ki="weight_specs",Ni="weight_data",Ii="model_metadata";function Si(e){return{info:[xi,e,wi].join("/"),topology:[xi,e,vi].join("/"),weightSpecs:[xi,e,ki].join("/"),weightData:[xi,e,Ni].join("/"),modelMetadata:[xi,e,Ii].join("/")}}function Ti(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function Ci(e){const t=e.split("/");if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join("/")}class $i{constructor(e){if(!K().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Si(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),s=ui(e),r=Ta.join(e.weightData);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(ni)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,s=t.length;e<s;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(r));const a={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,initializerSignature:null!=e.initializerSignature?e.initializerSignature:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(a)),{modelArtifactsInfo:s}}catch(e){throw Ti(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const e=JSON.parse(r);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.initializerSignature&&(t.initializerSignature=e.initializerSignature),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(ni){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(a),t}}$i.URL_SCHEME="localstorage://";const Ei=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith($i.URL_SCHEME)?(t=e.slice($i.URL_SCHEME.length),new $i(t)):null;var t};hi.registerSaveRouter(Ei),hi.registerLoadRouter(Ei);class Ai{constructor(){u(K().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),u("undefined"==typeof window||void 0!==window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=xi+"/",n="/"+wi;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(t)&&r.endsWith(n)){e[Ci(r)]=JSON.parse(this.LS.getItem(r))}}return e}async removeModel(e){var t;const n=Si(e=(t=e).startsWith($i.URL_SCHEME)?t.slice($i.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const s=JSON.parse(this.LS.getItem(n.info));return Ti(n),s}}class Ri{constructor(){this.managers={}}static getInstance(){return null==Ri.instance&&(Ri.instance=new Ri),Ri.instance}static registerManager(e,t){u(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),u(e.length>0,(()=>"scheme must not be an empty string."));const n=Ri.getInstance();u(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=Ri.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(Ri.getInstance().managers)}}function _i(e){if(-1===e.indexOf("://"))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${Ri.getSchemes().join(",")}`);return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function Fi(e,t,n=!1){u(e!==t,(()=>`Old path and new path are the same: '${e}'`));const s=hi.getLoadHandlers(e);u(s.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),u(s.length<2,(()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`));const r=s[0],a=hi.getSaveHandlers(t);u(a.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),u(a.length<2,(()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`));const i=a[0],o=_i(e).scheme,l=_i(e).path,c=o===_i(e).scheme,h=await r.load();n&&c&&await Ri.getManager(o).removeModel(l);const p=await i.save(h);return n&&!c&&await Ri.getManager(o).removeModel(l),p.modelArtifactsInfo}class Di{constructor(){this.messageName="setTimeoutCustom",this.functionRefs=[],this.handledMessageCount=0,this.hasEventListener=!1}fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}setTimeoutCustom(e,t){"undefined"!=typeof window&&K().getBool("USE_SETTIMEOUTCUSTOM")?(this.functionRefs.push(e),setTimeout((()=>{window.postMessage({name:this.messageName,index:this.functionRefs.length-1},"*")}),t),this.hasEventListener||(this.hasEventListener=!0,window.addEventListener("message",(e=>{if(e.source===window&&e.data.name===this.messageName){e.stopPropagation();(0,this.functionRefs[e.data.index])(),this.handledMessageCount++,this.handledMessageCount===this.functionRefs.length&&(this.functionRefs=[],this.handledMessageCount=0)}}),!0))):setTimeout(e,t)}isTypedArray(e){return As(e)}}if(K().get("IS_BROWSER")){K().setPlatform("browser",new Di);try{Ri.registerManager($i.URL_SCHEME,new Ai)}catch(e){}try{Ri.registerManager(gi.URL_SCHEME,new bi)}catch(e){}}const Oi=()=>require("node-fetch");let Mi;class Li{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=K().global.fetch?K().global.fetch(e,t):(null==Mi&&(Mi=Oi()),Mi(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}isTypedArray(e){return this.util.types.isFloat32Array(e)||this.util.types.isInt32Array(e)||this.util.types.isUint8Array(e)||this.util.types.isUint8ClampedArray(e)}}function zi(e,t="float32",n){return t=t||"float32",V(e),new Or(e,t,n)}K().get("IS_NODE")&&!K().get("IS_BROWSER")&&K().setPlatform("node",new Li);const Pi=va({cast_:function(e,t){const n=ba(e,"x","cast");if(!S(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:t};return la.runKernel("Cast",s,r)}});const Bi=va({clone_:function(e){const t={x:ba(e,"x","clone","string_or_numeric")};return la.runKernel("Identity",t)}});function Wi(e,t=!1){console.log(e.toString(t))}oa();Lr={buffer:zi,cast:Pi,clone:Bi,print:Wi};const Vi=va({add_:function(e,t){let n=ba(e,"a","add"),s=ba(t,"b","add");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel("Add",r)}});const Ui=va({floorDiv_:function(e,t){let n=ba(e,"a","floorDiv"),s=ba(t,"b","floorDiv");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel("FloorDiv",r)}});const Gi=va({div_:function(e,t){let n=ba(e,"a","div"),s=ba(t,"b","div");if([n,s]=Jr(n,s),"int32"===n.dtype&&"int32"===s.dtype)return Ui(n,s);const r={a:n,b:s};return la.runKernel("RealDiv",r,{})}});const Hi=va({mul_:function(e,t){let n=ba(e,"a","mul"),s=ba(t,"b","mul");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel("Multiply",r)}});const ji=va({abs_:function(e){const t=ba(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return la.runKernel("ComplexAbs",e)}{const e={x:t};return la.runKernel("Abs",e)}}});const qi=va({acos_:function(e){const t={x:ba(e,"x","acos")};return la.runKernel("Acos",t)}});const Ki=va({acosh_:function(e){const t={x:ba(e,"x","acosh")};return la.runKernel("Acosh",t)}});const Xi=va({addN_:function(e){u(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),u(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>ba(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!f(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=t;return la.runKernel("AddN",s)}});const Yi=va({all_:function(e,t=null,n=!1){const s={x:ba(e,"x","all","bool")},r={axis:t,keepDims:n};return la.runKernel("All",s,r)}});const Zi=va({any_:function(e,t=null,n=!1){const s={x:ba(e,"x","any","bool")},r={axis:t,keepDims:n};return la.runKernel("Any",s,r)}});const Ji=va({argMax_:function(e,t=0){const n={x:ba(e,"x","argMax")},s={axis:t};return la.runKernel("ArgMax",n,s)}});const Qi=va({argMin_:function(e,t=0){const n={x:ba(e,"x","argMin")},s={axis:t};return la.runKernel("ArgMin",n,s)}});const eo=va({asin_:function(e){const t={x:ba(e,"x","asin")};return la.runKernel("Asin",t)}});const to=va({asinh_:function(e){const t={x:ba(e,"x","asinh")};return la.runKernel("Asinh",t)}});const no=va({atan_:function(e){const t={x:ba(e,"x","atan")};return la.runKernel("Atan",t)}});const so=va({atan2_:function(e,t){let n=ba(e,"a","atan2"),s=ba(t,"b","atan2");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel("Atan2",r)}});const ro=va({atanh_:function(e){const t={x:ba(e,"x","atanh")};return la.runKernel("Atanh",t)}});function ao(e,t,n,s,r="NHWC",a){return lo(e,[...t,e[3]],n,a,s,null,null,xo(r))}function io(e,t,n,s,r,a,i="channelsLast"){const[o,l]=ho(t);let u;if("channelsLast"===i)u=[o,l,e[3],e[3]];else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);u=[o,l,e[1],e[1]]}return lo(e,u,n,s,r,a,!1,i)}function oo(e,t,n,s,r,a,i="NDHWC"){const[o,l,u]=po(t);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,e[4],e[4]];else{if("NCDHW"!==i)throw new Error(`Unknown dataFormat ${i}`);h="channelsFirst",c=[o,l,u,e[1],e[1]]}return uo(e,c,n,s,r,!1,h,a)}function lo(e,t,n,s,r,a,i=!1,o="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,c,h]=e;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,h,u,c]=e}const[p,d,,f]=t,[m,g]=ho(n),[y,b]=ho(s),x=fo(p,y),w=fo(d,b),{padInfo:v,outHeight:k,outWidth:N}=function(e,t,n,s,r,a,i,o,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const r=function(e,t,n,s,r){null==s&&(s=co(e,t,n));const a=e[0],i=e[1],o=mo((a-t+2*s)/n+1,r),l=mo((i-t+2*s)/n+1,r);return[o,l]}([t,n],a,s,e,o);c=r[0],h=r[1]}else if("same"===e){c=Math.ceil(t/s),h=Math.ceil(n/r);const e=Math.max(0,(c-1)*s+a-t),o=Math.max(0,(h-1)*r+i-n),l=Math.floor(e/2),p=e-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-a+1)/s),h=Math.ceil((n-i+1)/r);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const p="channelsLast"===l?e[1][0]:e[2][0],d="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],m="channelsLast"===l?e[2][1]:e[3][1];u={top:p,bottom:d,left:f,right:m,type:0===p&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},c=mo((t-a+p+d)/s+1,o),h=mo((n-i+f+m)/r+1,o)}}return{padInfo:u,outHeight:c,outWidth:h}}(r,u,c,m,g,x,w,a,o),I=i?f*h:f;let S;return"channelsFirst"===o?S=[l,I,k,N]:"channelsLast"===o&&(S=[l,k,N,I]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:c,inChannels:h,outHeight:k,outWidth:N,outChannels:I,padInfo:v,strideHeight:m,strideWidth:g,filterHeight:p,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:w,dilationHeight:y,dilationWidth:b,inShape:e,outShape:S,filterShape:t}}function uo(e,t,n,s,r,a=!1,i="channelsLast",o){let[l,u,c,h,p]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h,p]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,p,u,c,h]=e}const[d,f,m,,g]=t,[y,b,x]=po(n),[w,v,k]=po(s),N=fo(d,w),I=fo(f,v),S=fo(m,k),{padInfo:T,outDepth:C,outHeight:$,outWidth:E}=function(e,t,n,s,r,a,i,o,l,u,c){let h,p,d,f;"valid"===e&&(e=0);if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const m=function(e,t,n,s,r,a){null==r&&(r=co(e,t[0],s[0]));const i=[0,0,0,n];for(let n=0;n<3;n++)e[n]+2*r>=t[n]&&(i[n]=mo((e[n]-t[n]+2*r)/s[n]+1,a));return i}([t,n,s,1],[o,l,u],1,[r,a,i],e,c);p=m[0],d=m[1],f=m[2]}else{if("same"!==e)throw Error(`Unknown padding parameter: ${e}`);{p=Math.ceil(t/r),d=Math.ceil(n/a),f=Math.ceil(s/i);const e=(p-1)*r+o-t,c=(d-1)*a+l-n,m=(f-1)*i+u-s,g=Math.floor(e/2),y=e-g,b=Math.floor(c/2),x=c-b,w=Math.floor(m/2);h={top:b,bottom:x,left:w,right:m-w,front:g,back:y,type:"SAME"}}}return{padInfo:h,outDepth:p,outHeight:d,outWidth:f}}(r,u,c,h,y,b,x,N,I,S,o),A=a?g*p:g;let R;return"channelsFirst"===i?R=[l,A,C,$,E]:"channelsLast"===i&&(R=[l,C,$,E,A]),{batchSize:l,dataFormat:i,inDepth:u,inHeight:c,inWidth:h,inChannels:p,outDepth:C,outHeight:$,outWidth:E,outChannels:A,padInfo:T,strideDepth:y,strideHeight:b,strideWidth:x,filterDepth:d,filterHeight:f,filterWidth:m,effectiveFilterDepth:N,effectiveFilterHeight:I,effectiveFilterWidth:S,dilationDepth:w,dilationHeight:v,dilationWidth:k,inShape:e,outShape:R,filterShape:t}}function co(e,t,n,s=1){const r=fo(t,s);return Math.floor((e[0]*(n-1)-n+r)/2)}function ho(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function po(e){return"number"==typeof e?[e,e,e]:e}function fo(e,t){return t<=1?e:e+(e-1)*(t-1)}function mo(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function go(e){const[t,n,s]=ho(e);return 1===t&&1===n&&1===s}function yo(e,t){return go(e)||go(t)}function bo(e){return ho(e).every((e=>e>0))}function xo(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function wo(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)u(m(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{u(m(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const vo=va({reshape_:function(e,t){const n={x:ba(e,"x","reshape","string_or_numeric")},s={shape:t};return la.runKernel("Reshape",n,s)}});const ko=va({avgPool_:function(e,t,n,s,r){const a=ba(e,"x","avgPool","float32");u(yo(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let i=a,o=!1;3===a.rank&&(o=!0,i=vo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===i.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`)),wo("avgPool",s,r);const l={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r};let h=la.runKernel("AvgPool",l,c);return h=Pi(h,a.dtype),o?vo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const No=va({avgPool3d_:function(e,t,n,s,r,a="NDHWC"){const i=ba(e,"x","avgPool3d","float32");let o=i,l=!1;4===i.rank&&(l=!0,o=vo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),u("NDHWC"===a,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),u("number"==typeof n&&n>0||Array.isArray(n)&&n[0]>0&&n[1]>0&&n[2]>0,(()=>`Error in avgPool3d: Stride must be > 0, but got '${n}'`)),wo("avgPool3d",s,r);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a};let p=la.runKernel("AvgPool3D",c,h);return p=Pi(p,o.dtype),l?vo(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Io=va({concat_:function(e,t=0){u(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=xa(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return Bi(n[0]);const s=n,r={axis:t};return la.runKernel("Concat",s,r)}});const So=va({matMul_:function(e,t,n=!1,s=!1){let r=ba(e,"a","matMul"),a=ba(t,"b","matMul");[r,a]=Jr(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return la.runKernel("BatchMatMul",i,o)}});const To=va({sigmoid_:function(e){const t={x:ba(e,"x","sigmoid","float32")};return la.runKernel("Sigmoid",t)}});const Co=va({slice_:function(e,t,n){const s=ba(e,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:t,size:n};return la.runKernel("Slice",r,a)}});const $o=va({tanh_:function(e){const t={x:ba(e,"x","tanh","float32")};return la.runKernel("Tanh",t)}});const Eo=va({basicLSTMCell_:function(e,t,n,s,r,a){const i=ba(e,"forgetBias","basicLSTMCell"),o=ba(t,"lstmKernel","basicLSTMCell"),l=ba(n,"lstmBias","basicLSTMCell"),u=ba(s,"data","basicLSTMCell"),c=ba(r,"c","basicLSTMCell"),h=ba(a,"h","basicLSTMCell"),p=Io([u,h],1),d=So(p,o),f=Vi(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=Co(f,[0,0],y),x=Co(f,[0,g],y),w=Co(f,[0,2*g],y),v=Co(f,[0,3*g],y),k=Vi(Hi(To(b),$o(x)),Hi(c,To(Vi(i,w))));return[k,Hi($o(k),To(v))]}});const Ao=va({batchToSpaceND_:function(e,t,n){const s=ba(e,"x","batchToSpaceND"),r=t.reduce(((e,t)=>e*t));u(s.rank>=1+t.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${t.length}`)),u(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),u(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`));const a={x:s},i={blockShape:t,crops:n};return la.runKernel("BatchToSpaceND",a,i)}});const Ro=va({batchNorm_:function(e,t,n,s,r,a){null==a&&(a=.001);const i=ba(e,"x","batchNorm"),o=ba(t,"mean","batchNorm"),l=ba(n,"variance","batchNorm");let c,h;null!=r&&(c=ba(r,"scale","batchNorm")),null!=s&&(h=ba(s,"offset","batchNorm")),u(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==c||o.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const p=function(e){let t;return t=0===e.rank||1===e.rank?vo(e,[1,1,1,e.size]):2===e.rank?vo(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?vo(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),d={x:p,scale:c,offset:h,mean:o,variance:l},f={varianceEpsilon:a},m=la.runKernel("FusedBatchNorm",d,f);return vo(m,i.shape)}});const _o=va({batchNorm2d_:function(e,t,n,s,r,a){const i=ba(e,"x","batchNorm"),o=ba(t,"mean","batchNorm"),l=ba(n,"variance","batchNorm");let c,h;return null!=r&&(c=ba(r,"scale","batchNorm")),null!=s&&(h=ba(s,"offset","batchNorm")),u(2===i.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`)),u(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),u(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Ro(i,o,l,h,c,a)}});const Fo=va({batchNorm3d_:function(e,t,n,s,r,a){const i=ba(e,"x","batchNorm"),o=ba(t,"mean","batchNorm"),l=ba(n,"variance","batchNorm");let c,h;return null!=r&&(c=ba(r,"scale","batchNorm")),null!=s&&(h=ba(s,"offset","batchNorm")),u(3===i.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`)),u(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),u(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Ro(i,o,l,h,c,a)}});const Do=va({batchNorm4d_:function(e,t,n,s,r,a){const i=ba(e,"x","batchNorm"),o=ba(t,"mean","batchNorm"),l=ba(n,"variance","batchNorm");let c,h;return null!=r&&(c=ba(r,"scale","batchNorm")),null!=s&&(h=ba(s,"offset","batchNorm")),u(4===i.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`)),u(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),u(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Ro(i,o,l,h,c,a)}});const Oo=va({bincount_:function(e,t,n){const s=ba(e,"x","bincount"),r=ba(t,"weights","bincount");u("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const a={x:s,weights:r},i={size:n};return la.runKernel("Bincount",a,i)}});const Mo=va({bitwiseAnd_:function(e,t){const n=ba(e,"x","bitwiseAnd"),s=ba(t,"y","bitwiseAnd");if(!f(n.shape,s.shape))throw new Error(`BitwiseAnd: Tensors must have the same shape. x: ${n.shape}, y: ${s.shape}`);if("int32"!==n.dtype||"int32"!==s.dtype)throw new Error(`BitwiseAnd: Only supports 'int32' values in tensor, found type of x: ${n.dtype} and type of y: ${s.dtype}`);const r={a:n,b:s};return la.runKernel("BitwiseAnd",r)}});const Lo=va({broadcastArgs_:function(e,t){const n=ba(e,"s0","broadcastArgs","int32"),s=ba(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return la.runKernel("BroadcastArgs",r)}});const zo=va({broadcastTo_:function(e,t){let n=ba(e,"broadcastTo","x");const s=n.shape;if(V(t),t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=vo(n,e)}const r=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(r[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);if(0===a.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return Bi(n);const i={x:n},o={reps:a};return la.runKernel("Tile",i,o)}});const Po=va({ceil_:function(e){const t={x:ba(e,"x","ceil","float32")};return la.runKernel("Ceil",t)}});function Bo(e,t,n){V(e);const s={shape:e,value:t,dtype:n=n||_(t)};return la.runKernel("Fill",{},s)}const Wo=va({clipByValue_:function(e,t,n){const s=ba(e,"x","clipByValue");if(u(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`)),t===n)return Bo(s.shape,t,s.dtype);const r={x:s},a={clipValueMin:t,clipValueMax:n};return la.runKernel("ClipByValue",r,a)}});const Vo=va({concat1d_:function(e){return Io(e,0)}});const Uo=va({concat2d_:function(e,t){return Io(e,t)}});const Go=va({concat3d_:function(e,t){return Io(e,t)}});const Ho=va({concat4d_:function(e,t){return Io(e,t)}});const jo=va({conv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=ba(e,"x","conv2d","float32"),l=ba(t,"filter","conv2d","float32");let c=o,h=!1;3===o.rank&&(h=!0,c=vo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),wo("conv2d",s,i);const p="NHWC"===r?c.shape[3]:c.shape[1];u(p===l.shape[2],(()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${l.shape[2]}.`)),u(yo(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),u(bo(a),(()=>"Error in conv2D: Dilated rates should be larger than 0.")),u(bo(n),(()=>"Error in conv2D: Strides should be larger than 0."));const d={x:c,filter:l},f={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=la.runKernel("Conv2D",d,f);return h?vo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const qo=va({conv1d_:function(e,t,n,s,r="NWC",a=1,i){const o=ba(e,"x","conv1d"),l=ba(t,"filter","conv1d");let c=o,h=!1;2===o.rank&&(h=!0,c=vo(o,[1,o.shape[0],o.shape[1]])),u(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),u(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),wo("conv1d",s,i),u(c.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),u(yo(n,a),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`)),u(bo(a),(()=>"Error in conv1D: Dilated rates should be larger than 0.")),u(bo(n),(()=>"Error in conv1D: Stride should be larger than 0.")),u("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const p=vo(l,[1,l.shape[0],l.shape[1],l.shape[2]]),d=vo(c,[c.shape[0],1,c.shape[1],c.shape[2]]),f=jo(d,p,[1,n],s,"NHWC",[1,a],i);return vo(f,h?[f.shape[2],f.shape[3]]:[f.shape[0],f.shape[2],f.shape[3]])}});const Ko=va({conv2DBackpropInput_:function(e,t,n,s,r,a="NHWC",i){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,l=t,c=!1;3===t.rank&&(c=!0,l=vo(t,[1,t.shape[0],t.shape[1],t.shape[2]]),o=[1,e[0],e[1],e[2]]),u(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),u(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),u(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===a?o[3]:o[1],p="NHWC"===a?l.shape[3]:l.shape[1];u(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),u(p===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`)),wo("conv2dDerInput",r,i);const d={dy:l,filter:n},f={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:o},m=la.runKernel("Conv2DBackpropInput",d,f);return c?vo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Xo=va({conv2dTranspose_:function(e,t,n,s,r,a){const i=ba(e,"x","conv2dTranspose"),o=ba(t,"filter","conv2dTranspose");return Ko(n,i,o,s,r,"NHWC",a)}});const Yo=va({conv3d_:function(e,t,n,s,r="NDHWC",a=[1,1,1]){const i=ba(e,"x","conv3d"),o=ba(t,"filter","conv3d");let l=i,c=!1;4===i.rank&&(c=!0,l=vo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),u(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),u(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),u(yo(n,a),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),u("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`)),u(bo(a),(()=>"Error in conv3D: Dilated rates should be larger than 0.")),u(bo(n),(()=>"Error in conv3D: Strides should be larger than 0."));const h={x:l,filter:o},p={strides:n,pad:s,dataFormat:r,dilations:a},d=la.runKernel("Conv3D",h,p);return c?vo(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Zo=va({conv3DBackpropInput_:function(e,t,n,s,r){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let a=e,i=t,o=!1;4===t.rank&&(o=!0,i=vo(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const l=a[4],c=i.shape[4];u(5===a.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`)),u(5===i.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`)),u(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),u(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),u(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=la.runKernel("Conv3DBackpropInputV2",h,p);return o?vo(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Jo=va({conv3dTranspose_:function(e,t,n,s,r){const a=ba(e,"x","conv3dTranspose"),i=ba(t,"filter","conv3dTranspose");return Zo(n,a,i,s,r)}});const Qo=va({cos_:function(e){const t={x:ba(e,"x","cos","float32")};return la.runKernel(Oe,t)}});const el=va({cosh_:function(e){const t={x:ba(e,"x","cosh","float32")};return la.runKernel("Cosh",t)}});const tl=va({cumprod_:function(e,t=0,n=!1,s=!1){const r={x:ba(e,"x","cumprod")},a={axis:t,exclusive:n,reverse:s};return la.runKernel("Cumprod",r,a)}});const nl=va({cumsum_:function(e,t=0,n=!1,s=!1){const r={x:ba(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:s};return la.runKernel("Cumsum",r,a)}});const sl=va({denseBincount_:function(e,t,n,s=!1){const r=ba(e,"x","denseBincount"),a=ba(t,"weights","denseBincount");u("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),u(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(a.size===r.size||0===a.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${a.shape}.`));const i={x:r,weights:a},o={size:n,binaryOutput:s};return la.runKernel("DenseBincount",i,o)}});const rl=va({depthToSpace_:function(e,t,n="NHWC"){const s=ba(e,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];u(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),u(r*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${t}  for depthToSpace with input shape\n    ${s.shape}`)),u(a*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${s.shape}`)),u(i%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:t,dataFormat:n};return la.runKernel("DepthToSpace",o,l)}});const al=va({depthwiseConv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=ba(e,"x","depthwiseConv2d","float32"),l=ba(t,"filter","depthwiseConv2d","float32");let c=o,h=!1;3===o.rank&&(h=!0,c=vo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const p="NHWC"===r?c.shape[3]:c.shape[1];u(p===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${p}) must match the inChannels dimension in filter ${l.shape[2]}.`)),wo("depthwiseConv2d",s,i);const d={x:c,filter:l},f={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=la.runKernel("DepthwiseConv2dNative",d,f);return h?vo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const il=va({diag_:function(e){const t={x:ba(e,"x","diag")};return la.runKernel("Diag",t)}});const ol=va({dilation2d_:function(e,t,n,s,r=[1,1],a="NHWC"){const i=ba(e,"x","dilation2d"),o=ba(t,"filter","dilation2d");u(3===i.rank||4===i.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`)),u(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),u("NHWC"===a,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`));let l=i,c=!1;3===i.rank&&(l=vo(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0),u(l.shape[3]===o.shape[2],(()=>`Error in dilation2d:  input and filter must have the same depth: ${l.shape[3]} vs ${o.shape[2]}`));const h={x:l,filter:o},p={strides:n,pad:s,dilations:r},d=la.runKernel("Dilation2D",h,p);return c?vo(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});function ll(e,t){const n=e.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=e[a]||1;(t[t.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function ul(e,t){const n=[];for(let s=0;s<t.length;s++){const r=e[e.length-s-1],a=t.length-s-1,i=t[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function cl(e,t){const n=Math.max(e.length,t.length),s=new Array(n);for(let r=0;r<n;r++){let a=e[e.length-r-1];null==a&&(a=1);let i=t[t.length-r-1];if(null==i&&(i=1),1===a)s[n-r-1]=i;else if(1===i)s[n-r-1]=a;else{if(a!==i){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}s[n-r-1]=a}}return s}var hl=Object.freeze({__proto__:null,assertAndGetBroadcastShape:cl,getBroadcastDims:ll,getReductionAxes:ul});const pl=va({equal_:function(e,t){let n=ba(e,"a","equal","string_or_numeric"),s=ba(t,"b","equal","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("Equal",r)}});const dl=va({where_:function(e,t,n){const s=ba(t,"a","where"),r=ba(n,"b","where"),a=ba(e,"condition","where","bool"),i=cl(cl(a.shape,s.shape),r.shape),o={condition:zo(a,i),t:zo(s,i),e:zo(r,i)};return la.runKernel("Select",o)}});const fl=va({zerosLike_:function(e){const t={x:ba(e,"x","zerosLike")};return la.runKernel("ZerosLike",t)}});const ml=va({divNoNan_:function(e,t){let n=ba(e,"a","div"),s=ba(t,"b","div");[n,s]=Jr(n,s);const r=Gi(n,s),a=fl(r),i=pl(s,a);return dl(i,a,r)}});const gl=va({dot_:function(e,t){const n=ba(e,"t1","dot"),s=ba(t,"t2","dot");u(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(u(r===a,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`)),1===n.rank&&1===s.rank){const e=vo(n,[1,-1]),t=vo(s,[-1,1]),r=So(e,t);return vo(r,[])}if(1===n.rank&&2===s.rank){const e=vo(n,[1,-1]),t=vo(s,[s.shape[0],s.shape[1]]),r=So(e,t);return vo(r,[r.size])}if(2===n.rank&&1===s.rank){const e=vo(s,[-1,1]),t=So(n,e);return vo(t,[t.size])}{const e=vo(s,[s.shape[0],s.shape[1]]);return So(n,e)}}});const yl=va({einsum_:function(e,...t){const n=t.map(((e,t)=>ba(e,`tensors${t}`,"einsum"))),s={equation:e};return la.runKernel("Einsum",n,s)}});const bl=va({elu_:function(e){const t={x:ba(e,"x","elu","float32")};return la.runKernel("Elu",t)}});const xl=va({ensureShape_:function(e,t){const n=ba(e,"x","ensureShape","string_or_numeric");if(!d(n.shape,t))throw new Error(`EnsureShape: Shape of tensor ${n.shape} is not compatible with expected shape ${t}`);return e}});const wl=va({erf_:function(e){let t=ba(e,"x","erf");u("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=Pi(t,"float32"));const n={x:t};return la.runKernel(et,n)}});function vl(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function kl(e,t,n){const s=e.length+t.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(e[a++]):r.push(t[i++]);return r}function Nl(e,t){const n=[],s=e.length;for(let r=0;r<s;r++)-1===t.indexOf(r)&&n.push(e[r]);return[n,t.map((t=>e[t]))]}function Il(e,t){return kl(e,t.map((e=>1)),t)}function Sl(e,t,n){u(vl(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))}function Tl(e,t){if(vl(e,t))return null;const n=[];for(let s=0;s<t;++s)-1===e.indexOf(s)&&n.push(s);return e.forEach((e=>n.push(e))),n}function Cl(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))}function $l(e,t){const n=[];for(let s=t-e;s<t;++s)n.push(s);return n}const El=va({max_:function(e,t=null,n=!1){const s={x:ba(e,"x","max")},r={reductionIndices:t,keepDims:n};return la.runKernel("Max",s,r)}});const Al=va({min_:function(e,t=null,n=!1){const s={x:ba(e,"x","min")},r={axis:t,keepDims:n};return la.runKernel("Min",s,r)}});const Rl=va({pow_:function(e,t){let n=ba(e,"base","pow"),s=ba(t,"exp","pow");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel(on,r)}});function _l(e,t){if((Ir(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&Ir(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Na(e,[],[],t)}const Fl=va({sqrt_:function(e){const t={x:ba(e,"x","sqrt","float32")};return la.runKernel("Sqrt",t)}});const Dl=va({square_:function(e){const t=ba(e,"x","square");return la.runKernel("Square",{x:t},{})}});const Ol=va({sum_:function(e,t=null,n=!1){let s=ba(e,"x","sum");"bool"===s.dtype&&(s=Pi(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return la.runKernel("Sum",r,a)}});function Ml(e,t,n=null){if(0===e.rank)return ji(e);if(1!==e.rank&&null===n)return Ml(vo(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Ol(ji(e),n);if(t===1/0)return El(ji(e),n);if(t===-1/0)return Al(ji(e),n);if("euclidean"===t||2===t)return Fl(Ol(Rl(ji(e),_l(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return El(Ol(ji(e),n[0]),n[1]-1);if(t===1/0)return El(Ol(ji(e),n[1]),n[0]);if(t===-1/0)return Al(Ol(ji(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Fl(Ol(Dl(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Ll=va({norm_:function(e,t="euclidean",n=null,s=!1){const r=Ml(e=ba(e,"x","norm"),t,n);let a=r.shape;if(s){const t=w(n,e.shape);a=Il(r.shape,t)}return vo(r,a)}});const zl=va({euclideanNorm_:function(e,t=null,n=!1){return Ll(e,"euclidean",t,n)}});const Pl=va({exp_:function(e){const t={x:ba(e,"x","exp")};return la.runKernel(nt,t)}});const Bl=va({expandDims_:function(e,t=0){const n=ba(e,"x","expandDims","string_or_numeric");u(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:t};return la.runKernel("ExpandDims",s,r)}});const Wl=va({expm1_:function(e){const t={x:ba(e,"x","expm1")};return la.runKernel("Expm1",t)}});const Vl=va({tile_:function(e,t){const n=ba(e,"x","tile","string_or_numeric");u(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const s={x:n},r={reps:t};return la.runKernel("Tile",s,r)}});const Ul=va({eye_:function(e,t,n,s="float32"){null==t&&(t=e);const r=zi([e,t],s),a=e<=t?e:t;for(let e=0;e<a;++e)r.set(1,e,e);const i=vo(r.toTensor(),[e,t]);if(null==n)return i;if(1===n.length)return Vl(Bl(i,0),[n[0],1,1]);if(2===n.length)return Vl(Bl(Bl(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return Vl(Bl(Bl(Bl(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});const Gl=va({floor_:function(e){const t={x:ba(e,"x","floor","float32")};return la.runKernel("Floor",t)}});const Hl=va({gather_:function(e,t,n=0,s=0){const r={x:ba(e,"x","gather"),indices:ba(t,"indices","gather","int32")},a={axis:n,batchDims:s};return la.runKernel("GatherV2",r,a)}});const jl=va({greater_:function(e,t){let n=ba(e,"a","greater","string_or_numeric"),s=ba(t,"b","greater","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("Greater",r)}});const ql=va({greaterEqual_:function(e,t){let n=ba(e,"a","greaterEqual","string_or_numeric"),s=ba(t,"b","greaterEqual","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("GreaterEqual",r)}});const Kl=va({imag_:function(e){const t={input:ba(e,"input","imag")};return la.runKernel("Imag",t)}});const Xl=va({isFinite_:function(e){const t={x:ba(e,"x","isFinite")};return la.runKernel("IsFinite",t)}});const Yl=va({isInf_:function(e){const t={x:ba(e,"x","isInf")};return la.runKernel("IsInf",t)}});const Zl=va({isNaN_:function(e){const t={x:ba(e,"x","isNaN")};return la.runKernel("IsNan",t)}});const Jl=va({leakyRelu_:function(e,t=.2){const n={x:ba(e,"x","leakyRelu")},s={alpha:t};return la.runKernel("LeakyRelu",n,s)}});const Ql=va({less_:function(e,t){let n=ba(e,"a","less","string_or_numeric"),s=ba(t,"b","less","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("Less",r)}});const eu=va({lessEqual_:function(e,t){let n=ba(e,"a","lessEqual","string_or_numeric"),s=ba(t,"b","lessEqual","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("LessEqual",r)}});function tu(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:e,stop:t,num:n};return la.runKernel("LinSpace",{},s)}const nu=va({localResponseNormalization_:function(e,t=5,n=1,s=1,r=.5){const a=ba(e,"x","localResponseNormalization");u(4===a.rank||3===a.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`)),u(m(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let i=a,o=!1;3===a.rank&&(o=!0,i=vo(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const l={x:i},c={depthRadius:t,bias:n,alpha:s,beta:r},h=la.runKernel("LRN",l,c);return o?vo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const su=va({log_:function(e){const t={x:ba(e,"x","log","float32")};return la.runKernel(St,t)}});const ru=va({log1p_:function(e){const t={x:ba(e,"x","log1p")};return la.runKernel("Log1p",t)}});function au(e){return u(F(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const s=ba(t,"x","tf.grad","string_or_numeric"),r=null!=n?ba(n,"dy","tf.grad"):null;return la.tidy((()=>{const{value:t,grads:n}=la.gradients((()=>e(s)),[s],r);return null!=r&&c(t.shape,r.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),hu(n),n[0]}))}}function iu(e){return u(F(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{u(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const s=xa(t,"args","tf.grads","string_or_numeric"),r=null!=n?ba(n,"dy","tf.grads"):null;return la.tidy((()=>{const{value:t,grads:n}=la.gradients((()=>e(...s)),s,r);return null!=r&&c(t.shape,r.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),hu(n),n}))}}function ou(e){return u(F(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{u(t instanceof Pr,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),u(null==n||n instanceof Pr,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:s,value:r}=la.gradients((()=>e(t)),[t],n);return hu(s),{grad:s[0],value:r}}}function lu(e){return u(F(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{u(Array.isArray(t)&&t.every((e=>e instanceof Pr)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),u(null==n||n instanceof Pr,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const s=la.gradients((()=>e(...t)),t,n);return null!=n&&c(s.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),hu(s.grads),s}}function uu(e,t){u(F(e),(()=>"The f passed in variableGrads(f) must be a function")),u(null==t||Array.isArray(t)&&t.every((e=>e instanceof Wr)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in la.registeredVariables)t.push(la.registeredVariables[e])}const s=n?t.filter((e=>!e.trainable)):null,r=t.length;t=t.filter((e=>e.trainable)),u(t.length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:a,grads:i}=la.gradients(e,t,null,!0);u(i.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),u(0===a.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`));const o={};return t.forEach(((e,t)=>{null!=i[t]&&(o[e.name]=i[t])})),null!=s&&s.forEach((e=>o[e.name]=null)),{value:a,grads:o}}function cu(e){return la.customGrad(e)}function hu(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const pu=va({neg_:function(e){const t={x:ba(e,"x","neg")};return la.runKernel("Neg",t)}});const du=va({softplus_:function(e){const t={x:ba(e,"x","softplus")};return la.runKernel("Softplus",t)}});const fu=va({logSigmoid_:function(e){const t=ba(e,"x","logSigmoid"),n=cu((e=>({value:pu(du(pu(e))),gradFunc:t=>Hi(t,To(pu(e)))})));return n(t)}});const mu=va({sub_:function(e,t){let n=ba(e,"a","sub"),s=ba(t,"b","sub");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel(es,r)}});const gu=va({logSoftmax_:function(e,t=-1){const n=ba(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const s=cu(((e,n)=>{const s=El(e,t,!0),r=mu(e,s),a=mu(Pi(r,"float32"),su(Ol(Pl(r),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[s]=n,r=Pl(s);return mu(e,Hi(Ol(e,t,!0),r))}}}));return s(n)}});const yu=va({logSumExp_:function(e,t=null,n=!1){const s=ba(e,"x","logSumExp"),r=w(t,s.shape),a=El(s,r,!0),i=mu(s,a),o=Pl(i),l=Ol(o,r),u=su(l),c=Vi(vo(a,u.shape),u);if(n){const e=Il(c.shape,r);return vo(c,e)}return c}});const bu=va({logicalAnd_:function(e,t){const n=ba(e,"a","logicalAnd","bool"),s=ba(t,"b","logicalAnd","bool");cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("LogicalAnd",r)}});const xu=va({logicalNot_:function(e){const t={x:ba(e,"x","logicalNot","bool")};return la.runKernel("LogicalNot",t)}});const wu=va({logicalOr_:function(e,t){const n=ba(e,"a","logicalOr","bool"),s=ba(t,"b","logicalOr","bool");cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("LogicalOr",r)}});const vu=va({logicalXor_:function(e,t){const n=ba(e,"a","logicalXor","bool"),s=ba(t,"b","logicalXor","bool");return cl(n.shape,s.shape),bu(wu(e,t),xu(bu(e,t)))}});const ku=va({searchSorted_:function(e,t,n="left"){const s=ba(e,"sortedSequence","searchSorted"),r=ba(t,"values","searchSorted"),a=s.shape[s.shape.length-1],i=r.shape[r.shape.length-1],o=vo(s,[-1,a]),l=vo(r,[-1,i]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(p(l.shape)>=2147483648)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=2147483648)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},c={side:n};return la.runKernel("SearchSorted",u,c)}});function Nu(e,t){return ku(e,t,"left")}const Iu=va({maxPool_:function(e,t,n,s,r){const a=ba(e,"x","maxPool");let i=a,o=!1;3===a.rank&&(o=!0,i=vo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===i.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`)),u(yo(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),wo("maxPool",s,r);const l={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r},h=la.runKernel("MaxPool",l,c);return o?vo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Su=va({maxPool3d_:function(e,t=[1,1,1],n,s,r,a="NDHWC"){const i=ba(e,"x","maxPool3d");let o=i,l=!1;4===i.rank&&(l=!0,o=vo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),u("NDHWC"===a,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),wo("maxPool3d",s,r);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a},p=la.runKernel("MaxPool3D",c,h);return l?vo(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Tu=va({maxPoolWithArgmax_:function(e,t,n,s,r=!1){const a={x:ba(e,"x","maxPoolWithArgmax")},i={filterSize:t,strides:n,pad:s,includeBatchInIndex:r},o=la.runKernel("MaxPoolWithArgmax",a,i);return{result:o[0],indexes:o[1]}}});const Cu=va({maximum_:function(e,t){let n=ba(e,"a","maximum"),s=ba(t,"b","maximum");[n,s]=Jr(n,s),"bool"===n.dtype&&(n=Pi(n,"int32"),s=Pi(s,"int32")),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("Maximum",r)}});const $u=va({mean_:function(e,t=null,n=!1){const s={x:ba(e,"x","mean")},r={axis:t,keepDims:n};return la.runKernel("Mean",s,r)}});function Eu(e,t="float32"){if(V(e),"complex64"===t){const t=Eu(e,"float32"),n=Eu(e,"float32");return ka(t,n)}const n=B(p(e),t);return la.makeTensor(n,e,t)}function Au(e,t="float32"){if(V(e),"complex64"===t){const t=Au(e,"float32"),n=Eu(e,"float32");return ka(t,n)}const n=P(p(e),t);return la.makeTensor(n,e,t)}function Ru(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let s=ba(e,"x","meshgrid",e instanceof Pr?e.dtype:"float32");if(void 0===t)return[s];let r=ba(t,"y","meshgrid",t instanceof Pr?t.dtype:"float32");const a=p(s.shape),i=p(r.shape);return"xy"===n?(s=vo(s,[1,-1]),r=vo(r,[-1,1]),[So(Au([i,1],s.dtype),s),So(r,Au([1,a],r.dtype))]):(s=vo(s,[-1,1]),r=vo(r,[1,-1]),[So(s,Au([1,i],s.dtype)),So(Au([a,1],r.dtype),r)])}const _u=va({minimum_:function(e,t){let n=ba(e,"a","minimum"),s=ba(t,"b","minimum");[n,s]=Jr(n,s),"bool"===n.dtype&&(n=Pi(n,"int32"),s=Pi(s,"int32")),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("Minimum",r)}});const Fu=va({mirrorPad_:function(e,t,n){u("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=ba(e,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");u(t.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`));const r="reflect"===n?1:0;for(let e=0;e<s.rank;e++)u(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),u(t[e][0]>=0&&t[e][0]<=s.shape[e]-r&&t[e][1]>=0&&t[e][1]<=s.shape[e]-r,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${s.shape[e]-r} or less than 0 for input of shape ${s.shape}`));const a={paddings:t,mode:n},i={x:s};return la.runKernel("MirrorPad",i,a)}});const Du=va({mod_:function(e,t){let n=ba(e,"a","mod"),s=ba(t,"b","mod");[n,s]=Jr(n,s);const r={a:n,b:s};return la.runKernel(qt,r)}});const Ou=va({moments_:function(e,t=null,n=!1){const s=w(t,(e=ba(e,"x","moments")).shape),r=$u(e,s,n);let a=r.shape;n||(a=Il(r.shape,s));const i=Dl(mu(Pi(e,"float32"),vo(r,a)));return{mean:r,variance:$u(i,s,n)}}});const Mu=va({multiRNNCell_:function(e,t,n,s){const r=ba(t,"data","multiRNNCell"),a=xa(n,"c","multiRNNCell"),i=xa(s,"h","multiRNNCell");let o=r;const l=[];for(let t=0;t<e.length;t++){const n=e[t](o,a[t],i[t]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const Lu=va({multinomial_:function(e,t,n,s=!1){const r=ba(e,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);if(i>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${i}`);n=n||Math.random();const o={logits:1===i?vo(r,[1,-1]):r},l={numSamples:t,seed:n,normalized:s},u=la.runKernel("Multinomial",o,l);return 1===i?vo(u,[u.size]):u}});const zu=va({notEqual_:function(e,t){let n=ba(e,"a","notEqual","string_or_numeric"),s=ba(t,"b","notEqual","string_or_numeric");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("NotEqual",r)}});const Pu=va({oneHot_:function(e,t,n=1,s=0,r="int32"){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const a={indices:ba(e,"indices","oneHot","int32")},i={dtype:r,depth:t,onValue:n,offValue:s};return la.runKernel("OneHot",a,i)}});const Bu=va({onesLike_:function(e){const t={x:ba(e,"x","onesLike")};return la.runKernel("OnesLike",t)}});const Wu=va({outerProduct_:function(e,t){const n=ba(e,"v1","outerProduct"),s=ba(t,"v2","outerProduct");u(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=vo(n,[-1,1]),a=vo(s,[1,-1]);return So(r,a)}});const Vu=va({pad_:function(e,t,n=0){const s=ba(e,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:t,constantValue:n},a={x:s};return la.runKernel("PadV2",a,r)}});const Uu=va({pad1d_:function(e,t,n=0){return u(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),Vu(e,[t],n)}});const Gu=va({pad2d_:function(e,t,n=0){return u(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Vu(e,t,n)}});const Hu=va({pad3d_:function(e,t,n=0){return u(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Vu(e,t,n)}});const ju=va({pad4d_:function(e,t,n=0){return u(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Vu(e,t,n)}});const qu=va({spaceToBatchND_:function(e,t,n){const s=ba(e,"x","spaceToBatchND");u(s.rank>=1+t.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${t.length}`)),u(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),u(s.shape.reduce(((e,s,r)=>r>0&&r<=t.length?e&&(s+n[r-1][0]+n[r-1][1])%t[r-1]==0:e),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const r={x:s},a={blockShape:t,paddings:n};return la.runKernel("SpaceToBatchND",r,a)}});const Ku=va({pool_:function(e,t,n,s,r,a,i){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const o=ba(e,"x","maxPool");let l=o,c=!1;3===o.rank&&(c=!0,l=vo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(yo(a,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`));const h=io(l.shape,t,a,r,s),p=[h.dilationHeight,h.dilationWidth];let d;d="same"===s?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),s=n.map((e=>Math.floor(e/2))),r=n.map(((e,t)=>e-s[t]));return n.map(((e,t)=>[s[t],r[t]]))}([h.filterHeight,h.filterWidth],p):[[0,0],[0,0]];const f=1===p[0]&&1===p[1],[m,g]=function(e,t,n){const s=n.map((e=>e[0])),r=n.map((e=>e[1])),a=e.concat(s,r),i=t.map(((e,t)=>(e-a[t]%e)%e)),o=r.map(((e,t)=>e+i[t])),l=t.map(((e,t)=>[s[t],o[t]])),u=t.map(((e,t)=>[0,i[t]]));return[l,u]}([h.inHeight,h.inWidth],p,d),y=f?s:"valid",b=f?l:qu(l,p,m),x=("avg"===n?()=>ko(b,t,a,y,i):()=>Iu(b,t,a,y,i))(),w=f?x:Ao(x,p,g);return c?vo(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Xu=va({prelu_:function(e,t){const n={x:ba(e,"x","prelu"),alpha:ba(t,"alpha","prelu")};return la.runKernel("Prelu",n)}});const Yu=va({prod_:function(e,t=null,n=!1){let s=ba(e,"x","prod");"bool"===s.dtype&&(s=Pi(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return la.runKernel("Prod",r,a)}});const Zu=va({raggedGather_:function(e,t,n,s){const r={paramsNestedSplits:e.map(((e,t)=>ba(e,`tensors${t}`,"raggedGather","int32"))),paramsDenseValues:ba(t,"paramsDenseValues","raggedGather"),indices:ba(n,"indices","raggedGather","int32")},a={outputRaggedRank:s},i=la.runKernel("RaggedGather",r,a);return{outputNestedSplits:i.slice(0,i.length-1),outputDenseValues:i[i.length-1]}}});const Ju=va({raggedRange_:function(e,t,n){const s=ba(e,"starts","raggedRange"),r={starts:s,limits:ba(t,"limits","raggedRange",s.dtype),deltas:ba(n,"deltas","raggedRange",s.dtype)},a=la.runKernel("RaggedRange",r);return{rtNestedSplits:a[0],rtDenseValues:a[1]}}});const Qu=va({raggedTensorToTensor_:function(e,t,n,s,r){const a=ba(e,"shape","raggedTensorToTensor","int32"),i=ba(t,"values","raggedTensorToTensor"),o={shape:a,values:i,defaultValue:ba(n,"defaultValue","raggedTensorToTensor",i.dtype),rowPartitionTensors:s.map(((e,t)=>ba(e,`tensors${t}`,"raggedTensorToTensor","int32")))},l={rowPartitionTypes:r};return la.runKernel("RaggedTensorToTensor",o,l)}});const ec=va({rand_:function(e,t,n){V(e);const s=p(e);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let e=0;e<s;e++)r[e]=t();return la.makeTensor(r,e,n)}});var tc={exports:{}};!function(e,t,n){function s(e){var t,n=this,s=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var s=.02519603282416938*(t+=e.charCodeAt(n));s-=t=s>>>0,t=(s*=t)>>>0,t+=4294967296*(s-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(e),n.s0<0&&(n.s0+=1),n.s1-=s(e),n.s1<0&&(n.s1+=1),n.s2-=s(e),n.s2<0&&(n.s2+=1),s=null}function r(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new s(e),a=t&&t.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,tc,!1);var nc=tc.exports,sc={exports:{}};!function(e,t,n){function s(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,sc,!1);var rc=sc.exports,ac={exports:{}};!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),s==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,ac,!1);var ic=ac.exports,oc={exports:{}};!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.x,r=t.i;return e=s[r],n=(e^=e>>>7)^e<<24,n^=(e=s[r+1&7])^e>>>10,n^=(e=s[r+3&7])^e>>>3,n^=(e=s[r+4&7])^e<<7,e=s[r+7&7],n^=(e^=e<<13)^e<<9,s[r]=n,t.i=r+1&7,n},function(e,t){var n,s=[];if(t===(0|t))s[0]=t;else for(t=""+t,n=0;n<t.length;++n)s[7&n]=s[7&n]<<15^t.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],e.x=s,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function r(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,oc,!1);var lc=oc.exports,uc={exports:{}};!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.w,r=t.X,a=t.i;return t.w=s=s+1640531527|0,n=r[a+34&127],e=r[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=r[a]=n^e,t.i=a,n+(s^s>>>16)|0},function(e,t){var n,s,r,a,i,o=[],l=128;for(t===(0|t)?(s=t,t=null):(t+="\0",s=0,l=Math.max(l,t.length)),r=0,a=-32;a<l;++a)t&&(s^=t.charCodeAt((a+32)%t.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(t&&t.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;e.w=i,e.X=o,e.i=r}(t,e)}function r(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,uc,!1);var cc=uc.exports,hc={exports:{}};!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,s=t.d,r=t.a;return e=e<<25^e>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-s|0,t.d=s<<16^n>>>16^r,t.a=r-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var s=0;s<n.length+20;s++)t.b^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,hc,!1);var pc,dc=hc.exports,fc={exports:{}};pc=fc,function(e,t,n){var s,r=256,a=n.pow(r,6),i=n.pow(2,52),o=2*i,l=255;function u(l,u,m){var g=[],y=d(p((u=1==u?{entropy:!0}:u||{}).entropy?[l,f(t)]:null==l?function(){try{var n;return s&&(n=s.randomBytes)?n=n(r):(n=new Uint8Array(r),(e.crypto||e.msCrypto).getRandomValues(n)),f(n)}catch(n){var a=e.navigator,i=a&&a.plugins;return[+new Date,e,i,e.screen,f(t)]}}():l,3),g),b=new c(g),x=function(){for(var e=b.g(6),t=a,n=0;e<i;)e=(e+n)*r,t*=r,n=b.g(1);for(;e>=o;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|b.g(4)},x.quick=function(){return b.g(4)/4294967296},x.double=x,d(f(b.S),t),(u.pass||m||function(e,t,s,r){return r&&(r.S&&h(r,b),e.state=function(){return h(b,{})}),s?(n.random=e,t):e})(x,y,"global"in u?u.global:this==n,u.state)}function c(e){var t,n=e.length,s=this,a=0,i=s.i=s.j=0,o=s.S=[];for(n||(e=[n++]);a<r;)o[a]=a++;for(a=0;a<r;a++)o[a]=o[i=l&i+e[a%n]+(t=o[a])],o[i]=t;(s.g=function(e){for(var t,n=0,a=s.i,i=s.j,o=s.S;e--;)t=o[a=l&a+1],n=n*r+o[l&(o[a]=o[i=l&i+t])+(o[i]=t)];return s.i=a,s.j=i,n})(r)}function h(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function p(e,t){var n,s=[],r=typeof e;if(t&&"object"==r)for(n in e)try{s.push(p(e[n],t-1))}catch(e){}return s.length?s:"string"==r?e:e+"\0"}function d(e,t){for(var n,s=e+"",r=0;r<s.length;)t[l&r]=l&(n^=19*t[l&r])+s.charCodeAt(r++);return f(t)}function f(e){return String.fromCharCode.apply(0,e)}if(d(n.random(),t),pc.exports){pc.exports=u;try{s=require("crypto")}catch(e){}}else n.seedrandom=u}("undefined"!=typeof self?self:Rs,[],Math);var mc=fc.exports,gc=nc,yc=rc,bc=ic,xc=lc,wc=cc,vc=dc,kc=mc;kc.alea=gc,kc.xor128=yc,kc.xorwow=bc,kc.xorshift7=xc,kc.xor4096=wc,kc.tychei=vc;var Nc=kc;function Ic(){return 32===la.backend.floatPrecision()?.001:.1}function Sc(e,t,n){let s=!0;if((Ir(e)||Ir(t))&&(s=!1),Ir(e)&&Ir(t)&&(s=!0),s){const n=e.constructor.name,s=t.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${s}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=ma(e),s=ma(t);if(!f(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=Ir(e)?e:Sr(e),a=Ir(t)?t:Sr(t);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let e=0;e<a.length;++e){const t=r[e],s=a[e];if(!n(t,s))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}"undefined"!=typeof expect&&expect().nothing()}function Tc(e,t,n){if(null==n&&(n=Ic()),!Cc(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`);"undefined"!=typeof expect&&expect().nothing()}function Cc(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var $c=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,createVideoElement:function(e){const t=document.createElement("video");return"playsInline"in t&&(t.playsInline=!0),t.muted=!0,t.loop=!0,t.style.position="fixed",t.style.left="0px",t.style.top="0px",t.preload="auto",t.appendChild(e),new Promise((e=>{t.addEventListener("loadeddata",(n=>e(t))),t.load()}))},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const s=t[n];Array.isArray(s)?e(s):t[n]=kr(s)}return t},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),s=new Float32Array(t);if(n.length!==s.length)throw new Error(`Expected ArrayBuffer to be of length ${s.length}, but it was ${n.length}`);for(let e=0;e<s.length;e++)if(n[e]!==s[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${s[e]} but got ${n[e]} instead`)},expectArraysClose:function(e,t,n){return null==n&&(n=Ic()),Sc(e,t,((e,t)=>Cc(e,t,n)))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return E(e)||E(e[0])||E(t)||E(t[0])?Sc(e,n,((e,t)=>e==t)):Sc(e,t,((e,t)=>Cc(e,t,0)))},expectNumbersClose:Tc,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t())),"undefined"!=typeof expect&&expect().nothing()},expectValuesInRange:function(e,t,n){for(let s=0;s<e.length;s++)if(e[s]<t||e[s]>n)throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`)},play:async function(e){await e.play(),"requestVideoFrameCallback"in e&&await new Promise((t=>{e.requestVideoFrameCallback(t)}))},testEpsilon:Ic});class Ec{constructor(e,t,n,s,r){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=Nc.alea(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*s*i,t=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Ac{constructor(e,t,n,s){this.alpha=e,this.beta=1/t,this.dtype=n;const r=s||Math.random();this.randu=Nc.alea(r.toString()),this.randn=new Ec(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,e=s*s,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),r=this.randu(),r<t||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class Rc{constructor(e=0,t=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Nc.alea(s)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const _c=va({randomGamma_:function(e,t,n=1,s="float32",r){if(V(e),null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const a=new Ac(t,n,s,r),i=zi(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Fc=va({randomNormal_:function(e,t=0,n=1,s,r){if(V(e),null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const a=new Ec(t,n,s,!1,r),i=zi(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Dc=va({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return Fc(e,0,1,t,n)}});const Oc=va({randomUniform_:function(e,t=0,n=1,s="float32",r){V(e);const a=zi(e,s),i=new Rc(t,n,null,r);for(let e=0;e<a.values.length;e++)a.values[e]=i.nextValue();return a.toTensor()}});const Mc=va({randomUniformInt_:function(e,t,n,s){return Oc(e,t,n,"int32",s)}});function Lc(e,t,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:e,stop:t,step:n,dtype:s};return la.runKernel("Range",{},r)}const zc=va({real_:function(e){const t={input:ba(e,"input","real")};return la.runKernel("Real",t)}});const Pc=va({reciprocal_:function(e){const t={x:ba(e,"x","reciprocal")};return la.runKernel("Reciprocal",t)}});const Bc=va({relu_:function(e){const t={x:ba(e,"x","relu")};return la.runKernel("Relu",t)}});const Wc=va({relu6_:function(e){const t={x:ba(e,"x","relu6")};return la.runKernel("Relu6",t)}});const Vc=va({reverse_:function(e,t){const n={x:ba(e,"x","reverse")},s={dims:t};return la.runKernel("Reverse",n,s)}});const Uc=va({reverse1d_:function(e){const t=ba(e,"x","reverse");return u(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),Vc(t,0)}});const Gc=va({reverse2d_:function(e,t){const n=ba(e,"x","reverse");return u(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Vc(n,t)}});const Hc=va({reverse3d_:function(e,t){const n=ba(e,"x","reverse");return u(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Vc(n,t)}});const jc=va({reverse4d_:function(e,t){const n=ba(e,"x","reverse");return u(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Vc(n,t)}});const qc=va({round_:function(e){const t={x:ba(e,"x","round")};return la.runKernel("Round",t)}});const Kc=va({rsqrt_:function(e){const t={x:ba(e,"x","rsqrt","float32")};return la.runKernel("Rsqrt",t)}});const Xc=va({selu_:function(e){const t={x:ba(e,"x","selu")};return la.runKernel("Selu",t)}});const Yc=va({separableConv2d_:function(e,t,n,s,r,a=[1,1],i="NHWC"){const o=ba(e,"x","separableConv2d"),l=ba(t,"depthwiseFilter","separableConv2d"),c=ba(n,"pointwiseFilter","separableConv2d");let h=o,p=!1;if(3===o.rank&&(p=!0,h=vo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");u(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),u(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),u(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),u(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),u(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const d=l.shape[2],f=l.shape[3];u(c.shape[2]===d*f,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`));const m=al(h,l,s,r,i,a),g=jo(m,c,1,"valid",i);return p?vo(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Zc=async function(e,t){const n=ba(e,"x","setdiff1d"),s=ba(t,"y","setdiff1d");u(n.dtype===s.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`)),u(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),u(1===s.rank,(()=>`y should be 1D tensor, but got y (${s.shape}).`));const r=await n.data(),a=await s.data(),i=new Set(a);let o=0;for(let e=0;e<r.length;e++)i.has(r[e])||o++;const l=new Or([o],n.dtype),c=new Or([o],"int32");for(let e=0,t=0;e<r.length;e++)i.has(r[e])||(l.values[t]=r[e],c.values[t]=e,t++);return[l.toTensor(),c.toTensor()]};const Jc=va({sign_:function(e){const t={x:ba(e,"x","sign")};return la.runKernel("Sign",t)}});const Qc=va({sin_:function(e){const t={x:ba(e,"x","sin","float32")};return la.runKernel(_n,t)}});const eh=va({sinh_:function(e){const t={x:ba(e,"x","sinh")};return la.runKernel("Sinh",t)}});const th=va({slice1d_:function(e,t,n){const s=ba(e,"x","slice1d");return u(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),Co(s,[t],[n])}});const nh=va({slice2d_:function(e,t,n){const s=ba(e,"x","slice2d");return u(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),Co(s,t,n)}});const sh=va({slice3d_:function(e,t,n){const s=ba(e,"x","slice3d");return u(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),Co(s,t,n)}});const rh=va({slice4d_:function(e,t,n){const s=ba(e,"x","slice4d");return u(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),Co(s,t,n)}});const ah=va({softmax_:function(e,t=-1){const n=ba(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const s={logits:n},r={dim:t};return la.runKernel("Softmax",s,r)}});const ih=va({fft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return la.runKernel("FFT",t)}});const oh=va({ifft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return la.runKernel("IFFT",t)}});const lh=va({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let s;if(t<=2){const r=vo(e,[n,t]);s=oh(r)}else{const r=[n,2*(t-1)],a=vo(zc(e),[n,t]),i=vo(Kl(e),[n,t]),o=Vc(Co(a,[0,1],[n,t-2]),1),l=Hi(Vc(Co(i,[0,1],[n,t-2]),1),_l(-1)),u=Io([a,o],1),c=Io([i,l],1),h=vo(ka(u,c),[r[0],r[1]]);s=oh(h)}if(s=zc(s),3===e.rank&&0!==e.shape[0]){const t=s,n=e.shape[0];s=vo(s,[n,s.shape[0]/n,s.shape[1]]),t.dispose()}return s}});const uh=va({split_:function(e,t,n=0){const s={x:ba(e,"x","split")},r={numOrSizeSplits:t,axis:n};return la.runKernel("SplitV",s,r)}});const ch=va({rfft_:function(e,t){u("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const s=e.size/n;let r;if(null!=t&&t<n){const s=e.shape.map((e=>0)),a=e.shape.map((e=>e));a[e.shape.length-1]=t,r=Co(e,s,a),n=t}else if(null!=t&&t>n){const s=e.shape.map((e=>e));s[e.shape.length-1]=t-n,r=Io([e,Eu(s)],e.shape.length-1),n=t}else r=e;const a=fl(r),i=vo(ka(r,a),[s,n]),o=ih(i),l=Math.floor(n/2)+1,c=zc(o),h=Kl(o),p=uh(c,[l,n-l],c.shape.length-1),d=uh(h,[l,n-l],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=l,vo(ka(p[0],d[0]),f)}});const hh=va({squaredDifference_:function(e,t){let n=ba(e,"a","squaredDifference"),s=ba(t,"b","squaredDifference");[n,s]=Jr(n,s),cl(n.shape,s.shape);const r={a:n,b:s};return la.runKernel("SquaredDifference",r,{})}});const ph=va({squeeze_:function(e,t){const n=ba(e,"x","squeeze","string_or_numeric");return vo(n,v(n.shape,t).newShape)}});const dh=va({stack_:function(e,t=0){const n=xa(e,"tensors","stack","string_or_numeric");u(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&u(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:t};return la.runKernel("Pack",s,r)}});const fh=va({step_:function(e,t=0){const n={x:ba(e,"x","step")},s={alpha:t};return la.runKernel("Step",n,s)}});const mh=va({stridedSlice_:function(e,t,n,s,r=0,a=0,i=0,o=0,l=0){const u={x:ba(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return la.runKernel("StridedSlice",u,c)}});const gh=va({tan_:function(e){const t={x:ba(e,"x","tan","float32")};return la.runKernel(ts,t)}});function yh(e,t){h(e);const n=ma(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Na(e,null,n,t)}function bh(e,t,n){if(h(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const s=ma(e,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Na(e,t,s,n)}function xh(e,t,n){if(h(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const s=ma(e,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Na(e,t,s,n)}function wh(e,t,n){if(h(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const s=ma(e,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return Na(e,t,s,n)}function vh(e,t,n){if(h(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const s=ma(e,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return Na(e,t,s,n)}function kh(e,t,n){if(h(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const s=ma(e,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return Na(e,t=t||s,s,n)}function Nh(e,t,n){const s=t.rank>1?t.shape[t.rank-1]:1,r=t.rank>1?t.rank-1:1,a=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(e.length<s+(n.rank-r))throw new Error(a+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+e.length-s)throw new Error(a+" update.rank != "+(r+e.length-s));for(let e=0;e<r;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-r;++t)if(n.shape[t+r]!==e[t+s])throw new Error(a+` updates.shape[${t+r}] (${n.shape[t+r]}) != shape[${t+r}] (${e[t+r]})`)}function Ih(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}Nh(n,t,e)}function Sh(e,t,n){const s=t.shape.length,r=s>1?t.shape[s-1]:1,a=n.length;let i=1;for(let e=r;e<a;++e)i*=n[e];const o=r<1?1:r;return{sliceRank:r,numUpdates:p(t.shape)/o,sliceSize:i,strides:[...O(n.slice(0,r)),1],outputSize:p(n)}}var Th=Object.freeze({__proto__:null,calculateShapes:Sh,validateInput:Ih,validateUpdateShape:Nh});const Ch=va({tensorScatterUpdate_:function(e,t,n){const s=ba(e,"tensor","tensorScatterupdate"),r=ba(t,"indices","tensorScatterupdate","int32"),a=ba(n,"updates","tensorScatterupdate");if(Ih(a,r,s.shape),s.dtype!==a.dtype)throw new Error(`tensor and updates must have the same dtype, instead they are ${s.dtype} and ${a.dtype}.`);const i={tensor:s,indices:r,updates:a};return la.runKernel("TensorScatterUpdate",i,{})}});const $h=va({topk_:function(e,t=1,n=!0){const s=ba(e,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${t}`);const a={x:s},i={k:t,sorted:n},[o,l]=la.runKernel("TopK",a,i);return{values:o,indices:l}}});const Eh=va({truncatedNormal_:function(e,t=0,n=1,s,r){if(V(e),null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new Ec(t,n,s,!0,r),i=zi(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Ah=va({unique_:function(e,t=0){const n=ba(e,"x","unique","string_or_numeric");u(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:t},[a,i]=la.runKernel("Unique",s,r);return{values:a,indices:i}}});const Rh=va({unsortedSegmentSum_:function(e,t,n){const s=ba(e,"x","unsortedSegmentSum"),r=ba(t,"segmentIds","unsortedSegmentSum","int32");u(m(n),(()=>"numSegments must be of dtype int"));const a={x:s,segmentIds:r},i={numSegments:n};return la.runKernel("UnsortedSegmentSum",a,i)}});const _h=va({unstack_:function(e,t=0){const n=ba(e,"x","unstack","string_or_numeric");u(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:t};return la.runKernel("Unpack",s,r)}});function Fh(e,t){return ku(e,t,"right")}function Dh(e,t=!0,n,s){return la.makeVariable(e,t,n,s)}function Oh(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const s=zi(e,"int32"),r=zi([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=s.indexToLoc(n[t]),i=t*e.length;r.values.set(a,i)}return r.toTensor()}const Mh=async function(e){const t=ba(e,"condition","whereAsync","bool"),n=await t.data(),s=Oh(t.shape,n);return e!==t&&t.dispose(),s};const Lh=async function(e,t,n){const s=ba(e,"tensor","boolMask"),r=ba(t,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,o=s.shape;u(i>0,(()=>"mask cannot be scalar")),c(o.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let l=1;for(let e=a;e<a+i;e++)l*=o[e];const h=o.slice(0,a).concat([l],o.slice(a+i)),p=vo(s,h),d=vo(r,[-1]),f=await Mh(d),m=ph(f,[1]),g=Hl(p,m,a);return e!==s&&s.dispose(),t!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};const zh=va({transpose_:function(e,t,n){const s=ba(e,"x","transpose");if(null==t&&(t=s.shape.map(((e,t)=>t)).reverse()),u(s.rank===t.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${t}.`)),t.forEach((e=>{u(e>=0&&e<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${t}`))})),s.rank<=1)return s.clone();const r={x:s},a={perm:t};return"complex64"===s.dtype?Oa((()=>{let e=zc(s),t=Kl(s);return e=la.runKernel("Transpose",{x:e},a),t=la.runKernel("Transpose",{x:t},a),n&&(t=pu(t)),ka(e,t)})):la.runKernel("Transpose",r,a)}});const Ph=va({movingAverage_:function(e,t,n,s,r=!0){const a=ba(e,"v","movingAverage"),i=ba(t,"x","movingAverage"),o=ba(n,"decay","movingAverage");Qr(a,i),u(f(a.shape,i.shape),(()=>"Shape mismatch in v and x"));const l=_l(1),c=mu(l,o);let h=Hi(mu(i,a),c);if(r){u(null!=s,(()=>"When using zeroDebias: true, step is required."));const e=ba(s,"step","movingAverage");h=Gi(h,mu(l,Rl(o,e)))}return Vi(a,h)}});const Bh=va({scatterND_:function(e,t,n){V(n);const s=ba(e,"indices","scatterND","int32"),r=ba(t,"updates","scatterND");Ih(r,s,n);const a={indices:s,updates:r},i={shape:n};return la.runKernel("ScatterNd",a,i)}});const Wh=va({sparseToDense_:function(e,t,n,s=0){V(n);const r=ba(e,"sparseIndices","sparseToDense","int32"),a=ba(t,"sparseValues","sparseToDense","string_or_numeric"),i=ba(s,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,s){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const r=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=t.size;if(0!==t.rank&&(1!==t.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);if(t.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return la.runKernel("SparseToDense",o,l)}});const Vh=va({gatherND_:function(e,t){const n=ba(t,"indices","gatherND","int32"),s={params:ba(e,"x","gatherND","string_or_numeric"),indices:n};return la.runKernel("GatherNd",s)}});const Uh=va({dropout_:function(e,t,n,s){const r=ba(e,"x","dropout");if(u("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),u(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof Pr?r.clone():r;const a=function(e,t){if(null==t)return e.shape.slice();if(f(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let s=0;s<e.shape.length;s++)null==t[s]&&null!=e.shape[s]?n.push(e.shape[s]):n.push(t[s]);return n}return t}(r,n),i=1-t,o=Gi(Gl(Vi(Oc(a,0,1,"float32",s),i)),i);return Hi(r,o)}});function Gh(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Hh(e,t,n){const s=1-e%2,r=new Float32Array(e);for(let a=0;a<e;++a){const i=2*Math.PI*a/(e+s-1);r[a]=t-n*Math.cos(i)}return yh(r,"float32")}const jh=async function(e,t,n=1){const s=ba(e,"predictions","inTopK"),r=ba(t,"targets","inTopK");u(s.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${s.rank}`)),u(s.rank-1===r.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`)),c(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];u(n>0&&n<=a,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`));const i=await s.data(),o=await r.data(),[l,h]=[i.length/a,a],p=k("bool",l);for(let e=0;e<l;e++){const t=e*h,s=i.subarray(t,t+h),r=[];for(let e=0;e<s.length;e++)r.push({value:s[e],index:e});r.sort(((e,t)=>t.value-e.value)),p[e]=0;for(let t=0;t<n;t++)if(r[t].index===o[e]){p[e]=1;break}}return e!==s&&s.dispose(),t!==r&&r.dispose(),Ia(p,r.shape,"bool")};const qh=va({conv2DBackpropFilter_:function(e,t,n,s,r,a="NHWC",i){let o=e;3===e.rank&&(o=vo(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=vo(t,[1,t.shape[0],t.shape[1],t.shape[2]])),u(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),u(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),u(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===a?o.shape[3]:o.shape[1],h="NHWC"===a?l.shape[3]:l.shape[1];u(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),u(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),wo("conv2dDerFilter",r,i);const p={x:o,dy:l},d={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return la.runKernel("Conv2DBackpropFilter",p,d)}});function Kh(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return Hi(e,fh(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Xh(e,t){let n=t;const s=ul(e.shape,t.shape);return s.length>0&&(n=Ol(n,s)),vo(n,e.shape)}function Yh(e,t,n,s){if("linear"===t)return e;if("relu"===t)return Bc(e);if("elu"===t)return bl(e);if("relu6"===t)return Wc(e);if("prelu"===t)return Xu(e,n);if("leakyrelu"===t)return Jl(e,s);if("sigmoid"===t)return To(e);throw new Error(`Unknown fused activation ${t}.`)}const Zh=(e,t)=>!(e>0)||"linear"===t;const Jh=va({fusedConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(l=l||"linear",!1===Zh(la.state.gradientDepth,l)){u("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let p=jo(e,t,n,s,r,a,i);return null!=o&&(p=Vi(p,o)),Yh(p,l,c,h)}const p=ba(e,"x","conv2d","float32"),d=ba(t,"filter","conv2d","float32");let f=p,m=!1;3===p.rank&&(m=!0,f=vo(p,[1,p.shape[0],p.shape[1],p.shape[2]])),u(4===f.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===d.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${d.rank}.`)),wo("fused conv2d",s,i);const g="NHWC"===r?f.shape[3]:f.shape[1];u(d.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${d.shape[2]}.`)),u(yo(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const y=lo(f.shape,d.shape,n,a,s,i);let b,x;if(null!=o&&(b=ba(o,"bias","fused conv2d"),[b]=Jr(b,p),"NHWC"===r?cl(y.outShape,b.shape):(u(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),u(0===b.shape.length||b.shape[0]===y.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${y.outChannels})`)))),null!=c){const e=c.shape;if(u(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)u(1===e[0]||e[0]===y.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${y.outChannels}).`));else if(3===e.length)try{cl(e,y.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${y.outShape}).`;throw Error(n)}x=ba(c,"prelu weights","fused conv2d")}const w=(e,t)=>{u("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[i,o,c,h]=t,p=Kh(e,c,l);u(go(a),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`));const d=[Ko(o.shape,p,i,n,s),qh(o,p,i.shape,n,s)];if(null!=h){const e=Xh(h,p);d.push(e)}return d},v={x:f,filter:d,bias:b,preluActivationWeights:x},k={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:h};if(null==o){const e=cu(((e,t,n)=>{let s=la.runKernel("FusedConv2D",v,k);return n([t,e,s]),m&&(s=vo(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return e(f,d)}{const e=cu(((e,t,n,s)=>{let r=la.runKernel("FusedConv2D",v,k);return s([t,e,r,n]),m&&(r=vo(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return e(f,d,b)}}});const Qh=va({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,s,r,a=[1,1],i){let o=e;3===e.rank&&(o=vo(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=vo(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return la.runKernel("DepthwiseConv2dNativeBackpropFilter",u,c)}});const ep=va({depthwiseConv2dNativeBackpropInput_:function(e,t,n,s,r,a=[1,1],i){let o=t,l=!1;3===t.rank&&(l=!0,o=vo(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:e},h=la.runKernel("DepthwiseConv2dNativeBackpropInput",u,c);return l?vo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const tp=va({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===Zh(la.state.gradientDepth,l)){let u=al(e,t,n,s,r,a,i);return null!=o&&(u=Vi(u,o)),Yh(u,l,c,h)}const p=ba(e,"x","depthwiseConv2d","float32"),d=ba(t,"filter","depthwiseConv2d","float32");let f=p,m=!1;3===p.rank&&(m=!0,f=vo(p,[1,p.shape[0],p.shape[1],p.shape[2]])),u(4===f.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===d.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${d.rank}.`)),u(f.shape[3]===d.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${f.shape[3]}) must match the inChannels dimension in filter ${d.shape[2]}.`)),null==a&&(a=[1,1]),u(yo(n,a),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),wo("fused depthwiseConv2d",s,i);const g=lo(f.shape,d.shape,n,a,s,i,!0);let y,b;null!=o&&(y=ba(o,"bias","fused conv2d"),[y]=Jr(y,p),cl(g.outShape,y.shape)),null!=c&&(b=ba(c,"prelu weights","fused depthwiseConv2d"));const x=(e,t)=>{u(go(a),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`));const[r,o,c,h]=t,p=Kh(e,c,l),d=ep(o.shape,p,r,n,s,a,i),f=Qh(o,p,r.shape,n,s,a,i);if(null!=h){return[d,f,Xh(y,p)]}return[d,f]},w={x:f,filter:d,bias:y,preluActivationWeights:b},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:h};if(null==o){const e=cu(((e,t,n)=>{let s=la.runKernel("FusedDepthwiseConv2D",w,v);return n([t,e,s]),m&&(s=vo(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}}));return e(f,d)}{const e=cu(((e,t,n,s)=>{let r=la.runKernel("FusedDepthwiseConv2D",w,v);return s([t,e,r,n]),m&&(r=vo(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}}));return e(f,d,y)}}});const np=va({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:o=.2}){if(!1===Zh(la.state.gradientDepth,a)){let l=So(e,t,n,s);return null!=r&&(l=Vi(l,r)),Yh(l,a,i,o)}let l=ba(e,"a","fused matMul"),c=ba(t,"b","fused matMul");[l,c]=Jr(l,c);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],d=s?c.shape[c.rank-1]:c.shape[c.rank-2],f=n?l.shape[l.rank-1]:l.shape[l.rank-2],m=s?c.shape[c.rank-2]:c.shape[c.rank-1],g=l.shape.slice(0,-2),y=c.shape.slice(0,-2),b=p(g),x=p(y);u(h===d,(()=>`Error in fused matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${l.shape} and ${c.shape} and transposeA=${n} and transposeB=${s} must match.`));const w=cl(l.shape.slice(0,-2),c.shape.slice(0,-2)).concat([f,m]),v=vo(l,n?[b,h,f]:[b,f,h]),k=vo(c,s?[x,m,d]:[x,d,m]);let N,I;null!=r&&(N=ba(r,"bias","fused matMul"),[N]=Jr(N,l),cl(w,N.shape)),null!=i&&(I=ba(i,"prelu weights","fused matMul"));const S=(e,t)=>{const[i,o,l,u]=t,c=Kh(vo(e,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=So(c,o,!1,!1),p=So(c,i,!0,!1)):n&&!s?(h=So(o,c,!1,!0),p=So(i,c,!1,!1)):(h=So(o,c,!0,!0),p=So(c,i,!0,!0)):(h=So(c,o,!1,!0),p=So(i,c,!0,!1)),null!=r){return[h,p,Xh(u,c)]}return[h,p]},T={a:v,b:k,bias:N,preluActivationWeights:I},C={transposeA:n,transposeB:s,activation:a,leakyreluAlpha:o};if(null==r){const e=cu(((e,t,n)=>{const s=la.runKernel("_FusedMatMul",T,C);return n([e,t,s]),{value:vo(s,w),gradFunc:S}}));return e(v,k)}{const e=cu(((e,t,n,s)=>{const r=la.runKernel("_FusedMatMul",T,C);return s([e,t,r,n]),{value:vo(r,w),gradFunc:S}}));return e(v,k,N)}}});var sp=Object.freeze({__proto__:null,conv2d:Jh,depthwiseConv2d:tp,matMul:np});const rp=va({hammingWindow_:function(e){return Hh(e,.54,.46)}});const ap=va({hannWindow_:function(e){return Hh(e,.5,.5)}});const ip=va({frame_:function(e,t,n,s=!1,r=0){let a=0;const i=[];for(;a+t<=e.size;)i.push(Co(e,a,t)),a+=n;if(s)for(;a<e.size;){const s=a+t-e.size,o=Io([Co(e,a,t-s),Bo([s],r)]);i.push(o),a+=n}return 0===i.length?bh([],[0,t]):vo(Io(i),[i.length,t])}});const op=va({stft_:function(e,t,n,s,r=ap){null==s&&(s=Gh(t));const a=ip(e,t,n),i=Hi(a,r(t));return ch(i,s)}});const lp=va({cropAndResize_:function(e,t,n,s,r="bilinear",a=0){const i=ba(e,"image","cropAndResize"),o=ba(t,"boxes","cropAndResize","float32"),l=ba(n,"boxInd","cropAndResize","int32"),c=o.shape[0];u(4===i.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`)),u(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${o.shape}.`)),u(1===l.rank&&l.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${o.shape}.`)),u(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),u(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),u("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:i,boxes:o,boxInd:l},p={method:r,extrapolationValue:a,cropSize:s};return la.runKernel("CropAndResize",h,p)}});const up=va({flipLeftRight_:function(e){const t=ba(e,"image","flipLeftRight","float32");u(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return la.runKernel("FlipLeftRight",n,{})}});const cp=va({grayscaleToRGB_:function(e){const t=ba(e,"image","grayscaleToRGB"),n=t.rank-1,s=t.shape[n];u(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),u(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(t.rank);return r.fill(1,0,n),r[n]=3,Vl(t,r)}});const hp=va({rgbToGrayscale_:function(e){const t=ba(e,"image","RGBToGrayscale"),n=t.rank-1,s=t.shape[n];u(t.rank>=2,(()=>`Error in RGBToGrayscale: images must be at least rank 2, but got rank ${t.rank}.`)),u(3===s,(()=>`Error in RGBToGrayscale: last dimension of an RGB image should be size 3, but got size ${s}.`));const r=t.dtype,a=Pi(t,"float32"),i=yh([.2989,.587,.114]);let o;switch(t.rank){case 2:o=yl("ij,j->i",a,i);break;case 3:o=yl("ijk,k->ij",a,i);break;case 4:o=yl("ijkl,l->ijk",a,i);break;case 5:o=yl("ijklm,m->ijkl",a,i);break;case 6:o=yl("ijklmn,n->ijklm",a,i);break;default:throw new Error("Not a valid tensor rank.")}return o=Bl(o,-1),Pi(o,r)}});const pp=va({rotateWithOffset_:function(e,t,n=0,s=.5){const r=ba(e,"image","rotateWithOffset","float32");u(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const a={image:r},i={radians:t,fillValue:n,center:s};return la.runKernel("RotateWithOffset",a,i)}});function dp(e,t,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),u(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),u(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),u(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),u(1===t.rank,(()=>"scores must be a 1D tensor")),u(t.shape[0]===i,(()=>`scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`)),u(0<=a&&a<=1,(()=>`softNmsSigma must be in [0, 1], but was '${a}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const fp=va({nonMaxSuppression_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=ba(e,"boxes","nonMaxSuppression","float32"),i=ba(t,"scores","nonMaxSuppression","float32"),o=dp(a,i,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return la.runKernel("NonMaxSuppressionV3",{boxes:a,scores:i},l)}});function mp(e,t,n){const s=function(e,t,n){return function(e,t,n){let s=0,r=e.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(t,e[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(e,t,n||gp)}(e,t,n),r=s<0?-(s+1):s;e.splice(r,0,t)}function gp(e,t){return e>t?1:e<t?-1:0}function yp(e,t,n,s,r){return wp(e,t,n,s,r,0)}function bp(e,t,n,s,r,a){return wp(e,t,n,s,r,0,!1,a,!0)}function xp(e,t,n,s,r,a){return wp(e,t,n,s,r,a,!0)}function wp(e,t,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>r&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(Np);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=t;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=vp(e,a,h[n]);if(i>=s){o=!0;break}if(t.score=t.score*kp(s,c,i),t.score<=r)break}t.suppressBeginIndex=h.length,o||(t.score===n?(h.push(a),p.push(t.score)):t.score>r&&mp(u,t,Np))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:h};return i&&(m.selectedScores=p),l&&(m.validOutputs=d),m}function vp(e,t,n){const s=e.subarray(4*t,4*t+4),r=e.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function kp(e,t,n){const s=Math.exp(t*n*n);return n<=e?s:0}function Np(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Ip=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=ba(e,"boxes","nonMaxSuppressionAsync"),i=ba(t,"scores","nonMaxSuppressionAsync"),o=dp(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=l[0],c=l[1],{selectedIndices:h}=yp(u,c,n,s,r);return a!==e&&a.dispose(),i!==t&&i.dispose(),yh(h,"int32")};const Sp=va({nonMaxSuppressionWithScore_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=ba(e,"boxes","nonMaxSuppression"),o=ba(t,"scores","nonMaxSuppression"),l=dp(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=la.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const Tp=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=ba(e,"boxes","nonMaxSuppressionAsync"),o=ba(t,"scores","nonMaxSuppressionAsync"),l=dp(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=u[0],h=u[1],{selectedIndices:p,selectedScores:d}=xp(c,h,n,s,r,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:yh(p,"int32"),selectedScores:yh(d)}};const Cp=va({nonMaxSuppressionPadded_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=ba(e,"boxes","nonMaxSuppression"),o=ba(t,"scores","nonMaxSuppression"),l=dp(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=la.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const $p=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=ba(e,"boxes","nonMaxSuppressionAsync"),o=ba(t,"scores","nonMaxSuppressionAsync"),l=dp(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),{selectedIndices:f,validOutputs:m}=bp(p,d,u,c,h,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:yh(f,"int32"),validOutputs:_l(m,"int32")}};const Ep=va({resizeBilinear_:function(e,t,n=!1,s=!1){const r=ba(e,"images","resizeBilinear");u(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),u(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),u(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=vo(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},l={alignCorners:n,halfPixelCenters:s,size:t},c=la.runKernel("ResizeBilinear",o,l);return i?vo(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Ap=va({resizeNearestNeighbor_:function(e,t,n=!1,s=!1){const r=ba(e,"images","resizeNearestNeighbor");u(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),u(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),u("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),u(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=vo(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},l={alignCorners:n,halfPixelCenters:s,size:t},c=la.runKernel("ResizeNearestNeighbor",o,l);return i?vo(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Rp=va({threshold_:function(e,t="binary",n=!1,s=.5){const r=ba(e,"image","threshold"),a=r.shape[0]*r.shape[1];let i,o,l,c,h=Hi(yh([s]),255);if(u(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),u(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),u("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),u("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===r.shape[2]){[i,o,l]=uh(r,[1,1,1],-1);const e=Hi(i,.2989),t=Hi(o,.587),n=Hi(l,.114);c=Vi(Vi(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,s,r,a,i,o,l=yh([-1]),u=yh([0]),c=yh([0]);for(let h=0;h<e.size-1;h++){n=Co(e,0,h+1),s=Co(e,h+1),i=Gi(Ol(n),t),o=Gi(Ol(s),t);const p=Ol(Hi(n,Lc(0,n.size)));r=Gi(p,Ol(n));const d=Bo(s.shape,n.size),f=Vi(Lc(0,s.size),d),m=Hi(s,f);a=Gi(Ol(m),Ol(s));const g=mu(r,a),y=mu(r,a),b=Hi(i,o);c=Hi(Hi(b,g),y);const x=jl(c,u);u=dl(x,c,u),l=dl(x,yh([h]),l)}return l}(Oo(Pi(qc(c),"int32"),Ia([]),256),a)}const p=n?eu(c,h):jl(c,h);return Pi(Hi(p,255),"int32")}});const _p=va({transform_:function(e,t,n="nearest",s="constant",r=0,a){const i=ba(e,"image","transform","float32"),o=ba(t,"transforms","transform","float32");u(4===i.rank,(()=>`Error in transform: image must be rank 4,but got rank ${i.rank}.`)),u(2===o.rank&&(o.shape[0]===i.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),u(null==a||2===a.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${a}.`));const l={image:i,transforms:o},c={interpolation:n,fillMode:s,fillValue:r,outputShape:a};return la.runKernel("Transform",l,c)}});const Fp=va({bandPart_:function(e,t,n){const s=ba(e,"a","bandPart");u(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[a,i]=s.shape.slice(-2);let o,l;"number"==typeof t?(u(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),u(t<=a,(()=>`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`)),o=ba(t<0?a:t,"numLower","bandPart")):(u("int32"===t.dtype,(()=>"bandPart(): numLower's dtype must be an int32.")),o=dl(Ql(t,0),a,_u(t,a))),"number"==typeof n?(u(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`)),u(n<=i,(()=>`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`)),l=ba(n<0?i:n,"numUpper","bandPart")):(u("int32"===n.dtype,(()=>"bandPart(): numUpper's dtype must be an int32.")),l=dl(Ql(n,0),i,_u(n,i)));const c=vo(Lc(0,a,1,"int32"),[-1,1]),h=Lc(0,i,1,"int32"),p=mu(c,h),d=bu(eu(p,o),ql(p,pu(l))),f=Eu([a,i],s.dtype);return vo(dh(_h(vo(s,[-1,a,i])).map((e=>dl(d,e,f)))),r)}});const Dp=va({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,u(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)u(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=uh(e,e.shape[0],0).map((e=>ph(e,[0])));u(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],s=e;for(let t=0;t<e.length;++t)n.push(la.tidy((()=>{let e=s[t];if(t>0)for(let s=0;s<t;++s){const t=Hi(Ol(Hi(n[s],e)),n[s]);e=mu(e,t)}return Gi(e,Ll(e,"euclidean"))})));return t?dh(n,0):n}});function Op(e,t=!1){return la.tidy((()=>{u(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],s=e.shape[1];let r=Ul(n),a=Bi(e);const i=bh([[1]],[1,1]);let o=Bi(i);const l=n>=s?s:n;for(let e=0;e<l;++e){const t=a,l=o,u=r;[o,a,r]=la.tidy((()=>{const t=Co(a,[e,e],[n-e,1]),l=Ll(t),u=Co(a,[e,e],[1,1]),c=dl(jl(u,0),bh([[-1]]),bh([[1]])),h=mu(u,Hi(c,l)),p=Gi(t,h);o=1===p.shape[0]?Bi(i):Io([i,Co(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=pu(Gi(So(c,h),l)),f=Co(a,[e,0],[n-e,s]),m=Hi(d,o),g=zh(o);if(0===e)a=mu(f,So(m,So(g,f)));else{const t=mu(f,So(m,So(g,f)));a=Io([Co(a,[0,0],[e,s]),t],0)}const y=zh(m),b=Co(r,[0,e],[n,r.shape[1]-e]);if(0===e)r=mu(b,So(So(b,o),y));else{const t=mu(b,So(So(b,o),y));r=Io([Co(r,[0,0],[n,e]),t],1)}return[o,a,r]})),Ma([t,l,u])}return!t&&n>s&&(r=Co(r,[0,0],[n,s]),a=Co(a,[0,0],[s,s])),[r,a]}))}const Mp=va({qr_:function(e,t=!1){if(u(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Op(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),s=_h(vo(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),r=[],a=[];s.forEach((e=>{const[n,s]=Op(e,t);r.push(n),a.push(s)}));return[vo(dh(r,0),e.shape),vo(dh(a,0),e.shape)]}}});var Lp;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(Lp||(Lp={}));const zp=va({computeWeightedLoss_:function(e,t,n=Lp.SUM_BY_NONZERO_WEIGHTS){const s=ba(e,"losses","computeWeightedLoss");let r=null;null!=t&&(r=ba(t,"weights","computeWeightedLoss"));const a=null==r?s:Hi(s,r);if(n===Lp.NONE)return a;if(n===Lp.SUM)return Ol(a);if(n===Lp.MEAN){if(null==r)return $u(a);{const e=s.size/r.size,t=Gi(Ol(a),Ol(r));return e>1?Gi(t,_l(e)):t}}if(n===Lp.SUM_BY_NONZERO_WEIGHTS){if(null==r)return Gi(Ol(a),_l(s.size));{const e=Hi(r,Au(s.shape)),t=Pi(Ol(zu(e,_l(0))),"float32");return Gi(Ol(a),t)}}throw Error(`Unknown reduction: ${n}`)}});const Pp=va({absoluteDifference_:function(e,t,n,s=Lp.SUM_BY_NONZERO_WEIGHTS){const r=ba(e,"labels","absoluteDifference"),a=ba(t,"predictions","absoluteDifference");let i=null;null!=n&&(i=ba(n,"weights","absoluteDifference")),c(r.shape,a.shape,"Error in absoluteDifference: ");const o=ji(mu(r,a));return zp(o,i,s)}});const Bp=va({cosineDistance_:function(e,t,n,s,r=Lp.SUM_BY_NONZERO_WEIGHTS){const a=ba(e,"labels","cosineDistance"),i=ba(t,"predictions","cosineDistance");let o=null;null!=s&&(o=ba(s,"weights","cosineDistance")),c(a.shape,i.shape,"Error in cosineDistance: ");const l=_l(1),u=mu(l,Ol(Hi(a,i),n,!0));return zp(u,o,r)}});const Wp=va({hingeLoss_:function(e,t,n,s=Lp.SUM_BY_NONZERO_WEIGHTS){let r=ba(e,"labels","hingeLoss");const a=ba(t,"predictions","hingeLoss");let i=null;null!=n&&(i=ba(n,"weights","hingeLoss")),c(r.shape,a.shape,"Error in hingeLoss: ");const o=_l(1);r=mu(Hi(_l(2),r),o);const l=Bc(mu(o,Hi(r,a)));return zp(l,i,s)}});const Vp=va({huberLoss_:function(e,t,n,s=1,r=Lp.SUM_BY_NONZERO_WEIGHTS){const a=ba(e,"labels","huberLoss"),i=ba(t,"predictions","huberLoss");let o=null;null!=n&&(o=ba(n,"weights","huberLoss")),c(a.shape,i.shape,"Error in huberLoss: ");const l=_l(s),u=ji(mu(i,a)),h=_u(u,l),p=mu(u,h),d=Vi(Hi(_l(.5),Dl(h)),Hi(l,p));return zp(d,o,r)}});const Up=va({logLoss_:function(e,t,n,s=1e-7,r=Lp.SUM_BY_NONZERO_WEIGHTS){const a=ba(e,"labels","logLoss"),i=ba(t,"predictions","logLoss");let o=null;null!=n&&(o=ba(n,"weights","logLoss")),c(a.shape,i.shape,"Error in logLoss: ");const l=_l(1),u=_l(s),h=pu(Hi(a,su(Vi(i,u)))),p=Hi(mu(l,a),su(Vi(mu(l,i),u))),d=mu(h,p);return zp(d,o,r)}});const Gp=va({meanSquaredError_:function(e,t,n,s=Lp.SUM_BY_NONZERO_WEIGHTS){const r=ba(e,"labels","meanSquaredError"),a=ba(t,"predictions","meanSquaredError");let i=null;null!=n&&(i=ba(n,"weights","meanSquaredError")),c(r.shape,a.shape,"Error in meanSquaredError: ");const o=hh(r,a);return zp(o,i,s)}});const Hp=va({sigmoidCrossEntropy_:function(e,t,n,s=0,r=Lp.SUM_BY_NONZERO_WEIGHTS){let a=ba(e,"multiClassLabels","sigmoidCrossEntropy");const i=ba(t,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=ba(n,"weights","sigmoidCrossEntropy")),c(a.shape,i.shape,"Error in sigmoidCrossEntropy: "),s>0){const e=_l(s),t=_l(1),n=_l(.5);a=Vi(Hi(a,mu(t,e)),Hi(n,e))}const l=function(e,t){const n=ba(e,"labels","sigmoidCrossEntropyWithLogits"),s=ba(t,"logits","sigmoidCrossEntropyWithLogits");c(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=Bc(s),a=Hi(s,n),i=ru(Pl(pu(ji(s))));return Vi(mu(r,a),i)}(a,i);return zp(l,o,r)}});const jp=va({softmaxCrossEntropy_:function(e,t,n,s=0,r=Lp.SUM_BY_NONZERO_WEIGHTS){let a=ba(e,"onehotLabels","softmaxCrossEntropy");const i=ba(t,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=ba(n,"weights","softmaxCrossEntropy")),c(a.shape,i.shape,"Error in softmaxCrossEntropy: "),s>0){const e=_l(s),t=_l(1),n=_l(a.shape[1]);a=Vi(Hi(a,mu(t,e)),Gi(e,n))}const l=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const s=cu(((e,t,s)=>{const r=yu(t,[n],!0),a=mu(Pi(t,"float32"),r);s([e,a]);const i=pu(Hi(a,e));return{value:Ol(i,[n]),gradFunc:(e,t)=>{const[s,r]=t,a=Il(e.shape,[n]);return[Hi(vo(e,a),mu(Pi(s,"float32"),Pl(r))),Hi(vo(e,a),mu(Pl(r),Pi(s,"float32")))]}}}));return s(e,t)}(a,i);return zp(l,o,r)}});const qp=va({sparseFillEmptyRows_:function(e,t,n,s){const r=ba(e,"indices","sparseFillEmptyRows","int32"),a=ba(t,"values","sparseFillEmptyRows"),i=ba(n,"denseShape","sparseFillEmptyRows","int32"),o=ba(s,"defaultValue","sparseFillEmptyRows",a.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==a.rank)throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);if(1!==i.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${i.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:a,denseShape:i,defaultValue:o},u=la.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const Kp=va({sparseReshape_:function(e,t,n){const s=ba(e,"inputIndices","sparseReshape","int32"),r=ba(t,"inputShape","sparseReshape","int32"),a=ba(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==a.rank)throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);const i={inputIndices:s,inputShape:r,newShape:a},o=la.runKernel("SparseReshape",i);return{outputIndices:o[0],outputShape:o[1]}}});const Xp=va({sparseSegmentMean_:function(e,t,n){const s=ba(e,"data","sparseSegmentMean"),r=ba(t,"indices","sparseSegmentMean","int32"),a=ba(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${a.shape}`);const i={data:s,indices:r,segmentIds:a};return la.runKernel("SparseSegmentMean",i)}});const Yp=va({sparseSegmentSum_:function(e,t,n){const s=ba(e,"data","sparseSegmentSum"),r=ba(t,"indices","sparseSegmentSum","int32"),a=ba(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${a.shape}`);const i={data:s,indices:r,segmentIds:a};return la.runKernel("SparseSegmentSum",i)}});const Zp=va({stringNGrams_:function(e,t,n,s,r,a,i,o){const l=ba(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=ba(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:s,leftPad:r,rightPad:a,padWidth:i,preserveShortSequences:o},h={data:l,dataSplits:u},p=la.runKernel("StringNGrams",h,c);return{nGrams:p[0],nGramsSplits:p[1]}}});const Jp=va({stringSplit_:function(e,t,n=!0){const s=ba(e,"input","stringSplit","string"),r=ba(t,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const a={skipEmpty:n},i={input:s,delimiter:r},o=la.runKernel("StringSplit",i,a);return{indices:o[0],values:o[1],shape:o[2]}}});const Qp=va({stringToHashBucketFast_:function(e,t){const n=ba(e,"input","stringToHashBucketFast","string"),s={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return la.runKernel("StringToHashBucketFast",r,s)}});const ed=va({staticRegexReplace_:function(e,t,n,s=!0){const r=ba(e,"input","staticRegexReplace","string"),a={pattern:t,rewrite:n,replaceGlobal:s};return la.runKernel("StaticRegexReplace",{x:r},a)}}),td={fft:ih,ifft:oh,rfft:ch,irfft:lh},nd={hammingWindow:rp,hannWindow:ap,frame:ip,stft:op},sd={flipLeftRight:up,grayscaleToRGB:cp,resizeNearestNeighbor:Ap,resizeBilinear:Ep,rgbToGrayscale:hp,rotateWithOffset:pp,cropAndResize:lp,nonMaxSuppression:fp,nonMaxSuppressionAsync:Ip,nonMaxSuppressionWithScore:Sp,nonMaxSuppressionWithScoreAsync:Tp,nonMaxSuppressionPadded:Cp,nonMaxSuppressionPaddedAsync:$p,threshold:Rp,transform:_p},rd={bandPart:Fp,gramSchmidt:Dp,qr:Mp},ad={absoluteDifference:Pp,computeWeightedLoss:zp,cosineDistance:Bp,hingeLoss:Wp,huberLoss:Vp,logLoss:Up,meanSquaredError:Gp,sigmoidCrossEntropy:Hp,softmaxCrossEntropy:jp},id={sparseFillEmptyRows:qp,sparseReshape:Kp,sparseSegmentMean:Xp,sparseSegmentSum:Yp},od={stringNGrams:Zp,stringSplit:Jp,stringToHashBucketFast:Qp,staticRegexReplace:ed},ld=new Map,ud=new Map;class cd{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class hd{constructor(){this.classNameMap={}}static getMap(){return null==hd.instance&&(hd.instance=new hd),hd.instance}static register(e){hd.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function pd(e,t,n){u(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),u("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),u(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),void 0===t&&(t="Custom"),void 0===n&&(n=e.className);const s=t+">"+n;return hd.register(e),ld.set(s,e),ud.set(e,s),e}var dd=Object.freeze({__proto__:null,Serializable:cd,SerializationMap:hd,getRegisteredName:function(e){return ud.has(e)?ud.get(e):e.className},registerClass:pd});class fd extends cd{minimize(e,t=!1,n){const{value:s,grads:r}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:r[e.name]})));this.applyGradients(e)}else this.applyGradients(r);return Ma(r),t?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return uu(e,t)}dispose(){null!=this.iterations_&&Ma(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:_l(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(fd,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class md extends fd{static get className(){return"Adadelta"}constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=la.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=la.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:Oa((()=>fl(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:Oa((()=>fl(s).variable(false)))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;Oa((()=>{const e=Vi(Hi(a,this.rho),Hi(Dl(r),1-this.rho)),t=Hi(Gi(Fl(Vi(i,this.epsilon)),Fl(Vi(a,this.epsilon))),r),n=Vi(Hi(i,this.rho),Hi(Dl(t),1-this.rho));a.assign(e),i.assign(n);const o=Vi(Hi(t,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(Ma(this.accumulatedGrads.map((e=>e.variable))),Ma(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}class gd extends fd{static get className(){return"Adagrad"}constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=la.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:Oa((()=>Bo(s.shape,this.initialAccumulatorValue).variable(e)))}}const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable;Oa((()=>{const e=Vi(a,Dl(r));a.assign(e);const t=Vi(Hi(Gi(r,Fl(Vi(e,la.backend.epsilon()))),-this.learningRate),s);s.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&Ma(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}class yd extends fd{static get className(){return"Adam"}constructor(e,t,n,s=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Oa((()=>{this.accBeta1=_l(t).variable(),this.accBeta2=_l(n).variable()})),null==s&&(this.epsilon=la.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Oa((()=>{const n=mu(1,this.accBeta1),s=mu(1,this.accBeta2);t.forEach(((t,r)=>{const a=la.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:Oa((()=>fl(a).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${t}/v`,variable:Oa((()=>fl(a).variable(false)))});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=Vi(Hi(o,this.beta1),Hi(i,1-this.beta1)),c=Vi(Hi(l,this.beta2),Hi(Dl(i),1-this.beta2)),h=Gi(u,n),p=Gi(c,s);o.assign(u),l.assign(c);const d=Vi(Hi(Gi(h,Vi(Fl(p),this.epsilon)),-this.learningRate),a);a.assign(d)})),this.accBeta1.assign(Hi(this.accBeta1,this.beta1)),this.accBeta2.assign(Hi(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&Ma(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&Ma(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),Oa((()=>{this.accBeta1.assign(Rl(this.beta1,this.iterations_+1)),this.accBeta2.assign(Rl(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}class bd extends fd{static get className(){return"Adamax"}constructor(e,t,n,s=null,r=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Oa((()=>{this.iteration=_l(0).variable(),this.accBeta1=_l(t).variable()})),null==s&&(this.epsilon=la.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);Oa((()=>{const n=mu(1,this.accBeta1),s=Gi(-this.learningRate,Vi(Hi(this.iteration,this.decay),1));t.forEach(((t,r)=>{const a=la.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:fl(a).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${t}/v`,variable:fl(a).variable(false)});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=Vi(Hi(o,this.beta1),Hi(i,1-this.beta1)),c=Hi(l,this.beta2),h=ji(i),p=Cu(c,h);o.assign(u),l.assign(p);const d=Vi(Hi(Gi(s,n),Gi(u,Vi(p,this.epsilon))),a);a.assign(d)})),this.iteration.assign(Vi(this.iteration,1)),this.accBeta1.assign(Hi(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&Ma(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&Ma(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}class xd extends fd{static get className(){return"SGD"}constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const r=la.registeredVariables[t];Oa((()=>{const e=Vi(Hi(this.c,s),r);r.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=La(_l(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}class wd extends xd{static get className(){return"Momentum"}constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=_l(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=la.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:Oa((()=>fl(s).variable(e)))}}const r=this.accumulations[n].variable,a=Array.isArray(e)?e[n].tensor:e[t];null!=a&&Oa((()=>{let e;const t=Vi(Hi(this.m,r),a);e=this.useNesterov?Vi(Hi(this.c,Vi(a,Hi(t,this.m))),s):Vi(Hi(this.c,t),s),r.assign(t),s.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&Ma(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}class vd extends fd{static get className(){return"RMSProp"}constructor(e,t=.9,n=0,s=null,r=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=la.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=la.registeredVariables[t],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:Oa((()=>fl(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:Oa((()=>fl(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:Oa((()=>fl(s).variable(r)))});const a=Array.isArray(e)?e[n].tensor:e[t];if(null==a)return;const i=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;Oa((()=>{const e=Vi(Hi(i,this.decay),Hi(Dl(a),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,r=Vi(Hi(t,this.decay),Hi(a,1-this.decay)),l=Gi(Hi(a,this.learningRate),Fl(mu(e,Vi(Dl(r),this.epsilon)))),u=Vi(Hi(o,this.momentum),l);i.assign(e),t.assign(r),o.assign(u);const c=mu(s,u);s.assign(c)}else{const e=Vi(Hi(i,this.decay),Hi(Dl(a),1-this.decay)),t=Vi(Hi(o,this.momentum),Gi(Hi(a,this.learningRate),Fl(Vi(e,this.epsilon))));i.assign(e),o.assign(t);const n=mu(s,t);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&Ma(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&Ma(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&Ma(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}const kd=[md,gd,yd,bd,wd,vd,xd];function Nd(e){return new Promise((e=>setTimeout(e))).then(e)}class Id{constructor(e){if(!K().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Id.URL_SCHEME)&&(e=e.slice(Id.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=Ta.join(e.weightData),n=window.URL.createObjectURL(new Blob([t],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const t=ii(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(t)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Nd((()=>r.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=n,await Nd((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:ui(e)}}}}Id.URL_SCHEME="downloads://";class Sd{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const s=JSON.parse(n.target.result),r=s.modelTopology;if(null==r)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==s.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:r});const a=li(s,(e=>this.loadWeights(e)));e(a)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const s of e)t.push(...s.weights),n.push(...s.paths);const s=this.checkManifestAndWeightFiles(e),r=n.map((e=>this.loadWeightsFile(e,s[e])));return Promise.all(r).then((e=>[t,e]))}loadWeightsFile(e,t){return new Promise(((n,s)=>{const r=new FileReader;r.onload=e=>{const t=e.target.result;n(t)},r.onerror=t=>s(`Failed to weights data from file of path '${e}'.`),r.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>ai(e.name))),s={};for(const r of e)r.paths.forEach((e=>{const r=ai(e);if(-1!==t.indexOf(r))throw new Error(`Duplicate file basename found in weights manifest: '${r}'`);if(t.push(r),-1===n.indexOf(r))throw new Error(`Weight file with basename '${r}' is not provided.`);s[e]=this.weightsFiles[n.indexOf(r)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return s}}function Td(e,t,n,s){!function(e){u(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){u(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),u(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),u(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(e.map((a=>(a.then((a=>{const i=n+ ++r/e.length*(s-n);return t(i),a})),a))))}async function Cd(e,t){null==t&&(t={});const n=null==t.fetchFunc?K().platform.fetch:t.fetchFunc,s=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),r=(null==t.onProgress?await Promise.all(s):await Td(s,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(r):await Td(r,t.onProgress,.5,1)}async function $d(e,t="",n,s){return Ed((e=>Cd(e,{requestInit:s})))(e,t,n)}function Ed(e){return async(t,n="",s)=>{const r=t.map((()=>!1)),a={},i=null!=s?s.map((()=>!1)):[],o=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=Sa[l]*p(e.shape),c=()=>{r[t]=!0,null==a[t]&&(a[t]=[]),a[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=s?s.forEach(((t,n)=>{t===e.name&&(c(),i[n]=!0)})):c(),o.push(e.name),n+=u}))})),!i.every((e=>e))){const e=s.filter(((e,t)=>!i[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${o.join(", ")}.`)}const l=r.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const c=await e(u),h={};let d=0;return l.forEach((e=>{const n=t[e].paths.length,s=new Ta(c.slice(d,d+n));a[e].forEach((e=>{const t=Xa(s.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)h[e]=t[e]})),d+=n})),h}}hi.registerSaveRouter((e=>K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Id.URL_SCHEME)?function(e="model"){return new Id(e)}(e.slice(Id.URL_SCHEME.length)):null));class Ad{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(u("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=K().platform.fetch,u(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&u(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{},this.loadOptions=t}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=ii(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);if(t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData){const n=Ta.join(e.weightData);t.body.append("model.weights.bin",new Blob([n],{type:"application/octet-stream"}),"model.weights.bin")}const s=await this.fetch(this.path,t);if(s.ok)return{modelArtifactsInfo:ui(e),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async loadModelJSON(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,s=t.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return t}async load(){if(this.loadOptions.streamWeights)return this.loadStream();return li(await this.loadModelJSON(),(e=>this.loadWeights(e)))}async loadStream(){const e=await this.loadModelJSON(),t=await this.getWeightUrls(e.weightsManifest),n=ci(e.weightsManifest);return Object.assign(Object.assign({},e),{weightSpecs:n,getWeightStream:()=>function(e,t){var n;const s=null==t.fetchFunc?K().platform.fetch:t.fetchFunc;let r,a=0;return null===(n=t.onProgress)||void 0===n||n.call(t,0),new ReadableStream({pull:async n=>{for(var i;a<e.length;){if(!r){const n=(await s(e[a],t.requestInit,{isBinary:!0})).body;r=n.getReader()}const{done:o,value:l}=await r.read();if(!o)return void n.enqueue(l);a++,r=void 0,null===(i=t.onProgress)||void 0===i||i.call(t,a/e.length)}n.close()}})}(t,this.loadOptions)})}async getWeightUrls(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),s=e.substring(0,t),r=n>t?e.substring(n):"";return[s+"/",r]}(t),r=this.weightPathPrefix||n,a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(r+e+s);return this.weightUrlConverter&&a.push(...await Promise.all(i)),a}async loadWeights(e){const t=await this.getWeightUrls(e);return[ci(e),await Cd(t,this.loadOptions)]}}function Rd(e){return null!=e.match(Ad.URL_SCHEME_REGEX)}Ad.URL_SCHEME_REGEX=/^https?:\/\//;const _d=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>Rd(e))):Rd(e),n)return Fd(e,t)}return null};function Fd(e,t){return new Ad(e,t)}function Dd(e,t){return Fd(e,t)}hi.registerSaveRouter(_d),hi.registerLoadRouter(_d);class Od{constructor(e){this.modelArtifacts=e}load(){return this.modelArtifacts}}class Md{constructor(e){this.saveHandler=e}save(e){return this.saveHandler(e)}}class Ld{constructor(e){e.load&&(this.load=()=>Promise.resolve(e.load())),e.save&&(this.save=t=>Promise.resolve(e.save(t)))}}function zd(e,t,n,s){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new Od(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Od({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Od({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:s})}var Pd=Object.freeze({__proto__:null,CompositeArrayBuffer:Ta,browserFiles:function(e){return new Sd(e)},browserHTTPRequest:Dd,concatenateArrayBuffers:ri,copyModel:async function(e,t){return Fi(e,t,!1)},decodeWeights:Xa,decodeWeightsStream:ei,encodeWeights:Ka,fromMemory:function(e,t,n,s){const r=arguments;return new Ld(zd(...r))},fromMemorySync:zd,getLoadHandlers:di,getModelArtifactsForJSON:li,getModelArtifactsForJSONSync:oi,getModelArtifactsInfoForJSON:ui,getSaveHandlers:pi,getWeightSpecs:ci,http:Fd,isHTTPScheme:Rd,listModels:async function(){const e=Ri.getSchemes(),t={};for(const n of e){const e=await Ri.getManager(n).listModels();for(const s in e){t[n+"://"+s]=e[s]}}return t},loadWeights:$d,moveModel:async function(e,t){return Fi(e,t,!0)},registerLoadRouter:e=>hi.registerLoadRouter(e),registerSaveRouter:e=>hi.registerSaveRouter(e),removeModel:async function(e){const t=_i(e);return Ri.getManager(t.scheme).removeModel(t.path)},weightsLoaderFactory:Ed,withSaveHandler:function(e){return new Md(e)},withSaveHandlerSync:function(e){return new Md(e)}});const Bd=va({confusionMatrix_:function(e,t,n){const s=ba(e,"labels","confusionMatrix"),r=ba(t,"predictions","confusionMatrix");u(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),u(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),u(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),u(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),u(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const a=Pu(Pi(s,"int32"),n),i=Pu(Pi(r,"int32"),n),o=zh(a),l=So(o,i);return Pi(l,"int32")}});var Wd=Object.freeze({__proto__:null,confusionMatrix:Bd});let Vd,Ud=!1;function Gd(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1,o=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)a=!0;else if(null!=e.getContext)i=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);o=!0}if(null!=vs("FromPixels",la.backendName)){const n={pixels:e},s={numChannels:t};return la.runKernel("FromPixels",n,s)}const[l,u]=r?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(i)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)c=e.data;else if(a||r||o){if(null==Vd)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Vd=new OffscreenCanvas(1,1).getContext("2d")}else Vd=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Vd.canvas.width=l,Vd.canvas.height=u,Vd.drawImage(e,0,0,l,u),c=Vd.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return xh(h,[u,l,t],"int32")}function Hd(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}function jd(e){if(2!==e.rank&&3!==e.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${e.rank}.`);const t=2===e.rank?1:e.shape[2];if(t>4||2===t)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${t}`);if("float32"!==e.dtype&&"int32"!==e.dtype)throw new Error(`Unsupported type for toPixels: ${e.dtype}. Please use float32 or int32 tensors.`)}const qd=va({fromPixels_:Gd});var Kd=Object.freeze({__proto__:null,draw:function(e,t,n){let s=ba(e,"img","draw");if(!(e instanceof Pr)){const e=s;s=Pi(e,"int32"),e.dispose()}jd(s),function(e){const t=(null==e?void 0:e.alpha)||1;if(t>1||t<0)throw new Error(`Alpha value ${t} is suppoed to be in range [0 - 1].`)}(null==n?void 0:n.imageOptions);const r={image:s},a={canvas:t,options:n};la.runKernel("Draw",r,a)},fromPixels:qd,fromPixelsAsync:async function(e,t=3){let n=null;if(K().getBool("WRAP_TO_IMAGEBITMAP")&&Hd(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return Gd(n,t)},toPixels:async function(e,t){let n=ba(e,"img","toPixels");if(!(e instanceof Pr)){const e=n;n=Pi(e,"int32"),e.dispose()}jd(n);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2],i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let e=0;e<s*r;++e){const t=[0,0,0,255];for(let s=0;s<a;s++){const r=i[e*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(t[0]=r*o,t[1]=r*o,t[2]=r*o):t[s]=r*o}const s=4*e;l[s+0]=Math.round(t[0]),l[s+1]=Math.round(t[1]),l[s+2]=Math.round(t[2]),l[s+3]=Math.round(t[3])}if(null!=t){if(!Ud){null!=vs("Draw",la.backendName)&&(console.warn("tf.browser.toPixels is not efficient to draw tensor on canvas. Please try tf.browser.draw instead."),Ud=!0)}t.width=r,t.height=s;const e=t.getContext("2d"),n=new ImageData(l,r,s);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l}});function Xd(e,t){const n=e.shape.length,s=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(s<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[s-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s-1]} vs. ${n}`);if(0===p(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const r=t.shape,a=r[r.length-1];let i=1;for(let e=0;e<r.length-1;++e)i*=r[e];const o=e.shape,l=r.slice();l.pop();let u=1;for(let e=a;e<n;++e)u*=o[e],l.push(o[e]);const c=[...O(e.shape).map((e=>e/u)),1].slice(0,a);return[l,i,u,c]}var Yd=Object.freeze({__proto__:null,prepareAndValidate:Xd});function Zd(e,t,n){const s=e.shape.length;u(s===t.length,(()=>`Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`)),u(s===n.length,(()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`));for(let r=0;r<s;++r)u(t[r]+n[r]<=e.shape[r],(()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${t[r]+n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`))}function Jd(e,t,n){const s=[];for(let r=0;r<e.length;r++)s[r]=Math.ceil((t[r]-e[r])/n[r]);return s}function Qd(e,t,n,s){const r=[...e];for(let e=r.length;e<s.length;e++)r.push(1);for(let e=0;e<n;e++)0===e?r[t]=1:(r.splice(t,0,1),r.pop());return r}function ef(e,t,n){return n<=e?n:n-(t-1)}function tf(e,t){const n=[];for(let s=0;s<e;s++)n.push(t+s);return n}function nf(e,t,n,s,r){const a=[...r],i=tf(n,t);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=ef(t,n,r);let o=s[i];e&1<<i&&(o=0),a[r]=o}return a}function sf(e,t,n,s,r){const i=[...r],o=tf(n,t);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=ef(t,n,r);let o=s[a];e&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let e=0;e<i.length;e++){const t=r[e];i[e]<0&&(i[e]+=t),i[e]=a(0,i[e],r[e])}return i}function rf(e,t,n){let s=e[t];return(n&1<<t||null==s)&&(s=1),s}function af(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=a(0,o,u-1),o}function of(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=l>0?a(0,o,u):a(-1,o,u-1),o}function lf(e,t,n){let s=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){s=e;break}for(let r=s+1;r<n.length;r++)if(t[r]>0||n[r]!==e[r])return!1;return!0}function uf(e,t){let n=e.length>0?e[e.length-1]:1;for(let s=0;s<e.length-1;s++)n+=e[s]*t[s];return n}function cf(e,t,n){let s;const r=e.shape.length;let a;return s="number"==typeof t?[t,...new Array(r-1).fill(0)]:t.length<r?t.concat(new Array(r-t.length).fill(0)):t.slice(),s.forEach((e=>{u(-1!==e,(()=>"slice() does not support negative begin indexing."))})),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map(((t,n)=>t>=0?t:(u(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-s[n]))),[s,a]}function hf(e,t,n,s,r,a,i,o,l){let u;if(null==s?(u=new Array(t.length),u.fill(1)):u=s,null!=i&&0!=(i&i-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&o)&&h.numAddAxisAfterEllipsis++,1<<e&i&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const p={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let s=0;s<e.dims;s++)if(1<<s&e.ellipsisMask){const r=Math.min(t.dims-(e.dims-s)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<r;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=s}else if(1<<s&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[s]),null!=e.end&&(t.end[n]=e.end[s]),t.strides[n]=e.strides[s],e.beginMask&1<<s&&(t.beginMask|=1<<n),e.endMask&1<<s&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<s?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(s)),t.inputShapeGatherIndicesSparse[n]=s,n++}}(h,p);let d=!0,f=!0,m=!0;const g=[],y=[];for(let t=0;t<e.length;++t){if(0===p.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(p.shrinkAxisMask&1<<t),s=e[t];if(-1===s){g.push(n?1:-1);continue}const r=[p.beginMask&1<<t,p.endMask&1<<t],a=[p.strides[t]>0?0:-1,p.strides[t]>0?s:s-1];if(n&&p.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");m=m&&1===p.strides[t];const i=!!(p.beginMask&1<<t&&p.endMask&1<<t);if(p.beginValid&&p.endValid){if(n){const e=p.begin[t]<0?s+p.begin[t]:p.begin[t];if(p.begin[t]=e,p.end[t]=p.begin[t]+1,e<0||e>=s)throw Error(`slice index ${p.begin[t]} of dimension ${t} out of bounds.`)}else p.begin[t]=pf(p.begin[t],0,p.strides[t],s,r,a),p.end[t]=pf(p.end[t],1,p.strides[t],s,r,a);const e=1===p.strides[t]&&0===p.begin[t]&&p.end[t]===s;d=d&&e,f=f&&(0===t&&1===p.strides[t]||e)}else d=d&&1===p.strides[t]&&i,f=f&&(0===t&&1===p.strides[t]||i);let o,l=!1;if(p.beginValid&&p.endValid?(o=p.end[t]-p.begin[t],l=!0):n?(o=1,l=!0):i&&s>=0&&(o=p.strides[t]<0?-s:s,l=!0),l){let e;e=0===o||o<0!=p.strides[t]<0?0:Math.trunc(o/p.strides[t])+(o%p.strides[t]!=0?1:0),g.push(e)}else g.push(-1)}for(let e=0;e<p.finalShapeGatherIndices.length;++e){const t=p.finalShapeGatherIndices[e];t>=0?y.push(g[t]):-2===t&&y.push(1)}return{finalShapeSparse:y.filter(((e,t)=>-2!==p.finalShapeGatherIndices[t])),finalShape:y,isIdentity:d,sliceDim0:f,isSimpleSlice:m,begin:p.begin,end:p.end,strides:p.strides}}function pf(e,t,n,s,r,a){if(r[t])return n>0?a[t]:a[t+1&1];{const t=e<0?s+e:e;return t<a[0]?a[0]:t>a[1]?a[1]:t}}var df=Object.freeze({__proto__:null,assertParamsValid:Zd,computeFlatOffset:uf,computeOutShape:Jd,getNormalizedAxes:function(e,t,n,s,r,a,i,o,l){const u=e.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=nf(i,l,u,s,e),h=sf(o,l,u,r,e),p=Qd(a,l,u,e)}else for(let t=0;t<u;t++)c[t]=af(i,s,a,e,t,l),h[t]=of(o,r,a,e,t,l),p[t]=rf(a,t,l);return{begin:c,end:h,strides:p}},isSliceContinous:lf,maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},parseSliceParams:cf,sliceInfo:hf,startForAxis:af,startIndicesWithElidedDims:nf,stopForAxis:of,stopIndicesWithElidedDims:sf,stridesForAxis:rf,stridesWithElidedDims:Qd});const ff="4.22.0";class mf{static sgd(e){return new xd(e)}static momentum(e,t,n=!1){return new wd(e,t,n)}static rmsprop(e,t=.9,n=0,s=null,r=!1){return new vd(e,t,n,s,r)}static adam(e=.001,t=.9,n=.999,s=null){return new yd(e,t,n,s)}static adadelta(e=.001,t=.95,n=null){return new md(e,t,n)}static adamax(e=.002,t=.9,n=.999,s=null,r=0){return new bd(e,t,n,s,r)}static adagrad(e,t=.1){return new gd(e,t)}}const gf=mf,yf="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function bf(){return new Promise((e=>yf((()=>e()))))}function xf(e,t){const n=e[0].length;e.forEach(((e,t)=>{u(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),u(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const s=e[0];e.forEach(((e,r)=>{for(let a=0;a<n;a++)u(a===t||e[a]===s[a],(()=>`Error in concat${n}D: Shape of tensors[${r}] (${e}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`))}))}function wf(e,t){const n=e[0].slice();for(let s=1;s<e.length;s++)n[t]+=e[s][t];return n}var vf;function kf(e,t,n){let s=new Array;if(null==n&&null==t)return s;if(null==t)for(;s.length<e+n.length;)s.push(-1);else s=t.slice();if(null==n)return s;if(e+n.length!==s.length)throw new Error(`rt input.shape and shape=${t} are incompatible: rt input.rank = ${e+n.length}, but shape.rank = ${s.length}`);for(let r=1;r<n.length;++r){const a=n[r],i=s[s.length-n.length+r],o=s[i];if(a>=0)if(o>=0){if(o!==a)throw new Error(`rt input.shape and shape=${t} are incompatible: rt input.shape[${r+e}] = ${a} but shape[${r+e}] = ${o}`)}else s[i]=a}return s}function Nf(e){const t={FIRST_DIM_SIZE:vf.FIRST_DIM_SIZE,VALUE_ROWIDS:vf.VALUE_ROWIDS,ROW_LENGTHS:vf.ROW_LENGTHS,ROW_SPLITS:vf.ROW_SPLITS,ROW_LIMITS:vf.ROW_LIMITS,ROW_STARTS:vf.ROW_STARTS},n=[];for(const s of e){if(!(s in t))break;n.push(t[s])}return n}function If(e){return 0===e.length?0:e[0]===vf.FIRST_DIM_SIZE?e.length-1:e.length}function Sf(e,t){if(null==e||null==t)return;const n=e.length,s=t.length;if(n>=s)throw new Error(`defaultValue.shape=${e} and ragged tensor flatValues.shape=${t}, are incompatible: defaultValue.rank = ${n} must be less than ragged tensor input flatValues.rank = ${s})`);for(let r=0;r<Math.min(n,s-1);++r){const n=e[r],s=t[r+1];if(n>=0&&s>=0&&1!==n&&n!==s)throw new Error(`defaultValue.shape=${e}, and ragged tensor input flatValues.shape=${t} are incompatible: defaultValue.shape[${r-e.length}] = ${n} but ragged tensor input.flatValues.shape[${r-e.length}] = ${s}`)}}!function(e){e[e.FIRST_DIM_SIZE=0]="FIRST_DIM_SIZE",e[e.VALUE_ROWIDS=1]="VALUE_ROWIDS",e[e.ROW_LENGTHS=2]="ROW_LENGTHS",e[e.ROW_SPLITS=3]="ROW_SPLITS",e[e.ROW_LIMITS=4]="ROW_LIMITS",e[e.ROW_STARTS=5]="ROW_STARTS"}(vf||(vf={}));function Tf(e){return e<=30?e:D(e,Math.floor(Math.sqrt(e)))}function Cf(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]}function $f(e,t,n,s=!0){let r=[];if(s)r=r.concat(t.slice(0)),r.push(e[0]/n),r=r.concat(e.slice(1));else{r=r.concat(e[0]);const n=t.length;for(let s=0;s<n;++s)r=r.concat([e[s+1]/t[s],t[s]]);r=r.concat(e.slice(n+1))}return r}function Ef(e,t,n=!0){const s=[];if(n){s.push(t);for(let n=t+1;n<e;++n)n<=2*t?(s.push(n),s.push(n-(t+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<e;++s)s>=2*t+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function Af(e,t,n,s=!0){const r=[];s?r.push(e[0]/n):r.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?s?r.push(t[n-1]*e[n]):r.push(e[n]/t[n-1]):r.push(e[n]);return r}function Rf(e,t){const n=[0];for(let s=0;s<t;++s)n.push(e[s][0]);return n}function _f(e,t,n){const s=e.slice(0,1);for(let r=0;r<n;++r)s.push(e[r+1]-t[r][0]-t[r][1]);return s}const Ff=1.0507009873554805;function Df(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let s=0;s<n.length;s+=2)n[s]=e[s/2],n[s+1]=t[s/2];return n}function Of(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let s=0;s<e.length;s+=2)t[s/2]=e[s],n[s/2]=e[s+1];return{real:t,imag:n}}function Mf(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Lf(e){const t=Math.floor(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function zf(e,t){return{real:e[2*t],imag:e[2*t+1]}}function Pf(e,t,n,s){e[2*s]=t,e[2*s+1]=n}function Bf(e,t){const n=new Float32Array(e/2),s=new Float32Array(e/2);for(let r=0;r<Math.ceil(e/2);r++){const a=(t?2:-2)*Math.PI*(r/e);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function Wf(e,t,n){const s=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(s),imag:Math.sin(s)}}const Vf=/->/g;function Uf(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(Vf,"").length)/"->".length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[s,r]=e.split("->");u(-1===s.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const a=s.split(","),i=a.length;if(t!==i)throw new Error(`Expected ${i} input tensors, received ${t}`);if(i>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const o=[];for(let e=0;e<r.length;++e){const t=r[e];if(!a.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===o.indexOf(t)&&o.push(t)}for(let e=0;e<s.length;++e){const t=s[e];-1===o.indexOf(t)&&","!==t&&o.push(t)}const l=new Array(a.length);for(let e=0;e<i;++e){if(new Set(a[e].split("")).size!==a[e].length)throw new Error(`Found duplicate axes in input component ${a[e]}. Support for duplicate axes in input is not implemented yet.`);l[e]=[];for(let t=0;t<a[e].length;++t)l[e].push(o.indexOf(a[e][t]))}const c=o.length,h=[];for(let e=r.length;e<c;++e)h.push(e);return{allDims:o,summedDims:h,idDims:l}}function Gf(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const s=[];for(let t=0;t<e;++t)-1===n[t]&&s.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:s}}function Hf(e,t,n){const s=new Array(e);for(let e=0;e<n.length;++e){const r=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===s[t[e][n]]?s[t[e][n]]=r[n]:u(s[t[e][n]]===r[n],(()=>`Expected dimension ${s[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(r)}, but got dimension ${r[n]}`))}}function jf(e,t){const n=e,s=[];let r=0;0===e.length&&n.push(-1),r=e.length+1;for(let e=0;e<r;++e)s.push([]);const a=[];for(let e=0;e<n.length;++e){const r=Kf(t,n[e]);for(const t of r)-1===a.indexOf(t)&&(s[e].push(t),a.push(t))}return{path:n,steps:s}}function qf(e){return e.every(((e,t)=>e===t))}function Kf(e,t){const n=[];for(let s=0;s<e.length;++s)0!==e[s].length&&-1===e[s].indexOf(t)&&-1!==t||n.push(s);return n}function Xf(e,t,n=0){let s=[];if("number"==typeof t)u(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),s=new Array(t).fill(e.shape[n]/t);else{const r=t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0);u(r<=1,(()=>"There should be only one negative value in split array."));const a=t.indexOf(-1);if(-1!==a){const s=t.reduce(((e,t)=>t>0?e+t:e));t[a]=e.shape[n]-s}u(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),s=t}return s}function Yf(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`}function Zf(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`}function Jf(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`}function Qf(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`}function em(e,t){return`size ${e} must be non-negative, not ${t}`}function tm(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"}function nm(e,t){return`Input to reshape is a SparseTensor with ${p(e)}\n  dense values, but the requested shape requires a multiple of ${p(t)}. inputShape=${e} outputShape= ${t}`}function sm(e,t){return`Input to reshape is a tensor with ${p(e)} dense values, but the requested shape has ${p(t)}. inputShape=${e} outputShape=${t}`}function rm(){return"segment ids must be >= 0"}function am(){return"segment ids are not increasing"}function im(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`}function om(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}function lm(e,t){let n,s=!1;for(e<=30?(n=e,s=!0):n=D(e,Math.floor(Math.sqrt(e)));!s;)n>t||n===e?s=!0:n=D(e,n+1);return n}function um(e,t,n){const s=[],r=e.length;for(let a=0;a<r;a++)a!==t?s.push(e[a]):s.push(n);return s}function cm(e,t,n,s){const r=t.shape.length,a=e.shape.length;if(0!==s&&(s<-r||s>r))throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);if(s<0&&(s+=r),s>a)throw new Error(`batchDims (${s}) must be less than rank(x) (\n    ${a}).`);if(n<s)throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);for(let n=0;n<s;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const i=e.shape[n],o=[];let l=1,u=1,c=1;for(let t=0;t<s;++t)o.push(e.shape[t]),l*=e.shape[t];for(let t=s;t<n;t++)o.push(e.shape[t]),u*=e.shape[t];for(let e=s;e<r;e++)o.push(t.shape[e]);for(let t=n+1;t<a;t++)o.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:i,outputShape:o}}var hm=Object.freeze({__proto__:null,collectGatherOpShapeInfo:cm,computeOutShape:um,segOpComputeOptimalWindowSize:lm});function pm(e){try{return e.map((e=>Nr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}}function dm(e){return e.map((e=>kr(e)))}var fm=Object.freeze({__proto__:null,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,ERF_P:.3275911,PARALLELIZE_THRESHOLD:30,get RowPartitionType(){return vf},SELU_SCALE:Ff,SELU_SCALEALPHA:1.7580993408473768,applyActivation:Yh,assertAndGetBroadcastShape:cl,assertAxesAreInnerMostDims:Sl,assertParamsConsistent:xf,assignToTypedArray:Pf,axesAreInnerMostDims:vl,calculateShapes:Sh,checkEinsumDimSizes:Hf,checkPadOnDimRoundingMode:wo,combineLocations:kl,combineRaggedTensorToTensorShapes:kf,complexWithEvenIndex:Mf,complexWithOddIndex:Lf,computeConv2DInfo:lo,computeConv3DInfo:uo,computeDefaultPad:co,computeDilation2DInfo:ao,computeOptimalWindowSize:Tf,computeOutAndReduceShapes:Nl,computeOutShape:wf,computePool2DInfo:io,computePool3DInfo:oo,convertConv2DDataFormat:xo,decodeEinsumEquation:Uf,eitherStridesOrDilationsAreOne:yo,expandShapeToKeepDim:Il,exponent:Wf,exponents:Bf,fromStringArrayToUint8:dm,fromUint8ToStringArray:pm,getAxesPermutation:Tl,getBroadcastDims:ll,getComplexWithIndex:zf,getEinsumComputePath:jf,getEinsumPermutation:Gf,getFusedBiasGradient:Xh,getFusedDyActivation:Kh,getImageCenter:Cf,getInnerMostAxes:$l,getPermuted:Ef,getRaggedRank:If,getReductionAxes:ul,getReshaped:$f,getReshapedPermuted:Af,getRowPartitionTypesHelper:Nf,getSliceBeginCoords:Rf,getSliceSize:_f,getSparseFillEmptyRowsIndicesDenseShapeMismatch:Yf,getSparseFillEmptyRowsNegativeIndexErrorMessage:Zf,getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:Jf,getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:tm,getSparseReshapeInputOutputMismatchErrorMessage:sm,getSparseReshapeInputOutputMultipleErrorMessage:nm,getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:Qf,getSparseReshapeNegativeOutputDimErrorMessage:em,getSparseSegmentReductionIndicesOutOfRangeErrorMessage:om,getSparseSegmentReductionNegativeSegmentIdsErrorMessage:rm,getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:am,getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:im,getUndoAxesPermutation:Cl,isIdentityPermutation:qf,log:function(...e){K().getBool("IS_TEST")||K().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:Df,prepareAndValidate:Xd,prepareSplitSize:Xf,segment_util:hm,shouldFuse:Zh,slice_util:df,splitRealAndImagArrays:Of,stridesOrDilationsArePositive:bo,tupleValuesAreOne:go,upcastType:Kr,validateDefaultValueShape:Sf,validateInput:Ih,validateUpdateShape:Nh,warn:bs}),mm=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:yp,nonMaxSuppressionV4Impl:bp,nonMaxSuppressionV5Impl:xp,whereImpl:Oh});!function(){for(const e of kd)pd(e)}();const gm={kernelName:"Abs",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,fh(Pi(n,"float32"),-1))}}},ym={kernelName:"Acos",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Dl(Pi(n,"float32")),s=Fl(mu(_l(1),t));return pu(Gi(e,s))}}}},bm={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Fl(mu(Dl(Pi(n,"float32")),1));return Gi(e,t)}}}},xm={kernelName:"Add",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{let t=e;const s=ul(n.shape,r);return s.length>0&&(t=Ol(t,s)),vo(t,n.shape)},b:()=>{let t=e;const n=ul(s.shape,r);return n.length>0&&(t=Ol(t,n)),vo(t,s.shape)}}}},wm={kernelName:"AddN",saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach(((t,s)=>{n[s]=()=>e.clone()})),n}},vm={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fl(n)}}},km={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fl(n)}}},Nm={kernelName:"Asin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Fl(mu(_l(1),Dl(Pi(n,"float32")))))}}},Im={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Fl(Vi(_l(1),Dl(Pi(n,"float32"))));return Gi(e,t)}}}},Sm={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{const t=Vi(Dl(n),Dl(s));let a=Hi(e,Gi(s,t));const i=ul(n.shape,r);return i.length>0&&(a=Ol(a,i)),vo(a,n.shape)},b:()=>{const t=Vi(Dl(n),Dl(s));let a=pu(Hi(e,Gi(n,t)));const i=ul(s.shape,r);return i.length>0&&(a=Ol(a,i)),vo(a,s.shape)}}}},Tm={kernelName:"Atan",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Vi(Dl(Pi(n,"float32")),1))}}},Cm={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,mu(_l(1),Dl(Pi(n,"float32"))))}}};const $m=va({avgPool3dGrad_:function(e,t,n,s,r,a){const i=ba(e,"dy","avgPool3dGrad"),o=ba(t,"input","avgPool3dGrad");let l=i,c=o,h=!1;4===o.rank&&(h=!0,l=vo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]]),c=vo(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),u(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),u(5===c.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),wo("avgPool3dGrad",r,a);const p={dy:l,input:c},d={filterSize:n,strides:s,pad:r,dimRoundingMode:a},f=la.runKernel("AvgPool3DGrad",p,d);return h?vo(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}}),Em={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i,dimRoundingMode:o}=n;return{x:()=>$m(e,s,r,a,i,o)}}};const Am=va({avgPoolGrad_:function(e,t,n,s,r){const a=ba(e,"dy","avgPoolGrad"),i=ba(t,"input","avgPoolGrad");u(i.rank===a.rank,(()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`));let o=i,l=a,c=!1;3===i.rank&&(c=!0,o=vo(i,[1,i.shape[0],i.shape[1],i.shape[2]]),l=vo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),u(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},p={filterSize:n,strides:s,pad:r},d=la.runKernel("AvgPoolGrad",h,p);return c?vo(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),Rm={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i}=n;return{x:()=>Am(e,s,r,a,i)}}},_m={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[s,r]=t,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>So(e,r,!1,!1),b:()=>So(e,s,!0,!1)}:a&&!i?{a:()=>So(r,e,!1,!0),b:()=>So(s,e,!1,!1)}:{a:()=>So(r,e,!0,!0),b:()=>So(e,s,!0,!0)}:{a:()=>So(e,r,!1,!0),b:()=>So(s,e,!0,!1)}}},Fm={kernelName:"BatchToSpaceND",gradFunc:(e,t,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>qu(e,s,r)}}},Dm={kernelName:"BroadcastTo",gradFunc:(e,t,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let e=r.length-1;e>=0;e--)if(r[e]===a[e])i[e]=1;else if(1!==r[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let e=0;e<i.length;e++)i[e]>1&&o.push(e);return{x:()=>Ol(e,o,!0)}}},Om={kernelName:"Cast",gradFunc:e=>({x:()=>e.clone()})},Mm={kernelName:"Ceil",gradFunc:e=>({x:()=>fl(e)})},Lm={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>dl(bu(ql(s,r),eu(s,a)),e,fl(e))}}},zm={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:gm.gradFunc},Pm={kernelName:"Concat",saveAllInputs:!0,gradFunc:(e,t,n)=>{const s=t.map((e=>e.shape)),{axis:r}=n,a=w(r,t[0].shape)[0],i=s.map((e=>e[a]));return uh(e,i,a).map((e=>()=>e))}},Bm={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{dilations:a,strides:i,pad:o,dataFormat:l}=n;return u(go(a),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`)),{x:()=>Ko(s.shape,e,r,i,o,l),filter:()=>qh(s,e,r.shape,i,o,l)}}},Wm={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>jo(e,r,a,i,o,1,l),filter:()=>qh(e,s,r.shape,a,i,o,l)}}};const Vm=va({conv3DBackpropFilter_:function(e,t,n,s,r){let a=e;4===e.rank&&(a=vo(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=vo(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),u(5===a.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${a.shape}.`)),u(5===i.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${i.shape}.`)),u(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),u(a.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`)),u(i.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:a,dy:i},l={strides:s,pad:r,filterShape:n};return la.runKernel("Conv3DBackpropFilterV2",o,l)}}),Um={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a}=n;u(go(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[i,o]=t;return{x:()=>Zo(i.shape,e,o,r,a),filter:()=>Vm(i,e,o.shape,r,a)}}},Gm={kernelName:Oe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(pu(Qc(Pi(n,"float32"))),e)}}},Hm={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(eh(Pi(n,"float32")),e)}}},jm={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const t=Tl([r],s.rank);let n=nl(e,r,a,!i);return null!=t&&(n=zh(n,t)),n}}}},qm={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,o=null==s?[1,1]:s;u(go(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,c]=t;return u(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),u(4===c.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`)),u(l.shape[3]===c.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`)),u(yo(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),wo("depthwiseConv2d",a,i),{x:()=>ep(l.shape,e,c,r,a,o,i),filter:()=>Qh(l,e,c.shape,r,a,o,i)}}},Km={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,a={x:s,filter:r,dy:e},i={x:s,filter:r,dy:e};return{x:()=>la.runKernel("Dilation2DBackpropInput",a,n),filter:()=>la.runKernel("Dilation2DBackpropFilter",i,n)}}},Xm={kernelName:"Elu",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,s={dy:e,y:n};return{x:()=>la.runKernel("EluGrad",s)}}},Ym={kernelName:et,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=Hi(Pl(pu(Dl(n))),2/Math.sqrt(Math.PI));return{x:()=>Hi(e,s)}}},Zm={kernelName:nt,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,n)}}},Jm={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>vo(e,n.shape)}}},Qm={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,Pl(n))}}},eg={kernelName:"Floor",gradFunc:e=>({x:()=>fl(e)})},tg={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{const t=Gi(e,Pi(s,"float32")),a=ul(n.shape,r);return a.length>0?vo(Ol(t,a),n.shape):t},b:()=>{let t=Hi(e,Pi(n,"float32"));const a=ul(s.shape,r);a.length>0&&(t=vo(Ol(t,a),s.shape));const i=Dl(s);return pu(Gi(t,Pi(i,"float32")))}}}},ng={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=t,l=null==o?_l(1):o,u=ul(a.shape,r.shape),c=[];if(1===a.rank){for(let e=0;e<r.shape.length-1;++e)c.push(r.shape[e]);c.push(1)}const h=mu(r,a),p=Hi(e,l),d=Kc(Vi(i,_l(s))),f=Hi(Hi(Hi(d,d),d),_l(-.5));return{x:()=>1===a.rank?vo(Hi(Hi(e,Vl(vo(d,[1,1,1,a.shape[0]]),c)),l),r.shape):vo(Hi(Hi(e,d),l),r.shape),mean:()=>{let e=Hi(Hi(d,_l(-1)),p);return 1===a.rank&&(e=Ol(e,u)),vo(e,a.shape)},variance:()=>{let e=Hi(Hi(f,h),p);return 1===a.rank&&(e=Ol(e,u)),vo(e,a.shape)},scale:()=>{const t=Hi(h,d);let n=Hi(e,t);return 1===a.rank&&(n=Ol(n,u)),vo(n,a.shape)},offset:()=>{let t=e;return 1===a.rank&&(t=Ol(t,u)),vo(t,a.shape)}}}},sg={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[s,r]=t,{axis:a,batchDims:i}=n,o=w(a,s.shape)[0],l=(e,t,n)=>()=>{const s=e.shape,r=t.size,i=s.slice(0,o),l=i.length,u=s.slice(a,s.length).slice(1),c=u.length,h=rg(0,l),p=rg(l+1,l+1+c),d=ag([i,[r],u]),f=vo(n,d),m=vo(t,[r]),g=ag([[l],h,p]),y=zh(f,g);let b=Rh(y,m,e.shape[o]);const x=Cl(g);return b=zh(b,x),b};if(1===i){const t=s.shape[0],n=s.split(t,0);return{x:()=>{const t=dh(n.map(((t,n)=>l(t,r.slice(n,1),e.slice(n,1))())));return t.reshape(s.shape)},indices:()=>r}}return{x:l(s,r,e),indices:()=>r}}};function rg(e,t){const n=[];for(let s=e;s<t;++s)n.push(s);return n}function ag(e){const t=[];for(let n=0;n<e.length;++n)for(let s=0;s<e[n].length;++s)t.push(e[n][s]);return t}const ig={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>fl(n),b:()=>fl(s)}}},og={kernelName:"Identity",gradFunc:e=>({x:()=>Pi(e,"float32")})},lg={kernelName:"IsFinite",gradFunc:e=>({x:()=>fl(e)})},ug={kernelName:"IsInf",gradFunc:e=>({x:()=>fl(e)})},cg={kernelName:"IsNan",gradFunc:e=>({x:()=>fl(e)})},hg={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{alpha:r}=n,a=jl(s,0);return{x:()=>dl(a,e,Hi(e,r))}}},pg={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Vi(n,1))}}},dg={kernelName:St,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Pi(n,"float32"))}}},fg={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;return{logits:()=>{const t=Pl(s);return mu(e,Hi(Ol(e,r,!0),t))}}}};const mg=va({localResponseNormalizationBackprop_:function(e,t,n,s=5,r=1,a=1,i=.5){const o={x:e,y:t,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return la.runKernel("LRNGrad",o,l)}}),gg={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>mg(s,r,e,a,i,o,l)}}};function yg(e,t,n,s){return t.rank<n.rank&&(t=vo(t,Il(t.shape,s))),e.rank<n.rank&&(e=vo(e,Il(e.shape,s))),{x:()=>Hi(e,Pi(pl(n,t),e.dtype))}}const bg={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{reductionIndices:r}=s,a=t[0],i=yg(e,t[1],a,w(r,a.shape));return{x:()=>i.x()}}},xg={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>Hi(e,Pi(ql(n,s),"float32")),b:()=>Hi(e,Pi(Ql(n,s),"float32"))}}};const wg=va({maxPool3dGrad_:function(e,t,n,s,r,a,i){const o=ba(e,"dy","maxPool3dGrad"),l=ba(t,"input","maxPool3dGrad"),c=ba(n,"output","maxPool3dGrad");let h=o,p=l,d=c,f=!1;4===l.rank&&(f=!0,h=vo(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),p=vo(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),d=vo(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]])),u(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),u(5===p.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${p.rank}.`)),u(5===d.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${d.rank}.`)),wo("maxPool3dGrad",a,i);const m={dy:h,input:p,output:d},g={filterSize:s,strides:r,pad:a,dimRoundingMode:i},y=la.runKernel("MaxPool3DGrad",m,g);return f?vo(y,[y.shape[1],y.shape[2],y.shape[3],y.shape[4]]):y}}),vg={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=n;return{x:()=>wg(e,s,r,a,i,o,l)}}};const kg=va({maxPoolGrad_:function(e,t,n,s,r,a,i){const o=ba(e,"dy","maxPoolGrad"),l=ba(t,"input","maxPoolGrad"),c=ba(n,"output","maxPoolGrad");u(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),u(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),u(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),wo("maxPoolGrad",a,i);const h={dy:o,input:l,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return la.runKernel("MaxPoolGrad",h,p)}}),Ng={kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o}=n;return{x:()=>kg(e,s,r,a,i,o)}}},Ig={kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>Co(e,a,s.shape)}}},Sg={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>Co(e,a,s.shape)}}},Tg={kernelName:on,inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,s,r]=t,a=n,i=s,o=cl(a.shape,i.shape);return{a:()=>{const t=Pi(i,"float32");let n=Hi(e,Hi(t,Rl(a,mu(t,_l(1)))));const s=ul(a.shape,o);return s.length>0&&(n=Ol(n,s)),vo(n,a.shape)},b:()=>{const t=jl(a,0),n=dl(t,su(a),fl(a));let s=Hi(e,Hi(r,n));const l=ul(i.shape,o);return l.length>0&&(s=Ol(s,l)),vo(s,i.shape)}}}};function Cg(e,t,n){const s=e.shape.length,r=s-n.length,a=Tl(n,s);let i=e;null!=a&&(i=zh(e,a));const o=i.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((e,t)=>e*t),1);o.push(l);let u=function(e,t,n){const s=e.shape.slice();s[n]=1;const r=vo(t,s),a=tl(e,n,!0,!1),i=tl(e,n,!0,!0),o=Hi(a,i);return Hi(r,o)}(i.reshape(o),t,r);if(u=u.reshape(i.shape),null!=a){const e=Cl(a);u=zh(u,e)}return u}const $g={kernelName:"Selu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=jl(n,_l(0)),s=_l(1.7580993408473768),r=_l(Ff),a=Hi(e,r),i=Hi(Hi(e,s),Pl(Pi(n,"float32")));return dl(t,a,i)}}}},Eg={kernelName:"SpaceToBatchND",gradFunc:(e,t,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Ao(e,s,r)}}},Ag={kernelName:"SplitV",gradFunc:(e,t,n)=>{const{axis:s}=n;return{x:()=>Io(e,s)}}};const Rg=[gm,ym,bm,xm,wm,vm,km,Nm,Im,Sm,Tm,Cm,Em,Rm,_m,Fm,Dm,Om,Mm,Lm,zm,Pm,Wm,Bm,Um,Gm,Hm,jm,qm,Km,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{const t=Gi(e,Pi(s,"float32")),a=ul(n.shape,r);return a.length>0?vo(Ol(t,a),n.shape):t},b:()=>{let t=Hi(e,Pi(n,"float32"));const a=ul(s.shape,r);a.length>0&&(t=vo(Ol(t,a),s.shape));const i=Dl(s);return pu(Gi(t,Pi(i,"float32")))}}}},Xm,Ym,Zm,Jm,Qm,tg,eg,ng,sg,ig,og,lg,ug,cg,hg,pg,dg,fg,gg,bg,bg,xg,vg,Ng,{kernelName:"Mean",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n,a=w(r,s.shape),i=p(Nl(s.shape,a)[1]);return{x:()=>{const t=s.shape.slice();a.forEach((e=>{t[e]=1}));const n=vo(e,t);return Gi(Hi(n,Au(s.shape,"float32")),i)}}}},{kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{axis:r}=s,[a,i]=t,o=yg(e,i,a,w(r,a.shape));return{x:()=>o.x()}}},{kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>Hi(e,Pi(eu(n,s),"float32")),b:()=>Hi(e,Pi(jl(n,s),"float32"))}}},Ig,{kernelName:qt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{const t=ul(n.shape,r);return t.length>0?vo(Ol(e,t),n.shape):e},b:()=>{const t=Hi(e,pu(Gl(Gi(n,s)))),a=ul(s.shape,r);return a.length>0?vo(Ol(t,a),s.shape):t}}}},{kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{const t=Hi(e,Pi(s,"float32")),a=ul(n.shape,r);return a.length>0?vo(Ol(t,a),n.shape):t},b:()=>{const t=Hi(e,Pi(n,"float32")),a=ul(s.shape,r);return a.length>0?vo(Ol(t,a),s.shape):t}}}},{kernelName:"Neg",gradFunc:e=>({x:()=>pu(e)})},{kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>Eu(n.shape,"float32")}}},{kernelName:"OnesLike",gradFunc:e=>({x:()=>fl(e)})},{kernelName:"Pack",saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:s}=n;return _h(e,s).map((e=>()=>e))}},Sg,Sg,Tg,{kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,s]=t,r=jl(n,0);return{x:()=>dl(r,e,Hi(e,s)),alpha:()=>{let t=dl(r,fl(e),Hi(e,n));const a=ul(s.shape,e.shape);return a.length>0&&(t=Ol(t,a)),vo(t,s.shape)}}}},{kernelName:"Prod",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;let a=[];return a=null==r?s.shape.map(((e,t)=>t)):"number"==typeof r?[r]:r,{x:()=>Cg(s,e,a)}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,pu(Dl(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=Hi(eu(n,6),fh(n));return{x:()=>Hi(e,Pi(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,Pi(fh(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>la.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>la.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:"Reverse",gradFunc:(e,t,n)=>{const{dims:s}=n,r=w(s,e.shape);return{x:()=>Vc(e,r)}}},{kernelName:"Round",gradFunc:e=>({x:()=>fl(e)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>pu(Gi(e,Hi(Rl(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>Pi(fl(n),"float32"),t:()=>Hi(e,Pi(n,e.dtype)),e:()=>Hi(e,Pi(xu(n),e.dtype))}}},$g,{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,Hi(n,mu(_l(1),n)))}}},{kernelName:"Sign",gradFunc:e=>({x:()=>fl(e)})},{kernelName:_n,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(Qo(Pi(n,"float32")),e)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(el(Pi(n,"float32")),e)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{begin:r,size:a}=n,i=s.shape,[o,l]=cf(s,r,a),u=[];for(let t=0;t<e.rank;t++)u.push([o[t],i[t]-o[t]-l[t]]);return{x:()=>Vu(e,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{dim:r}=n,a=Hi(e,s);return{logits:()=>mu(a,Hi(Ol(a,[r],true),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,To(n))}}},Eg,Eg,Ag,Ag,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Hi(Fl(Pi(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_l(2);return{a:()=>Hi(e,Hi(r,mu(n,s))),b:()=>Hi(e,Hi(r,mu(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(e,Hi(Pi(n,"float32"),2))}}},{kernelName:"Step",gradFunc:e=>({x:()=>fl(e)})},{kernelName:es,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=cl(n.shape,s.shape);return{a:()=>{let t=e;const s=ul(n.shape,r);return s.length>0&&(t=Ol(t,s)),vo(t,n.shape)},b:()=>{let t=e;const n=ul(s.shape,r);return n.length>0&&(t=Ol(t,n)),vo(pu(t),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,r=s.shape.slice(),{axis:a}=n;w(a,s.shape).forEach((e=>{r[e]=1}));const i=vo(e,r),o=Hi(i,Au(s.shape,"float32"));return{x:()=>o}}},{kernelName:ts,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Gi(e,Dl(Qo(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Hi(mu(_l(1),Dl(n)),e)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{reps:r}=n;return{x:()=>{let t=fl(s);if(1===s.rank)for(let n=0;n<r[0];++n)t=Vi(t,Co(e,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)t=Vi(t,Co(e,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)t=Vi(t,Co(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)t=Vi(t,Co(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return t}}}},{kernelName:"Transpose",gradFunc:(e,t,n)=>{const s=n,{perm:r}=s,a=Cl(r);return{x:()=>zh(e,a)}}},{kernelName:"Unpack",gradFunc:(e,t,n)=>{const s=n,{axis:r}=s;return{value:()=>dh(e,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=Cu(t,fl(t)),s=Hl(e,n);let r=ql(t,_l(0,"int32"));const a=s.rank-r.rank;for(let e=0;e<a;++e)r=Bl(r,e+1);r=bu(r,Au(s.shape,"bool"));const i=fl(s);return dl(r,s,i)}(e,n)}}},{kernelName:"ZerosLike",gradFunc:e=>({x:()=>fl(e)})}];for(const e of Rg)Ss(e);Br().prototype.abs=function(){return this.throwIfDisposed(),ji(this)},Br().prototype.acos=function(){return this.throwIfDisposed(),qi(this)},Br().prototype.acosh=function(){return this.throwIfDisposed(),Ki(this)},Br().prototype.add=function(e){return this.throwIfDisposed(),Vi(this,e)},Br().prototype.all=function(e,t){return this.throwIfDisposed(),Yi(this,e,t)},Br().prototype.any=function(e,t){return this.throwIfDisposed(),Zi(this,e,t)},Br().prototype.argMax=function(e){return this.throwIfDisposed(),Ji(this,e)},Br().prototype.argMin=function(e){return this.throwIfDisposed(),Qi(this,e)},Br().prototype.asScalar=function(){return this.throwIfDisposed(),u(1===this.size,(()=>"The array must have only 1 element.")),vo(this,[])},Br().prototype.asType=function(e){return this.throwIfDisposed(),Pi(this,e)},Br().prototype.as1D=function(){return this.throwIfDisposed(),vo(this,[this.size])},Br().prototype.as2D=function(e,t){return this.throwIfDisposed(),vo(this,[e,t])},Br().prototype.as3D=function(e,t,n){return this.throwIfDisposed(),vo(this,[e,t,n])},Br().prototype.as4D=function(e,t,n,s){return this.throwIfDisposed(),vo(this,[e,t,n,s])},Br().prototype.as5D=function(e,t,n,s,r){return this.throwIfDisposed(),vo(this,[e,t,n,s,r])},Br().prototype.asin=function(){return this.throwIfDisposed(),eo(this)},Br().prototype.asinh=function(){return this.throwIfDisposed(),to(this)},Br().prototype.atan=function(){return this.throwIfDisposed(),no(this)},Br().prototype.atan2=function(e){return this.throwIfDisposed(),so(this,e)},Br().prototype.atanh=function(){return this.throwIfDisposed(),ro(this)},Br().prototype.avgPool=function(e,t,n,s){return this.throwIfDisposed(),ko(this,e,t,n,s)},Br().prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),Ao(this,e,t)},Br().prototype.batchNorm=function(e,t,n,s,r){return this.throwIfDisposed(),Ro(this,e,t,n,s,r)},Br().prototype.broadcastTo=function(e){return this.throwIfDisposed(),zo(this,e)},Br().prototype.cast=function(e){return this.throwIfDisposed(),Pi(this,e)},Br().prototype.ceil=function(){return this.throwIfDisposed(),Po(this)},Br().prototype.clipByValue=function(e,t){return this.throwIfDisposed(),Wo(this,e,t)},Br().prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof Pr&&(e=[e]),Io([this,...e],t)},Br().prototype.conv1d=function(e,t,n,s,r,a){return this.throwIfDisposed(),qo(this,e,t,n,s,r,a)},Br().prototype.conv2dTranspose=function(e,t,n,s,r){return this.throwIfDisposed(),Xo(this,e,t,n,s,r)},Br().prototype.conv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),jo(this,e,t,n,s,r,a)},Br().prototype.cos=function(){return this.throwIfDisposed(),Qo(this)},Br().prototype.cosh=function(){return this.throwIfDisposed(),el(this)},Br().prototype.cumprod=function(e,t,n){return this.throwIfDisposed(),tl(this,e,t,n)},Br().prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),nl(this,e,t,n)},Br().prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),rl(this,e,t)},Br().prototype.depthwiseConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),al(this,e,t,n,s,r,a)},Br().prototype.dilation2d=function(e,t,n,s,r){return this.throwIfDisposed(),ol(this,e,t,n,s,r)},Br().prototype.divNoNan=function(e){return this.throwIfDisposed(),ml(this,e)},Br().prototype.div=function(e){return this.throwIfDisposed(),Gi(this,e)},Br().prototype.dot=function(e){return this.throwIfDisposed(),gl(this,e)},Br().prototype.elu=function(){return this.throwIfDisposed(),bl(this)},Br().prototype.equal=function(e){return this.throwIfDisposed(),pl(this,e)},Br().prototype.erf=function(){return this.throwIfDisposed(),wl(this)},Br().prototype.euclideanNorm=function(e,t){return this.throwIfDisposed(),zl(this,e,t)},Br().prototype.exp=function(){return this.throwIfDisposed(),Pl(this)},Br().prototype.expandDims=function(e){return this.throwIfDisposed(),Bl(this,e)},Br().prototype.expm1=function(){return this.throwIfDisposed(),Wl(this)},Br().prototype.fft=function(){return this.throwIfDisposed(),ih(this)},Br().prototype.flatten=function(){return this.throwIfDisposed(),vo(this,[this.size])},Br().prototype.floor=function(){return this.throwIfDisposed(),Gl(this)},Br().prototype.floorDiv=function(e){return this.throwIfDisposed(),Ui(this,e)},Br().prototype.gather=function(e,t,n){return this.throwIfDisposed(),Hl(this,e,t,n)},Br().prototype.greaterEqual=function(e){return this.throwIfDisposed(),ql(this,e)},Br().prototype.greater=function(e){return this.throwIfDisposed(),jl(this,e)},Br().prototype.ifft=function(){return this.throwIfDisposed(),oh(this)},Br().prototype.irfft=function(){return this.throwIfDisposed(),lh(this)},Br().prototype.isFinite=function(){return this.throwIfDisposed(),Xl(this)},Br().prototype.isInf=function(){return this.throwIfDisposed(),Yl(this)},Br().prototype.isNaN=function(){return this.throwIfDisposed(),Zl(this)},Br().prototype.leakyRelu=function(e){return this.throwIfDisposed(),Jl(this,e)},Br().prototype.lessEqual=function(e){return this.throwIfDisposed(),eu(this,e)},Br().prototype.less=function(e){return this.throwIfDisposed(),Ql(this,e)},Br().prototype.localResponseNormalization=function(e,t,n,s){return this.throwIfDisposed(),nu(this,e,t,n,s)},Br().prototype.logSigmoid=function(){return this.throwIfDisposed(),fu(this)},Br().prototype.logSoftmax=function(e){return this.throwIfDisposed(),gu(this,e)},Br().prototype.logSumExp=function(e,t){return this.throwIfDisposed(),yu(this,e,t)},Br().prototype.log=function(){return this.throwIfDisposed(),su(this)},Br().prototype.log1p=function(){return this.throwIfDisposed(),ru(this)},Br().prototype.logicalAnd=function(e){return this.throwIfDisposed(),bu(this,e)},Br().prototype.logicalNot=function(){return this.throwIfDisposed(),xu(this)},Br().prototype.logicalOr=function(e){return this.throwIfDisposed(),wu(this,e)},Br().prototype.logicalXor=function(e){return this.throwIfDisposed(),vu(this,e)},Br().prototype.matMul=function(e,t,n){return this.throwIfDisposed(),So(this,e,t,n)},Br().prototype.maxPool=function(e,t,n,s){return this.throwIfDisposed(),Iu(this,e,t,n,s)},Br().prototype.max=function(e,t){return this.throwIfDisposed(),El(this,e,t)},Br().prototype.maximum=function(e){return this.throwIfDisposed(),Cu(this,e)},Br().prototype.mean=function(e,t){return this.throwIfDisposed(),$u(this,e,t)},Br().prototype.min=function(e,t){return this.throwIfDisposed(),Al(this,e,t)},Br().prototype.minimum=function(e){return this.throwIfDisposed(),_u(this,e)},Br().prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),Fu(this,e,t)},Br().prototype.mod=function(e){return this.throwIfDisposed(),Du(this,e)},Br().prototype.mul=function(e){return this.throwIfDisposed(),Hi(this,e)},Br().prototype.neg=function(){return this.throwIfDisposed(),pu(this)},Br().prototype.norm=function(e,t,n){return this.throwIfDisposed(),Ll(this,e,t,n)},Br().prototype.notEqual=function(e){return this.throwIfDisposed(),zu(this,e)},Br().prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),Pu(this,e,t,n)},Br().prototype.onesLike=function(){return this.throwIfDisposed(),Bu(this)},Br().prototype.pad=function(e,t){return this.throwIfDisposed(),Vu(this,e,t)},Br().prototype.pool=function(e,t,n,s,r,a){return this.throwIfDisposed(),Ku(this,e,t,n,s,r,a)},Br().prototype.pow=function(e){return this.throwIfDisposed(),Rl(this,e)},Br().prototype.prelu=function(e){return this.throwIfDisposed(),Xu(this,e)},Br().prototype.prod=function(e,t){return this.throwIfDisposed(),Yu(this,e,t)},Br().prototype.reciprocal=function(){return this.throwIfDisposed(),Pc(this)},Br().prototype.relu=function(){return this.throwIfDisposed(),Bc(this)},Br().prototype.relu6=function(){return this.throwIfDisposed(),Wc(this)},Br().prototype.reshapeAs=function(e){return this.throwIfDisposed(),vo(this,e.shape)},Br().prototype.reshape=function(e){return this.throwIfDisposed(),vo(this,e)},Br().prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),Ep(this,e,t,n)},Br().prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),Ap(this,e,t,n)},Br().prototype.reverse=function(e){return this.throwIfDisposed(),Vc(this,e)},Br().prototype.rfft=function(){return this.throwIfDisposed(),ch(this)},Br().prototype.round=function(){return this.throwIfDisposed(),qc(this)},Br().prototype.rsqrt=function(){return this.throwIfDisposed(),Kc(this)},Br().prototype.selu=function(){return this.throwIfDisposed(),Xc(this)},Br().prototype.separableConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Yc(this,e,t,n,s,r,a)},Br().prototype.sigmoid=function(){return this.throwIfDisposed(),To(this)},Br().prototype.sign=function(){return this.throwIfDisposed(),Jc(this)},Br().prototype.sin=function(){return this.throwIfDisposed(),Qc(this)},Br().prototype.sinh=function(){return this.throwIfDisposed(),eh(this)},Br().prototype.slice=function(e,t){return this.throwIfDisposed(),Co(this,e,t)},Br().prototype.softmax=function(e){return this.throwIfDisposed(),ah(this,e)},Br().prototype.softplus=function(){return this.throwIfDisposed(),du(this)},Br().prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),qu(this,e,t)},Br().prototype.split=function(e,t){return this.throwIfDisposed(),uh(this,e,t)},Br().prototype.sqrt=function(){return this.throwIfDisposed(),Fl(this)},Br().prototype.square=function(){return this.throwIfDisposed(),Dl(this)},Br().prototype.squaredDifference=function(e){return this.throwIfDisposed(),hh(this,e)},Br().prototype.squeeze=function(e){return this.throwIfDisposed(),ph(this,e)},Br().prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof Pr?[this,e]:[this,...e];return dh(n,t)},Br().prototype.step=function(e){return this.throwIfDisposed(),fh(this,e)},Br().prototype.stridedSlice=function(e,t,n,s,r,a,i,o){return this.throwIfDisposed(),mh(this,e,t,n,s,r,a,i,o)},Br().prototype.sub=function(e){return this.throwIfDisposed(),mu(this,e)},Br().prototype.sum=function(e,t){return this.throwIfDisposed(),Ol(this,e,t)},Br().prototype.tan=function(){return this.throwIfDisposed(),gh(this)},Br().prototype.tanh=function(){return this.throwIfDisposed(),$o(this)},Br().prototype.tile=function(e){return this.throwIfDisposed(),Vl(this,e)},Br().prototype.toBool=function(){return this.throwIfDisposed(),Pi(this,"bool")},Br().prototype.toFloat=function(){return this.throwIfDisposed(),Pi(this,"float32")},Br().prototype.toInt=function(){return this.throwIfDisposed(),Pi(this,"int32")},Br().prototype.topk=function(e,t){return this.throwIfDisposed(),$h(this,e,t)},Br().prototype.transpose=function(e){return this.throwIfDisposed(),zh(this,e)},Br().prototype.unique=function(e){return this.throwIfDisposed(),Ah(this,e)},Br().prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),Rh(this,e,t)},Br().prototype.unstack=function(e){return this.throwIfDisposed(),_h(this,e)},Br().prototype.where=function(e,t){return this.throwIfDisposed(),dl(e,this,t)},Br().prototype.zerosLike=function(){return this.throwIfDisposed(),fl(this)};class _g extends Error{constructor(e){super(e),Object.setPrototypeOf(this,_g.prototype)}}class Fg extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Fg.prototype)}}class Dg extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Dg.prototype)}}class Og extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Og.prototype)}}class Mg extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Mg.prototype)}}Error;class Lg{constructor(e){this.maxEntries=e||100,this.cache=new Map}get(e){let t;return this.cache.has(e)&&(t=this.cache.get(e),this.cache.delete(e),this.cache.set(e,t)),t}put(e,t){if(this.cache.has(e))this.cache.delete(e);else if(this.cache.size>=this.maxEntries){const e=this.cache.keys().next().value;this.cache.delete(e)}this.cache.set(e,t)}getMaxEntries(){return this.maxEntries}setMaxEntries(e){if(e<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${e}.`);if(this.maxEntries>e)for(let t=0;t<this.maxEntries-e;t++){const e=this.cache.keys().next().value;this.cache.delete(e)}this.maxEntries=e}}function zg(e,t){if(Array.isArray(e)){let n=[];for(let s=0;s<t;s++)n=n.concat(e);return n}{const n=new Array(t);return n.fill(e),n}}function Pg(e,t){if(!e)throw new Mg(t)}function Bg(e,t){let n=0;for(const s of e)s===t&&n++;return n}function Wg(e){return 1===e.length?e[0]:e}function Vg(e){return Array.isArray(e)?e:[e]}function Ug(e){const t=e.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==t[0]?t:"private"+t}function Gg(e){return e.length<=1||-1===e.indexOf("_")?e:e.replace(/[_]+(\w|$)/g,((e,t)=>t.toUpperCase()))}let Hg={};function jg(e){if(null==e)return null;const t={};return t.className=e.getClassName(),t.config=e.getConfig(),t}function qg(e){if(null!=e&&"object"==typeof e)if(Array.isArray(e))e.forEach((e=>qg(e)));else{const t=Object.keys(e);for(const n of t){const t=e[n];null!=t&&"object"==typeof t&&(Array.isArray(t)||"ndarray"!==t.type||"number"!=typeof t.value?qg(t):e[n]=t.value)}}}function Kg(e,t={},n={},s="object",r=!1){if("string"==typeof e){const r=e;let a;if(r in n)a=n[r];else if(r in Hg)a=Hg[r];else if(a=t[r],null==a)throw new Dg(`Unknown ${s}: ${e}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=e;if(null==a.className||null==a.config)throw new Dg(`${s}: Improper config format: ${JSON.stringify(a)}.\n'className' and 'config' must set.`);const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in Hg?[o,l]=Hg.className:i in t&&([o,l]=t[i]),null==o)throw new Dg(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const e={};for(const t of Object.keys(Hg))e[t]=Hg[t];for(const t of Object.keys(n))e[t]=n[t];a.config.customObjects=e;const t=Object.assign({},Hg);for(const e of Object.keys(n))Hg[e]=n[e];qg(a.config);const s=l(o,a.config,n,r);return Hg=Object.assign({},t),s}{const e=Object.assign({},Hg);for(const e of Object.keys(n))Hg[e]=n[e];const t=new o(a.config);return Hg=Object.assign({},e),t}}}function Xg(e,t){return-1*function(e,t){return e<t?-1:e>t?1:0}(e,t)}function Yg(e){if(null==e)return e;const t=[];for(const n of e)-1===t.indexOf(n)&&t.push(n);return t}function Zg(e){if(null==e)throw new Dg(`Invalid value in obj: ${JSON.stringify(e)}`);for(const t in e)if(e.hasOwnProperty(t))return!1;return!0}function Jg(e,t,n){if(null!=n&&e.indexOf(n)<0)throw new Dg(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`)}function Qg(e,t,n=0,s=1/0){return Pg(n>=0),Pg(s>=n),Array.isArray(e)&&e.length>=n&&e.length<=s&&e.every((e=>typeof e===t))}function ey(e,t){Array.isArray(e)?(u(e.length>0,(()=>`${t} is unexpectedly an empty array.`)),e.forEach(((e,n)=>ey(e,`element ${n+1} of ${t}`)))):u(Number.isInteger(e)&&e>0,(()=>`Expected ${t} to be a positive integer, but got ${ty(e)}.`))}function ty(e){return null===e?"null":Array.isArray(e)?"["+e.map((e=>ty(e))).join(",")+"]":"string"==typeof e?`"${e}"`:`${e}`}function ny(e){return"relu"===e?"relu":"linear"===e?"linear":"elu"===e?"elu":null}let sy=0;function ry(){return sy++}const ay={};function iy(e=""){return e in ay||(ay[e]=0),ay[e]+=1,e+ay[e].toString()}const oy=["channelsFirst","channelsLast"],ly=["nearest","bilinear"],uy=["valid","same","causal"],cy=["max","avg"],hy=["sum","mul","concat","ave"],py=new Map;function dy(e){Jg(oy,"DataFormat",e)}function fy(e){Jg(uy,"PaddingMode",e)}function my(e){Jg(cy,"PoolMode",e)}const gy=[];function yy(e,t){gy.push(e);try{const e=t();return gy.pop(),e}catch(e){throw gy.pop(),e}}function by(e){if(!vy(e))throw new Error("Not a valid tensor name: '"+e+"'");return(0===gy.length?"":gy.join("/")+"/")+e}function xy(e){if(!vy(e))throw new Error("Not a valid tensor name: '"+e+"'");py.has(e)||py.set(e,0);const t=py.get(e);if(py.set(e,py.get(e)+1),t>0){const n=`${e}_${t}`;return py.set(n,1),n}return e}const wy=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function vy(e){return!!e.match(wy)}function ky(e,t,n){null==t&&(t=0),null==n&&(n=e.length);let s=1;for(let r=t;r<n;++r)s*=e[r];return s}function Ny(e){if(0===e.length)return Number.NaN;let t=Number.POSITIVE_INFINITY;for(let n=0;n<e.length;n++){const s=e[n];s<t&&(t=s)}return t}function Iy(e){if(0===e.length)return Number.NaN;let t=Number.NEGATIVE_INFINITY;for(let n=0;n<e.length;n++){const s=e[n];s>t&&(t=s)}return t}function Sy(e,t){if(t<e)throw new Dg(`end (${t}) < begin (${e}) is forbidden.`);const n=[];for(let s=e;s<t;++s)n.push(s);return n}let Ty;function Cy(){return null==Ty&&(Ty=ja().epsilon()),Ty}function $y(e,t){return Pi(e,t)}function Ey(e,t=-1){const n=e.shape.slice();return t<0&&(t=n.length+t+1),n.splice(t,0,1),vo(e,n)}function Ay(e,t,n){return Oa((()=>{switch(e.rank){case 1:return th(e,t,n);case 2:return nh(e,[t,0],[n,e.shape[1]]);case 3:return sh(e,[t,0,0],[n,e.shape[1],e.shape[2]]);case 4:return rh(e,[t,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3]]);case 5:return Co(e,[t,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return Co(e,[t,0,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new Dg(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Ry(e,t,n){return Oa((()=>{switch(e.rank){case 1:return th(e,t,n);case 2:return nh(e,[0,t],[e.shape[0],n]);case 3:return sh(e,[0,0,t],[e.shape[0],e.shape[1],n]);case 4:return rh(e,[0,0,0,t],[e.shape[0],e.shape[1],e.shape[2],n]);default:throw new Dg(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function _y(e,t,n,s){return Oa((()=>{switch(e.rank){case 1:return th(e,t,n);case 2:switch(s){case 1:return Ay(e,t,n);case 2:return Ry(e,t,n);default:throw new Dg(`The axis is not within the rank of the tensor ${s}`)}case 3:switch(s){case 1:return Ay(e,t,n);case 2:return sh(e,[0,t,0],[e.shape[0],n,e.shape[2]]);case 3:return Ry(e,t,n);default:throw new Dg(`The axis is not within the rank of the tensor ${s}`)}case 4:switch(s){case 1:return Ay(e,t,n);case 2:return rh(e,[0,t,0,0],[e.shape[0],n,e.shape[2],e.shape[3]]);case 3:return rh(e,[0,0,t,0],[e.shape[0],e.shape[1],n,e.shape[3]]);case 4:return Ry(e,t,n);default:throw new Dg(`The axis is not within the rank of the tensor ${s}`)}default:throw new Dg(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Fy(e,t=-1){let n;return t<0&&(n=e[0].rank,t=0!==n?n:0),t===e[0].rank&&(t=-1),Io(e,t)}function Dy(e,t){switch(e.rank){case 1:return Vo([e,t]);case 2:return Uo([e,t],0);case 3:return Go([e,t],0);case 4:return Ho([e,t],0);default:throw new Dg(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}function Oy(e,t){if(Array.isArray(t)||(t=[t]),e.rank!==t.length)throw new Dg(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);return Vl(e,t)}function My(e,t=0,n=1,s,r){return Fc(e,t,n,s,r)}function Ly(e,t,n,s){if(e.rank<2||t.rank<2)throw new Og(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);if(t.rank>=3){if(e.shape.slice(-1)[0]!==t.shape.slice(-2)[0])throw new Og(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${t.shape}`)}if(2===e.rank&&2===t.rank){return np({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?By(e.rank,s,"channelsLast"):null,activation:n})}{const r=e.shape.slice(),a=r.pop();e=vo(e,[-1,a]);const i=t.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:t.rank},((e,n)=>0===n?t.rank-2:n<=t.rank-2?n-1:n));t=vo(zh(t,c),[l,-1]);const h=[...r,...u];return vo(np({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?By(e.rank,s,"channelsLast"):null,activation:n}),h)}}function zy(e,t,n){return Oa((()=>(t=Array.isArray(t)?yh(t,"int32"):Pi(t,"int32"),Hl(e,t,n))))}function Py(e){return Hi(e,e)}function By(e,t,n){const s=t.shape;if(1!==t.rank&&t.rank!==e)throw new Dg(`Unexpected bias dimensions: ${t.rank}; expected it to be 1 or ${e}`);if(5===e){if("channelsFirst"===n)return 1===s.length?vo(t,[1,s[0],1,1,1]):vo(t,[1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?vo(t,[1,1,1,1,s[0]]):vo(t,[1].concat(s))}else if(4===e){if("channelsFirst"===n)return 1===s.length?vo(t,[1,s[0],1,1]):vo(t,[1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?vo(t,[1,1,1,s[0]]):vo(t,[1].concat(s))}else if(3===e){if("channelsFirst"===n)return 1===s.length?vo(t,[1,s[0],1]):vo(t,[1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?vo(t,[1,1,s[0]]):vo(t,[1].concat(s))}else if(e<3)return t;throw new Dg(`Unsupported input rank by biasAdd: ${t.rank}`)}function Wy(e,t,n){return Oa((()=>(null==n&&(n="channelsLast"),dy(n),Vi(e,By(e.rank,t,n)))))}function Vy(e,t,n,s){return Oa((()=>Uh(e,t,n,s)))}function Uy(e,t,n=!1){return n?e():t()}const Gy=["fanIn","fanOut","fanAvg"],Hy=["normal","uniform","truncatedNormal"];class jy extends cd{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class qy extends jy{apply(e,t){return Eu(e,t)}}qy.className="Zeros",pd(qy);class Ky extends jy{apply(e,t){return Au(e,t)}}Ky.className="Ones",pd(Ky);class Xy extends jy{constructor(e){if(super(),"object"!=typeof e)throw new Dg(`Expected argument of type ConstantConfig but got ${e}`);if(void 0===e.value)throw new Dg(`config must have value set but got ${e}`);this.value=e.value}apply(e,t){return Oa((()=>Hi(_l(this.value),Au(e,t))))}getConfig(){return{value:this.value}}}Xy.className="Constant",pd(Xy);class Yy extends jy{constructor(e){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=e.minval||this.DEFAULT_MINVAL,this.maxval=e.maxval||this.DEFAULT_MAXVAL,this.seed=e.seed}apply(e,t){return Oc(e,this.minval,this.maxval,t,this.seed)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}Yy.className="RandomUniform",pd(Yy);class Zy extends jy{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Og(`randomNormal does not support dType ${t}.`);return My(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Zy.className="RandomNormal",pd(Zy);class Jy extends jy{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Og(`truncatedNormal does not support dType ${t}.`);return Eh(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Jy.className="TruncatedNormal",pd(Jy);class Qy extends jy{constructor(e){super(),this.gain=null!=e.gain?e.gain:1}apply(e,t){return Oa((()=>{if(2!==e.length||e[0]!==e[1])throw new Dg("Identity matrix initializer can only be used for 2D square matrices.");return Hi(this.gain,Ul(e[0]))}))}getConfig(){return{gain:this.gain}}}Qy.className="Identity",pd(Qy);class eb extends jy{constructor(e){if(super(),e.scale<0)throw new Dg(`scale must be a positive float. Got: ${e.scale}`);var t;this.scale=null==e.scale?1:e.scale,this.mode=null==e.mode?"fanIn":e.mode,t=this.mode,Jg(Gy,"FanMode",t),this.distribution=null==e.distribution?"normal":e.distribution,function(e){Jg(Hy,"Distribution",e)}(this.distribution),this.seed=e.seed}apply(e,t){const n=function(e,t="channelsLast"){let n,s;if(dy(t),2===e.length)n=e[0],s=e[1];else if(-1!==[3,4,5].indexOf(e.length)){if("channelsFirst"===t){const t=ky(e,2);n=e[1]*t,s=e[0]*t}else if("channelsLast"===t){const t=ky(e,0,e.length-2);n=e[e.length-2]*t,s=e[e.length-1]*t}}else{const t=ky(e);n=Math.sqrt(t),s=Math.sqrt(t)}return[n,s]}(e),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Og(`${this.getClassName()} does not support dType ${t}.`);return Eh(e,0,n,t,this.seed)}{const n=Math.sqrt(3*a);return Oc(e,-n,n,t,this.seed)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}eb.className="VarianceScaling",pd(eb);class tb extends eb{constructor(e){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return eb.className}}tb.className="GlorotUniform",pd(tb);class nb extends eb{constructor(e){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return eb.className}}nb.className="GlorotNormal",pd(nb);class sb extends eb{constructor(e){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return eb.className}}sb.className="HeNormal",pd(sb);class rb extends eb{constructor(e){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return eb.className}}rb.className="HeUniform",pd(rb);class ab extends eb{constructor(e){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return eb.className}}ab.className="LeCunNormal",pd(ab);class ib extends eb{constructor(e){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return eb.className}}ib.className="LeCunUniform",pd(ib);class ob extends jy{constructor(e){super(),this.DEFAULT_GAIN=1,this.ELEMENTS_WARN_SLOW=2e3,this.gain=null==e.gain?this.DEFAULT_GAIN:e.gain,this.seed=e.seed}apply(e,t){return Oa((()=>{if(e.length<2)throw new Og("Shape must be at least 2D.");if("int32"!==t&&"float32"!==t&&void 0!==t)throw new TypeError(`Unsupported data type ${t}.`);const n=p(e.slice(0,-1)),s=e[e.length-1],r=n*s;r>this.ELEMENTS_WARN_SLOW&&console.warn(`Orthogonal initializer is being called on a matrix with more than ${this.ELEMENTS_WARN_SLOW} (${r}) elements: Slowness may result.`);const a=My([Math.max(s,n),Math.min(s,n)],0,1,t,this.seed),i=rd.qr(a,!1);let o=i[0];const l=i[1].flatten().stridedSlice([0],[Math.min(s,n)*Math.min(s,n)],[Math.min(s,n)+1]);return o=Hi(o,l.sign()),n<s&&(o=o.transpose()),Hi(_l(this.gain),o.reshape(e))}))}getConfig(){return{gain:this.gain,seed:this.seed}}}ob.className="Orthogonal",pd(ob);const lb={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function ub(e,t={}){return Kg(e,hd.getMap().classNameMap,t,"initializer")}function cb(e){return jg(e)}function hb(e){if("string"==typeof e){const t=e in lb?lb[e]:e;if("GlorotNormal"===t)return new nb;if("GlorotUniform"===t)return new tb;if("HeNormal"===t)return new sb;if("HeUniform"===t)return new rb;if("LeCunNormal"===t)return new ab;if("LeCunUniform"===t)return new ib;{const e={};return e.className=t,e.config={},ub(e)}}return e instanceof jy?e:ub(e)}function pb(e){return Array.isArray(e)&&Array.isArray(e[0])}function db(e){return 0===e.length?[]:Array.isArray(e[0])?e:[e]}function fb(e){let t;if(Array.isArray(e)){if(1!==e.length)throw new Dg(`Expected Tensor length to be 1; got ${e.length}`);t=e[0]}else t=e;return t}function mb(e){if(Array.isArray(e)&&Array.isArray(e[0])){if(1===e.length)return e[0];throw new Dg(`Expected exactly 1 Shape; got ${e.length}`)}return e}function gb(e){let t=0;for(const n of e)0===n.shape.length?t+=1:t+=n.shape.reduce(((e,t)=>e*t));return t}class yb{constructor(e,t="float32",n="Variable",s=!0,r=null){this.dtype=null==t?"float32":t,this.shape=e.shape,this.id=ry(),n=null==n?"Variable":n,this.originalName=by(n),this.name=xy(this.originalName),this.trainable_=s,this.constraint=r,this.val=Dh(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(e){return this.assertNotDisposed(),function(e,t){if(e.shape.toString()!==t.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(e.shape)+" vs. "+JSON.stringify(t.shape))}(this.val,e),this.val.id!==e.id&&(this.val.assign(e),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(e){this.trainable_=e,this.val.trainable=e}}function bb(e){return e.map((e=>e.read()))}function xb(e){e.forEach((e=>{e[0].write(e[1])}))}class wb{constructor(e){this.dtype=e.dtype,this.shape=e.shape,null!=e.shape?this.ndim=e.shape.length:this.ndim=e.ndim,this.maxNDim=e.maxNDim,this.minNDim=e.minNDim,this.axes=e.axes||{}}}class vb{constructor(e,t,n,s,r,a,i){this.dtype=e,this.shape=t,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=ry(),null!=a&&(this.originalName=by(a),this.name=xy(this.originalName)),this.rank=t.length}}let kb=0;class Nb{constructor(e,t){this.callArgs=t,this.id=kb++,this.outboundLayer=e.outboundLayer,this.inboundLayers=e.inboundLayers,this.nodeIndices=e.nodeIndices,this.tensorIndices=e.tensorIndices,this.inputTensors=e.inputTensors,this.outputTensors=e.outputTensors,this.inputMasks=e.inputMasks,this.outputMasks=e.outputMasks,this.inputShapes=e.inputShapes,this.outputShapes=e.outputShapes;for(const t of e.inboundLayers)null!=t&&t.outboundNodes.push(this);e.outboundLayer.inboundNodes.push(this)}getConfig(){const e=[];for(const t of this.inboundLayers)null!=t?e.push(t.name):e.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:e,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Ib=0;class Sb extends cd{constructor(e={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Ib++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let t=e.name;if(!t){const e=this.getClassName();t=Ug(e)+"_"+iy(e)}if(this.name=t,this.trainable_=null==e.trainable||e.trainable,null!=e.inputShape||null!=e.batchInputShape){let t;if(null!=e.batchInputShape)t=e.batchInputShape;else if(null!=e.inputShape){let n=null;null!=e.batchSize&&(n=e.batchSize),t=[n].concat(e.inputShape)}this.batchInputShape=t;let n=e.dtype;null==n&&(n=e.inputDType),null==n&&(n="float32"),this.dtype=n}null!=e.weights?this.initialWeights=e.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(e,t){return e.name+"_ib-"+t.toString()}getNodeAtIndex(e,t){if(0===this.inboundNodes.length)throw new Fg(`The layer has never been called and thus has no defined ${t}.`);if(this.inboundNodes.length<=e)throw new Dg(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[e]}getInputAt(e){return Wg(this.getNodeAtIndex(e,"input").inputTensors)}getOutputAt(e){return Wg(this.getNodeAtIndex(e,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new _g(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new _g(`Layer ${this.name} is not connected, no input to return.`);return Wg(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new _g(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new _g(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return Wg(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((e=>e()))}get updates(){return this._updates}get built(){return this._built}set built(e){this._built=e}get trainable(){return this.trainable_}set trainable(e){this._trainableWeights.forEach((t=>t.trainable=e)),this.trainable_=e}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((e=>e.trainable)):[]}set trainableWeights(e){this._trainableWeights=e}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((e=>!e.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(e){this._nonTrainableWeights=e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(e){const t=Vg(e);if(null==this.inputSpec||0===this.inputSpec.length)return;const n=Vg(this.inputSpec);if(t.length!==n.length)throw new Dg(`Layer ${this.name} expects ${n.length} inputs, but it received ${t.length} input tensors. Input received: ${e}`);for(let e=0;e<t.length;e++){const s=t[e],r=n[e];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new Dg(`Input ${e} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new Dg(`Input ${e} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new Dg(`Input ${e} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Dg(`Input ${e} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const n in r.axes){const s=Number(n),a=r.axes[n],i=s>=0?t[s]:t[t.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new Dg(`Input ${e} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const n=r.shape[t],a=s.shape[t];if(null!=n&&null!=a&&n!==a)throw new Dg(`Input ${e} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(e,t){return e}invokeCallHook(e,t){null!=this._callHook&&this._callHook(e,t)}setCallHook(e){this._callHook=e}clearCallHook(){this._callHook=null}apply(e,t){t=t||{},this.assertNotDisposed();const n=Vg(e),s=function(e){let t=!0;for(const n of Vg(e))if(!(n instanceof vb)){t=!1;break}return t}(e),r=function(e){let t=!0;for(const n of Vg(e))if(n instanceof vb){t=!1;break}return t}(e);if(s===r)throw new Dg("Arguments to apply() must be all SymbolicTensors or all Tensors");return yy(this.name,(()=>{if(!this.built){this.assertInputCompatibility(e);const t=[];for(const n of Vg(e))t.push(n.shape);this.build(Wg(t)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(e),r){let s=this.call(e,t);this.supportsMasking&&this.setMaskMetadata(e,s);const r=Vg(s),a=[];for(let e of r)-1!==n.indexOf(e)&&(e=e.clone()),a.push(e);if(s=Wg(a),null!=this.activityRegularizer)throw new Og("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(e){e=Vg(e);const t=[];for(const n of e)t.push(n.shape);return Wg(t)}(e),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(e)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new vb(a,n,this,Vg(e),t,this.name,s))):new vb(a,s,this,Vg(e),t,this.name),this.addInboundNode(e,r,null,null,n,s,t),this._refCount++,null!=this.activityRegularizer)throw new Og("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(e){if(null!=this.batchInputShape)if(e.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(e)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let t=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=e[s]&&e[s]!==n&&(t=!0)})),t&&console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new _g(`The layer ${this.name} has never been called and thus has no defined output shape.`);const e=[];for(const t of this.inboundNodes){const n=JSON.stringify(t.outputShapes);-1===e.indexOf(n)&&e.push(n)}if(1===e.length){const e=this.inboundNodes[0].outputShapes;return Array.isArray(e)&&Array.isArray(e[0])&&1===e.length?e[0]:e}throw new _g(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new Fg(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return gb(this.weights)}build(e){this.built=!0}getWeights(e=!1){return bb(e?this.trainableWeights:this.weights)}setWeights(e){Oa((()=>{const t=this.weights;if(t.length!==e.length)throw new Dg(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);if(0===t.length)return;const n=[],s=bb(t);for(let r=0;r<s.length;++r){const a=s[r],i=t[r],o=e[r];if(!f(a.shape,o.shape))throw new Dg(`Layer weight shape ${a.shape} not compatible with provided weight shape ${o.shape}`);n.push([i,o])}xb(n)}))}addWeight(e,t,n,s,r,a,i,o){if(-1!==this._addedWeightNames.indexOf(e))throw new Dg(`Duplicate weight name ${e} for layer ${this.name}`);this._addedWeightNames.push(e),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=o?o():hb("zeros"));const l=s.apply(t,n),u=new yb(l,n,e,a,i);return l.dispose(),null!=r&&this.addLoss((()=>r.apply(u.read()))),null==a&&(a=!0),a?this._trainableWeights.push(u):this._nonTrainableWeights.push(u),u}setFastWeightInitDuringBuild(e){this.fastWeightInitDuringBuild=e}addLoss(e){null==e||Array.isArray(e)&&0===e.length||(e=Vg(e),void 0!==this._losses&&null!==this._losses&&this.losses.push(...e))}computeOutputShape(e){return e}computeMask(e,t){if(!this.supportsMasking){if(null!=t){if(!Array.isArray(t))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);t.forEach((e=>{if(null!=e)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return t}setMaskMetadata(e,t,n){if(!this.supportsMasking)return;const s=this.computeMask(e,n),r=Vg(t),a=Vg(s);if(r.length!==a.length)throw new Error(`${this.name} outputs ${r.length} tensors but ${r.length} masks for those tensors`);for(let e=0;e<r.length;e++)r[e].kerasMask=a[e]}addInboundNode(e,t,n,s,r,a,i=null){const o=Vg(e);t=Vg(t),n=Vg(n),s=Vg(s),r=db(r),a=db(a);const l=[],u=[],c=[];for(const e of o)l.push(e.sourceLayer),u.push(e.nodeIndex),c.push(e.tensorIndex);new Nb({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:t,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let e=0;e<t.length;e++)t[e].sourceLayer=this,t[e].nodeIndex=this.inboundNodes.length-1,t[e].tensorIndex=e}getConfig(){const e={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(e.batchInputShape=this.batchInputShape),null!=this.dtype&&(e.dtype=this.dtype),e}disposeWeights(){return this.weights.forEach((e=>e.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let e=0;return 0==--this._refCount&&(e=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:e}}}function Tb(e,t,n){if((null==t||null!=n&&n>0)&&(t=e.sourceLayer,n=e.nodeIndex),0===t.inboundNodes.length)return[e];{const e=t.inboundNodes[n];if(0===e.inboundLayers.length)return e.inputTensors;{const t=[];for(let n=0;n<e.inboundLayers.length;n++){const s=Tb(e.inputTensors[n],e.inboundLayers[n],e.nodeIndices[n]);for(const e of s)-1===t.indexOf(e)&&t.push(e)}return t}}}class Cb extends Sb{constructor(e){if(super({dtype:e.dtype,name:null!=e.name?e.name:iy("input").toString()}),null==e.batchSize&&(e.batchSize=null),null==e.sparse&&(e.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=e.sparse,null!=e.inputShape&&null!=e.batchInputShape)throw new Dg("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let t=e.batchInputShape;if(null==t){if(null==e.inputShape)throw new Dg("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");t=[e.batchSize].concat(e.inputShape)}else if(null!=e.batchSize)throw new Dg("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=e.dtype||"float32";this.batchInputShape=t,this.dtype=n,this.inputSpec=[{shape:t}];const s=new vb(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Nb({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[t],outputShapes:[t]})}apply(e,t){throw new Dg(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function $b(e){if(null==e.batchShape&&null==e.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=e.batchShape&&null!=e.shape)throw new Dg("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let t=e.batchShape;null!=e.shape&&null==t&&(t=[null].concat(e.shape));let n=e.dtype;null==n&&(n="float32");return new Cb({batchInputShape:t,name:e.name,dtype:n,sparse:e.sparse}).inboundNodes[0].outputTensors[0]}Cb.className="InputLayer",pd(Cb);class Eb{constructor(e){if(this.id2Value={},this.id2Mask={},this.name2Id={},e instanceof Eb)for(const t in e.id2Value)this.id2Value[t]=e.id2Value[t],t in e.id2Mask&&(this.id2Mask[t]=e.id2Mask[t]);else{if(null==e)return;for(const t of e)this.add(t.key,t.value)}}add(e,t,n){if(null!=this.id2Value[e.id])throw new Dg(`Duplicate key: name=${e.name}, id=${e.id}`);return this.id2Value[e.id]=function(e,t){if(null==e.dtype||e.dtype===t.dtype)return t;try{return Pi(t,e.dtype)}catch(n){throw new Dg(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`)}}(e,t),this.name2Id[e.name]=e.id,null!=n&&(this.id2Mask[e.id]=n),this}addFeed(e){this.add(e.key,e.value)}hasKey(e){return null!=this.id2Value[e.id]}names(){return Object.keys(this.name2Id)}getValue(e){if(e instanceof vb){if(null==this.id2Value[e.id])throw new Dg(`Nonexistent key: ${e.name}`);return this.id2Value[e.id]}{const t=this.name2Id[e];if(null==t)throw new Dg(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Value[t]}}getMask(e){if(e instanceof vb){if(null==this.id2Value[e.id])throw new Dg(`Nonexistent key: ${e.name}`);return this.id2Mask[e.id]}{const t=this.name2Id[e];if(null==t)throw new Dg(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Mask[t]}}disposeMasks(){null!=this.id2Mask&&Ma(this.id2Mask)}}const Ab=new Lg,Rb=new Lg;function _b(e,t,n,s){const r=null!=n&&n.training,a=Array.isArray(e),i=a?e:[e],o=i.map((e=>e.name)),l=[],c=t.names();for(const e of o)-1!==c.indexOf(e)?l.push(t.getValue(e)):l.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=o.join(",")+"|"+t.names().sort().join(",");let p,d=Ab.get(h);if(null==d){const e=function(e,t){u(null!=e&&e.length>0,(()=>"Expected at least one fetch, got none"));let n=[],s={};if(1===e.length){const r=Db(e[0],t);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of e){const{sorted:e,recipientMap:i}=Db(a,t);for(const t of e)r.has(t.name)||(n.push(t),r.add(t.name));for(const e in i)null==s[e]&&(s[e]=new Set),i[e].forEach((t=>s[e].add(t)))}}return{sorted:n,recipientCounts:Fb(s)}}(i,t);d=e.sorted,p=e.recipientCounts,Ab.put(h,d),Rb.put(h,p)}p={},r||Object.assign(p,Rb.get(h));const f=new Eb(t);for(let e=0;e<d.length;++e){if(null!=s){const e=Fa().numTensors;e>s.maxNumTensors&&(s.maxNumTensors=e),e<s.minNumTensors&&(s.minNumTensors=e)}const a=d[e],i=a.sourceLayer;if(i instanceof Cb)continue;const u=[],c=[],h=[];let m=!1;for(const e of a.inputs){const n=f.getValue(e),s=f.getMask(e);u.push(n),c.push(s),null!=s&&(m=!0),r||(p[e.name]--,0!==p[e.name]||t.hasKey(e)||-1!==o.indexOf(e.name)||n.isDisposed||!0===e.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Vg(i.apply(u,n));let y=null;i.supportsMasking&&(y=i.computeMask(u,c));const b=Ob(a),x=Array.isArray(b)?b:[b];for(let e=0;e<x.length;++e){f.hasKey(x[e])||f.add(x[e],g[e],Array.isArray(y)?y[0]:y);const t=o.indexOf(x[e].name);-1!==t&&(l[t]=g[e])}r||Ma(h)}return f.disposeMasks(),a?l:l[0]}function Fb(e){const t={};for(const n in e)t[n]=e[n].size;return t}function Db(e,t){const n=new Set,s=[],r={};for(const e of t.names())n.add(e);const a=[],i=[];for(a.push(e);a.length>0;){const e=a[a.length-1];if(n.has(e.name)){a.pop();continue}const t=i[i.length-1]===a.length-1;if(0===e.inputs.length||t)a.pop(),s.push(e),n.add(e.name),t&&i.pop();else{i.push(a.length-1);for(const t of e.inputs)null==r[t.name]&&(r[t.name]=new Set),r[t.name].add(e.name),n.has(t.name)||a.push(t)}}return{sorted:s,recipientMap:r}}function Ob(e){let t;if(1===e.sourceLayer.inboundNodes.length)t=e.sourceLayer.output;else{let n=null;for(let t=0;t<e.sourceLayer.inboundNodes.length;++t)for(const s of e.sourceLayer.inboundNodes[t].outputTensors)if(s.id===e.id){n=t;break}t=e.sourceLayer.getOutputAt(n)}return t}function Mb(e,t){return Oa((()=>Fl(Ol(Hi(e,e),t,!0))))}K().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(e){null!=Ab&&Ab.setMaxEntries(e),null!=Rb&&Rb.setMaxEntries(e)}));class Lb extends cd{getConfig(){return{}}}class zb extends Lb{constructor(e){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Oa((()=>{const t=Mb(e,this.axis),n=Wo(t,0,this.maxValue);return Hi(e,Gi(n,Vi(Cy(),t)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}zb.className="MaxNorm",pd(zb);class Pb extends Lb{constructor(e){super(),this.defaultAxis=0,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Oa((()=>Gi(e,Vi(Cy(),Mb(e,this.axis)))))}getConfig(){return{axis:this.axis}}}Pb.className="UnitNorm",pd(Pb);class Bb extends Lb{apply(e){return Bc(e)}}Bb.className="NonNeg",pd(Bb);class Wb extends Lb{constructor(e){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=e.minValue?e.minValue:this.defaultMinValue,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.rate=null!=e.rate?e.rate:this.defaultRate,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Oa((()=>{const t=Mb(e,this.axis),n=Vi(Hi(this.rate,Wo(t,this.minValue,this.maxValue)),Hi(1-this.rate,t));return Hi(e,Gi(n,Vi(Cy(),t)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Wb.className="MinMaxNorm",pd(Wb);const Vb={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Ub(e){return jg(e)}function Gb(e,t={}){return Kg(e,hd.getMap().classNameMap,t,"constraint")}function Hb(e){if(null==e)return null;if("string"==typeof e){return Gb({className:e in Vb?Vb[e]:e,config:{}})}return e instanceof Lb?e:Gb(e)}var jb=Object.freeze({__proto__:null,maxNorm:function(e){return new zb(e)},minMaxNorm:function(e){return new Wb(e)},nonNeg:function(){return new Bb},unitNorm:function(e){return new Pb(e)}});var qb,Kb=Object.freeze({__proto__:null,constant:function(e){return new Xy(e)},glorotNormal:function(e){return new nb(e)},glorotUniform:function(e){return new tb(e)},heNormal:function(e){return new sb(e)},heUniform:function(e){return new rb(e)},identity:function(e){return new Qy(e)},leCunNormal:function(e){return new ab(e)},leCunUniform:function(e){return new ib(e)},ones:function(){return new Ky},orthogonal:function(e){return new ob(e)},randomNormal:function(e){return new Zy(e)},randomUniform:function(e){return new Yy(e)},truncatedNormal:function(e){return new Jy(e)},varianceScaling:function(e){return new eb(e)},zeros:function(){return new qy}});async function Xb(e){if(null==e)return;const t=[],n=[],s=[];for(const r in e){const a=e[r];if("number"!=typeof a){const e=a;t.push(e.data()),n.push(r),s.push(e)}}if(t.length>0){const r=await Promise.all(t);for(let t=0;t<r.length;++t)e[n[t]]=r[t][0];Ma(s)}}function Yb(e){if(null!=e)for(const t in e){const n=e[t];"number"!=typeof n&&n.dispose()}}!function(e){e[e.SILENT=0]="SILENT",e[e.VERBOSE=1]="VERBOSE"}(qb||(qb={}));class Zb{constructor(){this.validationData=null}setParams(e){this.params=e}async onEpochBegin(e,t){}async onEpochEnd(e,t){}async onBatchBegin(e,t){}async onBatchEnd(e,t){}async onTrainBegin(e){}async onTrainEnd(e){}setModel(e){}}class Jb{constructor(e,t=10){null==e&&(e=[]),this.callbacks=e,this.queueLength=t}append(e){this.callbacks.push(e)}setParams(e){for(const t of this.callbacks)t.setParams(e)}setModel(e){for(const t of this.callbacks)t.setModel(e)}async onEpochBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochBegin(e,t)}async onEpochEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochEnd(e,t)}async onBatchBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchBegin(e,t)}async onBatchEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchEnd(e,t)}async onTrainBegin(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainBegin(e)}async onTrainEnd(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainEnd(e)}}class Qb extends Zb{constructor(){super()}async onEpochBegin(e){this.seen=0,this.totals={}}async onBatchEnd(e,t){null==t&&(t={});const n=null==t.size?0:t.size;this.seen+=n;for(const e in t){const s=t[e];if("number"==typeof s)this.totals.hasOwnProperty(e)||(this.totals[e]=0),this.totals[e]=this.totals[e]+s*n;else{let t;e in this.totals?t=this.totals[e]:this.totals[e]=0;const r=Oa((()=>Vi(this.totals[e],Hi(s,n))));this.totals[e]=r,null!=t&&t.dispose()}}}async onEpochEnd(e,t){if(null!=t)for(const e of this.params.metrics)null!=this.totals[e]&&("number"==typeof this.totals[e]?t[e]=this.totals[e]/this.seen:Oa((()=>{const n=Hi(Gi(1,this.seen),this.totals[e]);t[e]=n,this.totals[e].dispose(),La(t[e])})))}}class ex extends Zb{async onTrainBegin(e){this.epoch=[],this.history={}}async onEpochEnd(e,t){null==t&&(t={}),this.epoch.push(e);for(const e in t)null==this.history[e]&&(this.history[e]=[]),this.history[e].push(t[e])}async syncData(){const e=[],t=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];e.push(i.data()),t.push(s),n.push(a)}}const s=await Promise.all(e);for(let e=0;e<s.length;++e){this.history[t[e]][n[e]].dispose(),this.history[t[e]][n[e]]=s[e][0]}}}class tx extends Zb{constructor(e,t){if(super(),this.currentEpoch=0,this.nowFunc=e.nowFunc,this.nextFrameFunc=e.nextFrameFunc||bf,this.yieldEvery=t||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=e.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");R(this.yieldEvery)&&(this.maybeWait=function(e,t,n){let s,r=null!=n?n():wr();return(...a)=>{const i=null!=n?n():wr();return i-r<t||(r=i,s=e(...a)),s}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=e.onTrainBegin,this.trainEnd=e.onTrainEnd,this.epochBegin=e.onEpochBegin,this.epochEnd=e.onEpochEnd,this.batchBegin=e.onBatchBegin,this.batchEnd=e.onBatchEnd,this.yield=e.onYield}async maybeWait(e,t,n){const s=[];null!=this.yield&&(await Xb(n),s.push(this.yield(e,t,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(e,t){this.currentEpoch=e,null!=this.epochBegin&&(await Xb(t),await this.epochBegin(e,t))}async onEpochEnd(e,t){const n=[];null!=this.epochEnd&&(await Xb(t),n.push(this.epochEnd(e,t))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(e,t){null!=this.batchBegin&&(await Xb(t),await this.batchBegin(e,t))}async onBatchEnd(e,t){const n=[];null!=this.batchEnd&&(await Xb(t),n.push(this.batchEnd(e,t))),"batch"===this.yieldEvery?n.push(this.nextFrameFunc()):R(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,e,t)),await Promise.all(n)}async onTrainBegin(e){null!=this.trainBegin&&(await Xb(e),await this.trainBegin(e))}async onTrainEnd(e){null!=this.trainEnd&&(await Xb(e),await this.trainEnd(e))}}function nx(e,t){if(null==e&&(e={}),e instanceof Zb)return[e];if(Array.isArray(e)&&e[0]instanceof Zb)return e;return Vg(e).map((e=>new tx(e,t)))}class sx{constructor(){}static registerCallbackConstructor(e,t){u(e>=0&&Number.isInteger(e),(()=>`Verbosity level is expected to be an integer >= 0, but got ${e}`)),sx.checkForDuplicate(t),null==sx.constructors[e]&&(sx.constructors[e]=[]),sx.constructors[e].push(t)}static checkForDuplicate(e){for(const t in sx.constructors){sx.constructors[+t].forEach((t=>{if(t===e)throw new Dg("Duplicate callback constructor.")}))}}static clear(){sx.constructors={}}static createCallbacks(e){const t=[];for(const n in sx.constructors){const s=+n;e>=s&&t.push(...sx.constructors[s])}return t.map((e=>new e))}}function rx(e,t,n,s,r,a,i,o,l){const u=new ex,c=[new Qb,...sx.createCallbacks(t)];null!=e&&c.push(...e),c.push(u);const h=new Jb(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:t,doValidation:o,metrics:l}),{callbackList:h,history:u}}function ax(e,t={},n=!1){return Kg(e,hd.getMap().classNameMap,t,"layer",n)}function ix(e,t){return Oa((()=>{"float32"!==e.dtype&&(e=Pi(e,"float32"));const n=Ol(Py(e),t,!0),s=Bo(n.shape,Cy()),r=Fl(Cu(n,s));return Gi(e,r)}))}function ox(e,t){return Oa((()=>$u(Py(mu(t,e)),-1)))}function lx(e,t){return Oa((()=>$u(ji(mu(t,e)),-1)))}function ux(e,t){return Oa((()=>{const n=mu(e,t),s=Wo(ji(e),Cy(),Number.MAX_VALUE),r=ji(Gi(n,s));return Hi(100,$u(r,-1))}))}function cx(e,t){return Oa((()=>{const n=Wo(t,Cy(),Number.MAX_VALUE),s=su(Vi(1,n)),r=Wo(e,Cy(),Number.MAX_VALUE),a=su(Vi(1,r));return $u(Py(mu(s,a)),-1)}))}function hx(e,t,n=!1){return Oa((()=>{if(n)t=ah(t);else{const e=Ol(t,t.shape.length-1,!0);t=Gi(t,e)}return t=Wo(t,Cy(),1-Cy()),pu(Ol(Hi(Pi(e,"float32"),su(t)),t.shape.length-1))}))}function px(e,t,n=!1){return Oa((()=>{const s=Pi(Gl(function(e){const t=[ky(e.shape)];return vo(e,t)}(e)),"int32"),r=(t=Wo(t,Cy(),1-Cy())).shape;return hx(vo(Pu(s,r[r.length-1]),r),t,n)}))}function dx(e,t){return Oa((()=>{let n;return n=Wo(t,Cy(),1-Cy()),n=su(Gi(n,mu(1,n))),$u(function(e,t){if(!f(e.shape,t.shape))throw new Dg(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);return Oa((()=>{const n=Bc(t),s=pu(ji(t));return Vi(mu(n,Hi(t,e)),ru(Pl(s)))}))}(e,n),-1)}))}function fx(e,t){return Oa((()=>{const n=Wo(e,Cy(),1),s=Wo(t,Cy(),1);return Ol(Hi(e,su(Gi(n,s))),-1)}))}function mx(e,t){return Oa((()=>{const n=ix(e,-1),s=ix(t,-1),r=Hi(n,s);return pu(Ol(r,-1))}))}sx.constructors={};const gx={meanSquaredError:ox,meanAbsoluteError:lx,meanAbsolutePercentageError:ux,meanSquaredLogarithmicError:cx,squaredHinge:function(e,t){return Oa((()=>{const n=Cu(0,mu(1,Hi(e,t)));return $u(Py(n),-1)}))},hinge:function(e,t){return Oa((()=>{const n=Cu(0,mu(1,Hi(e,t)));return $u(n,-1)}))},categoricalHinge:function(e,t){return Oa((()=>{const n=Ol(Hi(e,t),-1),s=El(Hi(mu(1,e),t),-1);return Cu(0,Vi(1,mu(s,n)))}))},logcosh:function(e,t){return Oa((()=>{const n=Math.log(2),s=mu(t,e),r=mu(Vi(s,du(Hi(-2,s))),n);return $u(r,-1)}))},categoricalCrossentropy:hx,sparseCategoricalCrossentropy:px,binaryCrossentropy:dx,kullbackLeiblerDivergence:fx,poisson:function(e,t){return Oa((()=>{const n=su(Vi(Cy(),t));return $u(mu(t,Hi(e,n)),-1)}))},cosineProximity:mx};function yx(e){if("string"==typeof e){if(e in gx)return gx[e];let t=`Unknown loss ${e}`;throw e.toLowerCase().includes("softmaxcrossentropy")&&(t=`Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Dg(t)}return e}function bx(e,t){return Oa((()=>{const n=Hi(.5,Bu(t)),s=$y(jl(t,n),e.dtype);return $u(pl(e,s),-1)}))}function xx(e,t){return Oa((()=>$y(pl(Ji(e,-1),Ji(t,-1)),"float32")))}function wx(e,t){return Oa((()=>Pi(Ol(bu(pl(e,1),pl(t,1))),"float32")))}function vx(e,t){return Oa((()=>{const n=wx(e,t),s=function(e,t){return Oa((()=>Pi(Ol(bu(pl(e,0),pl(t,1))),"float32")))}(e,t),r=Vi(n,s);return Pi(dl(jl(r,0),Gi(n,r),0),"float32")}))}function kx(e,t){return Oa((()=>{const n=wx(e,t),s=function(e,t){return Oa((()=>Pi(Ol(bu(pl(e,1),pl(t,0))),"float32")))}(e,t),r=Vi(n,s);return Pi(dl(jl(r,0),Gi(n,r),0),"float32")}))}function Nx(e,t){return dx(e,t)}function Ix(e,t){return e.rank===t.rank&&(e=ph(e,[e.rank-1])),(t=Ji(t,-1)).dtype!==e.dtype&&(t=Pi(t,e.dtype)),Pi(pl(e,t),"float32")}const Sx=hx,Tx=px,Cx={binaryAccuracy:bx,categoricalAccuracy:xx,precision:vx,categoricalCrossentropy:Sx,sparseCategoricalCrossentropy:Tx,mse:ox,MSE:ox,mae:lx,MAE:lx,mape:ux,MAPE:ux,cosine:mx};function $x(e){if("string"==typeof e&&e in Cx)return Cx[e];if("string"!=typeof e&&null!=e)return e;throw new Dg(`Unknown metric ${e}`)}function Ex(e){if(Pg(null!==e,`Unknown LossOrMetricFn ${e}`),"string"==typeof e)return e;{let t;for(const n of Object.keys(gx))if(gx[n]===e){t=n;break}if(void 0!==t)return t;for(const n of Object.keys(Cx))if(Cx[n]===e){t=n;break}return void 0!==t?t:e.name}}function Ax(e,t,n=!1){if(null==e||"object"!=typeof e||Object.getPrototypeOf(e)!==Object.prototype||!Rx(e))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(e);n.length>1048576&&console.warn(`User-defined metadata of model "${t}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function Rx(e){if(null===e)return!0;if("object"==typeof e){if(Object.getPrototypeOf(e)===Object.prototype){const t=Object.keys(e);for(const n of t){if("string"!=typeof n)return!1;if(!Rx(e[n]))return!1}return!0}if(Array.isArray(e)){for(const t of e)if(!Rx(t))return!1;return!0}return!1}{const t=typeof e;return"string"===t||"number"===t||"boolean"===t}}function _x(e,t,n,s=console.log){const r=function(e){let t=!0;const n=[],s=[];for(const t in e.nodesByDepth)n.push(e.nodesByDepth[t]);for(const e of n){if(e.length>1||1===e.length&&e[0].inboundLayers.length>1){t=!1;break}s.push(...e)}if(t)for(const n of e.layers){let e=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(e){t=!1;break}e=!0}if(!t)break}return t}(e),a=["Layer (type)","Input Shape","Output shape","Param #"];let i;if(r?(t=t||90,n=n||[.32,.61,.89,1]):(t=t||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((e=>Math.floor(t*e)))),!r){a.push("Receives inputs"),i=[];for(const t in e.nodesByDepth)i.push(...e.nodesByDepth[t])}s("_".repeat(t)),Fx(a,n,s),s("=".repeat(t));const o=e.layers;for(let e=0;e<o.length;++e)r?Dx(o[e],n,s):Ox(o[e],n,i,s),s((e===o.length-1?"=":"_").repeat(t));e.checkTrainableWeightsConsistency();const l=function(e){let t;t=null!=e.collectedTrainableWeights?gb(e.collectedTrainableWeights):gb(e.trainableWeights);return t}(e),u=gb(e.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(t))}function Fx(e,t,n=console.log){let s="";for(let n=0;n<e.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=e[n],s=s.slice(0,t[n]),s+=" ".repeat(t[n]-s.length);n(s)}function Dx(e,t,n){let s,r;try{r=e.inboundNodes.map((e=>JSON.stringify(e.inputShapes))).join(",")}catch(e){r="multiple"}try{s=JSON.stringify(e.outputShape)}catch(e){s="multiple"}Fx([`${e.name} (${e.getClassName()})`,r,s,e.countParams().toString()],t,n)}function Ox(e,t,n,s){let r,a;try{a=e.inboundNodes.map((e=>JSON.stringify(e.inputShapes))).join(",")}catch(e){a="multiple"}try{r=JSON.stringify(e.outputShape)}catch(e){r="multiple"}const i=[];for(const t of e.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(t)))for(let e=0;e<t.inboundLayers.length;++e){const n=t.inboundLayers[e].name,s=t.nodeIndices[e],r=t.tensorIndices[e];i.push(`${n}[${s}][${r}]`)}const o=e.name,l=e.getClassName(),u=0===i.length?"":i[0];Fx([`${o} (${l})`,a,r,e.countParams().toString(),u],t,s);for(let e=1;e<i.length;++e)Fx(["","","","",i[e]],t,s)}function Mx(e,t,n){return("inboundNodes"===e||"outputLayers"===e||"inputLayers"===e)&&0===t&&"string"==typeof n}function Lx(e,t){if(null===e)return null;if("string"==typeof e)return Gg(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];Mx(t,r,s)?n.push(s):n.push(Lx(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n];if("name"===n&&"string"==typeof s)t[n]=s;else{const e=Gg(n);t[e]=Lx(s,e)}}return t}}function zx(e,t){if(null==e)return null;if("string"==typeof e)return Ug(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];Mx(t,r,s)?n.push(s):n.push(zx(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n],r=Ug(n);t[r]="name"!==n&&"className"!==n||"string"!=typeof s?zx(s,n):s}return t}}const Px="4.22.0";class Bx extends Sb{constructor(e){if(super({}),this.containerNodes=new Set,this.name=e.name,null==this.name){const e=this.getClassName().toLowerCase();this.name=iy(e)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(e.inputs)?this.inputs=e.inputs.slice():this.inputs=[e.inputs],Array.isArray(e.outputs)?this.outputs=e.outputs.slice():this.outputs=[e.outputs],Yg(this.inputs).length!==this.inputs.length)throw new Dg(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((e=>e.name))}`);Yg(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((e=>e.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const e of this.outputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;this.outputLayers.push(t),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const e of this.inputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;Pg(0===n,"input layer has >1 nodes"),Pg(0===s,"input layer has >1 tensors"),this.inputLayers.push(t),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t];if(!(n instanceof Cb))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${t} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const e of this.outputLayers)this.outputNames.push(e.name);this.internalInputShapes=this.inputs.map((e=>e.shape)),this.internalOutputShapes=this.outputs.map((e=>e.shape));const t={},n={},s={},r={},a={},i=[],o=(e,t,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=e.sourceLayer,r=e.nodeIndex,l=e.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new Fg(`The tensor ${e.name} at layer "${s.name}" is part of a cycle.`);if(-1!==t.indexOf(u))return;this.containerNodes.add(Bx.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let e=0;e<c;e++){const s=u.inputTensors[e],r=u.inboundLayers[e],a=u.nodeIndices[e],i=u.tensorIndices[e];o(s,t,n,r,a,i)}for(t.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const e of this.outputs)o(e,l,u);const c=i.slice().reverse();for(const e of c){n[e.id]=e,e.id in t||(t[e.id]=0);let a=t[e.id];const i=null==s[e.outboundLayer.id]?0:s[e.outboundLayer.id];a=Math.max(a,i),s[e.outboundLayer.id]=a,r[e.outboundLayer.id]=e.outboundLayer,t[e.id]=a;for(let s=0;s<e.inboundLayers.length;s++){const r=e.inboundLayers[s],i=e.nodeIndices[s],o=r.inboundNodes[i],l=null==t[o.id]?0:t[o.id];t[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const e in t){const s=t[e];s in h||(h[s]=[]),h[s].push(n[e])}const p={};for(const e in s){const t=s[e];t in p||(p[t]=[]),p[t].push(r[e])}let d=Object.keys(p).map((e=>parseInt(e,10))).sort(Xg);this.layers=[];for(const e of d){const t=p[e];t.sort(((e,t)=>{const n=a[e.id],s=a[t.id];return n<s?-1:n>s?1:0}));for(const e of t)e instanceof Bx&&this.internalContainerRefs.push(e),this.layers.push(e)}this.layersByDepth=p,d=Object.keys(h).map((e=>parseInt(e,10))).sort(Xg);const f=this.inputs.slice(),m=[];for(const e of d)for(const t of h[e]){const e=t.outboundLayer;if(null!=e){for(const n of t.inputTensors)if(-1===f.indexOf(n))throw new Fg(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${e.name}". The following previous layers were accessed without issue: ${m}`);for(const e of t.outputTensors)f.push(e);m.push(e.name)}}this.nodesByDepth=h;const g=this.layers.map((e=>e.name));for(const e of g){const t=g.filter((t=>t===e)).length;if(1!==t)throw new Fg(`The name "${e}" is used ${t} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new Nb({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((e=>null)),outputMasks:this.outputs.map((e=>null)),inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs.map((e=>e.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const e={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const t of this.layers)e.numDisposedVariables+=t.dispose().numDisposedVariables;for(const t of this.internalContainerRefs)e.numDisposedVariables+=t.dispose().numDisposedVariables}return e.refCountAfterDispose=this._refCount,e}get trainable(){return this.trainable_}set trainable(e){this.layers.forEach((t=>{t._trainableWeights.forEach((t=>t.trainable=e))})),this.trainable_=e}get trainableWeights(){if(this._trainableWeights.length>0)throw new Dg("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let e=[];for(const t of this.layers)e=e.concat(t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.layers)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.layers)t.push(...e.trainableWeights);return t.concat(e)}return e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(e,t=!0){const n={};let s=0;const r=(e=>{const t=Object.keys(e);if(0===t.length)return!1;const n=t[0].split("/");return!isNaN(parseInt(n[n.length-1],10))})(e);r&&this.parseWeights(e);for(const e of this.layers)for(const[t,a]of e.weights.entries()){const e=r?`${a.name.split("/").slice(0,-1).join("/")+"/"}${t}`:a.originalName;if(null!=n[e])throw new Dg(`Duplicate weight name: ${e}`);n[e]=a,s++}const a=[];for(const s in e){let r=s;if(null==n[s]){const e=s.split("/");r=e.slice(0,-2).concat([e[e.length-1]]).join("/")}if(null!=n[r])a.push([n[r],e[s]]);else if(t)throw new Dg(`Provided weight data has no target variable: ${s}`);delete n[r]}if(t){const e=[];for(const t in n)e.push(t);if(e.length>0)throw new Dg(`${e.length} of ${s} weights are not set: ${e}`)}xb(a)}parseWeights(e){for(const t in Object.keys(e)){const n=t.split("/"),s=["vars","layer_checkpoint_dependencies"],r=n.map((e=>e.startsWith("_")?e.slice(1):e)).filter((e=>!s.includes(e))).join("/");r!==t&&(e[r]=e[t],delete e[t])}}updatedConfig(){const e=this.getConfig(),t={};return t.className=this.getClassName(),t.config=e,t.kerasVersion="tfjs-layers 4.22.0",t.backend="TensorFlow.js",t}toJSON(e,t=!0){const n=zx(this.updatedConfig());return t?JSON.stringify(n):n}call(e,t){return Oa((()=>{e=Vg(e);const n=new Eb;for(let t=0;t<this.inputs.length;++t)n.add(this.inputs[t],e[t]);return _b(this.outputs,n,t)}))}computeMask(e,t){return Oa((()=>{let n;return e=Vg(e),n=null==t?zg(null,e.length):Vg(t),this.runInternalGraph(e,n)[1]}))}computeOutputShape(e){const t=db(e);if(t.length!==this.inputLayers.length)throw new Dg(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let e=0;e<t.length;e++){const s=this.inputLayers[e],r=t[e];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(Xg);if(s.length>1)for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer;if(-1!==this.inputLayers.map((e=>e.id)).indexOf(t.id))continue;const s=[];for(let t=0;t<e.inboundLayers.length;t++){const r=e.inboundLayers[t],a=e.nodeIndices[t],i=e.tensorIndices[t],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=db(t.computeOutputShape(Wg(s))),a=t.inboundNodes.indexOf(e);for(let e=0;e<r.length;e++){n[`${t.name}_${a}_${e}`]=r[e]}}}const r=[],a=[];for(let e=0;e<this.outputLayers.length;e++){const t=this.outputLayers[e],n=this.outputLayersNodeIndices[e],s=this.outputLayersTensorIndices[e],r=`${t.name}_${n}_${s}`;a.push(r)}for(let e=0;e<a.length;e++){const t=a[e];Pg(t in n),r.push(n[t])}return Wg(r)}runInternalGraph(e,t){null==t&&(t=zg(null,e.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=e[s],i=t[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(Xg);for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer,s=e.inputTensors,r=e.outputTensors,a=new Array;for(const e of s)e.id in n&&a.push(n[e.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=e.callArgs&&(u=e.callArgs),1===a.length){const[e,n]=a[0];null==u.mask&&(u.mask=n),o=Vg(t.call(e,u)),l=Vg(t.computeMask(e,n)),s=[e],i=[n]}else s=a.map((e=>e[0])),i=a.map((e=>e[1])),null==u.mask&&(u.mask=i),o=Vg(t.call(s,u)),l=Vg(t.computeMask(s,i));if(t.activityRegularizer)throw new Og("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let e=0;e<r.length;++e){const t=r[e],s=o[e],a=l[e];n[t.id]=[s,a]}}}}const r=[],a=[],i=[];for(const e of this.outputs){Pg(e.id in n,`Could not compute output ${e.name} : ${e.id}`);const[t,s]=n[e.id];i.push(t.shape),r.push(t),a.push(s)}return[r,a,i]}buildNodeConversionMap(e){const t={};let n;for(const e of this.layers){n=e instanceof Bx?1:0;for(let s=0;s<e.inboundNodes.length;s++){const r=Bx.nodeKey(e,s);this.containerNodes.has(r)&&(t[r]=n,n+=1)}}return t}getLayer(e,t){if(null!=t)return this.findLayer(t);if(null==e)throw new Dg("Provide either a layer name or layer index");if("number"==typeof e)return this.findLayer(e);for(const t of this.layers)if(t.name===e)return t;throw new Dg(`No such layer: ${e}`)}findLayer(e){if(this.layers.length<=e)throw new Dg(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}calculateLosses(){return Oa((()=>{const e=[];for(const t of this.layers)for(let n=0;n<t.inboundNodes.length;++n){const s=Bx.nodeKey(t,n);this.containerNodes.has(s)&&e.push(...t.calculateLosses())}return e}))}getConfig(){const e={name:this.name},t=this.buildNodeConversionMap(this.layers),n=[];for(const e of this.layers){const s=e.getClassName(),r=e.getConfig(),a=[];for(let n=0;n<e.inboundNodes.length;n++){const s=e.inboundNodes[n],r=Bx.nodeKey(e,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(t){console.warn(`Layer ${e.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),i={}}if(s.inboundLayers.length>0){const e=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=t[Bx.nodeKey(r,a)];null==l&&(l=0),e.push([r.name,l,o,i])}a.push(e)}}}const i={};i.name=e.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}e.layers=n;const s=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e],r=this.inputLayersNodeIndices[e],a=Bx.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[e];s.push([n.name,i,o])}e.inputLayers=s;const r=[];for(let e=0;e<this.outputLayers.length;e++){const n=this.outputLayers[e],s=this.outputLayersNodeIndices[e],a=Bx.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[e];r.push([n.name,i,o])}return e.outputLayers=r,e}static fromConfig(e,t,n={},s=!1){const r={},a={};function i(e,t){e.name in a?a[e.name].push(t):a[e.name]=[t]}function o(e,t){const n=[];let s;for(const a of t){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(e,t);const c=r[o];if(c.inboundNodes.length<=l)return void i(e,t);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&e.apply(Wg(n),s)}function l(e){const n=e.name,a=ax(e,null!=t.customObjects?t.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a;e.inboundNodes.forEach((e=>{if(!(e instanceof Array))throw new Dg(`Corrupted configuration, expected array for nodeData: ${e}`);i(a,e)}))}const u=t.name,c=t.layers;for(const e of c)l(e);for(;!Zg(a);)for(const e of c){const t=r[e.name];if(t.name in a){const e=a[t.name];delete a[t.name];for(const n of e)o(t,n)}}const h=[],p=[],d=t.inputLayers;for(const e of d){const t=e[0],n=e[1],s=e[2];Pg(t in r);const a=r[t].inboundNodes[n].outputTensors;h.push(a[s])}const f=t.outputLayers;for(const e of f){const t=e[0],n=e[1],s=e[2];Pg(t in r);const a=r[t].inboundNodes[n].outputTensors;p.push(a[s])}return new e({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Dg("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const e of this.layers)if(e.stateful)return!0;return!1}resetStates(){Oa((()=>{this.layers.forEach((e=>{e.stateful&&e.resetStates()}))}))}}function Wx(e,t,n){const s=t.length;if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>null));if(1===s)return Array.isArray(e)&&1===e.length?e:"object"==typeof e&&t[0]in e?[e[t[0]]]:[e];if(Array.isArray(e)){if(e.length!==s)throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return e}if("object"==typeof e&&Object.keys(e).length>0&&"object"==typeof e[Object.keys(e)[0]]){const n=[];return t.forEach((t=>{t in e?n.push(e[t]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`)}function Vx(e,t){return Wx(e,t,"classWeight")}async function Ux(e,t,n,s){if(null!=t||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const t=Oa((()=>{if(1===e.shape.length)return Bi(e);if(2===e.shape.length){if(e.shape[1]>1){return Ji(e,1)}if(1===e.shape[1])return vo(e,[e.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),s=Array.from(await t.data());Ma(t);const r=[];return s.forEach((e=>{if(null==n[e])throw new Error(`classWeight must contain all classes in the training data. The class ${e} exists in the data but not in classWeight`);r.push(n[e])})),yh(r,"float32")}return null}function Gx(e,t){return Hi(e,t)}function Hx(e,t){let n,s;const r=t;n=r.xs,s=r.ys,u(null!=n&&null!=s,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${t}`));const a=jx("input",e.inputNames,n),i=jx("output",e.outputNames,s),o=a[0].shape[0];u(a.length===e.inputs.length,(()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`)),u(i.length===e.outputs.length,(()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`));for(let t=0;t<a.length;t++)u(a[t].shape[0]===o,(()=>`Batch size mismatch: input ${e.inputNames[t]} has ${a[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));for(let t=0;t<i.length;t++)u(i[t].shape[0]===o,(()=>`Batch size mismatch: output ${e.outputNames[t]} has ${i[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));return{xs:a,ys:i}}function jx(e,t,n){if(n instanceof Pr)return[n];if(Array.isArray(n))return u(n.length===t.length,(()=>`Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`)),n;{const s=[];for(const r of t){if(null==n[r])throw new Dg(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);s.push(n[r])}return s}}async function qx(e,t,n){const s=null!=n.batchesPerEpoch;if(u(null!=e.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),u(null!=n,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),u(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`)),u(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`)),u(null==n.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(Kx(n.validationData))u(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`));else{const e=function(e){if(3===e.length)throw new Og("Validation with sample weights is not implemented yet.");return{xs:e[0],ys:e[1]}}(n.validationData);a=e.xs,i=e.ys}const o=e.makeTrainFunction(),l=e.getDedupedMetricsNames();let c;c=r?l.slice().concat(l.map((e=>"val_"+e))):l.slice();const h=nx(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=rx(h,p,n.epochs,null,null,function(e,t){let n=null;null!=t.batchesPerEpoch?n=t.batchesPerEpoch:Number.isFinite(e.size)&&(n=e.size);return n}(t,n),null,r,c);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await t.iterator();for(;m<n.epochs;){const u={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await t.iterator());!s||c<n.batchesPerEpoch;){const t=await g.next();if(s&&t.done){console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=t.value){const{xs:s,ys:r}=Hx(e,t.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const t=Vx(n.classWeight,e.outputNames);for(let e=0;e<t.length;++e)i.push(await Ux(r[e],null,t[e]))}const u=s.concat(r).concat(i),p=o(u);Ma(u);for(let e=0;e<l.length;++e){const t=l[e],n=p[e];a[t]=n,La(n)}await d.onBatchEnd(h,a),Yb(a),h++,c++}if(s?c>=n.batchesPerEpoch:t.done){if(r){let t;t=Kx(n.validationData)?Vg(await e.evaluateDataset(n.validationData,{batches:n.validationBatches})):Vg(e.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)u[`val_${e.metricsNames[n]}`]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(m,u),m++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Kx(e){return"function"==typeof e.iterator}function Xx(e){u(e>0&&Number.isInteger(e),(()=>`batchSize is required to be a positive integer, but got ${e}`))}function Yx(e,t,n){return null==e?[null]:Array.isArray(e)?e.map((e=>Ay(e,t,n-t))):Ay(e,t,n-t)}function Zx(e,t){return Oa((()=>null==e?null:Array.isArray(e)?e.map((e=>Zx(e,t))):zy(e,"int32"===t.dtype?t:Pi(t,"int32"))))}function Jx(e,t){const n=[];let s=0,r=null;for(;s<e;)r=s+t,r>=e&&(r=e),n.push([s,r]),s=r;return n}function Qx(e){const t=[];e instanceof Pr&&(e=[e]);for(let n=0;n<e.length;++n){const s=e[n];if(1===s.rank)t.push(Ey(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");t.push(s)}}return t}function ew(e,t){if(null==e)return;const n=[];if(t instanceof Pr)n.push(t.id);else if(Array.isArray(t))t.forEach((e=>n.push(e.id)));else if(null!=t)for(const e in t){const s=t[e];n.push(s.id)}const s=[];if(e instanceof Pr)-1===n.indexOf(e.id)&&s.push(e);else if(Array.isArray(e))e.forEach((e=>{-1===n.indexOf(e.id)&&s.push(e)}));else if(null!=e)for(const t in e){const r=e[t];-1===n.indexOf(r.id)&&s.push(r)}s.forEach((e=>{e.isDisposed||e.dispose()}))}function tw(e){return Array.isArray(e)}function nw(e){return!function(e){return e instanceof Pr}(e)&&!tw(e)}function sw(e,t,n,s=!0,r=""){if(null==t||0===t.length){if(null!=e){let t=!1;if(tw(e)&&e.length>0)t=!0;else if(nw(e)){for(const n in e)if(e.hasOwnProperty(n)){t=!0;break}}else t=!0;if(t)throw new Dg(`Error when checking model ${r} expected no data, but got ${e}`)}return[]}if(null==e)return t.map((e=>null));let a;if(nw(e)){a=[];for(const n of t){if(null==e[n])throw new Dg(`No data provided for "${n}". Need data for each key in: ${t}`);a.push(e[n])}}else if(tw(e)){if(e.length!==t.length)throw new Dg(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): ${e}`);a=e}else{if(t.length>1)throw new Dg(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${e.shape}`);a=[e]}if(a=Qx(a),null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Dg(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s). but got array with shape ${i.shape}`);for(let t=0;t<n[e].length;++t){if(0===t&&!s)continue;const a=i.shape[t],o=n[e][t];if(null!=o&&o>=0&&a!==o)throw new Dg(`${r} expected a batch of elements where each example has shape [${n[e].slice(1,n[e].length)}] (i.e.,tensor shape [*,${n[e].slice(1,n[e].length)}]) but the ${r} received an input with ${i.shape[0]} examples, each with shape [${i.shape.slice(1,i.shape.length)}] (tensor shape [${i.shape}])`)}}return a}function rw(e,t,n,s=!0,r=""){let a;if(Array.isArray(e)){if(e.length!==t.length)throw new Dg(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);a=e}else{if(t.length>1)throw new Dg(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(e.shape)}.`);a=[e]}if(null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Dg(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s), but got array with shape ${JSON.stringify(i.shape)}`);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l!==o)throw new Dg(`Error when checking ${r}: expected ${t[e]} to have shape ${JSON.stringify(n[e])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class aw extends Bx{constructor(e){super(e),this.isTraining=!1}summary(e,t,n=console.log){if(!this.built)throw new Dg("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");_x(this,e,t,n)}compile(e){if(null==e.loss&&(e.loss=[]),this.loss=e.loss,"string"==typeof e.optimizer)this.optimizer_=function(e){const t={Adagrad:()=>gf.adagrad(.01),Adadelta:()=>gf.adadelta(1,.95,Cy()),Adam:()=>gf.adam(.001,.9,.999,Cy()),Adamax:()=>gf.adamax(.002,.9,.999,Cy(),0),RMSProp:()=>gf.rmsprop(.001,.9,0,Cy()),SGD:()=>gf.sgd(.01)};if(t.adagrad=t.Adagrad,t.adadelta=t.Adadelta,t.adam=t.Adam,t.adamax=t.Adamax,t.rmsprop=t.RMSProp,t.sgd=t.SGD,e in t)return t[e]();throw new Dg(`Unknown Optimizer ${e}`)}(e.optimizer),this.isOptimizerOwned=!0;else{if(!(e.optimizer instanceof fd))throw new Dg("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=e.optimizer,this.isOptimizerOwned=!1}let t=[];if(Array.isArray(e.loss)||"string"==typeof e.loss||"function"==typeof e.loss)if(Array.isArray(e.loss)){if(e.loss.length!==this.outputs.length)throw new Dg(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);const n=e.loss;t=n.map((e=>yx(e)))}else{const n=yx(e.loss);this.outputs.forEach((e=>{t.push(n)}))}else{e.loss=e.loss;for(const t in e.loss)if(-1===this.outputNames.indexOf(t))throw new Dg(`Unknown entry in loss dictionary: "${t}". Only expected the following keys: ${this.outputNames}`);for(const n of this.outputNames)null==e.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),t.push(yx(e.loss[n]))}this.lossFunctions=t,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let e=0;e<this.outputs.length;++e){const t=this.internalOutputShapes[e],n=this.outputNames[e];this.feedOutputNames.push(n),this.feedOutputShapes.push(t),this.feedLossFns.push(this.lossFunctions[e])}const n=[];this.metrics=e.metrics,this.metricsNames=["loss"],this.metricsTensors=[],yy("loss",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;const t=this.lossFunctions[e];this.outputs.length>1&&(this.metricsTensors.push([t,e]),this.metricsNames.push(this.outputNames[e]+"_loss"))}}));const s=function(e,t){if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>[]));let n;if("string"==typeof e||"function"==typeof e)n=[e];else{if(!Array.isArray(e)&&"object"!=typeof e)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${e}`);n=e}if(Array.isArray(n))return t.map((e=>n));{const e=[];for(const s of t){let t=n.hasOwnProperty(s)?n[s]:[];Array.isArray(t)||(t=[t]),e.push(t)}return e}}(e.metrics,this.outputNames),r=(e,t,n)=>{this.outputNames.length>1&&(t=this.outputNames[e]+"_"+t),this.metricsNames.push(t),this.metricsTensors.push([n,e])};yy("metric",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;(t=>{let n,s,a;for(const i of t){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const t=this.internalOutputShapes[e];let r;1===t[t.length-1]||this.lossFunctions[e]===dx?-1!==["accuracy","acc"].indexOf(i)?s=bx:-1!==["crossentropy","ce"].indexOf(i)&&(s=Nx):this.lossFunctions[e]===px?-1!==["accuracy","acc"].indexOf(i)?s=Ix:-1!==["crossentropy","ce"].indexOf(i)&&(s=Tx):-1!==["accuracy","acc"].indexOf(i)?s=xx:-1!==["crossentropy","ce"].indexOf(i)&&(s=Sx),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const e=$x(i);a=e,n=""+Ex(i)}let t;yy(n,(()=>{t=a})),r(e,n,t)}})(s[e])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(e,t,n={}){const s=null==n.batchSize?32:n.batchSize;Xx(s);const r=this.standardizeUserDataXY(e,t,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return Wg(this.testLoop(i,a,s,n.verbose,n.steps))}finally{ew(r[0],e),ew(r[1],t)}}async evaluateDataset(e,t){return this.makeTestFunction(),async function(e,t,n){const s=null!=(n=n||{}).batches,r=e.testFunction;let a=[];if(n.verbose>0)throw new Og("Verbose mode is not implemented yet.");u(!s||n.batches>0&&Number.isInteger(n.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(n.batches)}`));const i="function"==typeof t.next?t:await t.iterator();let o=0,l=0;for(;!s||l<n.batches;){const t=await i.next();if(a=Oa((()=>{if(t.value){const{xs:n,ys:s}=Hx(e,t.value),i=n.concat(s),u=Oa((()=>r(i)));if(Ma(i),0===l)for(let e=0;e<u.length;++e)a.push(_l(0));const c=i[0].shape[0];for(let e=0;e<u.length;++e){const t=u[e],n=a[e];a[e]=Oa((()=>Vi(a[e],Hi(c,t)))),l>0&&Ma(n)}Ma(u),o+=c,++l}return a})),t.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const t=a[e];a[e]=Gi(a[e],o),Ma(t)}return Wg(a)}(this,e,t)}checkNumSamples(e,t,n,s="steps"){let r;if(null!=n){if(r=null,null!=t)throw new Dg(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${t}`)}else{if(null==e)throw new Dg(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(e)?e[0].shape[0]:e.shape[0]}return r}execute(e,t){if(Array.isArray(t)&&0===t.length)throw new Dg("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(t),s=n?t:[t],r=this.retrieveSymbolicTensors(s),a=new Eb;if(e instanceof Pr&&(e=[e]),Array.isArray(e)){if(e.length!==this.inputs.length)throw new Dg(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let t=0;t<this.inputs.length;++t)a.add(this.inputs[t],e[t])}else for(const t of this.inputs){const n=e[t.name];if(null==n)throw new Dg(`No value is provided for the model's input ${t.name}`);a.add(t,n)}const i=_b(r,a);return n?i:i[0]}retrieveSymbolicTensors(e){const t=zg(null,e.length);let n=e.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map((e=>e.name));for(let s=0;s<e.length;++s){const i=a.indexOf(e[s]);if(-1!==i&&(t[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw t.forEach(((t,s)=>{null==t&&n.push(e[s])})),new Dg(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return t}predictLoop(e,t=32,n=!1){return Oa((()=>{const s=this.checkNumSamples(e);if(n)throw new Og("Verbose predictLoop() is not implemented yet.");const r=Jx(s,t),a=this.outputs.map((e=>[]));for(let t=0;t<r.length;++t){Oa((()=>{const n=r[t][0],s=r[t][1],a=Yx(e,n,s),i=[];if(Array.isArray(a))for(let e=0;e<a.length;++e)i.push({key:this.inputs[e],value:a[e]});else i.push({key:this.inputs[0],value:a});const o=new Eb(i);return _b(this.outputs,o)})).forEach(((e,t)=>a[t].push(e)))}return Wg(a.map((e=>Io(e,0))))}))}predict(e,t={}){const n=Qx(e);rw(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==t.batchSize?32:t.batchSize;return Xx(s),this.predictLoop(n,s)}finally{ew(n,e)}}predictOnBatch(e){rw(e,this.inputNames,this.feedInputShapes,!0);const t=(Array.isArray(e)?e[0]:e).shape[0];return this.predictLoop(e,t)}standardizeUserDataXY(e,t,n=!0,s){if(null==this.optimizer_)throw new Fg("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let e=0;e<this.feedOutputShapes.length;++e){const t=this.feedOutputShapes[e];this.feedLossFns[e]===px?r.push(t.slice(0,t.length-1).concat([1])):r.push(t)}if(function(e,t,n){const s=Yg(e.map((e=>e.shape[0])));s.sort();const r=Yg(t.map((e=>e.shape[0])));if(r.sort(),s.length>1)throw new Dg(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(e.map((e=>e.shape)))}`);if(r.length>1)throw new Dg(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((e=>e.shape)))}`);if(s.length>0&&r.length>0&&!f(s,r))throw new Dg(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(e=sw(e,this.feedInputNames,this.feedInputShapes,!1,"input"),t=sw(t,this.feedOutputNames,r,!1,"target")),function(e,t,n){const s=[ox,dx,hx];for(let r=0;r<e.length;++r){const a=e[r],i=t[r],o=n[r];if(null!=i){if(i===hx&&1===a.shape[a.shape.length-1])throw new Dg(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const e=a.shape.slice(1),t=o.slice(1);for(let n=0;n<e.length;++n){const s=e[n],r=t[n];if(null!=r&&s!==r)throw new Dg(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(t,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&e[0].shape[0]%s!=0)throw new Dg(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);return[e,t]}async standardizeUserData(e,t,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(e,t,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const e=Vx(s,this.outputNames);l=[];for(let t=0;t<e.length;++t)l.push(await Ux(o[t],null,e[t]))}return[i,o,l]}testLoop(e,t,n,s=0,r){return Oa((()=>{const a=this.checkNumSamples(t,n,r,"steps"),i=[];if(s>0)throw new Og("Verbose mode is not implemented yet.");if(null!=r)throw new Og("steps mode in testLoop() is not implemented yet");{const s=Jx(a,n),r=yh(Sy(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=Ay(r,a,o-a),u=Zx(t,l),c=e(u);if(0===n)for(let e=0;e<c.length;++e)i.push(_l(0));for(let e=0;e<c.length;++e){const t=c[e];i[e]=Vi(i[e],Hi(o-a,t))}}for(let e=0;e<i.length;++e)i[e]=Gi(i[e],a)}return i}))}getDedupedMetricsNames(){const e=this.metricsNames,t=[];for(let n=0;n<e.length;++n){const s=e[n];let r=s;if(Bg(e,s)>1){r+=`_${Bg(e.slice(0,n),s)}`}t.push(r)}return t}makeTrainFunction(){return e=>{const t=[],n=e.slice(0,this.inputs.length),s=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map((e=>e.read()));return[this.optimizer_.minimize((()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:n[t]});const i=new Eb(e),o=_b(this.outputs,i,{training:!0});let l;for(let e=0;e<this.lossFunctions.length;++e){let n=(0,this.lossFunctions[e])(s[e],o[e]);null!=r[e]&&(n=Gx(n,r[e]));const a=$u(n);t.push(a),l=0===e?n:Vi(l,n)}for(let e=0;e<this.metricsTensors.length;++e){let n;if(this.outputs.length>1&&e<this.outputs.length)n=t[e];else{const t=this.metricsTensors[e][0],r=this.metricsTensors[e][1];n=$u(t(s[r],o[r]))}La(n),a.push(n)}return l=$u(l),this.calculateLosses().forEach((e=>{l=Vi(l,e)})),l}),!0,i)].concat(a)}}makeTestFunction(){this.testFunction=e=>Oa((()=>{const t=[];let n;const s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let e=0;e<this.inputs.length;++e)a.push({key:this.inputs[e],value:s[e]});const i=new Eb(a),o=_b(this.outputs,i);for(let e=0;e<this.lossFunctions.length;++e){const s=this.lossFunctions[e],a=$u(s(r[e],o[e]));n=0===e?a:Vi(n,a),t.push(n)}for(let e=0;e<this.metricsTensors.length;++e){const n=this.metricsTensors[e][0],s=this.metricsTensors[e][1],a=$u(n(r[s],o[s]));t.push(a)}return t}))}async fit(e,t,n={}){if(this.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let s,r,a,i,o,l,u,c,h;this.isTraining=!0;try{const p=null==n.batchSize?32:n.batchSize;Xx(p);const d=!1,f=await this.standardizeUserData(e,t,n.sampleWeight,n.classWeight,d,p);s=f[0],r=f[1],h=f[2];let m,g=!1;if(null!=n.validationData&&n.validationData.length>0){if(g=!0,2!==n.validationData.length)throw 3===n.validationData.length?new Og("validationData including sample weights is not supported yet."):new Dg(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${n.validationData} is invalid.`);o=n.validationData[0],l=n.validationData[1];const e=!0,t=await this.standardizeUserData(o,l,null,null,e,p);u=t[0],c=t[1],m=u.concat(c)}else if(null!=n.validationSplit&&n.validationSplit>0&&n.validationSplit<1){g=!0;const e=Math.floor(s[0].shape[0]*(1-n.validationSplit)),t=s[0].shape[0];u=Yx(s,e,t),a=s,s=Yx(s,0,e),c=Yx(r,e,t),i=r,r=Yx(r,0,e),m=u.concat(c)}else null!=n.validationSteps&&(g=!0);const y=s.concat(r).concat(h);this.checkTrainableWeightsConsistency();const b=this.makeTrainFunction(),x=this.getDedupedMetricsNames();let w,v;g?(this.makeTestFunction(),w=this.testFunction,v=x.slice().concat(x.map((e=>"val_"+e)))):(w=null,m=[],v=x.slice());const k=nx(n.callbacks,n.yieldEvery);return await this.fitLoop(b,y,x,p,n.epochs,n.verbose,k,w,m,n.shuffle,v,n.initialEpoch,null,null)}finally{this.isTraining=!1,ew(s,e),ew(r,t),ew(a,e),ew(i,t),ew(u,o),ew(c,l),null!=h&&Ma(h)}}async fitLoop(e,t,n,s,a,i,o,l,u,c,h,p,d,f){null==s&&(s=32),null==a&&(a=1),null==c&&(c=!0),null==p&&(p=0);let m=!1;if(null!=l&&null!=u&&(m=!0),null!=f&&(m=!0,null==d))throw new Dg("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const g=this.checkNumSamples(t,s,d,"steps_per_epoch");let y;null!=g&&(y=Sy(0,g)),null==i&&(i=1);const{callbackList:b,history:x}=rx(o,i,a,p,g,d,s,m,h);b.setModel(this),this.history=x,await b.onTrainBegin(),this.stopTraining_=!1;for(let i=p;i<a;++i){await b.onEpochBegin(i);const a={};if(null!=d)throw new Og("stepsPerEpoch mode is not implemented yet.");{if("batch"===c)throw new Og("batch shuffling is not implemneted yet");c&&r(y);const i=yh(y),o=Jx(g,s);for(let r=0;r<o.length;++r){const c={};if(await b.onBatchBegin(r,c),Oa((()=>{const h=o[r][0],p=o[r][1],d=Ay(i,h,p-h);c.batch=r,c.size=p-h;const f=Zx(t,d),g=e(f);for(let e=0;e<n.length;++e){const t=n[e],s=g[e];c[t]=s,La(s)}if(r===o.length-1&&m){const e=this.testLoop(l,u,s);for(let t=0;t<n.length;++t){const s=n[t],r=e[t];La(r),a["val_"+s]=r}}})),await b.onBatchEnd(r,c),Yb(c),this.stopTraining_)break}i.dispose()}if(await b.onEpochEnd(i,a),this.stopTraining_)break}return await b.onTrainEnd(),await this.history.syncData(),this.history}async fitDataset(e,t){return qx(this,e,t)}async trainOnBatch(e,t){const n=await this.standardizeUserData(e,t),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const e of a){const t=await e.data();i.push(t[0])}return Ma(a),ew(n[0],e),ew(n[1],t),Wg(i)}getNamedWeights(e){const t=[],n=null!=e&&e.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let e=0;e<s.length;++e)n&&!s[e].trainable||t.push({name:s[e].originalName,tensor:r[e]});return t}set stopTraining(e){this.stopTraining_=e}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(e){this.optimizer_!==e&&(this.optimizer_=e,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const t=Fa().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=t-Fa().numTensors}return e}getLossIdentifiers(){let e;if("string"==typeof this.loss)e=Ug(this.loss);else if(Array.isArray(this.loss)){for(const e of this.loss)if("string"!=typeof e)throw new Error("Serialization of non-string loss is not supported.");e=this.loss.map((e=>Ug(e)))}else{const t=Object.keys(this.loss);e={};const n=this.loss;for(const s of t){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");e[s]=Ug(n[s])}}return e}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[Ug(Ex(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((e=>Ug(Ex(e))));{const e={};for(const t in this.metrics)e[t]=Ug(Ex(this.metrics[t]));return e}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(e){if(null!=e.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=e.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=e.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const t=ax(Lx(e.optimizer_config));let n,s;if("string"==typeof e.loss)n=Gg(e.loss);else if(Array.isArray(e.loss))n=e.loss.map((e=>Gg(e)));else if(null!=e.loss){n={};for(const t in e.loss)n[t]=Gg(e.loss[t])}if(Array.isArray(e.metrics))s=e.metrics.map((e=>Gg(e)));else if(null!=e.metrics){s={};for(const t in e.metrics)s[t]=Gg(e.metrics[t])}this.compile({loss:n,metrics:s,optimizer:t})}async save(e,t){if("string"==typeof e){const t=pi(e);if(0===t.length)throw new Dg(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Dg(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Dg("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await Ka(this.getNamedWeights(t)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v4.22.0",convertedBy:null};if(null!=t&&t.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const e="optimizer",{data:t,specs:r}=await Ka(await this.optimizer.getWeights(),e);n.specs.push(...r),n.data=ri([n.data,t])}if(null!=this.userDefinedMetadata){const e=!0;Ax(this.userDefinedMetadata,this.name,e),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,e.save(s)}setUserDefinedMetadata(e){Ax(e,this.name),this.userDefinedMetadata=e}getUserDefinedMetadata(){return this.userDefinedMetadata}}aw.className="Model",pd(aw);class iw extends aw{}async function ow(e,t){if(null==t&&(t={}),"string"==typeof e){const n=di(e,t);if(0===n.length)n.push(Dd(e,t));else if(n.length>1)throw new Dg(`Found more than one (${n.length}) load handlers for URL '${e}'`);e=n[0]}return async function(e,t,n){null==n&&(n={});if(null==e.load)throw new Dg("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await e.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=ax(Lx(r),t,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Dg("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:e,optimizerWeights:t}=function(e,t){const n=Xa(e,t),s={},r=[];return t.forEach((e=>{"optimizer"===e.group?r.push({name:e.name,tensor:n[e.name]}):s[e.name]=n[e.name]})),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(e,a),null!=o.optimizer&&t.length>0&&await o.optimizer.setWeights(t),Ma(e),Ma(t.map((e=>e.tensor)))}return o}(e,void 0,t)}iw.className="Functional",pd(iw);class lw extends aw{constructor(e){if(super({inputs:[],outputs:[]}),e=e||{},this.trainable=!0,this.built=!1,this.name=null!=e.name?e.name:iy("sequential_"),null!=e.layers)for(const t of e.layers)this.add(t)}checkShape(e){if(e.inboundNodes[0].outputTensors[0].shape.some((e=>e<0)))throw new Dg(`Negative dimension size caused by adding layer ${e.name} with input shape [${e.inboundNodes[0].inputTensors[0].shape}]`)}add(e){const t=e instanceof lw||e instanceof aw;let n;if(t){if(n=e,1!==n.outputs.length)throw new Dg("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Dg("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===e.inboundNodes.length){if(null==e.batchInputShape)throw new Dg("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const t=$b({batchShape:e.batchInputShape,dtype:e.dtype,name:e.name+"_input"});e.apply(t)}if(t)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==e.inboundNodes.length)throw new Dg(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);if(1!==e.inboundNodes[0].outputTensors.length)throw new Dg("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[e.inboundNodes[0].outputTensors[0]],this.inputs=Tb(this.outputs[0])}this.inboundNodes=[],new Nb({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:zg(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs[0].shape})}else{const t=e.apply(this.outputs[0]);if(Array.isArray(t))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[t],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(e),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const e=this.layers.length-1;this.layers[e].outboundNodes=[],this.outputs=[this.layers[e].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(e,t){return null==this.model&&this.build(),this.model.call(e,t)}build(e){if(mb(e),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new aw({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(e,t,n=console.log){this.built||this.build(),super.summary(e,t,n)}setWeights(e){null==this.model&&this.build(),this.model.setWeights(e)}evaluate(e,t,n={}){if(!this.built)throw new Fg("The model needs to be compiled before being used.");return this.model.evaluate(e,t,n)}async evaluateDataset(e,t){if(!this.built)throw new Fg("The model needs to be compiled before being used.");return this.model.evaluateDataset(e,t)}predict(e,t={}){return null==this.model&&this.build(),this.model.predict(e,t)}predictOnBatch(e){return null==this.model&&this.build(),this.model.predictOnBatch(e)}compile(e){this.build(),this.model.compile(e),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(e){this.model.optimizer=e}async fit(e,t,n={}){if(!this.built)throw new Fg("The model needs to be compiled before being used.");return this.model.fit(e,t,n)}async fitDataset(e,t){if(!this.built)throw new Fg("The model needs to be compiled before being used.");return this.model.fitDataset(e,t)}async trainOnBatch(e,t){return this.model.trainOnBatch(e,t)}static fromConfig(e,t,n={},s=!1){let r,a={};if(t instanceof Array){if(null==t[0].className||"Merge"===t[0].className)throw new Dg("Legacy serialization format not supported yet.");r=t}else u(null!=t.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),r=t.layers,delete t.layers,a=t;const i=new e(a);if(!(i instanceof lw))throw new Og(`Sequential.fromConfig called on non-Sequential input: ${i}`);for(const e of r){const t=ax(e,void 0,s);s&&t.setFastWeightInitDuringBuild(!0),i.add(t)}return i}set stopTraining(e){if(null==this.model)throw new Dg("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=e}get stopTraining(){if(null==this.model)throw new Dg("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const e=[];for(const t of this.layers){const n={};n.className=t.getClassName(),n.config=t.getConfig(),e.push(n)}return{name:this.name,layers:e}}}function uw(e){return new aw(e)}function cw(e){return new lw(e)}function hw(e){return $b(e)}function pw(e,t){sx.registerCallbackConstructor(e,t)}lw.className="Sequential",pd(lw);let dw=class extends cd{getConfig(){return{}}};class fw extends dw{apply(e,t=1){return function(e,t=1){if(1!==t)throw new Og(`Support for alpha values other than 1 (${t}) is not implemented yet.`);return bl(e)}(e,t)}}fw.className="elu",pd(fw);class mw extends dw{apply(e){return Xc(e)}}mw.className="selu",pd(mw);class gw extends dw{apply(e){return Bc(e)}}gw.className="relu",pd(gw);class yw extends dw{apply(e){return Oa((()=>_u(6,Bc(e))))}}yw.className="relu6",pd(yw);class bw extends dw{apply(e){return e}}bw.className="linear",pd(bw);class xw extends dw{apply(e){return To(e)}}xw.className="sigmoid",pd(xw);class ww extends dw{apply(e){return function(e){return Oa((()=>{const t=Vi(.5,Hi(.2,e));return Wo(t,0,1)}))}(e)}}ww.className="hardSigmoid",pd(ww);class vw extends dw{apply(e){return du(e)}}vw.className="softplus",pd(vw);class kw extends dw{apply(e){return function(e){return Oa((()=>Gi(e,Vi(ji(e),1))))}(e)}}kw.className="softsign",pd(kw);class Nw extends dw{apply(e){return $o(e)}}Nw.className="tanh",pd(Nw);let Iw=class extends dw{apply(e,t=-1){return ah(e,t)}};Iw.className="softmax",pd(Iw);class Sw extends dw{apply(e,t=-1){return gu(e,t)}}Sw.className="logSoftmax",pd(Sw);class Tw extends dw{apply(e){return Oa((()=>Oa((()=>{const t=Math.sqrt(2),n=Hi(.5,Vi(1,wl(Gi(e,t))));return Hi(e,n)}))))}}Tw.className="gelu",pd(Tw);class Cw extends dw{apply(e){return Oa((()=>Hi(.5,Hi(e,Vi(1,$o(Hi(Fl(Gi(2,Math.PI)),Vi(e,Hi(.044715,Rl(e,3))))))))))}}Cw.className="gelu_new",pd(Cw);class $w extends dw{apply(e){return Oa((()=>Hi(e,$o(du(e)))))}}$w.className="mish",pd($w);class Ew extends dw{apply(e,t=1){return Oa((()=>Hi(To(Hi(e,t)),e)))}}function Aw(e){return e.getClassName()}function Rw(e,t={}){return Kg(e,hd.getMap().classNameMap,t,"activation")}function _w(e){if(null==e){const e={className:"linear",config:{}};return Rw(e)}if("string"==typeof e){const t={};return t.className=e,t.config={},Rw(t)}return e instanceof dw?e:Rw(e)}function Fw(e){if(null!=e&&"object"!=typeof e)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${e}`)}Ew.className="swish",pd(Ew);class Dw extends cd{}class Ow extends Dw{constructor(e){super(),Fw(e),this.l1=null==e||null==e.l1?.01:e.l1,this.l2=null==e||null==e.l2?.01:e.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return Oa((()=>{let t=Eu([1]);return this.hasL1&&(t=Vi(t,Ol(Hi(this.l1,ji(e))))),this.hasL2&&(t=Vi(t,Ol(Hi(this.l2,Py(e))))),vo(t,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(e,t){return new e({l1:t.l1,l2:t.l2})}}Ow.className="L1L2",pd(Ow);const Mw={l1l2:"L1L2"};function Lw(e){return jg(e)}function zw(e,t={}){return Kg(e,hd.getMap().classNameMap,t,"regularizer")}function Pw(e){if(null==e)return null;if("string"==typeof e){return zw({className:e in Mw?Mw[e]:e,config:{}})}return e instanceof Dw?e:zw(e)}class Bw extends Sb{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,null!=e&&(this.maxValue=e.maxValue)}call(e,t){e=fb(e);let n=Bc(e);return null!=this.maxValue&&(n=Wo(n,0,this.maxValue)),n}computeOutputShape(e){return e}getConfig(){const e={maxValue:this.maxValue},t=super.getConfig();return Object.assign(e,t),e}}Bw.className="ReLU",pd(Bw);class Ww extends Sb{constructor(e){super(null==e?{}:e),this.DEFAULT_ALPHA=.3,null==e&&(e={}),this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=fb(e);return Jl(n,this.alpha)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Ww.className="LeakyReLU",pd(Ww);class Vw extends Sb{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==e&&(e={}),this.supportsMasking=!0,this.alphaInitializer=hb(e.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Pw(e.alphaRegularizer),this.alphaConstraint=Hb(e.alphaConstraint),null==e.sharedAxes)this.sharedAxes=null;else if(Array.isArray(e.sharedAxes))this.sharedAxes=e.sharedAxes;else{if("number"!=typeof e.sharedAxes)throw new Dg(`Expected sharedAxes to be a number or an array of numbers, but got ${e.sharedAxes}`);this.sharedAxes=[e.sharedAxes]}}build(e){const t=(e=mb(e)).slice(1);if(null!=this.sharedAxes)for(const e of this.sharedAxes)t[e-1]=1;this.alpha=this.addWeight("alpha",t,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let t=1;t<e.length;++t)n[t]=e[t];this.inputSpec=[new wb({ndim:e.length,axes:n})],this.built=!0}call(e,t){return e=fb(e),Xu(e,this.alpha.read())}getConfig(){const e={alphaInitializer:cb(this.alphaInitializer),alphaRegularizer:Lw(this.alphaRegularizer),alphaConstraint:Ub(this.alphaConstraint),sharedAxes:this.sharedAxes},t=super.getConfig();return Object.assign(e,t),e}}Vw.className="PReLU",pd(Vw);let Uw=class extends Sb{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA=1,null==e&&(e={}),null!=e.alpha&&e.alpha!==this.DEFAULT_ALPHA)throw new Og(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=fb(e);return bl(n)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}};Uw.className="ELU",pd(Uw);class Gw extends Sb{constructor(e){super(null==e?{}:e),this.DEFAULT_THETA=1,null==e&&(e={}),this.theta=null==e.theta?this.DEFAULT_THETA:e.theta}call(e,t){const n=fb(e);return Hi(n,Pi(jl(n,this.theta),"float32"))}computeOutputShape(e){return e}getConfig(){const e={theta:this.theta},t=super.getConfig();return Object.assign(e,t),e}}Gw.className="ThresholdedReLU",pd(Gw);class Hw extends Sb{constructor(e){super(null==e?{}:e),this.DEFAULT_AXIS=1,null==e&&(e={}),this.softmax=(new Iw).apply,this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis}call(e,t){return Oa((()=>{let n=fb(e);const s=t.mask;if(null!=s){const e=Hi(mu(Au(n.shape),Pi(s,n.dtype)),_l(-1e9));n=Vi(n,e)}return this.axis instanceof Array?this.axis.length>1?Pl(mu(n,yu(n,this.axis,!0))):this.softmax(n,this.axis[0]):this.softmax(n,this.axis)}))}computeOutputShape(e){return e}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function jw(e,t,n){if("number"==typeof e)return zg(e,t);if(e.length!==t)throw new Dg(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);for(let r=0;r<t;++r){const a=e[r];if((s=a)!==parseInt(s.toString(),10))throw new Dg(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number ${a}`)}return e;var s}function qw(e,t,n,s,r=1){if(null==e)return e;let a;return a="same"===n?e:e-(t+(t-1)*(r-1))+1,Math.floor((a+s-1)/s)}function Kw(e,t,n,s){if(null==e)return null;if("valid"===s)e=e*t+Iy([n-t,0]);else{if("same"!==s)throw new Dg(`Unsupport padding mode: ${s}.`);e*=t}return e}function Xw(e,t){return Oa((()=>(dy(t),"channelsFirst"===t?zh(e,[0,2,3,1]):e)))}function Yw(e,t){return Oa((()=>(dy(t),"channelsFirst"===t?zh(e,[0,2,3,4,1]):e)))}function Zw(e,t,n,s=1,r="valid",a,i=1){return Oa((()=>{if(null==a&&(a="channelsLast"),dy(a),3!==e.shape.length)throw new Dg(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);if(3!==t.shape.length)throw new Dg(`The kernel for a conv1dWithBias operation should be 3, but is ${t.shape.length} instead`);if(null!=n&&1!==n.shape.length)throw new Dg(`The bias for a conv1dWithBias operation should be 1, but is ${n.shape.length} instead`);if("channelsFirst"===a&&(e=zh(e,[0,2,1])),"causal"===r)throw new Og("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=qo(e,t,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=Wy(o,n)),o}))}function Jw(e,t,n,s=[1,1],r="valid",a,i,o=null){return Oa((()=>{if(null==a&&(a="channelsLast"),dy(a),3!==e.rank&&4!==e.rank)throw new Dg(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==t.rank&&4!==t.rank)throw new Dg(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let l=Xw(e,a);if("causal"===r)throw new Og("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=Jh({x:l,filter:t,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=zh(l,[0,3,1,2])),l}))}function Qw(e,t,n,s=[1,1,1],r="valid",a,i){return Oa((()=>{if(null==a&&(a="channelsLast"),dy(a),4!==e.rank&&5!==e.rank)throw new Dg(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);if(4!==t.rank&&5!==t.rank)throw new Dg(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);let o=Yw(e,a);if("causal"===r)throw new Og("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=Yo(o,t,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=Wy(o,n)),"channelsFirst"===a&&(o=zh(o,[0,4,1,2,3])),o}))}Hw.className="Softmax",pd(Hw);class ev extends Sb{constructor(e,t){if(super(t),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",ev.verifyArgs(t),this.rank=e,ey(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new Og(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=jw(t.kernelSize,e,"kernelSize"),this.strides=jw(null==t.strides?1:t.strides,e,"strides"),this.padding=null==t.padding?"valid":t.padding,fy(this.padding),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,dy(this.dataFormat),this.activation=_w(t.activation),this.useBias=null==t.useBias||t.useBias,this.biasInitializer=hb(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Hb(t.biasConstraint),this.biasRegularizer=Pw(t.biasRegularizer),this.activityRegularizer=Pw(t.activityRegularizer),this.dilationRate=jw(null==t.dilationRate?1:t.dilationRate,e,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Dg(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Dg(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Dg(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(e){if(Pg("kernelSize"in e,"required key 'kernelSize' not in config"),"number"!=typeof e.kernelSize&&!Qg(e.kernelSize,"number",1,3))throw new Dg(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`)}getConfig(){const e={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:Aw(this.activation),useBias:this.useBias,biasInitializer:cb(this.biasInitializer),biasRegularizer:Lw(this.biasRegularizer),activityRegularizer:Lw(this.activityRegularizer),biasConstraint:Ub(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}class tv extends ev{constructor(e,t){super(e,t),this.kernel=null,tv.verifyArgs(t),this.filters=t.filters,ey(this.filters,"filters"),this.kernelInitializer=hb(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Hb(t.kernelConstraint),this.kernelRegularizer=Pw(t.kernelRegularizer)}build(e){e=mb(e);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Dg(`The channel dimension of the input should be defined. Found ${e[t]}`);const n=e[t],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[t]:n}}],this.built=!0}call(e,t){return Oa((()=>{let t;e=fb(e);const n=null==this.bias?null:this.bias.read(),s=ny(this.activation.getClassName());if(null!=s&&2===this.rank)t=Jw(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)t=Zw(e,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)t=Jw(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new Og("convolutions greater than 3D are not implemented yet.");t=Qw(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(t=this.activation.apply(t))}return t}))}computeOutputShape(e){e=mb(e);const t=[],n="channelsLast"===this.dataFormat?e.slice(1,e.length-1):e.slice(2);for(let e=0;e<n.length;++e){const s=qw(n[e],this.kernelSize[e],this.padding,this.strides[e],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[e]);t.push(s)}let s=[e[0]];return"channelsLast"===this.dataFormat?(s=s.concat(t),s.push(this.filters)):(s.push(this.filters),s=s.concat(t)),s}getConfig(){const e={filters:this.filters,kernelInitializer:cb(this.kernelInitializer),kernelRegularizer:Lw(this.kernelRegularizer),kernelConstraint:Ub(this.kernelConstraint)},t=super.getConfig();return Object.assign(e,t),e}static verifyArgs(e){if(!("filters"in e)||"number"!=typeof e.filters||e.filters<1)throw new Dg(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(e.filters)}`)}}class nv extends tv{constructor(e){super(2,e),nv.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Qg(e.kernelSize,"number",1,2))throw new Dg(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`)}}nv.className="Conv2D",pd(nv);class sv extends tv{constructor(e){super(3,e),sv.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&(!Array.isArray(e.kernelSize)||1!==e.kernelSize.length&&3!==e.kernelSize.length))throw new Dg(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`)}}sv.className="Conv3D",pd(sv);class rv extends nv{constructor(e){if(super(e),this.inputSpec=[new wb({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Dg(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(4!==(e=mb(e)).length)throw new Dg("Input should have rank 4; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Dg("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new wb({ndim:4,axes:{[t]:n}})],this.built=!0}call(e,t){return Oa((()=>{let t=fb(e);if(4!==t.shape.length)throw new Dg(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,Kw(i,c,l,this.padding),Kw(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=zh(t,[0,2,3,1]));let d=Xo(t,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=zh(d,[0,3,1,2])),null!=this.bias&&(d=Wy(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d}))}computeOutputShape(e){const t=(e=mb(e)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return t[n]=this.filters,t[s]=Kw(t[s],o,a,this.padding),t[r]=Kw(t[r],l,i,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}rv.className="Conv2DTranspose",pd(rv);class av extends sv{constructor(e){if(super(e),this.inputSpec=[new wb({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new Dg(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(5!==(e=mb(e)).length)throw new Dg("Input should have rank 5; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Dg("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new wb({ndim:5,axes:{[t]:n}})],this.built=!0}call(e,t){return Oa((()=>{let t=fb(e);if(5!==t.shape.length)throw new Dg(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a,i;"channelsFirst"===this.dataFormat?(i=2,r=3,a=4):(i=1,r=2,a=3);const o=n[i],l=n[r],u=n[a],c=this.kernelSize[0],h=this.kernelSize[1],p=this.kernelSize[2],d=this.strides[0],f=this.strides[1],m=this.strides[2],g=[s,Kw(o,d,c,this.padding),Kw(l,f,h,this.padding),Kw(u,m,p,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=zh(t,[0,2,3,4,1]));let y=Jo(t,this.kernel.read(),g,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(y=zh(y,[0,4,1,2,3])),null!==this.bias&&(y=Wy(y,this.bias.read(),this.dataFormat)),null!==this.activation&&(y=this.activation.apply(y)),y}))}computeOutputShape(e){const t=(e=mb(e)).slice();let n,s,r,a;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,a=4):(n=4,s=1,r=2,a=3);const i=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],c=this.strides[1],h=this.strides[2];return t[n]=this.filters,t[s]=Kw(t[s],u,i,this.padding),t[r]=Kw(t[r],c,o,this.padding),t[a]=Kw(t[a],h,l,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}av.className="Conv3DTranspose",pd(av);class iv extends tv{constructor(e,t){if(super(e,t),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==t.filters)throw new Dg("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=t.kernelInitializer||null!=t.kernelRegularizer||null!=t.kernelConstraint)throw new Dg("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=t.padding&&"same"!==t.padding&&"valid"!==t.padding)throw new Dg(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(t.padding)}`);this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=hb(t.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Pw(t.depthwiseRegularizer),this.depthwiseConstraint=Hb(t.depthwiseConstraint),this.pointwiseInitializer=hb(t.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Pw(t.pointwiseRegularizer),this.pointwiseConstraint=Hb(t.pointwiseConstraint)}build(e){if((e=mb(e)).length<this.rank+2)throw new Dg(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(e)}`);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t]||e[t]<0)throw new Dg(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(e[t])}`);const n=e[t],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let e=0;e<this.rank;++e)r.push(1);r.push(n*this.depthMultiplier,this.filters);const a=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,a,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,a,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,a,this.biasConstraint):this.bias=null,this.inputSpec=[new wb({ndim:this.rank+2,axes:{[t]:n}})],this.built=!0}call(e,t){return Oa((()=>{let t;if(e=fb(e),1===this.rank)throw new Og("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=zh(e,[0,2,3,1])),t=Yc(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(t=Wy(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),"channelsFirst"===this.dataFormat&&(t=zh(t,[0,3,1,2])),t}))}getConfig(){const e=super.getConfig();return delete e.rank,delete e.kernelInitializer,delete e.kernelRegularizer,delete e.kernelConstraint,e.depthwiseInitializer=cb(this.depthwiseInitializer),e.pointwiseInitializer=cb(this.pointwiseInitializer),e.depthwiseRegularizer=Lw(this.depthwiseRegularizer),e.pointwiseRegularizer=Lw(this.pointwiseRegularizer),e.depthwiseConstraint=Ub(this.depthwiseConstraint),e.pointwiseConstraint=Ub(this.pointwiseConstraint),e}}iv.className="SeparableConv";class ov extends iv{constructor(e){super(2,e)}}ov.className="SeparableConv2D",pd(ov);class lv extends tv{constructor(e){super(1,e),lv.verifyArgs(e),this.inputSpec=[{ndim:3}]}getConfig(){const e=super.getConfig();return delete e.rank,delete e.dataFormat,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Qg(e.kernelSize,"number",1,1))throw new Dg(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`)}}lv.className="Conv1D",pd(lv);class uv extends Sb{constructor(e){super(e),"number"==typeof e.cropping?this.cropping=[[e.cropping,e.cropping],[e.cropping,e.cropping]]:"number"==typeof e.cropping[0]?this.cropping=[[e.cropping[0],e.cropping[0]],[e.cropping[1],e.cropping[1]]]:this.cropping=e.cropping,this.dataFormat=void 0===e.dataFormat?"channelsLast":e.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(e){return"channelsFirst"===this.dataFormat?[e[0],e[1],e[2]-this.cropping[0][0]-this.cropping[0][1],e[3]-this.cropping[1][0]-this.cropping[1][1]]:[e[0],e[1]-this.cropping[0][0]-this.cropping[0][1],e[2]-this.cropping[1][0]-this.cropping[1][1],e[3]]}call(e,t){return Oa((()=>{if(e=fb(e),"channelsLast"===this.dataFormat){const t=_y(e,this.cropping[0][0],e.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return _y(t,this.cropping[1][0],e.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const t=_y(e,this.cropping[0][0],e.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return _y(t,this.cropping[1][0],e.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const e={cropping:this.cropping,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}uv.className="Cropping2D",pd(uv);class cv extends Sb{constructor(e){var t;super(e),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==e.size?this.DEFAULT_SIZE:e.size,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,dy(this.dataFormat),this.interpolation=null==e.interpolation?"nearest":e.interpolation,t=this.interpolation,Jg(ly,"InterpolationFormat",t)}computeOutputShape(e){if("channelsFirst"===this.dataFormat){const t=null==e[2]?null:this.size[0]*e[2],n=null==e[3]?null:this.size[1]*e[3];return[e[0],e[1],t,n]}{const t=null==e[1]?null:this.size[0]*e[1],n=null==e[2]?null:this.size[1]*e[2];return[e[0],t,n,e[3]]}}call(e,t){return Oa((()=>{let t=fb(e);const n=t.shape;if("channelsFirst"===this.dataFormat){t=zh(t,[0,2,3,1]);const e=this.size[0]*n[2],s=this.size[1]*n[3],r="nearest"===this.interpolation?sd.resizeNearestNeighbor(t,[e,s]):sd.resizeBilinear(t,[e,s]);return zh(r,[0,3,1,2])}{const e=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?sd.resizeNearestNeighbor(t,[e,s]):sd.resizeBilinear(t,[e,s])}}))}getConfig(){const e={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},t=super.getConfig();return Object.assign(e,t),e}}cv.className="UpSampling2D",pd(cv);class hv extends ev{constructor(e){super(2,e),this.depthwiseKernel=null,this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=hb(e.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Hb(e.depthwiseConstraint),this.depthwiseRegularizer=Pw(e.depthwiseRegularizer)}build(e){if((e=mb(e)).length<4)throw new Dg(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);const t="channelsFirst"===this.dataFormat?1:3;if(null==e[t]||e[t]<0)throw new Dg(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);const n=e[t],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Oa((()=>{let t=function(e,t,n=[1,1],s="valid",r,a){return Oa((()=>{null==r&&(r="channelsLast"),dy(r);let i=Xw(e,r);if(4!==e.rank)throw new Dg(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);if(4!==t.rank)throw new Dg(`depthwiseKernel is required to be 4-D, but is instead ${t.rank}-D`);return i=al(i,t,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=zh(i,[0,3,1,2])),i}))}(e=fb(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(t=Wy(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),t}))}computeOutputShape(e){e=mb(e);const t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[1]*this.depthMultiplier:e[3]*this.depthMultiplier,r=qw(t,this.kernelSize[0],this.padding,this.strides[0]),a=qw(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[e[0],s,r,a]:[e[0],r,a,s]}getConfig(){const e=super.getConfig();return e.depthMultiplier=this.depthMultiplier,e.depthwiseInitializer=cb(this.depthwiseInitializer),e.depthwiseRegularizer=Lw(this.depthwiseRegularizer),e.depthwiseConstraint=Ub(this.depthwiseRegularizer),e}}function pv(e,t,n,s){if(Array.isArray(e)){if(null!=t||null!=n)throw new Dg("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=e.slice(e.length-s,e.length),e=e.slice(0,e.length-s)),e.length>1&&(t=e.slice(1,e.length)),e=e[0]}function r(e){return null==e||Array.isArray(e)?e:[e]}return{inputs:e,initialState:t=r(t),constants:n=r(n)}}function dv(e,t,n,s=!1,r,a,i=!1,o=!1){return Oa((()=>{const l=t.shape.length;if(l<3)throw new Dg(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(Sy(2,l));if(t=zh(t,u),null!=a)throw new Og("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=Pi(Pi(r,"bool"),"float32")).rank===l-1&&(r=Bl(r,-1)),r=zh(r,u)),s&&(t=Vc(t,0),null!=r&&(r=Vc(r,0)));const c=[];let h,p=n;const d=t.shape[0],f=_h(t);let m,g;null!=r&&(m=_h(r));for(let t=0;t<d;++t){const n=f[t],s=Oa((()=>e(n,p)));if(null==r)h=s[0],p=s[1];else{const e=Oa((()=>{const e=m[t],n=mu(Bu(e),e);return{output:Vi(Hi(s[0],e),Hi(p[0],n)),newStates:p.map(((t,r)=>Vi(Hi(s[1][r],e),Hi(t,n))))}}));h=e.output,p=e.newStates}o&&c.push(h)}if(o){g=dh(c,1)}return[h,g,p]}))}hv.className="DepthwiseConv2D",pd(hv);class fv extends Sb{constructor(e){let t;if(super(e),null==e.cell)throw new Dg("cell property is missing for the constructor of RNN.");if(t=Array.isArray(e.cell)?new kv({cells:e.cell}):e.cell,null==t.stateSize)throw new Dg("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=t,this.returnSequences=null!=e.returnSequences&&e.returnSequences,this.returnState=null!=e.returnState&&e.returnState,this.goBackwards=null!=e.goBackwards&&e.goBackwards,this._stateful=null!=e.stateful&&e.stateful,this.unroll=null!=e.unroll&&e.unroll,this.supportsMasking=!0,this.inputSpec=[new wb({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return Sy(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((e=>null))}return this.states_}setStates(e){this.states_=e}computeOutputShape(e){pb(e)&&(e=e[0]);let t=this.cell.stateSize;Array.isArray(t)||(t=[t]);const n=t[0];let s;if(s=this.returnSequences?[e[0],e[1],n]:[e[0],n],this.returnState){const n=[];for(const s of t)n.push([e[0],s]);return[s].concat(n)}return s}computeMask(e,t){return Oa((()=>{Array.isArray(t)&&(t=t[0]);const e=this.returnSequences?t:null;if(this.returnState){const t=this.states.map((e=>null));return[e].concat(t)}return e}))}get states(){if(null==this.states_){const e=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,t=[];for(let n=0;n<e;++n)t.push(null);return t}return this.states_}set states(e){this.states_=e}build(e){if(null!=this.numConstants)throw new Og("Constants support is not implemented in RNN yet.");pb(e)&&(e=e[0]);const t=this.stateful?e[0]:null,n=e.slice(2);this.inputSpec[0]=new wb({shape:[t,null,...n]});const s=[e[0]].concat(e.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!f(this.stateSpec.map((e=>e.shape[e.shape.length-1])),r))throw new Dg(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=r.map((e=>new wb({shape:[null,e]})));this.stateful&&this.resetStates()}resetStates(e,t=!1){Oa((()=>{if(!this.stateful)throw new _g("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new Dg("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>Eu([n,e]))):this.states_=[Eu([n,this.cell.stateSize])];else if(null==e)Ma(this.states_),null!=this.keptStates&&(Ma(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>Eu([n,e]))):this.states_[0]=Eu([n,this.cell.stateSize]);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Dg(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);!0===t?this.keptStates.push(this.states_.slice()):Ma(this.states_);for(let t=0;t<this.states_.length;++t){const s=e[t],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[n,r];if(!f(s.shape,a))throw new Dg(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map((e=>La(e.clone())))}))}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=pv(e,n,s,this.numConstants);e=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){t.initialState=n,a=a.concat(n),this.stateSpec=[];for(const e of n)this.stateSpec.push(new wb({shape:e.shape}));i=i.concat(this.stateSpec)}null!=s&&(t.constants=s,a=a.concat(s),this.numConstants=s.length);if(a[0]instanceof vb){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return Oa((()=>{const n=null==t?null:t.mask,s=null==t?null:t.training;let r=null==t?null:t.initialState;e=fb(e),null==r&&(r=this.stateful?this.states_:this.getInitialState(e));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new Dg(`RNN Layer has ${a} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=dv(((e,t)=>{const n=this.cell.call([e].concat(t),i);return[n[0],n.slice(1)]}),e,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h}))}getInitialState(e){return Oa((()=>{let t=Eu(e.shape);return t=Ol(t,[1,2]),t=Ey(t),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((e=>e>1?Oy(t,[1,e]):t)):this.cell.stateSize>1?[Oy(t,[1,this.cell.stateSize])]:[t]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(e)}getConfig(){const e=super.getConfig(),t={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(t.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===fv.className&&(t.cell={className:this.cell.getClassName(),config:n}),Object.assign(Object.assign(Object.assign({},n),e),t)}static fromConfig(e,t,n={}){const s=ax(t.cell,n);return new e(Object.assign(t,{cell:s}))}}fv.className="RNN",pd(fv);class mv extends Sb{}class gv extends mv{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,ey(this.units,"units"),this.activation=_w(null==e.activation?this.DEFAULT_ACTIVATION:e.activation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=hb(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=hb(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=hb(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Pw(e.kernelRegularizer),this.recurrentRegularizer=Pw(e.recurrentRegularizer),this.biasRegularizer=Pw(e.biasRegularizer),this.kernelConstraint=Hb(e.kernelConstraint),this.recurrentConstraint=Hb(e.recurrentConstraint),this.biasConstraint=Hb(e.biasConstraint),this.dropout=Ny([1,Iy([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=Ny([1,Iy([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){e=mb(e),this.kernel=this.addWeight("kernel",[e[e.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Oa((()=>{if(2!==e.length)throw new Dg(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let n=e[1];e=e[0];const s=null!=t.training&&t.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Nv({ones:()=>Bu(e),rate:this.dropout,training:s,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Nv({ones:()=>Bu(n),rate:this.recurrentDropout,training:s,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Ly(null!=a?Hi(e,a):e,this.kernel.read()),null!=this.bias&&(r=Wy(r,this.bias.read())),null!=i&&(n=Hi(n,i));let o=Vi(r,Ly(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:Aw(this.activation),useBias:this.useBias,kernelInitializer:cb(this.kernelInitializer),recurrentInitializer:cb(this.recurrentInitializer),biasInitializer:cb(this.biasInitializer),kernelRegularizer:Lw(this.kernelRegularizer),recurrentRegularizer:Lw(this.recurrentRegularizer),biasRegularizer:Lw(this.biasRegularizer),activityRegularizer:Lw(this.activityRegularizer),kernelConstraint:Ub(this.kernelConstraint),recurrentConstraint:Ub(this.recurrentConstraint),biasConstraint:Ub(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign(Object.assign({},e),t)}}gv.className="SimpleRNNCell",pd(gv);class yv extends fv{constructor(e){e.cell=new gv(e),super(e)}call(e,t){return Oa((()=>{null!=this.cell.dropoutMask&&(Ma(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Ma(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return new e(t)}}yv.className="SimpleRNN",pd(yv);class bv extends mv{constructor(e){if(super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",e.resetAfter)throw new Dg("GRUCell does not support reset_after parameter set to true.");this.units=e.units,ey(this.units,"units"),this.activation=_w(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=_w(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=hb(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=hb(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=hb(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Pw(e.kernelRegularizer),this.recurrentRegularizer=Pw(e.recurrentRegularizer),this.biasRegularizer=Pw(e.biasRegularizer),this.kernelConstraint=Hb(e.kernelConstraint),this.recurrentConstraint=Hb(e.recurrentConstraint),this.biasConstraint=Hb(e.biasConstraint),this.dropout=Ny([1,Iy([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=Ny([1,Iy([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.implementation=e.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){const t=(e=mb(e))[e.length-1];this.kernel=this.addWeight("kernel",[t,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Oa((()=>{if(2!==e.length)throw new Dg(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);const n=null!=t.training&&t.training;let s=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Nv({ones:()=>Bu(e),rate:this.dropout,training:n,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Nv({ones:()=>Bu(s),rate:this.recurrentDropout,training:n,count:3,dropoutFunc:this.dropoutFunc}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(e=Hi(e,r[0]));let u=Ly(e,this.kernel.read());this.useBias&&(u=Wy(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=Hi(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=uh(c,[2*this.units,this.units],c.rank-1),d=Ly(s,h),[f,m,g]=uh(u,3,u.rank-1),[y,b]=uh(d,2,d.rank-1);i=this.recurrentActivation.apply(Vi(f,y)),o=this.recurrentActivation.apply(Vi(m,b));const x=Ly(Hi(o,s),p);l=this.activation.apply(Vi(g,x));const w=Vi(Hi(i,s),Hi(Vi(1,pu(i)),l));return[w,w]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:Aw(this.activation),recurrentActivation:Aw(this.recurrentActivation),useBias:this.useBias,kernelInitializer:cb(this.kernelInitializer),recurrentInitializer:cb(this.recurrentInitializer),biasInitializer:cb(this.biasInitializer),kernelRegularizer:Lw(this.kernelRegularizer),recurrentRegularizer:Lw(this.recurrentRegularizer),biasRegularizer:Lw(this.biasRegularizer),activityRegularizer:Lw(this.activityRegularizer),kernelConstraint:Ub(this.kernelConstraint),recurrentConstraint:Ub(this.recurrentConstraint),biasConstraint:Ub(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign(Object.assign({},e),t)}}bv.className="GRUCell",pd(bv);class xv extends fv{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new bv(e),super(e)}call(e,t){return Oa((()=>{null!=this.cell.dropoutMask&&(Ma(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Ma(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}xv.className="GRU",pd(xv);class wv extends mv{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,ey(this.units,"units"),this.activation=_w(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=_w(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=hb(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=hb(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=hb(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=e.unitForgetBias,this.kernelRegularizer=Pw(e.kernelRegularizer),this.recurrentRegularizer=Pw(e.recurrentRegularizer),this.biasRegularizer=Pw(e.biasRegularizer),this.kernelConstraint=Hb(e.kernelConstraint),this.recurrentConstraint=Hb(e.recurrentConstraint),this.biasConstraint=Hb(e.biasConstraint),this.dropout=Ny([1,Iy([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=Ny([1,Iy([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.implementation=e.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){var t;const n=(e=mb(e))[e.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const e=this.biasInitializer,n=this.units;s=new((t=class extends jy{apply(t,s){const r=e.apply([n]),a=(new Ky).apply([n]),i=e.apply([2*n]);return Dy(Dy(r,a),i)}}).className="CustomInit",t)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,t){return Oa((()=>{const n=null!=t.training&&t.training;if(3!==e.length)throw new Dg(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);let s=e[1];const r=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Nv({ones:()=>Bu(e),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Nv({ones:()=>Bu(s),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(e=Hi(e,a[0]));let h=Ly(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=Hi(s,i[0])),h=Vi(h,Ly(s,this.recurrentKernel.read())),this.useBias&&(h=Wy(h,this.bias.read()));const[p,d,f,m]=uh(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=Vi(Hi(l,r),Hi(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=Hi(c,this.activation.apply(u));return[g,g,u]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:Aw(this.activation),recurrentActivation:Aw(this.recurrentActivation),useBias:this.useBias,kernelInitializer:cb(this.kernelInitializer),recurrentInitializer:cb(this.recurrentInitializer),biasInitializer:cb(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Lw(this.kernelRegularizer),recurrentRegularizer:Lw(this.recurrentRegularizer),biasRegularizer:Lw(this.biasRegularizer),activityRegularizer:Lw(this.activityRegularizer),kernelConstraint:Ub(this.kernelConstraint),recurrentConstraint:Ub(this.recurrentConstraint),biasConstraint:Ub(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign(Object.assign({},e),t)}}wv.className="LSTMCell",pd(wv);class vv extends fv{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new wv(e),super(e)}call(e,t){return Oa((()=>{null!=this.cell.dropoutMask&&(Ma(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Ma(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}vv.className="LSTM",pd(vv);class kv extends mv{constructor(e){super(e),this.cells=e.cells}get stateSize(){const e=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?e.push(...t.stateSize):e.push(t.stateSize);return e}call(e,t){return Oa((()=>{let n=e.slice(1);const s=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?s.push(n.splice(0,e.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[e[0]].concat(n):[a[0]].concat(n),a=o.call(a,t),r.push(a.slice(1))}n=[];for(const e of r.slice().reverse())n.push(...e);return[a[0]].concat(n)}))}build(e){let t;pb(e)&&(e=e[0]),this.cells.forEach(((n,s)=>{yy(`RNNCell_${s}`,(()=>{n.build(e),t=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,e=[e[0],t]}))})),this.built=!0}getConfig(){const e=super.getConfig(),t={cells:this.cells.map((e=>({className:e.getClassName(),config:e.getConfig()})))};return Object.assign(Object.assign({},e),t)}static fromConfig(e,t,n={}){const s=[];for(const e of t.cells)s.push(ax(e,n));return new e({cells:s})}get trainableWeights(){if(!this.trainable)return[];const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.cells)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t.concat(e)}return e}getWeights(){const e=[];for(const t of this.cells)e.push(...t.weights);return bb(e)}setWeights(e){const t=[];for(const n of this.cells){const s=n.weights.length,r=e.splice(s);for(let e=0;e<n.weights.length;++e)t.push([n.weights[e],r[e]])}xb(t)}}function Nv(e){const{ones:t,rate:n,training:s=!1,count:r=1,dropoutFunc:a}=e,i=()=>null!=a?a(t(),n):Vy(t(),n),o=()=>Uy(i,t,s);if(!r||r<=1)return La(o().clone());return Array(r).fill(void 0).map(o).map((e=>La(e.clone())))}kv.className="StackedRNNCells",pd(kv);var Iv=function(e,t){var n={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(n[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(e);r<s.length;r++)t.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(e,s[r])&&(n[s[r]]=e[s[r]])}return n};class Sv extends fv{constructor(e){if(e.unroll)throw new Og("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(e.cell))throw new Og("It is not possible at the moment to stack convolutional cells.");super(e),this.inputSpec=[new wb({ndim:5})]}call(e,t){return Oa((()=>{if(null!=this.cell.dropoutMask&&(Ma(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Ma(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),t&&t.constants)throw new Dg("ConvRNN2D cell does not support constants");const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}computeOutputShape(e){let t=this.computeSingleOutputShape(e);return this.returnSequences||(t=[t[0],...t.slice(2)]),this.returnState&&(t=[t,...Array(2).fill([e[0],...t.slice(-3)])]),t}getInitialState(e){return Oa((()=>{const{stateSize:t}=this.cell,n=e.shape,s=this.computeSingleOutputShape(n),r=Eu([s[0],...s.slice(2)]);return Array.isArray(t)?Array(t.length).fill(r):[r]}))}resetStates(e,t=!1){Oa((()=>{if(!this.stateful)throw new _g("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new Dg("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>Eu(r))):this.states_=[Eu(r)];else if(null==e)Ma(this.states_),null!=this.keptStates&&(Ma(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>Eu(r))):this.states_[0]=Eu(r);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Dg(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);t?this.keptStates.push(this.states_.slice()):Ma(this.states_);for(let t=0;t<this.states_.length;++t){const n=e[t],s=r;if(!f(n.shape,s))throw new Dg(`State ${t} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[t]=n}}this.states_=this.states_.map((e=>La(e.clone())))}))}computeSingleOutputShape(e){const{dataFormat:t,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===t,l=e[o?3:2],u=e[o?4:3],c=qw(l,s[0],r,a[0],i[0]),h=qw(u,s[1],r,a[1],i[1]);return[...e.slice(0,2),...o?[n,c,h]:[c,h,n]]}}Sv.className="ConvRNN2D";class Tv extends wv{constructor(e){const{filters:t,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=e;super(Object.assign(Object.assign({},e),{units:t})),this.filters=t,ey(this.filters,"filters"),this.kernelSize=jw(n,2,"kernelSize"),this.kernelSize.forEach((e=>ey(e,"kernelSize"))),this.strides=jw(s||1,2,"strides"),this.strides.forEach((e=>ey(e,"strides"))),this.padding=r||"valid",fy(this.padding),this.dataFormat=a||"channelsLast",dy(this.dataFormat),this.dilationRate=jw(i||1,2,"dilationRate"),this.dilationRate.forEach((e=>ey(e,"dilationRate")))}build(e){var t;e=mb(e);const n="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[n])throw new Dg(`The channel dimension of the input should be defined. Found ${e[n]}`);const s=e[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;e=new((t=class extends jy{apply(e,t){return Fy([n.apply([s]),Au([s]),n.apply([2*s])])}}).className="CustomInit",t)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,t){return Oa((()=>{if(3!==e.length)throw new Dg(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);const n=t.training||!1,s=e[0],r=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Nv({ones:()=>Bu(s),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,o=(e,t,n)=>t&&t[n]?Hi(t[n],e):e;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Nv({ones:()=>Bu(r),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=uh(this.kernel.read(),4,3),[v,k,N,I]=this.useBias?uh(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,v,this.padding),u=this.inputConv(u,b,k,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[S,T,C,$]=uh(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,S),f=this.recurrentConv(f,T),m=this.recurrentConv(m,C),g=this.recurrentConv(g,$);const E=this.recurrentActivation.apply(Vi(l,d)),A=this.recurrentActivation.apply(Vi(u,f)),R=Vi(Hi(A,a),Hi(E,this.activation.apply(Vi(c,m)))),_=Hi(this.recurrentActivation.apply(Vi(h,g)),this.activation.apply(R));return[_,_,R]}))}getConfig(){const e=super.getConfig(),{units:t}=e,n=Iv(e,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign(Object.assign({},n),s)}inputConv(e,t,n,s){const r=jo(e,t,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?Wy(r,n,this.dataFormat):r}recurrentConv(e,t){return jo(e,t,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}Tv.className="ConvLSTM2DCell",pd(Tv);class Cv extends Sv{constructor(e){const t=new Tv(e);super(Object.assign(Object.assign({},e),{cell:t}))}static fromConfig(e,t){return new e(t)}}Cv.className="ConvLSTM2D",pd(Cv);class $v extends Sb{constructor(e){super(e),this.rate=Math.max(Math.min(e.rate,1),0),this.noiseShape=e.noiseShape,this.seed=e.seed,this.supportsMasking=!0}getNoiseShape(e){if(null==this.noiseShape)return this.noiseShape;const t=e.shape,n=[];for(let e=0;e<this.noiseShape.length;++e)n.push(null==this.noiseShape[e]?t[e]:this.noiseShape[e]);return n}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e);if(0<this.rate&&this.rate<1){const e=null!=t.training&&t.training,s=this.getNoiseShape(n);return Uy((()=>Vy(n,this.rate,s,this.seed)),(()=>n),e)}return e}))}getConfig(){const e={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},t=super.getConfig();return Object.assign(e,t),e}dispose(){return super.dispose()}}$v.className="Dropout",pd($v);class Ev extends $v{constructor(e){super(e),this.inputSpec=[{ndim:3}]}getNoiseShape(e){const t=e.shape;return[t[0],1,t[2]]}}Ev.className="SpatialDropout1D",pd(Ev);class Av extends Sb{constructor(e){if(super(e),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==e.batchInputShape&&null==e.inputShape&&null!=e.inputDim){let t=null;null!=e.batchSize&&(t=e.batchSize),this.batchInputShape=[t,e.inputDim]}this.units=e.units,ey(this.units,"units"),this.activation=_w(e.activation),null!=e.useBias&&(this.useBias=e.useBias),this.kernelInitializer=hb(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=hb(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Hb(e.kernelConstraint),this.biasConstraint=Hb(e.biasConstraint),this.kernelRegularizer=Pw(e.kernelRegularizer),this.biasRegularizer=Pw(e.biasRegularizer),this.activityRegularizer=Pw(e.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(e){const t=(e=mb(e))[e.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[t,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:t}}],this.built=!0}computeOutputShape(e){const t=(e=mb(e)).slice();return t[t.length-1]=this.units,t}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e),s=ny(this.activation.getClassName());let r;return null!=s?r=Ly(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Ly(n,this.kernel.read()),null!=this.bias&&(r=Wy(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const e={units:this.units,activation:Aw(this.activation),useBias:this.useBias,kernelInitializer:cb(this.kernelInitializer),biasInitializer:cb(this.biasInitializer),kernelRegularizer:Lw(this.kernelRegularizer),biasRegularizer:Lw(this.biasRegularizer),activityRegularizer:Lw(this.activityRegularizer),kernelConstraint:Ub(this.kernelConstraint),biasConstraint:Ub(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}Av.className="Dense",pd(Av);class Rv extends Sb{constructor(e){super(e=e||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=e.dataFormat}computeOutputShape(e){e=mb(e);for(const t of e.slice(1))if(null==t)throw new Dg(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[e[0],ky(e,1)]}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);let n=fb(e);if("channelsFirst"===this.dataFormat&&n.rank>1){const e=[0];for(let t=2;t<n.rank;++t)e.push(t);e.push(1),n=zh(n,e)}return function(e){if(e.rank<=1)throw new Dg(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const t=[e.shape[0],ky(e.shape,1)];return vo(e,t)}(n)}))}getConfig(){const e={};null!=this.dataFormat&&(e.dataFormat=this.dataFormat);const t=super.getConfig();return Object.assign(e,t),e}}Rv.className="Flatten",pd(Rv);class _v extends Sb{constructor(e){super(e),this.supportsMasking=!0,this.activation=_w(e.activation)}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e);return this.activation.apply(n)}))}getConfig(){const e={activation:Aw(this.activation)},t=super.getConfig();return Object.assign(e,t),e}}_v.className="Activation",pd(_v);class Fv extends Sb{constructor(e){super(e),this.n=e.n,this.inputSpec=[{ndim:2}]}computeOutputShape(e){return[e[0],this.n,e[1]]}call(e,t){return Oa((()=>{return e=fb(e),t=e,n=this.n,Oa((()=>{if(2!==t.shape.length)throw new Dg(`repeat() expects a rank-2 tensor, but received a rank-${t.shape.length} tensor.`);return Oy(Ey(t,1),[1,n,1])}));var t,n}))}getConfig(){const e={n:this.n},t=super.getConfig();return Object.assign(e,t),e}}Fv.className="RepeatVector",pd(Fv);class Dv extends Sb{constructor(e){super(e),this.targetShape=e.targetShape;for(let e=0;e<this.targetShape.length;++e)this.isUnknown(this.targetShape[e])&&(this.targetShape[e]=null)}isUnknown(e){return e<0||null==e}fixUnknownDimension(e,t){const n="Total size of new array must be unchanged.",s=t.slice();let r=1,a=null;for(let e=0;e<s.length;++e){const t=s[e];if(this.isUnknown(t)){if(null!==a)throw new Dg("Can only specifiy one unknown dimension.");a=e}else r*=t}const i=ky(e);if(null!==a){if(0===r||i%r!=0)throw new Dg(n);s[a]=i/r}else if(i!==r)throw new Dg(n);return s}computeOutputShape(e){let t=!1;for(let n=0;n<e.length;++n)if(this.isUnknown(e[n])){t=!0;break}return t?e.slice(0,1).concat(this.targetShape):e.slice(0,1).concat(this.fixUnknownDimension(e.slice(1),this.targetShape))}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return vo(n,r)}))}getConfig(){const e={targetShape:this.targetShape},t=super.getConfig();return Object.assign(e,t),e}}Dv.className="Reshape",pd(Dv);class Ov extends Sb{constructor(e){if(super(e),null==e.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(e.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${e.dims} instead.`);const t=Sy(1,e.dims.length+1);if(!f(e.dims.slice().sort(),t))throw new Error("Invalid permutation `dims`: "+JSON.stringify(e.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=e.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new wb({ndim:this.dims.length+1})]}computeOutputShape(e){const t=(e=mb(e)).slice();return this.dims.forEach(((n,s)=>{t[s+1]=e[n]})),t}call(e,t){return zh(fb(e),this.dimsIncludingBatch)}getConfig(){const e={dims:this.dims},t=super.getConfig();return Object.assign(e,t),e}}Ov.className="Permute",pd(Ov);class Mv extends Sb{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,this.maskValue=null!=e?null==e.maskValue?0:e.maskValue:0}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={maskValue:this.maskValue};return Object.assign(t,e),t}computeMask(e,t){const n=fb(e);return Zi(zu(n,this.maskValue),-1)}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e),s=Zi(zu(n,this.maskValue),-1,!0);return Hi(n,Pi(s,n.dtype))}))}}Mv.className="Masking",pd(Mv);class Lv extends Sb{constructor(e){if(super(e),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==e.batchInputShape&&null==e.inputShape){let t=null;null!=e.batchSize&&(t=e.batchSize),null==e.inputLength?this.batchInputShape=[t,null]:this.batchInputShape=[t].concat(Vg(e.inputLength))}this.inputDim=e.inputDim,ey(this.inputDim,"inputDim"),this.outputDim=e.outputDim,ey(this.outputDim,"outputDim"),this.embeddingsInitializer=hb(e.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Pw(e.embeddingsRegularizer),this.activityRegularizer=Pw(e.activityRegularizer),this.embeddingsConstraint=Hb(e.embeddingsConstraint),this.maskZero=e.maskZero,this.supportsMasking=e.maskZero,this.inputLength=e.inputLength}build(e){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(e){}computeMask(e,t){return Oa((()=>this.maskZero?(e=fb(e),zu(e,fl(e))):null))}computeOutputShape(e){if(e=mb(e),null==this.inputLength)return[...e,this.outputDim];const t=Vg(this.inputLength);if(t.length!==e.length-1)throw new Dg(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);{let n=0;for(let s=0;s<t.length;++s){const r=t[s],a=e[s+1];if(null!=r&&null!=a&&r!==a)throw new Dg(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);null==r&&(t[n]=a),n++}}return[e[0],...t,this.outputDim]}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);let n=fb(e);"int32"!==n.dtype&&(n=$y(n,"int32"));const s=zy(this.embeddings.read(),vo(n,[n.size]));return vo(s,mb(this.computeOutputShape(n.shape)))}))}getConfig(){const e={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:cb(this.embeddingsInitializer),embeddingsRegularizer:Lw(this.embeddingsRegularizer),activityRegularizer:Lw(this.activityRegularizer),embeddingsConstraint:Ub(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},t=super.getConfig();return Object.assign(e,t),e}}Lv.className="Embedding",pd(Lv);class zv extends Sb{constructor(e){super(e||{}),this.supportsMasking=!0}mergeFunction(e){throw new Og}computeElementwiseOpOutputShape(e,t){if(null==e||null==t)return null;if(e.length<t.length)return this.computeElementwiseOpOutputShape(t,e);if(0===t.length)return e;const n=e.slice(0,e.length-t.length);for(let s=0;s<t.length;++s){const r=e[e.length-t.length+s],a=t[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new Dg("Operands could not be broadcast together with shapes "+JSON.stringify(e)+" "+JSON.stringify(t));n.push(r)}}return n}build(e){if(Array.isArray(e)&&!Array.isArray(e[0])&&(e=[mb(e)]),e.length<2)throw new Dg(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);let t=[];for(const n of e)null!=n&&null!==n[0]&&t.push(n[0]);if(t=Yg(t),t.length>1)throw new Dg(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);let n=null==e[0]?null:e[0].slice(1);for(let t=1;t<e.length;++t){const s=null==e[t]?null:e[t].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=e.map((e=>e.length));-1===e.indexOf(null)&&1===Yg(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,t){return Oa((()=>{if(this.reshapeRequired){const t=[],n=e.map((e=>e.rank));if(-1===n.indexOf(null)){const s=Iy(n);for(let n of e){const e=n.rank;for(let t=0;t<s-e;++t)n=Ey(n,1);t.push(n)}return this.mergeFunction(t)}{let n=!1;for(const s of e){const e=s.rank;if(null==e){const e=s.shape,r=e[0],a=e.slice(1).concat([r]);let i=vo(s,[r].concat(ky(e.slice(1))));i=zh(i,[1,0]),i=vo(i,a),t.push(i),n=!0}else if(e>1){const r=Sy(1,e).concat([0]);t.push(zh(s,r)),n=!0}else t.push(s)}let s=this.mergeFunction(t);const r=s.rank;if(n)if(null==r){const e=s.shape,t=e[e.length-1],n=[t].concat(e.slice(0,e.length-1));s=vo(zh(vo(s,[-1,t]),[1,0]),n)}else if(r>1){const e=[r-1].concat(Sy(0,r-1));s=zh(s,e)}return s}}return this.mergeFunction(e)}))}computeOutputShape(e){let t;t=null==e[0]?null:e[0].slice(1);for(let n=1;n<e.length;++n){const s=null==e[n]?null:e[n].slice(1);t=this.computeElementwiseOpOutputShape(t,s)}let n=[];for(const t of e)null!=t&&null!==t[0]&&n.push(t[0]);return n=Yg(n),t=1===n.length?n.concat(t):[null].concat(t),t}computeMask(e,t){return Oa((()=>{if(null==t)return null;if(!Array.isArray(t))throw new Dg("`mask` should be an Array");if(!Array.isArray(e))throw new Dg("`inputs` should be an Array");if(t.length!==e.length)throw new Dg(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);if(t.every((e=>null==e)))return null;let n=(t=t.map((e=>null==e?e:Bl(e,0))))[0];for(let e=1;e<t.length-1;++e)n=bu(n,t[e]);return n}))}}class Pv extends zv{constructor(e){super(e)}mergeFunction(e){return Oa((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=Vi(t,e[n]);return t}))}}Pv.className="Add",pd(Pv);class Bv extends zv{constructor(e){super(e)}mergeFunction(e){return Oa((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=Hi(t,e[n]);return t}))}}Bv.className="Multiply",pd(Bv);class Wv extends zv{constructor(e){super(e)}mergeFunction(e){return Oa((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=Vi(t,e[n]);return Hi(1/e.length,t)}))}}Wv.className="Average",pd(Wv);class Vv extends zv{constructor(e){super(e)}mergeFunction(e){return Oa((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Cu(t,e[n]);return t}))}}Vv.className="Maximum",pd(Vv);class Uv extends zv{constructor(e){super(e)}mergeFunction(e){return Oa((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=_u(t,e[n]);return t}))}}Uv.className="Minimum",pd(Uv);class Gv extends zv{constructor(e){super(e),this.DEFAULT_AXIS=-1,null==e&&(e={}),this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){if(!Array.isArray(e)||!Array.isArray(e[0])||1===e.length)throw new Dg("A `Concatenate` layer should be called on a list of at least 2 inputs");let t=!0;for(const n of e)if(null!=n){t=!1;break}if(t)return;const n=[];for(let t=0;t<e.length;++t){const s=e[t].slice();s.splice(this.axis,1);let r=!1;for(const e of n)if(f(e,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new Dg("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(e))}mergeFunction(e){return Oa((()=>Fy(e,this.axis)))}computeOutputShape(e){if(!Array.isArray(e)||!Array.isArray(e[0]))throw new Dg("A `Concatenate` layer should be called on a list of inputs.");const t=e,n=t[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const e of t.slice(1)){if(null==n[s]||null==e[s]){n[s]=null;break}n[s]+=e[s]}return n}computeMask(e,t){if(null==t)return null;if(!Array.isArray(t))throw new Dg("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new Dg("`inputs` should be an array for Concatenate");if(t.length!==e.length)throw new Dg(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);return Oa((()=>{let n=!0;if(t.forEach((e=>{null==e||(n=!1)})),n)return null;const s=[];for(let n=0;n<e.length;++n)null==t[n]?s.push(Pi(Bu(e[n]),"bool")):t[n].rank<e[n].rank?s.push(Bl(t[n],-1)):s.push(t[n]);const r=Io(s,this.axis);return Yi(r,-1,!1)}))}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Hv(e,t){for(;e<0;)e+=t;return e}Gv.className="Concatenate",pd(Gv);class jv extends zv{constructor(e){super(e),this.axes=e.axes,this.normalize=null!=e.normalize&&e.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){u(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0],n=e[1];if(t.length>3||n.length>3)throw new Og("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);if(t[s[0]]!==n[s[1]])throw new Dg(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`)}mergeFunction(e){if(2!==e.length)throw new Dg(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let t,n=e[0],s=e[1];return t=Array.isArray(this.axes)?this.axes.map(((t,n)=>Hv(t,e[n].shape.length))):[Hv(this.axes,n.shape.length),Hv(this.axes,s.shape.length)],this.normalize&&(n=ix(n,t[0]),s=ix(s,t[1])),function(e,t,n){if(e.shape.length>3||t.shape.length>3)throw new Og("batchDot is not implemented for tensors of 4D or higher rank yet");if(u(e.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`)),u(e.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${t.shape.length}`)),"number"==typeof n&&(n=[n,n]),"complex64"===e.dtype||"complex64"===t.dtype)throw new Og("batchDot is not implemented for complex64-type Tensors yet.");const s=e.shape.length,r=t.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return Oa((()=>{let n,i;if(s>r){n=s-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=vo(t,t.shape.concat(e))}else if(r>s){n=r-s;const t=[];for(let e=0;e<n;++e)t.push(1);e=vo(e,e.shape.concat(t))}else n=0;if(2===e.shape.length&&2===t.shape.length)i=a[0]===a[1]?Ol(Hi(e,t),a[0]):Ol(Hi(zh(e,[1,0]),t),a[1]);else{const n=a[0]!==e.shape.length-1,s=a[1]===t.shape.length-1;i=So(e,t,n,s)}if(n>0){let e;e=s>r?s+r-3:s-1;const t=[];for(let s=e;s<e+n;++s)t.push(s);i=ph(i,t)}return 1===i.shape.length&&(i=Bl(i,1)),i}))}(n,s,t)}interpretAxes(e,t){let n;return n=Array.isArray(this.axes)?this.axes:[Hv(this.axes,e.length),Hv(this.axes,t.length)],n}computeOutputShape(e){u(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0].slice(),n=e[1].slice();if(t.length>3||n.length>3)throw new Og("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);t.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=t.concat(n);return 1===r.length&&r.push(1),r}computeMask(e,t){return null}getConfig(){const e={axes:this.axes,normalize:this.normalize},t=super.getConfig();return Object.assign(e,t),e}}jv.className="Dot",pd(jv);class qv extends Sb{constructor(e){super(e),this.supportsMasking=!0,this.stddev=e.stddev}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={stddev:this.stddev};return Object.assign(t,e),t}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e);return Uy((()=>Vi(My(n.shape,0,this.stddev),n)),(()=>n),t.training||!1)}))}}qv.className="GaussianNoise",pd(qv);class Kv extends Sb{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return Oa((()=>{this.invokeCallHook(e,t);const n=fb(e);if(this.rate>0&&this.rate<1){return Uy((()=>{const e=Math.sqrt(this.rate/(1-this.rate));return Hi(n,My(n.shape,1,e))}),(()=>n),t.training||!1)}return n}))}}Kv.className="GaussianDropout",pd(Kv);class Xv extends Sb{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate,this.noiseShape=e.noiseShape}_getNoiseShape(e){return this.noiseShape||fb(e).shape}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return Oa((()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(e),s=()=>{const t=fb(e),s=-1.7580993408473766;let r=ql(Oc(n),this.rate);r=$y(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate,o=Vi(Hi(t,r),Hi(Vi(r,-1),s));return Vi(Hi(o,a),i)};return Uy(s,(()=>fb(e)),t.training||!1)}return e}))}}function Yv(e,t,n,s,r,a=.001){let i;if(2===e.rank)i=_o(e,t,n,s,r,a);else if(3===e.rank)i=Fo(e,t,n,s,r,a);else{if(4!==e.rank)throw new Og(`batchNormalization is not implemented for array of rank ${e.rank} yet`);i=Do(e,t,n,s,r,a)}return i}function Zv(e,t,n,s,r=.001){return f(s.slice().sort(),Sy(0,e.rank-1))?function(e,t,n,s,r=.001){return Oa((()=>{const a=Ou(e,s),i=a.mean,o=a.variance;return[Yv(e,i,o,n,t,r),i,o]}))}(e,t,n,s,r):function(e,t,n,s,r=.001){return Oa((()=>{const a=Ou(e,s),i=a.mean,o=a.variance,l=[];for(const t of Sy(0,e.rank))-1!==s.indexOf(t)?l.push(1):l.push(e.shape[t]);const u=vo(i,l),c=vo(o,l),h=null==t?null:vo(t,l),p=null==n?null:vo(n,l);return[Yv(e,u,c,p,h,r),i,o]}))}(e,t,n,s,r)}Xv.className="AlphaDropout",pd(Xv);class Jv extends Sb{constructor(e){null==e&&(e={}),super(e),this.supportsMasking=!0,this.axis=null==e.axis?-1:e.axis,this.momentum=null==e.momentum?.99:e.momentum,this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=hb(e.betaInitializer||"zeros"),this.gammaInitializer=hb(e.gammaInitializer||"ones"),this.movingMeanInitializer=hb(e.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=hb(e.movingVarianceInitializer||"ones"),this.betaConstraint=Hb(e.betaConstraint),this.gammaConstraint=Hb(e.gammaConstraint),this.betaRegularizer=Pw(e.betaRegularizer),this.gammaRegularizer=Pw(e.gammaRegularizer)}build(e){e=mb(e);const t=this.axis>=0?this.axis:this.axis+e.length,n=e[t];if(null==n)throw new Dg(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(e)}.`);this.inputSpec=[new wb({ndim:e.length,axes:{[t]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(e,t){return Oa((()=>{const n=null!=t.training&&t.training,s=fb(e),r=s.shape,a=r.length,i=Sy(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=zg(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!f(u,Sy(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const e=vo(this.movingMean.read(),l),t=vo(this.movingVariance.read(),l),n=this.center?vo(this.beta.read(),l):null,r=this.scale?vo(this.gamma.read(),l):null;return Yv(s,e,t,n,r,this.epsilon)}return Yv(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,p,d]=Zv(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(e,t,n)=>{Oa((()=>{const s=1-n,r=e.read(),a=Hi(mu(r,t),s);e.write(mu(r,a))}))};return(()=>{m(this.movingMean,p,this.momentum),m(this.movingVariance,d,this.momentum)})(),h}))}getConfig(){const e={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:cb(this.betaInitializer),gammaInitializer:cb(this.gammaInitializer),movingMeanInitializer:cb(this.movingMeanInitializer),movingVarianceInitializer:cb(this.movingVarianceInitializer),betaRegularizer:Lw(this.betaRegularizer),gammaRegularizer:Lw(this.gammaRegularizer),betaConstraint:Ub(this.betaConstraint),gammaConstraint:Ub(this.gammaConstraint)},t=super.getConfig();return Object.assign(e,t),e}}Jv.className="BatchNormalization",pd(Jv);class Qv extends Sb{constructor(e){if(null==e&&(e={}),super(e),this.axis=null==e.axis?-1:e.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const e of this.axis)if(!Number.isInteger(e))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=hb(e.betaInitializer||"zeros"),this.gammaInitializer=hb(e.gammaInitializer||"ones"),this.betaRegularizer=Pw(e.betaRegularizer),this.gammaRegularizer=Pw(e.gammaRegularizer),this.supportsMasking=!0}build(e){const t=(e=mb(e)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let e=0;e<this.axis.length;++e)this.axis[e]<0&&(this.axis[e]+=t);for(const e of this.axis)if(e<0||e>=t)throw new Error(`Invalid axis: ${e}`);if(this.axis.length!==Yg(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((t=>e[t]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(e,t){const n=fb(e),s=n.shape,r=s.length;return Oa((()=>{let{mean:e,variance:t}=Ou(n,this.axis,!0);const a=zg(1,r);for(const e of this.axis)a[e]=s[e];const i=e=>null!=e&&e.shape.length!==r?vo(e,a):e;let o=this.scale?i(this.gamma.read()):null,l=this.center?i(this.beta.read()):null;const u=[],c=[];for(let e=0;e<r;++e)-1!==this.axis.indexOf(e)?(u.push(s[e]),c.push(1)):(u.push(1),c.push(s[e]));return e=Vl(e,u),t=Vl(t,u),null!=o&&(o=Vl(o,c)),null!=l&&(l=Vl(l,c)),Yv(n,e,t,l,o,this.epsilon)}))}getConfig(){const e={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:cb(this.betaInitializer),gammaInitializer:cb(this.gammaInitializer),betaRegularizer:Lw(this.betaRegularizer),gammaRegularizer:Lw(this.gammaRegularizer)},t=super.getConfig();return Object.assign(e,t),e}}Qv.className="LayerNormalization",pd(Qv);class ek extends Sb{constructor(e){if(null==e&&(e={}),super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,null==e.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof e.padding)this.padding=[[e.padding,e.padding],[e.padding,e.padding]];else{if(e.padding=e.padding,2!==e.padding.length)throw new Dg(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);let t,n;if("number"==typeof e.padding[0])t=[e.padding[0],e.padding[0]],n=[e.padding[1],e.padding[1]];else{if(e.padding=e.padding,2!==e.padding[0].length)throw new Dg(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);if(t=e.padding[0],2!==e.padding[1].length)throw new Dg(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);n=e.padding[1]}this.padding=[t,n]}this.inputSpec=[new wb({ndim:4})]}computeOutputShape(e){let t,n;return e=mb(e),"channelsFirst"===this.dataFormat?(t=null!=e[2]&&e[2]>=0?e[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[3]&&e[3]>=0?e[3]+this.padding[1][0]+this.padding[1][1]:null,[e[0],e[1],t,n]):(t=null!=e[1]&&e[1]>=0?e[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[2]&&e[2]>=0?e[2]+this.padding[1][0]+this.padding[1][1]:null,[e[0],t,n,e[3]])}call(e,t){return Oa((()=>{return t=fb(e),n=this.padding,s=this.dataFormat,Oa((()=>{if(4!==t.rank)throw new Dg(`temporalPadding expects input tensor to be 4-D, but received a ${t.rank}-D tensor.`);if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new Dg("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new Dg(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],Vu(t,e)}));var t,n,s}))}getConfig(){const e={padding:this.padding,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}function tk(e,t,n,s,r,a){return Oa((()=>{let i;dy(r),my(a),fy(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Xw(e,r);const o="same"===s?"same":"valid";return i="max"===a?Iu(e,t,n,o):ko(e,t,n,o),"channelsFirst"===r&&(i=zh(i,[0,3,1,2])),i}))}function nk(e,t,n,s,r,a){return Oa((()=>{let i;dy(r),my(a),fy(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Yw(e,r);const o="same"===s?"same":"valid";return i="max"===a?Su(e,t,n,o):No(e,t,n,o),"channelsFirst"===r&&(i=zh(i,[0,4,1,2,3])),i}))}ek.className="ZeroPadding2D",pd(ek);class sk extends Sb{constructor(e){if(null==e.poolSize&&(e.poolSize=2),super(e),"number"==typeof e.poolSize)this.poolSize=[e.poolSize];else{if(!Array.isArray(e.poolSize)||1!==e.poolSize.length||"number"!=typeof e.poolSize[0])throw new Dg(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.poolSize)}`);this.poolSize=e.poolSize}if(ey(this.poolSize,"poolSize"),null==e.strides)this.strides=this.poolSize;else if("number"==typeof e.strides)this.strides=[e.strides];else{if(!Array.isArray(e.strides)||1!==e.strides.length||"number"!=typeof e.strides[0])throw new Dg(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.strides)}`);this.strides=e.strides}ey(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,fy(this.padding),this.inputSpec=[new wb({ndim:3})]}computeOutputShape(e){const t=qw((e=mb(e))[1],this.poolSize[0],this.padding,this.strides[0]);return[e[0],t,e[2]]}call(e,t){return Oa((()=>{this.invokeCallHook(e,t),e=Ey(fb(e),2);const n=this.poolingFunction(fb(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return ph(n,[2])}))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides},t=super.getConfig();return Object.assign(e,t),e}}class rk extends sk{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),tk(e,t,n,s,r,"max")}}rk.className="MaxPooling1D",pd(rk);class ak extends sk{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),tk(e,t,n,s,r,"avg")}}ak.className="AveragePooling1D",pd(ak);class ik extends Sb{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(2!==e.strides.length)throw new Dg(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides];ey(this.poolSize,"poolSize"),ey(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,dy(this.dataFormat),fy(this.padding),this.inputSpec=[new wb({ndim:4})]}computeOutputShape(e){e=mb(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2];return t=qw(t,this.poolSize[0],this.padding,this.strides[0]),n=qw(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n]:[e[0],t,n,e[3]]}call(e,t){return Oa((()=>(this.invokeCallHook(e,t),this.poolingFunction(fb(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class ok extends ik{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),tk(e,t,n,s,r,"max")}}ok.className="MaxPooling2D",pd(ok);class lk extends ik{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),tk(e,t,n,s,r,"avg")}}lk.className="AveragePooling2D",pd(lk);class uk extends Sb{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(3!==e.strides.length)throw new Dg(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides,e.strides];ey(this.poolSize,"poolSize"),ey(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,dy(this.dataFormat),fy(this.padding),this.inputSpec=[new wb({ndim:5})]}computeOutputShape(e){e=mb(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[4]:e[3];return t=qw(t,this.poolSize[0],this.padding,this.strides[0]),n=qw(n,this.poolSize[1],this.padding,this.strides[1]),s=qw(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n,s]:[e[0],t,n,s,e[4]]}call(e,t){return Oa((()=>(this.invokeCallHook(e,t),this.poolingFunction(fb(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class ck extends uk{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),nk(e,t,n,s,r,"max")}}ck.className="MaxPooling3D",pd(ck);class hk extends uk{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return dy(r),fy(s),nk(e,t,n,s,r,"avg")}}hk.className="AveragePooling3D",pd(hk);class pk extends Sb{constructor(e){super(e),this.inputSpec=[new wb({ndim:3})]}computeOutputShape(e){return[e[0],e[2]]}call(e,t){throw new Og}}class dk extends pk{constructor(e){super(e||{})}call(e,t){return Oa((()=>{const t=fb(e);return $u(t,1)}))}}dk.className="GlobalAveragePooling1D",pd(dk);class fk extends pk{constructor(e){super(e||{})}call(e,t){return Oa((()=>{const t=fb(e);return El(t,1)}))}}fk.className="GlobalMaxPooling1D",pd(fk);class mk extends Sb{constructor(e){super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,dy(this.dataFormat),this.inputSpec=[new wb({ndim:4})]}computeOutputShape(e){return"channelsLast"===this.dataFormat?[e[0],e[3]]:[e[0],e[1]]}call(e,t){throw new Og}getConfig(){const e={dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class gk extends mk{call(e,t){return Oa((()=>{const t=fb(e);return"channelsLast"===this.dataFormat?$u(t,[1,2]):$u(t,[2,3])}))}}gk.className="GlobalAveragePooling2D",pd(gk);class yk extends mk{call(e,t){return Oa((()=>{const t=fb(e);return"channelsLast"===this.dataFormat?El(t,[1,2]):El(t,[2,3])}))}}yk.className="GlobalMaxPooling2D",pd(yk);class bk extends Sb{constructor(e){super(e),this.layer=e.layer}build(e){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(e){null!=this.layer&&(this.layer.trainable=e)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(e){this.layer.setWeights(e)}getConfig(){const e={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},t=super.getConfig();return Object.assign(e,t),e}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(e)}static fromConfig(e,t,n={}){const s=ax(t.layer,n);delete t.layer;const r={layer:s};return Object.assign(r,t),new e(r)}}class xk extends bk{constructor(e){super(e),this.supportsMasking=!0}build(e){if((e=mb(e)).length<3)throw new Dg(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(e)}`);this.inputSpec=[{shape:e}];const t=[e[0]].concat(e.slice(2));this.layer.built||(this.layer.build(t),this.layer.built=!0),super.build(e)}computeOutputShape(e){const t=[(e=mb(e))[0]].concat(e.slice(2)),n=this.layer.computeOutputShape(t),s=e[1];return[n[0],s].concat(n.slice(1))}call(e,t){return Oa((()=>dv(((e,n)=>[fb(this.layer.call(e,t)),[]]),e=fb(e),[],!1,null,null,!1,!0)[1]))}}xk.className="TimeDistributed",pd(xk);class wk extends bk{constructor(e){super(e);const t=e.layer.getConfig(),n={};n.className=e.layer.getClassName(),n.config=t,this.forwardLayer=ax(n),t.goBackwards=!0!==t.goBackwards;const s={};var r;if(s.className=e.layer.getClassName(),s.config=t,this.backwardLayer=ax(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===e.mergeMode?"concat":e.mergeMode,r=this.mergeMode,Jg(hy,"BidirectionalMergeMode",r),e.weights)throw new Og("weights support is not implemented for Bidirectional layer yet.");this._stateful=e.layer.stateful,this.returnSequences=e.layer.returnSequences,this.returnState=e.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=e.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(e){this._trainable=e,null!=this.forwardLayer&&(this.forwardLayer.trainable=e),null!=this.backwardLayer&&(this.backwardLayer.trainable=e)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(e){const t=e.length,n=Math.floor(t/2);this.forwardLayer.setWeights(e.slice(0,n)),this.backwardLayer.setWeights(e.slice(n))}computeOutputShape(e){let t,n,s,r=this.forwardLayer.computeOutputShape(e);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),t=r[0]):t=r[0],"concat"===this.mergeMode?(t[t.length-1]*=2,n=[t]):n=null==this.mergeMode?[t,t.slice()]:[t],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[t].concat(s).concat(s.slice()):Wg(n)}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=pv(e,n,s,this.numConstants);if(e=r.inputs,n=r.initialState,s=r.constants,Array.isArray(e)&&(n=e.slice(1),e=e[0]),(null==n||0===n.length)&&null==s)return super.apply(e,t);const a=[],i=[];if(null!=n){const e=n.length;if(e%2>0)throw new Dg("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");t.initialState=n,a.push(...n);const s=n.map((e=>new wb({shape:e.shape})));this.forwardLayer.stateSpec=s.slice(0,e/2),this.backwardLayer.stateSpec=s.slice(e/2),i.push(...s)}if(null!=s)throw new Og("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof vb;for(const e of a)if(e instanceof vb!==o)throw new Dg("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return Oa((()=>{const n=t.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(e,t),r=this.backwardLayer.call(e,t);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(e,Object.assign(t,{initialState:a})),r=this.backwardLayer.call(e,Object.assign(t,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=Vc(r,1)),"concat"===this.mergeMode?i=Fy([s,r]):"sum"===this.mergeMode?i=Vi(s,r):"ave"===this.mergeMode?i=Hi(.5,Vi(s,r)):"mul"===this.mergeMode?i=Hi(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i}))}resetStates(e){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(e){yy(this.forwardLayer.name,(()=>{this.forwardLayer.build(e)})),yy(this.backwardLayer.name,(()=>{this.backwardLayer.build(e)})),this.built=!0}computeMask(e,t){let n;if(Array.isArray(t)&&(t=t[0]),n=this.returnSequences?null==this.mergeMode?[t,t]:t:null==this.mergeMode?[null,null]:null,this.returnState){const e=this.forwardLayer.states.map((e=>null));return Array.isArray(n)?n.concat(e).concat(e):[n].concat(e).concat(e)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(e),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(e)}getConfig(){const e={mergeMode:this.mergeMode},t=super.getConfig();return Object.assign(e,t),e}static fromConfig(e,t){const n=ax(t.layer);if(delete t.layer,null!=t.numConstants)throw new Og("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=t;return s.layer=n,new e(s)}}wk.className="Bidirectional",pd(wk);class vk extends Sb{constructor(e){super(e),this.scale=e.scale,e.offset?this.offset=e.offset:this.offset=0}getConfig(){const e={scale:this.scale,offset:this.offset},t=super.getConfig();return Object.assign(e,t),e}call(e,t){return Oa((()=>("float32"!==(e=fb(e)).dtype&&(e=$y(e,"float32")),Vi(Hi(e,this.scale),this.offset))))}}vk.className="Rescaling",pd(vk);const{resizeBilinear:kk,cropAndResize:Nk}=sd;class Ik extends Sb{constructor(e){super(e),this.height=e.height,this.width=e.width}centerCrop(e,t,n,s,r,a,i,o){return Oa((()=>{let l,u=!1;const c=[t/a,n/i,(s+t)/a,(r+n)/i],h=[];3===e.rank?(u=!0,l=dh([e])):l=e;for(let e=0;e<l.shape[0];e++)h.push(c);const p=Ia(h,[h.length,4]),d=Lc(0,h.length,1,"int32"),f=Nk(l,p,d,[s,r],"nearest");return $y(u?fb(_h(f)):f,o)}))}upsize(e,t,n,s){return Oa((()=>$y(kk(e,[t,n]),s)))}call(e,t){return Oa((()=>{const t=fb(e),n=t.dtype,s=t.shape,r=s[s.length-3],a=s[s.length-2];let i=0;r!==this.height&&(i=Math.floor((r-this.height)/2));let o=0;return a!==this.width&&(o=Math.floor((a-this.width)/2),0===o&&(o=1)),i>=0&&o>=0?this.centerCrop(t,i,o,this.height,this.width,r,a,n):this.upsize(e,this.height,this.width,n)}))}getConfig(){const e={height:this.height,width:this.width},t=super.getConfig();return Object.assign(e,t),e}computeOutputShape(e){const t=(e=mb(e)).length-3,n=e.length-2;return e[t]=this.height,e[n]=this.width,e}}Ik.className="CenterCrop",pd(Ik);class Sk extends Sb{constructor(e){super(e),this.numTokens=e.numTokens,e.outputMode?this.outputMode=e.outputMode:this.outputMode="multiHot"}getConfig(){const e={numTokens:this.numTokens,outputMode:this.outputMode},t=super.getConfig();return Object.assign(e,t),e}computeOutputShape(e){return null==(e=mb(e))?[this.numTokens]:"oneHot"===this.outputMode&&1!==e[e.length-1]?(e.push(this.numTokens),e):(e[e.length-1]=this.numTokens,e)}call(e,t){return Oa((()=>{let n;if("int32"!==(e=fb(e)).dtype&&(e=$y(e,"int32")),void 0!==t.countWeights){if("count"!==this.outputMode)throw new Dg(`countWeights is not used when outputMode !== count.\n              Received countWeights=${t.countWeights}`);n=fb(t.countWeights)}const s=El(e),r=Al(e),a=jl(this.numTokens,s).bufferSync().get(0),i=ql(r,0).bufferSync().get(0);if(!a||!i)throw new Dg(`Input values must be between 0 < values <= numTokens with numTokens=${this.numTokens}`);return function(e,t,n,s){let r=fb(e);if("int32"!==r.dtype&&(r=$y(r,"int32")),"int"===t)return r;const a=r.shape;if(0===r.rank&&(r=Bl(r,-1)),"oneHot"===t&&1!==r.shape[r.shape.length-1]&&(r=Bl(r,-1)),r.rank>2)throw new Dg(`When outputMode is not int, maximum output rank is 2 Received outputMode ${t} and input shape ${a} which would result in output rank ${r.rank}.`);const i=["multiHot","oneHot"].includes(t);let o;if(o=sl(r,void 0!==s&&"count"===t?s:[],n,i),"tfIdf"!==t)return o;if(s)return Hi(o,s);throw new Dg("When outputMode is 'tfIdf', weights must be provided.")}(e,this.outputMode,this.numTokens,n)}))}}Sk.className="CategoryEncoding",pd(Sk);const Tk=new Set(["bilinear","nearest"]);class Ck extends Sb{constructor(e){if(super(e),this.height=e.height,this.width=e.width,e.interpolation){if(!Tk.has(e.interpolation))throw new Dg(`Invalid interpolation parameter: ${e.interpolation} is not implemented`);this.interpolation=e.interpolation}else this.interpolation="bilinear";this.cropToAspectRatio=Boolean(e.cropToAspectRatio)}computeOutputShape(e){const t=(e=mb(e))[2];return[this.height,this.width,t]}getConfig(){const e={height:this.height,width:this.width,interpolation:this.interpolation,cropToAspectRatio:this.cropToAspectRatio},t=super.getConfig();return Object.assign(e,t),e}call(e,t){return Oa((()=>{const t=[this.height,this.width];if("bilinear"===this.interpolation)return sd.resizeBilinear(e,t,!this.cropToAspectRatio);if("nearest"===this.interpolation)return sd.resizeNearestNeighbor(e,t,!this.cropToAspectRatio);throw new Error(`Interpolation is ${this.interpolation} but only ${[...Tk]} are supported`)}))}}Ck.className="Resizing",pd(Ck);class $k{constructor(e){this.seed=e}next(){if(void 0!==this.seed)return this.seed++}}$k.className="RandomSeed";class Ek extends Sb{constructor(e){super(e),this.randomGenerator=new $k(e.seed)}getConfig(){const e={seed:this.randomGenerator.seed},t=super.getConfig();return Object.assign(e,t),e}}Ek.className="BaseRandomLayer";const Ak=new Set(["bilinear","nearest"]);class Rk extends Ek{constructor(e){super(e);const{factor:t,interpolation:n="bilinear"}=e;if(this.factor=t,Array.isArray(this.factor)&&2===this.factor.length)this.widthLower=this.factor[0],this.widthUpper=this.factor[1];else{if(Array.isArray(this.factor)||!(this.factor>0))throw new Dg(`Invalid factor: ${this.factor}. Must be positive number or tuple of 2 numbers`);this.widthLower=-this.factor,this.widthUpper=this.factor}if(this.widthLower<-1||this.widthUpper<-1)throw new Dg(`factor must have values larger than -1. Got: ${this.factor}`);if(this.widthUpper<this.widthLower)throw new Dg(`factor cannot have upper bound less than lower bound.\n        Got upper bound: ${this.widthUpper}.\n        Got lower bound: ${this.widthLower}\n      `);if(n){if(!Ak.has(n))throw new Dg(`Invalid interpolation parameter: ${n} is not implemented`);this.interpolation=n}}getConfig(){const e={factor:this.factor,interpolation:this.interpolation},t=super.getConfig();return Object.assign(e,t),e}computeOutputShape(e){const t=(e=mb(e))[2];return[this.imgHeight,-1,t]}call(e,t){return Oa((()=>{const t=fb(e);this.imgHeight=t.shape[t.shape.length-3];const n=t.shape[t.shape.length-2];this.widthFactor=Oc([1],1+this.widthLower,1+this.widthUpper,"float32",this.randomGenerator.next());let s=this.widthFactor.dataSync()[0]*n;s=Math.round(s);const r=[this.imgHeight,s];switch(this.interpolation){case"bilinear":return sd.resizeBilinear(e,r);case"nearest":return sd.resizeNearestNeighbor(e,r);default:throw new Error(`Interpolation is ${this.interpolation}\n          but only ${[...Ak]} are supported`)}}))}}function _k(e){return new ak(e)}function Fk(e){return new lk(e)}function Dk(e){return new hk(e)}function Ok(e){return new fk(e)}function Mk(e){return new yk(e)}function Lk(e){return new rk(e)}function zk(e){return new ok(e)}Rk.className="RandomWidth",pd(Rk);const Pk=Ok,Bk=Mk,Wk=Lk,Vk=zk;var Uk=Object.freeze({__proto__:null,Layer:Sb,RNN:fv,RNNCell:mv,activation:function(e){return new _v(e)},add:function(e){return new Pv(e)},alphaDropout:function(e){return new Xv(e)},average:function(e){return new Wv(e)},averagePooling1d:_k,averagePooling2d:Fk,averagePooling3d:Dk,avgPool1d:function(e){return _k(e)},avgPool2d:function(e){return Fk(e)},avgPool3d:function(e){return Dk(e)},avgPooling1d:function(e){return _k(e)},avgPooling2d:function(e){return Fk(e)},avgPooling3d:function(e){return Dk(e)},batchNormalization:function(e){return new Jv(e)},bidirectional:function(e){return new wk(e)},categoryEncoding:function(e){return new Sk(e)},centerCrop:function(e){return new Ik(e)},concatenate:function(e){return new Gv(e)},conv1d:function(e){return new lv(e)},conv2d:function(e){return new nv(e)},conv2dTranspose:function(e){return new rv(e)},conv3d:function(e){return new sv(e)},conv3dTranspose:function(e){return new av(e)},convLstm2d:function(e){return new Cv(e)},convLstm2dCell:function(e){return new Tv(e)},cropping2D:function(e){return new uv(e)},dense:function(e){return new Av(e)},depthwiseConv2d:function(e){return new hv(e)},dot:function(e){return new jv(e)},dropout:function(e){return new $v(e)},elu:function(e){return new Uw(e)},embedding:function(e){return new Lv(e)},flatten:function(e){return new Rv(e)},gaussianDropout:function(e){return new Kv(e)},gaussianNoise:function(e){return new qv(e)},globalAveragePooling1d:function(e){return new dk(e)},globalAveragePooling2d:function(e){return new gk(e)},globalMaxPool1d:Pk,globalMaxPool2d:Bk,globalMaxPooling1d:Ok,globalMaxPooling2d:Mk,gru:function(e){return new xv(e)},gruCell:function(e){return new bv(e)},input:hw,inputLayer:function(e){return new Cb(e)},layerNormalization:function(e){return new Qv(e)},leakyReLU:function(e){return new Ww(e)},lstm:function(e){return new vv(e)},lstmCell:function(e){return new wv(e)},masking:function(e){return new Mv(e)},maxPool1d:Wk,maxPool2d:Vk,maxPooling1d:Lk,maxPooling2d:zk,maxPooling3d:function(e){return new ck(e)},maximum:function(e){return new Vv(e)},minimum:function(e){return new Uv(e)},multiply:function(e){return new Bv(e)},permute:function(e){return new Ov(e)},prelu:function(e){return new Vw(e)},randomWidth:function(e){return new Rk(e)},reLU:function(e){return new Bw(e)},repeatVector:function(e){return new Fv(e)},rescaling:function(e){return new vk(e)},reshape:function(e){return new Dv(e)},resizing:function(e){return new Ck(e)},rnn:function(e){return new fv(e)},separableConv2d:function(e){return new ov(e)},simpleRNN:function(e){return new yv(e)},simpleRNNCell:function(e){return new gv(e)},softmax:function(e){return new Hw(e)},spatialDropout1d:function(e){return new Ev(e)},stackedRNNCells:function(e){return new kv(e)},thresholdedReLU:function(e){return new Gw(e)},timeDistributed:function(e){return new xk(e)},upSampling2d:function(e){return new cv(e)},zeroPadding2d:function(e){return new ek(e)}});var Gk=Object.freeze({__proto__:null,MAPE:function(e,t){return ux(e,t)},MSE:function(e,t){return ox(e,t)},binaryAccuracy:function(e,t){return bx(e,t)},binaryCrossentropy:function(e,t){return Nx(e,t)},categoricalAccuracy:function(e,t){return xx(e,t)},categoricalCrossentropy:function(e,t){return Sx(e,t)},cosineProximity:function(e,t){return mx(e,t)},mape:function(e,t){return ux(e,t)},meanAbsoluteError:function(e,t){return lx(e,t)},meanAbsolutePercentageError:function(e,t){return ux(e,t)},meanSquaredError:function(e,t){return ox(e,t)},mse:function(e,t){return ox(e,t)},precision:function(e,t){return vx(e,t)},r2Score:function(e,t){return function(e,t){return Oa((()=>{const n=e.sub(t).square().sum(),s=e.sub(e.mean()).square().sum();return _l(1).sub(n.div(s))}))}(e,t)},recall:function(e,t){return kx(e,t)},sparseCategoricalAccuracy:function(e,t){return Ix(e,t)}}),Hk=Object.freeze({__proto__:null,modelFromJSON:async function(e,t){"modelTopology"in e||(e={modelTopology:e});let n=e.modelTopology;null!=n.model_config&&(n=n.model_config);const s=ax(Lx(n),t);if(null!=e.weightsManifest){const t=await $d(e.weightsManifest,e.pathPrefix,s.weights.map((e=>e.originalName))),n={};for(const e of s.weights)n[e.originalName]=t[e.originalName];s.loadWeights(n),Ma(t)}return s}});var jk=Object.freeze({__proto__:null,l1:function(e){return Fw(t=e),new Ow({l1:null!=t?t.l1:null,l2:0});var t},l1l2:function(e){return new Ow(e)},l2:function(e){return Fw(t=e),new Ow({l2:null!=t?t.l2:null,l1:0});var t}});class qk extends Zb{constructor(){super(...arguments),this.model=null}setModel(e){if(!(e instanceof aw))throw new Error("model must be a LayersModel, not some other Container");this.model=e}}function Kk(e,t){return e<t}function Xk(e,t){return e>t}class Yk extends qk{constructor(e){if(super(),null==e&&(e={}),e.restoreBestWeights)throw new Og("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=e.monitor||"val_loss",this.minDelta=Math.abs(e.minDelta||0),this.patience=e.patience||0,this.verbose=e.verbose||0,this.mode=e.mode||"auto",this.baseline=e.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=Kk:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=Xk:this.monitorFunc=Kk,this.monitorFunc===Kk&&(this.minDelta*=-1)}async onTrainBegin(e){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===Kk?1/0:-1/0}async onEpochEnd(e,t){await Xb(t);const n=this.getMonitorValue(t);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=e,this.model.stopTraining=!0)))}async onTrainEnd(e){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(e){null==e&&(e={});const t=e[this.monitor];return null==t&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(e)}`),t}}const Zk={earlyStopping:function(e){return new Yk(e)}};var Jk,Qk;K().registerFlag("KEEP_INTERMEDIATE_TENSORS",(()=>!1),(e=>{e&&console.warn("Keep intermediate tensors is ON. This will print the values of all intermediate tensors during model inference. Not all models support this mode. For details, check e2e/benchmarks/ model_config.js. This significantly impacts performance.")})),function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_QINT16=15]="DT_QINT16",e[e.DT_QUINT16=16]="DT_QUINT16",e[e.DT_UINT16=17]="DT_UINT16",e[e.DT_COMPLEX128=18]="DT_COMPLEX128",e[e.DT_HALF=19]="DT_HALF",e[e.DT_RESOURCE=20]="DT_RESOURCE",e[e.DT_VARIANT=21]="DT_VARIANT",e[e.DT_UINT32=22]="DT_UINT32",e[e.DT_UINT64=23]="DT_UINT64",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF",e[e.DT_QINT16_REF=115]="DT_QINT16_REF",e[e.DT_QUINT16_REF=116]="DT_QUINT16_REF",e[e.DT_UINT16_REF=117]="DT_UINT16_REF",e[e.DT_COMPLEX128_REF=118]="DT_COMPLEX128_REF",e[e.DT_HALF_REF=119]="DT_HALF_REF",e[e.DT_RESOURCE_REF=120]="DT_RESOURCE_REF",e[e.DT_VARIANT_REF=121]="DT_VARIANT_REF",e[e.DT_UINT32_REF=122]="DT_UINT32_REF",e[e.DT_UINT64_REF=123]="DT_UINT64_REF"}(Jk||(Jk={})),function(e){let t;!function(e){e[e.LEGACY=0]="LEGACY",e[e.V1=1]="V1",e[e.V2=2]="V2"}(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))}(Qk||(Qk={}));const eN={};function tN(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};eN[e]=n}function nN(e){return eN[e]}function sN(e){delete eN[e]}function rN(e,t,n,s,r){const a=t.inputParams[e];if(a&&void 0!==a.inputIndexStart){const e=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?e+1:a.inputIndexEnd,o=e<0?t.inputNames.length+e:e;if("tensor"===a.type)return aN(t.inputNames[o],n,s,r);if("tensors"===a.type){const a=t.inputs.slice(e,i),o=t.inputNames.slice(e,i).filter(((e,t)=>{var n;return"NoOp"!==(null===(n=a[t])||void 0===n?void 0:n.op)}));return o.map((e=>aN(e,n,s,r)))}const l=aN(t.inputNames[o],n,s,r),u=l.dataSync();return"number"===a.type?u[0]:L(l.shape,u)}const i=t.attrParams[e];return i&&i.value}function aN(e,t,n,s){const[r,a]=uN(e,n);if(null!=s){const e=s.getHashTableHandleByName(r);if(null!=e)return e}const i=n.currentContextIds.find((e=>!!t[lN(r,e)]));return void 0!==i?t[lN(r,i)][a]:void 0}function iN(e,t,n){return t[lN(e,n.currentContextId)]}function oN(e,t){const[n,s,r]=uN(e,t);return[lN(n,t&&t.currentContextId),s,r]}function lN(e,t){return t?`${e}-${t}`:e}function uN(e,t){if(""===e)return["",0,void 0];const n=null!=t&&null!=t.parseNodeNameCache;if(n){const n=t.parseNodeNameCache.get(e);if(null!=n)return n}const s=e.split(":");let r;if(1===s.length)r=[e,0,void 0];else{const e=s[0],t=3===s.length?s[1]:void 0;r=[e,Number(s[s.length-1]),t]}return n&&t.parseNodeNameCache.set(e,r),r}function cN(e,t,n){let s=rN("pad",e,t,n);if("explicit"===s){s=rN("explicitPaddings",e,t,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)r[e][0]=s[2*e],r[e][1]=s[2*e+1];return r}return s}function hN(e){return e.kept?e:Bi(e)}var pN=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var dN=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsNan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsFinite",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsInf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var fN=Object.freeze({__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcatV2",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListLength",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}]},{tfOpName:"TensorListResize",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"size",type:"number"}]}]});var mN=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var gN=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomStandardNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"RandomUniformInt",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number"},{tfName:"maxval",name:"maxval",type:"number"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var yN=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var bN=Object.freeze({__proto__:null,json:[{tfOpName:"LowerBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"UpperBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var xN=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var wN=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableSize",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"LookupTableSizeV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"InitializeTable",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}]},{tfOpName:"InitializeTableV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}]}]});var vN=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]},{tfOpName:"ImageProjectiveTransformV3",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"transforms",type:"tensor"},{start:2,name:"outputShape",type:"number[]"},{start:3,name:"fillValue",type:"number"}],attrs:[{tfName:"interpolation",name:"interpolation",type:"string"},{tfName:"fill_mode",name:"fillMode",type:"string"}]}]});var kN=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BitwiseAnd",category:"logical",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}]}]});var NN=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Einsum",category:"matrices",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"equation",name:"equation",type:"string"},{tfName:"N",name:"n",type:"number",defaultValue:2},{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"MatrixBandPart",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"numLower",type:"tensor"},{start:1,name:"numUpper",type:"tensor"}]}]});var IN=Object.freeze({__proto__:null,json:[{tfOpName:"EuclideanNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",defaultValue:!1}]},{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]}]});var SN=Object.freeze({__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cumprod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var TN=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]},{tfOpName:"TensorScatterUpdate",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"values",type:"tensor"}]}]});var CN=Object.freeze({__proto__:null,json:[{tfOpName:"SparseFillEmptyRows",category:"sparse",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"denseShape",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}]},{tfOpName:"SparseReshape",category:"sparse",inputs:[{start:0,name:"inputIndices",type:"tensor"},{start:1,name:"inputShape",type:"tensor"},{start:2,name:"newShape",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SparseSegmentMean",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]},{tfOpName:"SparseSegmentSum",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]}]});var $N=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var EN=Object.freeze({__proto__:null,json:[{tfOpName:"StaticRegexReplace",category:"string",inputs:[{start:0,name:"input",type:"tensor"}],attrs:[{tfName:"pattern",name:"pattern",type:"string"},{tfName:"rewrite",name:"rewrite",type:"string"},{tfName:"replace_global",name:"replaceGlobal",type:"bool"}]},{tfOpName:"StringNGrams",category:"string",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"dataSplits",type:"tensor"}],attrs:[{tfName:"separator",name:"separator",type:"string"},{tfName:"ngram_widths",name:"nGramWidths",type:"number[]"},{tfName:"left_pad",name:"leftPad",type:"string"},{tfName:"right_pad",name:"rightPad",type:"string"},{tfName:"pad_width",name:"padWidth",type:"number"},{tfName:"preserve_short_sequences",name:"preserveShortSequences",type:"bool"}],outputs:["ngrams","ngrams_splits"]},{tfOpName:"StringSplit",category:"string",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"delimiter",type:"tensor"}],attrs:[{tfName:"skip_empty",name:"skipEmpty",type:"bool"}],outputs:["indices","values","shape"]},{tfOpName:"StringToHashBucketFast",category:"string",inputs:[{start:0,name:"input",type:"tensor"}],attrs:[{tfName:"num_buckets",name:"numBuckets",type:"number"}]}]});var AN=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"EnsureShape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]},{tfOpName:"BroadcastArgs",category:"transformation",inputs:[{start:0,name:"s0",type:"tensor"},{start:1,name:"s1",type:"tensor"}],attrs:[]}]});class RN{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[pN,dN,fN,mN,gN,yN,bN,xN,wN,vN,kN,NN,IN,SN,TN,CN,$N,EN,AN].map((e=>e.json)));this.opMappers=e.reduce(((e,t)=>(e[t.tfOpName]=t,e)),{})}transformGraph(e,t={}){const n=e.node,s=[],r=[],a=[],i=n.reduce(((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?s.push(e[t.name]):"Const"===t.op?r.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e)),{});let o=[];const l=[];let u={},c={};null!=t&&(u=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(i);h.forEach((e=>{const t=i[e];t.inputNames.forEach(((e,n)=>{const[s,,r]=oN(e),a=i[s];if(null!=a.outputs){const e=a.outputs.indexOf(r);if(-1!==e){const r=`${s}:${e}`;t.inputNames[n]=r}}t.inputs.push(a),a.children.push(t)}))})),0===Object.keys(c).length?h.forEach((e=>{const t=i[e];0===t.children.length&&l.push(t)})):Object.keys(c).forEach((e=>{const[t]=oN(e),n=i[t];null!=n&&(n.signatureKey=c[e],l.push(n))})),Object.keys(u).length>0?Object.keys(u).forEach((e=>{const[t]=oN(e),n=i[t];n&&(n.signatureKey=u[e],o.push(n))})):o=s;let p={};null!=e.library&&null!=e.library.function&&(p=e.library.function.reduce(((e,t)=>(e[t.signature.name]=this.mapFunction(t),e)),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:t,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce(((t,n)=>(t[e[n].name]=n,t)),{})}mapNode(e){const t=nN(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map((e=>e.startsWith("^")?e.slice(1):e)),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr,outputs:t.outputs};return null!=t.inputs&&(n.inputParams=t.inputs.reduce(((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e)),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce(((t,n)=>{const s=n.type;let r;switch(n.type){case"string":r=FN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=FN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=UN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=UN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=ON(e.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=ON(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=VN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=VN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=DN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=DN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=HN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=HN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=WN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=WN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=GN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=GN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=zN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=zN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=PN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=PN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=LN(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=LN(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:r,type:s},t}),{})),n}mapFunction(e){const t=e.nodeDef,n=[];let s={};null!=t&&(s=t.reduce(((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e)),{}));const r=[],a=[];e.signature.inputArg.forEach((e=>{const[t]=oN(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:MN(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,r.push(n),s[t]=n}));Object.keys(s).forEach((e=>{const t=s[e];t.inputNames.forEach(((e,n)=>{const[r,,a]=oN(e),i=s[r];if(null!=i.outputs){const e=i.outputs.indexOf(a);if(-1!==e){const s=`${r}:${e}`;t.inputNames[n]=s}}t.inputs.push(i),i.children.push(t)}))}));const i=e.ret;e.signature.outputArg.forEach((e=>{const[t,n]=oN(i[e.name]),r=s[t];null!=r&&(r.defaultOutput=n,a.push(r))}));const o=this.mapArgsToSignature(e);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce(((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e)),{}),outputs:e.signature.outputArg.reduce(((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t)),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function _N(e,t){const n=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const t=K().global;if(void 0!==t.atob)return t.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return t?n:n.toLowerCase()}function FN(e,t,n,s=!1){const r=e[t];return null!=r?_N(r.s,s):n}function DN(e,t,n){const s=e[t];return s?s.b:n}function ON(e,t,n){const s=e[t]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function MN(e){switch("string"==typeof e&&(e=Jk[e]),e){case Jk.DT_FLOAT:case Jk.DT_HALF:return"float32";case Jk.DT_INT32:case Jk.DT_INT64:case Jk.DT_INT8:case Jk.DT_UINT8:return"int32";case Jk.DT_BOOL:return"bool";case Jk.DT_DOUBLE:return"float32";case Jk.DT_STRING:return"string";case Jk.DT_COMPLEX64:case Jk.DT_COMPLEX128:return"complex64";default:return null}}function LN(e,t,n){const s=e[t];return s&&s.func?s.func.name:n}function zN(e,t,n){const s=e[t];return s&&s.type?MN(s.type):n}function PN(e,t,n){const s=e[t];return s&&s.list&&s.list.type?s.list.type.map((e=>MN(e))):n}function BN(e){if(!e.unknownRank)return null!=e.dim?e.dim.map((e=>"number"==typeof e.size?e.size:parseInt(e.size,10))):[]}function WN(e,t,n){const s=e[t];return s&&s.shape?BN(s.shape):n}function VN(e,t,n){const s=e[t];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map((e=>"number"==typeof e?e:parseInt(e,10))):n}function UN(e,t,n,s=!1){const r=e[t];return r&&r.list&&r.list.s?r.list.s.map((e=>_N(e,s))):n}function GN(e,t,n){const s=e[t];return s&&s.list&&s.list.shape?s.list.shape.map((e=>BN(e))):n}function HN(e,t,n){const s=e[t];return s&&s.list&&s.list.b?s.list.b:n}class jN{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map((e=>this.getInput(e))),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce(((e,t)=>(e[t]=this.getAttr(t),e)),{}))}getInput(e){return aN(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return aN(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return ON(this.node.rawAttrs,e,t);if(null!=n.s)return FN(this.node.rawAttrs,e,t);if(null!=n.b)return DN(this.node.rawAttrs,e,t);if(null!=n.shape)return WN(this.node.rawAttrs,e,t);if(null!=n.type)return zN(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return VN(this.node.rawAttrs,e,t);if(null!=n.list.s)return UN(this.node.rawAttrs,e,t);if(null!=n.list.shape)return GN(this.node.rawAttrs,e,t);if(null!=n.list.b)return HN(this.node.rawAttrs,e,t);if(null!=n.list.type)return PN(this.node.rawAttrs,e,t)}return t}}var qN=Object.freeze({__proto__:null,OP_SCOPE_SUFFIX:"__op",abs:ji,acos:qi,acosh:Ki,add:Vi,addN:Xi,all:Yi,any:Zi,argMax:Ji,argMin:Qi,asin:eo,asinh:to,atan:no,atan2:so,atanh:ro,avgPool:ko,avgPool3d:No,basicLSTMCell:Eo,batchNorm:Ro,batchNorm2d:_o,batchNorm3d:Fo,batchNorm4d:Do,batchToSpaceND:Ao,bincount:Oo,bitwiseAnd:Mo,booleanMaskAsync:Lh,broadcastArgs:Lo,broadcastTo:zo,buffer:zi,cast:Pi,ceil:Po,clipByValue:Wo,clone:Bi,complex:ka,concat:Io,concat1d:Vo,concat2d:Uo,concat3d:Go,concat4d:Ho,conv1d:qo,conv2d:jo,conv2dTranspose:Xo,conv3d:Yo,conv3dTranspose:Jo,cos:Qo,cosh:el,cosineWindow:Hh,cumprod:tl,cumsum:nl,denseBincount:sl,depthToSpace:rl,depthwiseConv2d:al,diag:il,dilation2d:ol,div:Gi,divNoNan:ml,dot:gl,dropout:Uh,einsum:yl,elu:bl,enclosingPowerOfTwo:Gh,ensureShape:xl,equal:pl,erf:wl,euclideanNorm:zl,exp:Pl,expandDims:Bl,expm1:Wl,eye:Ul,fft:ih,fill:Bo,floor:Gl,floorDiv:Ui,fused:sp,gather:Hl,gatherND:Vh,greater:jl,greaterEqual:ql,ifft:oh,imag:Kl,image:sd,inTopKAsync:jh,irfft:lh,isFinite:Xl,isInf:Yl,isNaN:Zl,leakyRelu:Jl,less:Ql,lessEqual:eu,linalg:rd,linspace:tu,localResponseNormalization:nu,log:su,log1p:ru,logSigmoid:fu,logSoftmax:gu,logSumExp:yu,logicalAnd:bu,logicalNot:xu,logicalOr:wu,logicalXor:vu,losses:ad,lowerBound:Nu,matMul:So,max:El,maxPool:Iu,maxPool3d:Su,maxPoolWithArgmax:Tu,maximum:Cu,mean:$u,meshgrid:Ru,min:Al,minimum:_u,mirrorPad:Fu,mod:Du,moments:Ou,movingAverage:Ph,mul:Hi,multiRNNCell:Mu,multinomial:Lu,neg:pu,norm:Ll,notEqual:zu,oneHot:Pu,ones:Au,onesLike:Bu,op:va,outerProduct:Wu,pad:Vu,pad1d:Uu,pad2d:Gu,pad3d:Hu,pad4d:ju,pool:Ku,pow:Rl,prelu:Xu,print:Wi,prod:Yu,raggedGather:Zu,raggedRange:Ju,raggedTensorToTensor:Qu,rand:ec,randomGamma:_c,randomNormal:Fc,randomStandardNormal:Dc,randomUniform:Oc,randomUniformInt:Mc,range:Lc,real:zc,reciprocal:Pc,relu:Bc,relu6:Wc,reshape:vo,reverse:Vc,reverse1d:Uc,reverse2d:Gc,reverse3d:Hc,reverse4d:jc,rfft:ch,round:qc,rsqrt:Kc,scalar:_l,scatterND:Bh,searchSorted:ku,selu:Xc,separableConv2d:Yc,setdiff1dAsync:Zc,sigmoid:To,sign:Jc,signal:nd,sin:Qc,sinh:eh,slice:Co,slice1d:th,slice2d:nh,slice3d:sh,slice4d:rh,softmax:ah,softplus:du,spaceToBatchND:qu,sparse:id,sparseToDense:Wh,spectral:td,split:uh,sqrt:Fl,square:Dl,squaredDifference:hh,squeeze:ph,stack:dh,step:fh,stridedSlice:mh,string:od,sub:mu,sum:Ol,tan:gh,tanh:$o,tensor:Ia,tensor1d:yh,tensor2d:bh,tensor3d:xh,tensor4d:wh,tensor5d:vh,tensor6d:kh,tensorScatterUpdate:Ch,tile:Vl,topk:$h,transpose:zh,truncatedNormal:Eh,unique:Ah,unsortedSegmentSum:Rh,unstack:_h,upperBound:Fh,variable:Dh,where:dl,whereAsync:Mh,zeros:Eu,zerosLike:fl});function KN(e,t,n=""){if("number"!=typeof e&&"number"!=typeof t){u(e.length===t.length,(()=>n+` Shapes ${e} and ${t} must match`));for(let s=0;s<e.length;s++){const r=e[s],a=t[s];u(r<0||a<0||r===a,(()=>n+` Shapes ${e} and ${t} must match`))}}}function XN(e){return"number"!=typeof e&&!e.some((e=>e<0))}function YN(e,t,n){let s=ZN(e,n);const r=!XN(s);if(r&&0===t.length)throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${s}`);if(r&&t.forEach((e=>{s=ZN(e.shape,s)})),!XN(s))throw new Error(`Non-fully-defined elementShape: ${s}`);return s}function ZN(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let s=0;s<e.length;++s){const r=e[s],a=t[s];if(r>=0&&a>=0&&r!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[s]=r>=0?r:a}return n}class JN{constructor(e,t,n,s,r,a,i){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=_l(0),La(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()})),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map((e=>this.read(e)))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),KN(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,La(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach(((e,n)=>this.write(e,t[n])))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return Ia([],[0].concat(this.elementShape));const n=this.readMany(e);return KN(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),dh(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return Ia([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return KN(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Io(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,_h(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const s=e.map((e=>(n+=e,n)));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:t.size/n,a=[];Oa((()=>{t=vo(t,[1,n,r]);for(let n=0;n<e.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,e[n],r];a[n]=vo(Co(t,i,o),this.elementShape)}return a}));const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,a)}}class QN{get id(){return this.idTensor.id}constructor(e,t,n,s=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach((e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);KN(t,e.shape,"TensorList shape mismatch: "),La(e)})),this.idTensor=_l(0),this.maxNumElements=s,La(this.idTensor)}copy(){return new QN([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.id)||t.dispose()})),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);KN(e,this.elementShape,"TensorList shape mismatch: ");const s=YN(this.elementShape,this.tensors,e);return Oa((()=>{const e=this.tensors.map((e=>vo(e,s)));return dh(e,0)}))}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=YN(this.elementShape,this.tensors,e),s=this.tensors.pop();return s.kept=!1,KN(s.shape,e,"TensorList shape mismatch: "),vo(s,n)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(KN(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");La(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);const t=new QN([],this.elementShape,this.elementDtype,this.maxNumElements);t.tensors.length=e;for(let n=0;n<Math.min(this.tensors.length,e);++n)t.tensors[n]=this.tensors[n];return t}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);KN(this.tensors[e].shape,t,"TensorList shape mismatch: ");const s=YN(this.elementShape,this.tensors,t);return vo(this.tensors[e],s)}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);KN(this.elementShape,t.shape,"TensorList shape mismatch: "),La(t),null!=this.tensors[e]&&(this.tensors[e].kept=!1),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);KN(this.elementShape,n,"TensorList shape mismatch: "),e=e.slice(0,this.size());const s=YN(this.elementShape,this.tensors,n);return 0===e.length?Ia([],[0].concat(s)):Oa((()=>{const t=e.map((e=>vo(this.tensors[e],s)));return dh(t,0)}))}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);KN(this.elementShape,t,"TensorList shape mismatch: ");const n=YN(this.elementShape,this.tensors,t);return 0===this.size()?Ia([],[0].concat(n)):Oa((()=>{const e=this.tensors.map((e=>vo(e,n)));return Io(e,0)}))}}const eI=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const s=rN("thenBranch",e,t,n),r=rN("elseBranch",e,t,n),a=rN("cond",e,t,n),i=rN("args",e,t,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=rN("body",e,t,n),r=rN("cond",e,t,n),a=rN("args",e,t,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map((e=>e.id));let l=await i[0].data();i.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||e.dispose()}));let u=a;for(;l[0];){const e=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const t=u.map((e=>e.id));e.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}));const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}))}return u}case"LoopCond":return[hN(rN("pred",e,t,n))];case"Switch":{const s=rN("pred",e,t,n);let r=rN("data",e,t,n);return r.kept||(r=hN(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=e.inputNames.find((e=>void 0!==aN(e,t,n)));if(s){return[hN(aN(s,t,n))]}return}case"Enter":{const s=rN("frameName",e,t,n),r=rN("tensor",e,t,n);return n.enterFrame(s),[hN(r)]}case"Exit":{const s=rN("tensor",e,t,n);return n.exitFrame(),[hN(s)]}case"NextIteration":{const s=rN("tensor",e,t,n);return n.nextIteration(),[hN(s)]}case"TensorArrayV3":{const s=rN("size",e,t,n),r=rN("dtype",e,t,n),a=rN("elementShape",e,t,n),i=rN("dynamicSize",e,t,n),o=rN("clearAfterRead",e,t,n),l=rN("identicalElementShapes",e,t,n),u=rN("name",e,t,n),c=new JN(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,_l(1)]}case"TensorArrayWriteV3":{const s=rN("tensorArrayId",e,t,n),r=rN("index",e,t,n),a=rN("tensor",e,t,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=rN("tensorArrayId",e,t,n),r=rN("index",e,t,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=rN("tensorArrayId",e,t,n),r=rN("indices",e,t,n),a=rN("dtype",e,t,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=rN("tensorArrayId",e,t,n),r=rN("indices",e,t,n),a=rN("tensor",e,t,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=rN("tensorArrayId",e,t,n),r=n.getTensorArray(s.id),a=rN("dtype",e,t,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=rN("tensorArrayId",e,t,n),r=rN("tensor",e,t,n),a=rN("lengths",e,t,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=rN("tensorArrayId",e,t,n);return[_l(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=rN("tensorArrayId",e,t,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=rN("tensorListId",e,t,n),r=rN("index",e,t,n),a=rN("tensor",e,t,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=rN("tensorListId",e,t,n),r=rN("index",e,t,n),a=rN("elementShape",e,t,n),i=rN("elementDType",e,t,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=rN("indices",e,t,n),r=function(e,t,n,s){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const r=Math.max(...t);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new QN([],n,e.dtype,s),i=_h(e,0);return t.forEach(((e,t)=>{a.setItem(e,i[t])})),a}(rN("tensor",e,t,n),s,rN("elementShape",e,t,n),rN("numElements",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const s=rN("elementShape",e,t,n),r=rN("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const i=rN(a,e,t,n),o=function(e,t,n,s){return new QN([],e,t,s)}(s,r,0,"TensorListReserve"===e.op?-1:i);return n.addTensorList(o),[o.idTensor]}case"TensorListGather":{const s=rN("tensorListId",e,t,n),r=rN("indices",e,t,n),a=rN("elementShape",e,t,n),i=rN("elementDType",e,t,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=rN("tensorListId",e,t,n),r=rN("elementShape",e,t,n),a=rN("elementDType",e,t,n),i=rN("numElements",e,t,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(e,t,n){const s=e.dtype;if(e.shape.length<1)throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);KN(e.shape.slice(1),t,"TensorList shape mismatch: ");const r=_h(e);return new QN(r,t,s)}(rN("tensor",e,t,n),rN("elementShape",e,t,n),rN("elementDType",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":case"TensorListConcatV2":{const s=rN("tensorListId",e,t,n),r=n.getTensorList(s.id),a=rN("dtype",e,t,n),i=rN("elementShape",e,t,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=rN("tensorListId",e,t,n),r=rN("tensor",e,t,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=rN("tensorListId",e,t,n),r=rN("elementShape",e,t,n),a=rN("elementDType",e,t,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=rN("tensor",e,t,n),r=rN("elementShape",e,t,n),a=function(e,t,n){let s=0;const r=t.map((e=>(s+=e,s)));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const a=ZN(e.shape.slice(1),n),i=0===s?0:e.size/s,o=Oa((()=>{const n=[];e=vo(e,[1,s,i]);for(let s=0;s<t.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,t[s],i];n[s]=vo(Co(e,o,l),a)}return e.dispose(),n})),l=new QN([],n,e.dtype,t.length);for(let e=0;e<o.length;e++)l.setItem(e,o[e]);return l}(s,rN("lengths",e,t,n),r);return n.addTensorList(a),[a.idTensor]}case"TensorListLength":{const s=rN("tensorListId",e,t,n);return[_l(n.getTensorList(s.id).size(),"int32")]}case"TensorListResize":{const s=rN("tensorListId",e,t,n),r=rN("size",e,t,n),a=n.getTensorList(s.id).resize(r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function tI(e,t,n){const[s,r]=rN("fusedOps",e,t,n),a="biasadd"===s,i=!a,o="prelu"===r,l="fusedbatchnorm"===s,u=rN("numArgs",e,t,n);if(a){if(o&&2!==u)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!o&&a&&1!==u)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(l)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");const c=rN("strides",e,t,n),h=cN(e,t,n),p=rN("dataFormat",e,t,n).toUpperCase(),d=rN("dilations",e,t,n);let[f,m]=rN("args",e,t,n);i&&(m=f,f=void 0);return{stride:c,pad:h,dataFormat:p,dilations:d,biasArg:f,preluArg:m,activationFunc:r,leakyreluAlpha:rN("leakyreluAlpha",e,t,n)}}function nI(e,t,n){return{boxes:rN("boxes",e,t,n),scores:rN("scores",e,t,n),maxOutputSize:rN("maxOutputSize",e,t,n),iouThreshold:rN("iouThreshold",e,t,n),scoreThreshold:rN("scoreThreshold",e,t,n),softNmsSigma:rN("softNmsSigma",e,t,n)}}class sI{get id(){return this.handle.id}constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=_l(0),this.tensorMap=new Map,La(this.handle)}clearAndClose(){this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}tensorSize(){return _l(this.size(),"int32")}async import(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),Oa((()=>{const e=_h(t),s=n.length,r=e.length;u(s===r,(()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`));for(let t=0;t<s;t++){const s=n[t],r=e[t];La(r),this.tensorMap.set(s,r)}return this.handle}))}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return Oa((()=>{const e=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,t);e.push(a)}return dh(e)}))}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`)}}function rI(e,t,n,s,r=Oa){const a=((e,t,n)=>{switch(e.category){case"arithmetic":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[s.add(rN("a",e,t,n),rN("b",e,t,n))];case"AddN":return[s.addN(rN("tensors",e,t,n))];case"FloorMod":case"Mod":return[s.mod(rN("a",e,t,n),rN("b",e,t,n))];case"Mul":return[s.mul(rN("a",e,t,n),rN("b",e,t,n))];case"RealDiv":case"Div":return[s.div(rN("a",e,t,n),rN("b",e,t,n))];case"DivNoNan":return[s.divNoNan(rN("a",e,t,n),rN("b",e,t,n))];case"FloorDiv":return[s.floorDiv(rN("a",e,t,n),rN("b",e,t,n))];case"Sub":return[s.sub(rN("a",e,t,n),rN("b",e,t,n))];case"Minimum":return[s.minimum(rN("a",e,t,n),rN("b",e,t,n))];case"Maximum":return[s.maximum(rN("a",e,t,n),rN("b",e,t,n))];case"Pow":return[s.pow(rN("a",e,t,n),rN("b",e,t,n))];case"SquaredDifference":return[s.squaredDifference(rN("a",e,t,n),rN("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"basic_math":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Abs":case"ComplexAbs":return[s.abs(rN("x",e,t,n))];case"Acos":return[s.acos(rN("x",e,t,n))];case"Acosh":return[s.acosh(rN("x",e,t,n))];case"Asin":return[s.asin(rN("x",e,t,n))];case"Asinh":return[s.asinh(rN("x",e,t,n))];case"Atan":return[s.atan(rN("x",e,t,n))];case"Atan2":return[s.atan2(rN("x",e,t,n),rN("y",e,t,n))];case"Atanh":return[s.atanh(rN("x",e,t,n))];case"Ceil":return[s.ceil(rN("x",e,t,n))];case"Complex":return[s.complex(rN("real",e,t,n),rN("imag",e,t,n))];case"Cos":return[s.cos(rN("x",e,t,n))];case"Cosh":return[s.cosh(rN("x",e,t,n))];case"Elu":return[s.elu(rN("x",e,t,n))];case"Erf":return[s.erf(rN("x",e,t,n))];case"Exp":return[s.exp(rN("x",e,t,n))];case"Expm1":return[s.expm1(rN("x",e,t,n))];case"Floor":return[s.floor(rN("x",e,t,n))];case"Log":return[s.log(rN("x",e,t,n))];case"Log1p":return[s.log1p(rN("x",e,t,n))];case"Imag":return[s.imag(rN("x",e,t,n))];case"Neg":return[s.neg(rN("x",e,t,n))];case"Reciprocal":return[s.reciprocal(rN("x",e,t,n))];case"Real":return[s.real(rN("x",e,t,n))];case"Relu":return[s.relu(rN("x",e,t,n))];case"Round":return[s.round(rN("x",e,t,n))];case"Selu":return[s.selu(rN("x",e,t,n))];case"Sigmoid":return[s.sigmoid(rN("x",e,t,n))];case"Sin":return[s.sin(rN("x",e,t,n))];case"Sign":return[s.sign(rN("x",e,t,n))];case"Sinh":return[s.sinh(rN("x",e,t,n))];case"Softplus":return[s.softplus(rN("x",e,t,n))];case"Sqrt":return[s.sqrt(rN("x",e,t,n))];case"Square":return[s.square(rN("x",e,t,n))];case"Tanh":return[s.tanh(rN("x",e,t,n))];case"Tan":return[s.tan(rN("x",e,t,n))];case"ClipByValue":return[s.clipByValue(rN("x",e,t,n),rN("clipValueMin",e,t,n),rN("clipValueMax",e,t,n))];case"Relu6":return[s.relu6(rN("x",e,t,n))];case"Rsqrt":return[s.rsqrt(aN(e.inputNames[0],t,n))];case"LeakyRelu":return[s.leakyRelu(rN("x",e,t,n),rN("alpha",e,t,n))];case"Prelu":return[s.prelu(rN("x",e,t,n),rN("alpha",e,t,n))];case"IsNan":return[s.isNaN(aN(e.inputNames[0],t,n))];case"IsInf":return[s.isInf(aN(e.inputNames[0],t,n))];case"IsFinite":return[s.isFinite(aN(e.inputNames[0],t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"control":return eI(e,t,n);case"convolution":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Conv1D":{const r=rN("stride",e,t,n),a=rN("pad",e,t,n),i=rN("dataFormat",e,t,n).toUpperCase(),o=rN("dilation",e,t,n);return[s.conv1d(rN("x",e,t,n),rN("filter",e,t,n),r,a,i,o)]}case"Conv2D":{const r=rN("strides",e,t,n),a=cN(e,t,n),i=rN("dataFormat",e,t,n).toUpperCase(),o=rN("dilations",e,t,n);return[s.conv2d(rN("x",e,t,n),rN("filter",e,t,n),[r[1],r[2]],a,i,[o[1],o[2]])]}case"_FusedConv2D":{const{stride:r,pad:a,dataFormat:i,dilations:o,biasArg:l,preluArg:u,activationFunc:c,leakyreluAlpha:h}=tI(e,t,n);return[s.fused.conv2d({x:rN("x",e,t,n),filter:rN("filter",e,t,n),strides:[r[1],r[2]],pad:a,dataFormat:i,dilations:[o[1],o[2]],bias:l,activation:c,preluActivationWeights:u,leakyreluAlpha:h})]}case"FusedDepthwiseConv2dNative":{const{stride:r,pad:a,dataFormat:i,dilations:o,biasArg:l,preluArg:u,activationFunc:c,leakyreluAlpha:h}=tI(e,t,n);return[s.fused.depthwiseConv2d({x:rN("x",e,t,n),filter:rN("filter",e,t,n),strides:[r[1],r[2]],pad:a,dataFormat:i,dilations:[o[1],o[2]],bias:l,activation:c,preluActivationWeights:u,leakyreluAlpha:h})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const r=rN("outputShape",e,t,n),a=rN("strides",e,t,n),i=cN(e,t,n);return[s.conv2dTranspose(rN("x",e,t,n),rN("filter",e,t,n),r,[a[1],a[2]],i)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const r=rN("strides",e,t,n),a=cN(e,t,n),i=rN("dilations",e,t,n),o=rN("dataFormat",e,t,n).toUpperCase();return[s.depthwiseConv2d(rN("input",e,t,n),rN("filter",e,t,n),[r[1],r[2]],a,o,[i[1],i[2]])]}case"Conv3D":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("dataFormat",e,t,n).toUpperCase(),o=rN("dilations",e,t,n);return[s.conv3d(rN("x",e,t,n),rN("filter",e,t,n),[r[1],r[2],r[3]],a,i,[o[1],o[2],o[3]])]}case"AvgPool":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("kernelSize",e,t,n);return[s.avgPool(rN("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a)]}case"MaxPool":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("kernelSize",e,t,n);return[s.maxPool(rN("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a)]}case"MaxPoolWithArgmax":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("kernelSize",e,t,n),o=rN("includeBatchInIndex",e,t,n),{result:l,indexes:u}=s.maxPoolWithArgmax(rN("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a,o);return[l,u]}case"AvgPool3D":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("kernelSize",e,t,n);return[s.avgPool3d(rN("x",e,t,n),[i[1],i[2],i[3]],[r[1],r[2],r[3]],a)]}case"MaxPool3D":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("kernelSize",e,t,n);return[s.maxPool3d(rN("x",e,t,n),[i[1],i[2],i[3]],[r[1],r[2],r[3]],a)]}case"Dilation2D":{const r=rN("strides",e,t,n),a=rN("pad",e,t,n),i=rN("dilations",e,t,n),o=r[1],l=r[2],u=i[1],c=i[2];return[s.dilation2d(rN("x",e,t,n),rN("filter",e,t,n),[o,l],a,[u,c],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"creation":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Fill":{const r=rN("shape",e,t,n),a=rN("dtype",e,t,n),i=rN("value",e,t,n);return[s.fill(r,i,a)]}case"LinSpace":{const r=rN("start",e,t,n),a=rN("stop",e,t,n),i=rN("num",e,t,n);return[s.linspace(r,a,i)]}case"Multinomial":{const r=rN("logits",e,t,n),a=rN("numSamples",e,t,n),i=rN("seed",e,t,n);return[s.multinomial(r,a,i)]}case"OneHot":{const r=rN("indices",e,t,n),a=rN("depth",e,t,n),i=rN("onValue",e,t,n),o=rN("offValue",e,t,n),l=rN("dtype",e,t,n);return[s.oneHot(r,a,i,o,l)]}case"Ones":return[s.ones(rN("shape",e,t,n),rN("dtype",e,t,n))];case"OnesLike":return[s.onesLike(rN("x",e,t,n))];case"RandomStandardNormal":return[s.randomStandardNormal(rN("shape",e,t,n),rN("dtype",e,t,n),rN("seed",e,t,n))];case"RandomUniform":return[s.randomUniform(rN("shape",e,t,n),rN("minval",e,t,n),rN("maxval",e,t,n),rN("dtype",e,t,n))];case"RandomUniformInt":return[s.randomUniformInt(rN("shape",e,t,n),rN("minval",e,t,n),rN("maxval",e,t,n),rN("seed",e,t,n))];case"Range":{const r=rN("start",e,t,n),a=rN("stop",e,t,n),i=rN("step",e,t,n);return[s.range(r,a,i,rN("dtype",e,t,n))]}case"TruncatedNormal":{const r=rN("shape",e,t,n),a=rN("mean",e,t,n),i=rN("stdDev",e,t,n),o=rN("seed",e,t,n);return[s.truncatedNormal(r,a,i,rN("dtype",e,t,n),o)]}case"Zeros":return[s.zeros(rN("shape",e,t,n),rN("dtype",e,t,n))];case"ZerosLike":return[s.zerosLike(rN("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"dynamic":return(async(e,t,n,s,r=qN)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=nI(e,t,n),c=await r.image.nonMaxSuppressionWithScoreAsync(s,a,i,o,l,u);return[c.selectedIndices,c.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=nI(e,t,n),u=rN("padToMaxOutputSize",e,t,n),c=await r.image.nonMaxSuppressionPaddedAsync(s,a,i,o,l,u);return[c.selectedIndices,c.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=nI(e,t,n);return[await r.image.nonMaxSuppressionAsync(s,a,i,o,l)]}case"Where":{const s=r.cast(rN("condition",e,t,n),"bool"),a=[await r.whereAsync(s)];return s.dispose(),a}case"ListDiff":return r.setdiff1dAsync(rN("x",e,t,n),rN("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n);case"evaluation":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"LowerBound":{const r=rN("sortedSequence",e,t,n),a=rN("values",e,t,n);return[s.lowerBound(r,a)]}case"TopKV2":{const r=rN("x",e,t,n),a=rN("k",e,t,n),i=rN("sorted",e,t,n),o=s.topk(r,a,i);return[o.values,o.indices]}case"UpperBound":{const r=rN("sortedSequence",e,t,n),a=rN("values",e,t,n);return[s.upperBound(r,a)]}case"Unique":{const r=rN("x",e,t,n),a=s.unique(r);return[a.values,a.indices]}case"UniqueV2":{const r=rN("x",e,t,n),a=rN("axis",e,t,n),i=s.unique(r,a);return[i.values,i.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"image":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"ResizeBilinear":{const r=rN("images",e,t,n),a=rN("size",e,t,n),i=rN("alignCorners",e,t,n),o=rN("halfPixelCenters",e,t,n);return[s.image.resizeBilinear(r,[a[0],a[1]],i,o)]}case"ResizeNearestNeighbor":{const r=rN("images",e,t,n),a=rN("size",e,t,n),i=rN("alignCorners",e,t,n),o=rN("halfPixelCenters",e,t,n);return[s.image.resizeNearestNeighbor(r,[a[0],a[1]],i,o)]}case"CropAndResize":{const r=rN("image",e,t,n),a=rN("boxes",e,t,n),i=rN("boxInd",e,t,n),o=rN("cropSize",e,t,n),l=rN("method",e,t,n),u=rN("extrapolationValue",e,t,n);return[s.image.cropAndResize(r,a,i,o,l,u)]}case"ImageProjectiveTransformV3":{const r=rN("images",e,t,n),a=rN("transforms",e,t,n),i=rN("outputShape",e,t,n),o=rN("fillValue",e,t,n),l=rN("interpolation",e,t,n),u=rN("fillMode",e,t,n);return[s.image.transform(r,a,l.toLowerCase(),u.toLowerCase(),o,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"graph":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const r=rN("default",e,t,n);return[aN(e.name,t,n)||r];case"Placeholder":return[aN(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":case"Snapshot":return[hN(rN("x",e,t,n))];case"IdentityN":return rN("x",e,t,n).map((e=>hN(e)));case"Shape":return[s.tensor1d(rN("x",e,t,n).shape,"int32")];case"ShapeN":return rN("x",e,t,n).map((e=>s.tensor1d(e.shape)));case"Size":return[s.scalar(rN("x",e,t,n).size,"int32")];case"Rank":return[s.scalar(rN("x",e,t,n).rank,"int32")];case"NoOp":return[s.scalar(1)];case"Print":const a=rN("x",e,t,n),i=rN("data",e,t,n),o=rN("message",e,t,n),l=rN("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(o);for(let e=0;e<i.length;e++)console.log(Array.prototype.slice.call(i[e].dataSync()).slice(0,l));return[a];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"logical":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Equal":return[s.equal(rN("a",e,t,n),rN("b",e,t,n))];case"NotEqual":return[s.notEqual(rN("a",e,t,n),rN("b",e,t,n))];case"Greater":return[s.greater(rN("a",e,t,n),rN("b",e,t,n))];case"GreaterEqual":return[s.greaterEqual(rN("a",e,t,n),rN("b",e,t,n))];case"Less":return[s.less(rN("a",e,t,n),rN("b",e,t,n))];case"LessEqual":return[s.lessEqual(rN("a",e,t,n),rN("b",e,t,n))];case"LogicalAnd":return[s.logicalAnd(rN("a",e,t,n),rN("b",e,t,n))];case"LogicalNot":return[s.logicalNot(rN("a",e,t,n))];case"LogicalOr":return[s.logicalOr(rN("a",e,t,n),rN("b",e,t,n))];case"Select":case"SelectV2":return[s.where(rN("condition",e,t,n),rN("a",e,t,n),rN("b",e,t,n))];case"BitwiseAnd":return[s.bitwiseAnd(rN("a",e,t,n),rN("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"matrices":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[s.matMul(rN("a",e,t,n),rN("b",e,t,n),rN("transposeA",e,t,n),rN("transposeB",e,t,n))];case"Einsum":return[s.einsum(rN("equation",e,t,n),...rN("tensors",e,t,n))];case"Transpose":return[s.transpose(rN("x",e,t,n),rN("perm",e,t,n))];case"_FusedMatMul":const[r,a]=rN("fusedOps",e,t,n),i="biasadd"===r,o="prelu"===a,l=rN("numArgs",e,t,n),u=rN("leakyreluAlpha",e,t,n);if(i){if(o&&2!==l)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!o&&1!==l)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[c,h]=rN("args",e,t,n);return[s.fused.matMul({a:rN("a",e,t,n),b:rN("b",e,t,n),transposeA:rN("transposeA",e,t,n),transposeB:rN("transposeB",e,t,n),bias:c,activation:a,preluActivationWeights:h,leakyreluAlpha:u})];case"MatrixBandPart":return[s.linalg.bandPart(rN("a",e,t,n),rN("numLower",e,t,n),rN("numUpper",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"normalization":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"EuclideanNorm":return[s.euclideanNorm(rN("x",e,t,n),rN("axis",e,t,n),rN("keepDims",e,t,n))];case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[s.batchNorm(rN("x",e,t,n),rN("mean",e,t,n),rN("variance",e,t,n),rN("offset",e,t,n),rN("scale",e,t,n),rN("epsilon",e,t,n))];case"LRN":return[s.localResponseNormalization(rN("x",e,t,n),rN("radius",e,t,n),rN("bias",e,t,n),rN("alpha",e,t,n),rN("beta",e,t,n))];case"Softmax":return[s.softmax(rN("x",e,t,n))];case"LogSoftmax":return[s.logSoftmax(rN("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"ragged":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"RaggedGather":{const{outputNestedSplits:r,outputDenseValues:a}=s.raggedGather(rN("paramsNestedSplits",e,t,n),rN("paramsDenseValues",e,t,n),rN("indices",e,t,n),rN("outputRaggedRank",e,t,n));return r.concat(a)}case"RaggedRange":{const{rtNestedSplits:r,rtDenseValues:a}=s.raggedRange(rN("starts",e,t,n),rN("limits",e,t,n),rN("splits",e,t,n));return[r,a]}case"RaggedTensorToTensor":return[s.raggedTensorToTensor(rN("shape",e,t,n),rN("values",e,t,n),rN("defaultValue",e,t,n),rN("rowPartitionTensors",e,t,n),rN("rowPartitionTypes",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"reduction":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Max":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.max(rN("x",e,t,n),r,a)]}case"Mean":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.mean(rN("x",e,t,n),r,a)]}case"Min":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.min(rN("x",e,t,n),r,a)]}case"Sum":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.sum(rN("x",e,t,n),r,a)]}case"All":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.all(rN("x",e,t,n),r,a)]}case"Any":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.any(rN("x",e,t,n),r,a)]}case"ArgMax":{const r=rN("axis",e,t,n);return[s.argMax(rN("x",e,t,n),r)]}case"ArgMin":{const r=rN("axis",e,t,n);return[s.argMin(rN("x",e,t,n),r)]}case"Prod":{const r=rN("axis",e,t,n),a=rN("keepDims",e,t,n);return[s.prod(rN("x",e,t,n),r,a)]}case"Cumprod":{const r=rN("axis",e,t,n),a=rN("exclusive",e,t,n),i=rN("reverse",e,t,n);return[s.cumprod(rN("x",e,t,n),r,a,i)]}case"Cumsum":{const r=rN("axis",e,t,n),a=rN("exclusive",e,t,n),i=rN("reverse",e,t,n);return[s.cumsum(rN("x",e,t,n),r,a,i)]}case"Bincount":const r=rN("x",e,t,n),a=rN("weights",e,t,n),i=rN("size",e,t,n);return[s.bincount(r,a,i)];case"DenseBincount":{const r=rN("x",e,t,n),a=rN("weights",e,t,n),i=rN("size",e,t,n),o=rN("binaryOutput",e,t,n);return[s.denseBincount(r,a,i,o)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"slice_join":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"ConcatV2":case"Concat":{const r=rN("n",e,t,n),a=rN("axis",e,t,n);let i=rN("tensors",e,t,n);return i=i.slice(0,r),[s.concat(i,a)]}case"Gather":{const r=rN("x",e,t,n),a=rN("indices",e,t,n);return[s.gather(r,s.cast(a,"int32"),0)]}case"GatherV2":{const r=rN("axis",e,t,n),a=rN("batchDims",e,t,n),i=rN("x",e,t,n),o=rN("indices",e,t,n);return[s.gather(i,s.cast(o,"int32"),r,a)]}case"Reverse":{const r=rN("dims",e,t,n),a=[];for(let e=0;e<r.length;e++)r[e]&&a.push(e);const i=rN("x",e,t,n);return[s.reverse(i,a)]}case"ReverseV2":{const r=rN("axis",e,t,n),a=rN("x",e,t,n);return[s.reverse(a,r)]}case"Slice":{const r=rN("begin",e,t,n),a=rN("size",e,t,n);return[s.slice(rN("x",e,t,n),r,a)]}case"StridedSlice":{const r=rN("begin",e,t,n),a=rN("end",e,t,n),i=rN("strides",e,t,n),o=rN("beginMask",e,t,n),l=rN("endMask",e,t,n),u=rN("ellipsisMask",e,t,n),c=rN("newAxisMask",e,t,n),h=rN("shrinkAxisMask",e,t,n),p=rN("x",e,t,n);return[s.stridedSlice(p,r,a,i,o,l,u,c,h)]}case"Pack":return Oa((()=>{const r=rN("axis",e,t,n),a=rN("tensors",e,t,n),i=a[0].shape,o=s.squeeze(a[0]).shape,l=a.map((e=>{const t=f(e.shape,i);if(!t&&!f(s.squeeze(e).shape,o))throw new Error("the input tensors shape does not match");return t?e:s.reshape(e,i)}));return[s.stack(l,r)]}));case"Unpack":{const r=rN("axis",e,t,n),a=rN("tensor",e,t,n);return s.unstack(a,r)}case"Tile":{const r=rN("reps",e,t,n);return[s.tile(rN("x",e,t,n),r)]}case"Split":case"SplitV":{const r=rN("axis",e,t,n),a=rN("numOrSizeSplits",e,t,n),i=rN("x",e,t,n);return s.split(i,a,r)}case"ScatterNd":{const r=rN("indices",e,t,n),a=rN("values",e,t,n),i=rN("shape",e,t,n);return[s.scatterND(r,a,i)]}case"GatherNd":{const r=rN("x",e,t,n),a=rN("indices",e,t,n);return[s.gatherND(r,a)]}case"SparseToDense":{const r=rN("sparseIndices",e,t,n),a=rN("outputShape",e,t,n),i=rN("sparseValues",e,t,n),o=rN("defaultValue",e,t,n);return[s.sparseToDense(r,i,a,i.dtype===o.dtype?o:s.cast(o,i.dtype))]}case"TensorScatterUpdate":{const r=rN("indices",e,t,n),a=rN("values",e,t,n),i=rN("tensor",e,t,n);return[s.tensorScatterUpdate(i,r,a)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"sparse":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"SparseFillEmptyRows":{const{outputIndices:r,outputValues:a,emptyRowIndicator:i,reverseIndexMap:o}=s.sparse.sparseFillEmptyRows(rN("indices",e,t,n),rN("values",e,t,n),rN("denseShape",e,t,n),rN("defaultValue",e,t,n));return[r,a,i,o]}case"SparseReshape":{const{outputIndices:r,outputShape:a}=s.sparse.sparseReshape(rN("inputIndices",e,t,n),rN("inputShape",e,t,n),rN("newShape",e,t,n));return[r,a]}case"SparseSegmentMean":return[s.sparse.sparseSegmentMean(rN("data",e,t,n),rN("indices",e,t,n),rN("segmentIds",e,t,n))];case"SparseSegmentSum":return[s.sparse.sparseSegmentSum(rN("data",e,t,n),rN("indices",e,t,n),rN("segmentIds",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"spectral":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"FFT":return[s.fft(rN("x",e,t,n))];case"IFFT":return[s.ifft(rN("x",e,t,n))];case"RFFT":return[s.rfft(rN("x",e,t,n))];case"IRFFT":return[s.irfft(rN("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"string":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"StaticRegexReplace":return[s.string.staticRegexReplace(rN("input",e,t,n),rN("pattern",e,t,n),rN("rewrite",e,t,n),rN("replaceGlobal",e,t,n))];case"StringNGrams":{const{nGrams:r,nGramsSplits:a}=s.string.stringNGrams(rN("data",e,t,n),rN("dataSplits",e,t,n),rN("separator",e,t,n),rN("nGramWidths",e,t,n),rN("leftPad",e,t,n),rN("rightPad",e,t,n),rN("padWidth",e,t,n),rN("preserveShortSequences",e,t,n));return[r,a]}case"StringSplit":{const{indices:r,values:a,shape:i}=s.string.stringSplit(rN("input",e,t,n),rN("delimiter",e,t,n),rN("skipEmpty",e,t,n));return[r,a,i]}case"StringToHashBucketFast":return[s.string.stringToHashBucketFast(rN("input",e,t,n),rN("numBuckets",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"transformation":return r((()=>((e,t,n,s=qN)=>{switch(e.op){case"Cast":return[s.cast(rN("x",e,t,n),rN("dtype",e,t,n))];case"ExpandDims":{const r=rN("axis",e,t,n);return[s.expandDims(rN("x",e,t,n),r)]}case"Squeeze":{const r=rN("axis",e,t,n);return[s.squeeze(rN("x",e,t,n),r)]}case"Reshape":return[s.reshape(rN("x",e,t,n),rN("shape",e,t,n))];case"EnsureShape":return[s.ensureShape(rN("x",e,t,n),rN("shape",e,t,n))];case"MirrorPad":return[s.mirrorPad(rN("x",e,t,n),rN("padding",e,t,n),rN("mode",e,t,n))];case"PadV2":case"Pad":return[s.pad(rN("x",e,t,n),rN("padding",e,t,n),rN("constantValue",e,t,n))];case"SpaceToBatchND":{const r=rN("blockShape",e,t,n),a=rN("paddings",e,t,n);return[s.spaceToBatchND(rN("x",e,t,n),r,a)]}case"BatchToSpaceND":{const r=rN("blockShape",e,t,n),a=rN("crops",e,t,n);return[s.batchToSpaceND(rN("x",e,t,n),r,a)]}case"DepthToSpace":{const r=rN("blockSize",e,t,n),a=rN("dataFormat",e,t,n).toUpperCase();return[s.depthToSpace(rN("x",e,t,n),r,a)]}case"BroadcastTo":return[s.broadcastTo(rN("x",e,t,n),rN("shape",e,t,n))];case"BroadcastArgs":return[s.broadcastArgs(rN("s0",e,t,n),rN("s1",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"hash_table":return(async(e,t,n,s)=>{switch(e.op){case"HashTable":case"HashTableV2":{const r=s.getHashTableHandleByName(e.name);if(null!=r)return[r];{const r=rN("keyDType",e,t,n),a=rN("valueDType",e,t,n),i=new sI(r,a);return s.addHashTable(e.name,i),[i.handle]}}case"InitializeTable":case"InitializeTableV2":case"LookupTableImport":case"LookupTableImportV2":{const r=rN("tableHandle",e,t,n,s),a=rN("keys",e,t,n),i=rN("values",e,t,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=rN("tableHandle",e,t,n,s),a=rN("keys",e,t,n),i=rN("defaultValue",e,t,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}case"LookupTableSize":case"LookupTableSizeV2":{const r=rN("tableHandle",e,t,n,s);return[s.getHashTableById(r.id).tensorSize()]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n,s);case"custom":const a=nN(e.op);if(a&&a.customExecutor)return a.customExecutor(new jN(e,t,n));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,t,n);return H(a)?a.then((e=>[].concat(e))):[].concat(a)}class aI{constructor(e={},t={},n={},s={},r){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=s,this.parseNodeNameCache=r,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map((e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`)).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function iI(e,t,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=new Set(Object.keys(e).map((e=>uN(e)[0])));s=s||[];const c=new Set(s.map((e=>uN(e.name)[0]))),h=[...t];for(;h.length>0;){const e=h.pop();(pI(e)||dI(e)||fI(e))&&null==i&&(i=e,o=i.children.map((e=>e.name)).filter((e=>r.has(e)))),r.add(e.name),null==n[e.name]&&(u.has(e.name)||c.has(e.name)||(0!==e.inputs.length?e.inputs.forEach((e=>{l.has(e.name)||(l.add(e.name),h.push(e))})):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}function oI(e,t){const{usedNodes:n,inputs:s}=t,r=Object.keys(s).map((e=>uN(e)[0])).map((t=>e.nodes[t])),a=e.initNodes||[],i=e=>n.has("string"==typeof e?e:e.name);function o(e){return[...new Map(e.map((e=>[e.name,e]))).values()]}const l=o([...r,...e.weights,...a]).filter(i),u=o([...l,...Object.values(e.nodes)]).filter(i),c=new Map(u.map((e=>[e.name,e]))),h={};for(const e of u){h[e.name]=h[e.name]||0;for(const t of e.children)i(t)||(h[t.name]=Number.POSITIVE_INFINITY),h[t.name]=(h[t.name]||0)+1}const p=Object.entries(h).filter((([,e])=>0===e)).map((([e])=>e)),d=[...p];for(;p.length>0;){const e=p.pop(),t=c.get(e);for(const e of t.children.filter(i))0==--h[e.name]&&(d.push(e.name),p.push(e.name))}const f=function(e,t){const n=new Map(e.map((e=>[e.name,e]))),s=t.map((e=>e.name)),r=new Set(s);for(;s.length>0;){const e=s.pop(),t=n.get(e);for(const e of t.children)n.has(e.name)&&!r.has(e.name)&&(r.add(e.name),s.push(e.name))}return e.filter((e=>r.has(e.name)))}(d.map((e=>c.get(e))),l);return function(e,t){const n=new Map(e.map(((e,t)=>[e.name,t]))),s=new Set(t.map((e=>e.name))),r=e=>s.has("string"==typeof e?e:e.name),a=new Set(e.map((e=>e.name))),i=e=>a.has("string"==typeof e?e:e.name);for(const t of e){for(const e of t.children.filter(i)){if(!n.has(e.name))throw new lI(`Child ${e.name} of node ${t.name} is unreachable.`);if(n.get(t.name)>n.get(e.name))throw new lI(`Node ${t.name} is scheduled to run after its child ${e.name}.`)}if(!r(t))for(const e of t.inputs){if(!n.has(e.name))throw new lI(`Input ${e.name} of node ${t.name} is unreachable.`);if(n.get(e.name)>n.get(t.name))throw new lI(`Node ${t.name} is scheduled to run before its input ${e.name}.`)}}}(f,l),f}class lI extends Error{constructor(e){super(`NodesExecutionOrderError: ${e}`)}}const uI=new Set(["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"]),cI=new Set(["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"]),hI=new Set(["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2","LookupTableSize","LookupTableSizeV2"]);function pI(e){return uI.has(e.op)}function dI(e){return cI.has(e.op)}function fI(e){return hI.has(e.op)}class mI{get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map((t=>e[t].map((e=>e.id))));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get outputs(){return this._outputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get inputNodes(){return this._inputs.map((e=>e.signatureKey||e.name))}get outputNodes(){return this._outputs.map((e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t}))}get functions(){return Object.keys(this._functions).reduce(((e,t)=>(e[t]=this._functions[t].signature,e)),{})}constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this.parseNodeNameCache=new Map,this._weightMap={},this.SEPARATOR=",",this._functions={},this._functionExecutorMap={},this.keepIntermediateTensors=!1,this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach((t=>{this._functionExecutorMap[t]=new mI(e.functions[t],this)}))}getCompilationKey(e,t){const n=e.map((e=>e.name)).sort(),s=t.map((e=>e.name)).sort();return n.join(this.SEPARATOR)+"--"+s.join(this.SEPARATOR)}compile(e,t){const n=iI(e,t,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=t.map((e=>e.name)),r=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}const i=oI(this.graph,n),o=function(e){const t=new Map(e.map(((e,t)=>[e.name,t]))),n=Number.MAX_SAFE_INTEGER,s=e.map(((e,t)=>pI(e)?n:t)),r=e=>{const n=s[t.get(e.name)];return null==n?-1:n},a=e.map(((e,t)=>e.children.map(r).reduce(((e,t)=>Math.max(e,t)),s[t]))),i=new Map;for(let t=0;t<e.length;++t){const s=a[t];if(s===n)continue;const r=e[t],o=e[s];i.has(o.name)||i.set(o.name,[]),i.get(o.name).push(r)}return i}(i);return{orderedNodes:i,nodeLiveUntilMap:o}}cloneAndKeepTensor(e){if(null==e)return null;const t=e.clone();return La(t),t}cloneTensorList(e){if(!e)return null;const t=e.map((e=>this.cloneAndKeepTensor(e)));return t}cloneTensorMap(e){return Object.fromEntries(Object.entries(e).map((([e,t])=>[e,this.cloneTensorList(t)])))}execute(e,t){this.disposeIntermediateTensors(),e=this.mapInputs(e);const n=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=n.map((e=>this.graph.nodes[uN(e)[0]])),r=t.map((e=>uN(e)[0])),a=new Set(r);let i=r.map((e=>this.graph.nodes[e]));0===i.length&&(i=this._outputs);const o=this.getCompilationKey(s,i);let l=this.compiledMap.get(o);null==l&&(l=this.compile(e,i),this.compiledMap.set(o,l));try{this.keepIntermediateTensors=K().getBool("KEEP_INTERMEDIATE_TENSORS")}catch(e){this.keepIntermediateTensors=!1,console.warn(e.message)}const u={},c={};return Oa((()=>{const n=new aI(this.weightMap,u,c,this.functionExecutorMap,this.parseNodeNameCache),s=Object.assign({},this.weightMap);this.keepIntermediateTensors&&(this.clonedTensorsMap=this.cloneTensorMap(this.weightMap)),Object.keys(e).forEach((t=>{const[r,a]=uN(t,n),i=[];i[a]=e[t],s[r]=i,this.keepIntermediateTensors&&(this.clonedTensorsMap[r]=this.cloneTensorList(i))}));const r=this.getFrozenTensorIds(s),{orderedNodes:i,nodeLiveUntilMap:o}=l;for(const e of i){if(s[e.name])continue;const t=rI(e,s,n,this._resourceManager);if(H(t))throw new Error(`The execution of the op '${e.op}' returned a promise. Please use model.executeAsync() instead.`);s[e.name]=t,this.keepIntermediateTensors&&(this.clonedTensorsMap[e.name]=this.cloneTensorList(t)),this.checkTensorForDisposalWithNodeLiveUntilInfo(e,s,n,r,a,o.get(e.name))}return null==this.parent&&n.dispose(r),t.map((e=>aN(e,s,n)))}))}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map((t=>e[t])).map((e=>e.map((e=>e.id)))));return new Set(t)}checkTensorForDisposal(e,t,n,s,r,a,i){if(!pI(t)&&!a.has(e)){for(const s of n[e])null!=s&&(i[s.id]=(i[s.id]||0)+t.children.length);for(const e of t.inputs){if(pI(e))continue;const t=iN(e.name,n,s);if(null!=t)for(const e of t){if(!e||e.kept||r.has(e.id))continue;const t=i[e.id];1===t?(e.dispose(),delete i[e.id]):null!=t&&i[e.id]--}}}}checkTensorForDisposalWithNodeLiveUntilInfo(e,t,n,s,r,a){function i(e){return pI(e)||r.has(e.name)}if(!pI(e)&&null!=a)for(const e of a){if(i(e))continue;const r=iN(e.name,t,n);for(const e of r)!e||e.kept||s.has(e.id)||e.dispose()}}async executeAsync(e,t){return this._executeAsync(e,t)}disposeIntermediateTensors(){this.clonedTensorsMap&&(Object.values(this.clonedTensorsMap).forEach((e=>{for(const t of e)t&&!t.isDisposed&&t.dispose()})),this.clonedTensorsMap=null)}getIntermediateTensors(){return this.clonedTensorsMap}async _executeAsync(e,t,n=!1,s={},r={}){this.disposeIntermediateTensors(),n||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t));try{this.keepIntermediateTensors=K().getBool("KEEP_INTERMEDIATE_TENSORS")}catch(e){this.keepIntermediateTensors=!1,console.warn(e.message)}const a=new aI(this.weightMap,s,r,this.functionExecutorMap,this.parseNodeNameCache);this.keepIntermediateTensors&&(this.clonedTensorsMap=this.cloneTensorMap(this.weightMap));const i=await this.executeWithControlFlow(e,a,t,n),o=t.map((e=>aN(e,i,a))),l=o.map((e=>e.id)),u=Object.keys(e).map((t=>e[t].id)),c=new Set([...l,...u,...this.weightIds]);return Object.values(i).forEach((e=>{e.forEach((e=>{!e||e.isDisposed||c.has(e.id)||e.dispose()}))})),null==this.parent&&a.dispose(c),o}async executeFunctionAsync(e,t,n){const s=e.reduce(((e,t,n)=>(e[this.inputs[n].name]=t,e)),{});return this._executeAsync(s,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,s){const r=Object.keys(e),a=r.map((e=>this.graph.nodes[uN(e)[0]])),i=n.map((e=>uN(e)[0])),o=new Set(i);let l=i.map((e=>this.graph.nodes[e]));0===l.length&&(l=this._outputs);const{usedNodes:u,missingInputs:c,dynamicNode:h,syncInputs:p}=iI(e,l,this.weightMap,this._initNodes),d=[...a,...this.graph.weights,...this._initNodes||[]].map((e=>({node:e,contexts:t.currentContext}))),f=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,s]=uN(t),r=[];r[s]=e[t],f[n]=r}));const m={},g=this.getFrozenTensorIds(f),y={};for(;d.length>0;){const e=this.processStack(a,d,t,f,y,g,o,m,u);await Promise.all(e)}null!=h||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const b=l.filter((e=>!pI(e)&&!aN(e.name,f,t))).map((e=>e.name));if(b.length>0){let e="";throw null!=h&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${p}]`),new Error(`Cannot compute the outputs [${b}] from the provided inputs [${r}]. Consider providing the following inputs: [${c}]. ${e}`)}return f}processStack(e,t,n,s,r,a,i,o,l){const u=[];for(;t.length>0;){const e=t.pop();n.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&rN("isConstant",e.node,s,n)&&([c]=oN(e.node.name,n)),null==s[e.node.name]){const h=rI(e.node,s,n,this._resourceManager);c||([c]=oN(e.node.name,n));const p=n.currentContext;H(h)?u.push(h.then((u=>(s[c]=u,this.keepIntermediateTensors&&(this.clonedTensorsMap[c]=this.cloneTensorList(u)),n.currentContext=p,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l),u)))):(s[c]=h,this.keepIntermediateTensors&&(this.clonedTensorsMap[c]=this.cloneTensorList(h)),this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l))}else this.processChildNodes(e.node,t,n,s,r,l)}return u}processChildNodes(e,t,n,s,r,a){e.children.forEach((e=>{const[i]=oN(e.name,n);!r[i]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some((e=>!!aN(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every((e=>!!aN(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})))}))}dispose(){Object.keys(this.weightMap).forEach((e=>this.weightMap[e].forEach((e=>e.dispose()))))}checkInputShapeAndType(e){Object.keys(e).forEach((t=>{const n=e[t],[s]=uN(t),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const e=r.attrParams.shape.value,t=e.length===n.shape.length&&n.shape.every(((t,n)=>-1===e[n]||e[n]===t));u(t,(()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${e}], but was [${n.shape}]`))}r.attrParams.dtype&&r.attrParams.dtype.value&&u(n.dtype===r.attrParams.dtype.value,(()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`))}))}mapInputs(e){var t,n;const s={};for(const r in e){const a=null===(n=null===(t=this._signature)||void 0===t?void 0:t.inputs)||void 0===n?void 0:n[r];null!=a?s[a.name]=e[r]:s[r]=e[r]}return s}checkInputs(e){const t=Object.keys(e).filter((e=>{const[t]=uN(e);return null==this.graph.nodes[t]}));if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map((e=>{var t,n;const s=null===(n=null===(t=this._signature)||void 0===t?void 0:t.outputs)||void 0===n?void 0:n[e];return null!=s?s.name:e}),{})}checkOutputs(e){e.forEach((e=>{const[t]=uN(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)}))}}class gI{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class yI{get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}get modelStructuredOutputKeys(){return this.structuredOutputKeys}constructor(e,t={},n=Pd){this.modelUrl=e,this.loadOptions=t,this.version="n/a",this.io=n,null==t&&(this.loadOptions={}),this.resourceManager=new gI}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=this.io.browserHTTPRequest(e,this.loadOptions);else{const t=this.io.getLoadHandlers(e,this.loadOptions);if(0===t.length)t.push(this.io.browserHTTPRequest(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=this.handler.load();return H(e)?e.then((e=>null==e.getWeightStream?this.loadSync(e):this.loadStreaming(e))):this.loadSync(e)}loadSync(e){const t=this.io.decodeWeights(e.weightData,e.weightSpecs);return this.loadWithWeightMap(e,t)}async loadStreaming(e){if(null==e.getWeightStream)throw new Error("Model artifacts missing streamWeights function");const t=await ei(e.getWeightStream(),e.weightSpecs);return this.loadWithWeightMap(e,t)}loadWithWeightMap(e,t){this.artifacts=e;const n=this.artifacts.modelTopology;let s=this.artifacts.signature;if(null!=this.artifacts.userDefinedMetadata){const e=this.artifacts.userDefinedMetadata;null!=e.signature&&(s=e.signature),null!=e.structuredOutputKeys&&(this.structuredOutputKeys=e.structuredOutputKeys)}if(this.signature=s,this.version=`${n.versions.producer}.${n.versions.minConsumer}`,this.executor=new mI(RN.Instance.transformGraph(n,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(t),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=RN.Instance.transformGraph(e.modelInitializer);this.initializer=new mI(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializerSignature=e.initializerSignature}return!0}async save(e,t){if("string"==typeof e){const t=this.io.getSaveHandlers(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}addStructuredOutputNames(e){if(this.structuredOutputKeys){const t={};return(e instanceof Pr?[e]:e).forEach(((e,n)=>t[this.structuredOutputKeys[n]]=e)),t}return e}predict(e,t){const n=this.execute(e,this.outputNodes);return this.addStructuredOutputNames(n)}async predictAsync(e,t){const n=await this.executeAsync(e,this.outputNodes);return this.addStructuredOutputNames(n)}normalizeInputs(e){var t;if(!(e instanceof Pr||Array.isArray(e))){const n=null===(t=this.signature)||void 0===t?void 0:t.inputs;if(null!=n)for(const t in n){const s=n[t];null!=s.resourceId&&(e[t]=this.resourceIdToCapturedInput[s.resourceId])}return e}e=Array.isArray(e)?e:[e];const n=Object.keys(this.resourceIdToCapturedInput).length;if(e.length+n!==this.inputNodes.length)throw new Error(`Input tensor count mismatch, the graph model has ${this.inputNodes.length-n} non-resource placeholders, while there are ${e.length} input tensors provided.`);let s=0;return this.inputNodes.reduce(((t,n)=>{var r,a,i;const o=null===(i=null===(a=null===(r=this.signature)||void 0===r?void 0:r.inputs)||void 0===a?void 0:a[n])||void 0===i?void 0:i.resourceId;return t[n]=null!=o?this.resourceIdToCapturedInput[o]:e[s++],t}),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}executeInitializerGraph(){return null==this.initializer?[]:null==this.initializerSignature?this.initializer.execute({},[]):this.initializer.execute({},Object.keys(this.initializerSignature.outputs))}async executeInitializerGraphAsync(){return null==this.initializer?[]:null==this.initializerSignature?this.initializer.executeAsync({},[]):this.initializer.executeAsync({},Object.keys(this.initializerSignature.outputs))}setResourceIdToCapturedInput(e){if(this.resourceIdToCapturedInput={},this.initializerSignature){const t=this.initializerSignature.outputs,n=Object.keys(t);for(let s=0;s<n.length;s++){const r=t[n[s]];this.resourceIdToCapturedInput[r.resourceId]=e[s]}}}execute(e,t){null==this.resourceIdToCapturedInput&&this.setResourceIdToCapturedInput(this.executeInitializerGraph()),e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){null==this.resourceIdToCapturedInput&&this.setResourceIdToCapturedInput(await this.executeInitializerGraphAsync()),e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}getIntermediateTensors(){return this.executor.getIntermediateTensors()}disposeIntermediateTensors(){this.executor.disposeIntermediateTensors()}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce(((t,n)=>(t[n]=[e[n]],t)),{})}dispose(){this.executor.dispose(),this.initializer&&(this.initializer.dispose(),this.resourceIdToCapturedInput&&Ma(this.resourceIdToCapturedInput)),this.resourceManager.dispose()}}async function bI(e,t={},n=Pd){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==t&&(t={}),t.fromTFHub&&"string"==typeof e&&(e=function(e){e.endsWith("/")||(e+="/");return`${e}model.json?tfjs-format=file`}(e));const s=new yI(e,t,n);return await s.load(),s}function xI(e){if(null==e)throw new Error("modelUrl in loadGraphModelSync() cannot be null. Please provide model artifacts or an IOHandler that loads the model");let t;if(e instanceof Array){const[n,s]=e;if(!n)throw new Error("modelJSON must be the first element of the array");if(!(s&&s instanceof ArrayBuffer))throw new Error("An ArrayBuffer of weights must be the second element of the array");if(!("modelTopology"in n))throw new Error("Model JSON is missing 'modelTopology'");if(!("weightsManifest"in n))throw new Error("Model JSON is missing 'weightsManifest'");t=zd(oi(n,ci(n.weightsManifest),s))}else if("load"in e)t=e;else{if(!("modelTopology"in e&&"weightSpecs"in e&&"weightData"in e))throw new Error("Unknown model format");t=zd(e)}const n=new yI(t);return n.load(),n}const wI="4.22.0";function vI(e,t,n=new Map,s=new Set){if(null==e)return null;if("function"==typeof Blob&&e instanceof Blob)return e.slice();if(s.has(e))throw new Error("Circular references are not supported.");if(n.has(e))return n.get(e);const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if(TI(e)){const r=Array.isArray(e)?[]:{};s.add(e);for(const a in e){const i=vI(e[a],t,n,s);r[a]=i}return s.delete(e),e.__proto__&&(r.__proto__=e.__proto__),r}throw new Error(`Can't recurse into non-iterable type: ${e}`)}return n.set(e,r.value),r.value}function kI(e,t=II){return NI(e,t)}function NI(e,t,n=new Set){const s=e[0];if(n.has(s))throw new Error("Circular references are not supported.");const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(r.recurse){if(TI(s)){const r=Array.isArray(s)?[]:{};n.add(s);for(const a in s){const s=NI(e.map((e=>e[a])),t,n);r[a]=s}return n.delete(s),r}throw new Error(`Can't recurse into non-iterable type: ${s}`)}return r.value}function II(e){return null===e?null:TI(e[0])?{value:null,recurse:!0}:{value:e,recurse:!1}}async function SI(e,t){const n=new Map;vI(e,t,n);for(const e of Array.from(n.keys())){const t=n.get(e);if(H(t)){const s=await t;n.set(e,s)}}return vI(e,t,n)}function TI(e){let t=!1;if(K().get("IS_BROWSER"))t=e instanceof TextDecoder;else{const{StringDecoder:n}=require("string_decoder");t=e instanceof n}return null!=e&&!ArrayBuffer.isView(e)&&(Array.isArray(e)||"object"==typeof e&&!(e instanceof Pr)&&!(e instanceof Promise)&&!t)}function CI(e){return function(e,t){return vI(e,t)}(e,$I)}function $I(e){return e instanceof Pr?{value:e.clone(),recurse:!1}:TI(e)?{value:null,recurse:!0}:{value:e,recurse:!1}}class EI{constructor(e){if(this.capacity=e,this.begin=0,this.end=0,null==e)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(e<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(e),this.doubledCapacity=2*e}wrap(e){for(;e<0;)e+=this.doubledCapacity;return e%this.doubledCapacity}get(e){if(e<0)throw new RangeError("Can't get item at a negative index.");return this.data[e%this.capacity]}set(e,t){if(e<0)throw new RangeError("Can't set item at a negative index.");this.data[e%this.capacity]=t}length(){let e=this.end-this.begin;return e<0&&(e=this.doubledCapacity+e),e}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,e),this.end=this.wrap(this.end+1)}pushAll(e){for(const t of e)this.push(t)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const e=this.get(this.end);return this.set(this.end,void 0),e}unshift(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,e)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),e}shuffleExcise(e){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.wrap(this.begin+e),n=this.get(t);return this.set(t,this.pop()),n}}class AI extends EI{constructor(){super(AI.INITIAL_CAPACITY)}isFull(){return!1}push(e){super.isFull()&&this.expand(),super.push(e)}unshift(e){super.isFull()&&this.expand(),super.unshift(e)}expand(){const e=2*this.capacity,t=new Array(e),n=this.length();for(let e=0;e<n;e++)t[e]=this.get(this.wrap(this.begin+e));this.data=t,this.capacity=e,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function RI(e){return new OI(e)}function _I(e){return new MI(e)}function FI(e,t){return new qI(e,t)}AI.INITIAL_CAPACITY=32;class DI{async toArray(){const e=[];let t=await this.next();for(;!t.done;)e.push(t.value),t=await this.next();return e}async toArrayForTest(){const e=this.prefetch(100),t=[];let n=await e.next();for(;!n.done;)t.push(n.value),n=await e.next();return t}async resolveFully(){let e=await this.next();for(;!e.done;)e=await this.next()}async resolveWhile(e){let t=await this.next(),n=e(t.value);for(;!t.done&&n;)t=await this.next(),n=e(t.value)}handleErrors(e){return new UI(this,e)}filter(e){return new WI(this,e)}map(e){return new VI(this,e)}mapAsync(e){return new GI(this,e)}serialMapAsync(e){return new GI(this,e).serial()}flatmap(e){return new jI(this,e)}async forEachAsync(e){return this.map(e).resolveFully()}async serialForEach(e){return this.serialMapAsync(e).resolveWhile((e=>!0===e))}rowMajorBatch(e,t=!0){return new BI(this,e,t)}columnMajorBatch(e,t=!0,n=II){return this.rowMajorBatch(e,t).map((e=>kI(e,n)))}concatenate(e,t){return new qI(RI([this,e]),t)}take(e){return e<0||null==e?this:new PI(this,e)}skip(e){return e<0||null==e?this:new zI(this,e)}prefetch(e){return new YI(this,e)}shuffle(e,t){return new ZI(this,e,t)}serial(){return new LI(this)}}class OI extends DI{constructor(e){super(),this.items=e,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const e=this.items[this.trav];return this.trav++,{value:CI(e),done:!1}}}class MI extends DI{constructor(e){super(),this.nextFn=e}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(e){throw e.message=`Error thrown while iterating through a dataset: ${e.message}`,e}}}class LI extends DI{constructor(e){super(),this.upstream=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Serial`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){return this.upstream.next()}}class zI extends DI{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Skip`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const e=await this.upstream.next();if(e.done)return e;Ma(e.value)}return this.upstream.next()}}class PI extends DI{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0}summary(){return`${this.upstream.summary()} -> Take`}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class BI extends DI{constructor(e,t,n=!0){super(),this.upstream=e,this.batchSize=t,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> RowMajorBatch`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){const e=[];for(;e.length<this.batchSize;){const t=await this.upstream.next();if(t.done)return this.enableSmallLastBatch&&e.length>0?{value:e,done:!1}:{value:null,done:!0};e.push(t.value)}return{value:e,done:!1}}}class WI extends DI{constructor(e,t){super(),this.upstream=e,this.predicate=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Filter`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;){const e=await this.upstream.next();if(e.done||this.predicate(e.value))return e;Ma(e.value)}}}class VI extends DI{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Map`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=ta(e.value),n=this.transform(e.value),s=ta(n);for(const e of t)ea(e,s)||e.dispose();return{value:n,done:!1}}}class UI extends DI{constructor(e,t){super(),this.upstream=e,this.handler=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> handleErrors`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(e){if(!this.handler(e))return{value:null,done:!0}}}}class GI extends DI{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> AsyncMap`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=ta(e.value),n=await this.transform(e.value),s=ta(n);for(const e of t)ea(e,s)||e.dispose();return{value:n,done:!1}}}class HI extends DI{constructor(){super(),this.outputQueue=new AI,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class jI extends HI{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Flatmap`}async pump(){const e=await this.upstream.next();if(e.done)return!1;const t=ta(e.value),n=this.transform(e.value),s=ta(n);this.outputQueue.pushAll(n);for(const e of t)ea(e,s)||e.dispose();return!0}}class qI extends DI{constructor(e,t){super(),this.baseErrorHandler=t,this.lastRead=null,this.iterator=null,this.moreIterators=e}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(e){if(await e,null==this.iterator){const e=await this.moreIterators.next();if(e.done)return{value:null,done:!0};this.iterator=e.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const t=await this.iterator.next();return t.done?(this.iterator=null,this.readFromChain(e)):t}}var KI;!function(e){e[e.FAIL=0]="FAIL",e[e.SHORTEST=1]="SHORTEST",e[e.LONGEST=2]="LONGEST"}(KI||(KI={}));class XI extends DI{constructor(e,t=KI.FAIL){super(),this.iterators=e,this.mismatchMode=t,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(e){await e;let t=0,n=0;const s=await SI(this.iterators,(function(e){if(e instanceof DI){return{value:e.next().then((e=>(t++,e.done&&n++,e.value))),recurse:!1}}return{value:null,recurse:!0}}));if(t===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case KI.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case KI.SHORTEST:return{value:null,done:!0};case KI.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class YI extends DI{constructor(e,t){super(),this.upstream=e,this.bufferSize=t,this.buffer=new EI(t)}summary(){return`${this.upstream.summary()} -> Prefetch`}refill(){for(;!this.buffer.isFull();){const e=this.upstream.next();this.buffer.push(e)}}next(){return this.refill(),this.buffer.shift()}}class ZI extends YI{constructor(e,t,n){super(e,t),this.upstream=e,this.windowSize=t,this.upstreamExhausted=!1,this.random=Nc.alea(n||wr().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}randomInt(e){return Math.floor(this.random()*e)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const e=this.chooseIndex(),t=await this.buffer.shuffleExcise(e);if(!t.done)return this.refill(),t;this.upstreamExhausted=!0}return{value:null,done:!0}}}class JI{constructor(){this.size=null}batch(e,t=!0){const n=this;let s;return u(e>0,(()=>`batchSize needs to be positive, but it is\n      ${e}`)),s=this.size===1/0||null==this.size?this.size:t?Math.ceil(this.size/e):Math.floor(this.size/e),QI((async()=>(await n.iterator()).columnMajorBatch(e,t,eS)),s)}concatenate(e){const t=this;let n;return n=this.size===1/0||e.size===1/0?1/0:null!=this.size&&null!=e.size?this.size+e.size:null,QI((async()=>(await t.iterator()).concatenate(await e.iterator())),n)}filter(e){const t=this;let n;return n=this.size===1/0?1/0:null,QI((async()=>(await t.iterator()).filter((t=>Oa((()=>e(t)))))),n)}async forEachAsync(e){return(await this.iterator()).forEachAsync(e)}map(e){const t=this;return QI((async()=>(await t.iterator()).map((t=>Oa((()=>e(t)))))),this.size)}mapAsync(e){const t=this;return QI((async()=>(await t.iterator()).mapAsync(e)),this.size)}prefetch(e){if(null==e)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const t=this;return QI((async()=>(await t.iterator()).prefetch(e)),this.size)}repeat(e){const t=this;let n;return n=null!=this.size&&e>0?this.size*e:0===e?0:null!=this.size&&(void 0===e||e<0)?1/0:null,QI((async()=>FI(_I((async()=>({value:await t.iterator(),done:!1}))).take(e))),n)}skip(e){const t=this;let n;return n=null!=this.size&&e>=0&&this.size>=e?this.size-e:null!=this.size&&(this.size<e||void 0===e||e<0)?0:null,QI((async()=>(await t.iterator()).skip(e)),n)}shuffle(e,t,n=!0){if(null==e||e<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=Nc.alea(t||wr().toString());return QI((async()=>{let t=r.int32();return n&&(t+=r.int32()),(await s.iterator()).shuffle(e,t.toString())}),this.size)}take(e){const t=this;let n;return n=null!=this.size&&this.size>e?e:null!=this.size&&this.size<=e?this.size:null,QI((async()=>(await t.iterator()).take(e)),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function QI(e,t=null){return new class extends JI{constructor(){super(...arguments),this.size=t}async iterator(){return e()}}}function eS(e){if(null===e)return null;const t=e[0];if(null==(n=t)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof Pr||Ir(n)){return{value:function(e){if(0===e.length)throw new Error("Can't make a batch of zero elements.");return e[0]instanceof Pr?dh(e):Ia(e)}(e),recurse:!1}}var n,s;return{value:null,recurse:!0}}JI.MAX_BUFFER_SIZE=1e4;class tS extends JI{constructor(e){super(),this.input=e}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map((e=>(e.endsWith("\r")&&(e=e.slice(0,-1)),e)))}}const nS=Symbol("out"),sS=Symbol("field"),rS=Symbol("quote"),aS=Symbol("quoteafterquote"),iS=Symbol("quoteinquote");class oS extends JI{async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const e=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!e)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&e&&u(e.length===this.fullColumnNames.length,(()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+e.length.toString()+").")),this.fullColumnNames||(this.fullColumnNames=e);const t=this.fullColumnNames.reduce(((e,t)=>(e[t]=e[t]+1||1,e)),{}),n=Object.keys(t).filter((e=>t[e]>1));if(u(0===n.length,(()=>"Duplicate column names found: "+n.toString())),this.columnConfigs)for(const e of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(e))throw new Error('The key "'+e+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const e=await this.base.iterator(),t=await e.next();if(t.done)throw new Error("No data was found for CSV parsing.");const n=t.value;return this.parseRow(n,!1)}return null}constructor(e,t){super(),this.input=e,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new tS(e),t||(t={}),this.hasHeader=!1!==t.hasHeader,this.fullColumnNames=t.columnNames,this.columnConfigs=t.columnConfigs,this.configuredColumnsOnly=t.configuredColumnsOnly,t.delimWhitespace?(u(null==t.delimiter,(()=>"Delimiter should not be provided when delimWhitespace is true.")),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=t.delimiter?t.delimiter:","}async iterator(){this.columnNamesValidated||await this.setColumnNames();let e=await this.base.iterator();return this.hasHeader&&(e=e.skip(1)),e.map((e=>this.makeDataElement(e)))}makeDataElement(e){const t=this.parseRow(e),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=t[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${e}`);l=void 0}else{const e=Number(o);if(isNaN(e))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":default:l=e;break;case"int32":l=Math.floor(e);break;case"bool":l=this.getBoolean(o)}else l=e}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(e){return"1"===e||"true"===e.toLowerCase()?1:0}parseRow(e,t=!0){const n=[];let s=0;const r=e.length;let a=nS;for(let t=0;t<r;t++)switch(a){case nS:switch(e.charAt(t)){case'"':s=t+1,a=rS;break;case this.delimiter:if(s=t+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=nS;break;default:a=sS,s=t}break;case sS:if(e.charAt(t)===this.delimiter)n.push(e.substring(s,t)),a=nS,s=t+1;break;case rS:if('"'===e.charAt(t))a=aS;break;case aS:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t-1)),a=nS,s=t+1;break;case'"':a=rS;break;default:a=iS}break;case iS:if('"'===e.charAt(t))a=rS}if(a===aS?n.push(e.substring(s,r-1)):n.push(e.substring(s)),t&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class lS extends DI{constructor(e){super(),this.microphoneConfig=e,this.isClosed=!1,this.fftSize=e.fftSize||1024;const t=Math.log2(this.fftSize);if(this.fftSize<0||t<4||t>14||!Number.isInteger(t))throw new Error(`Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got ${this.fftSize}`);if(this.numFrames=e.numFramesPerSpectrogram||43,this.sampleRateHz=e.sampleRateHz,this.columnTruncateLength=e.columnTruncateLength||this.fftSize,this.audioTrackConstraints=e.audioTrackConstraints,this.smoothingTimeConstant=e.smoothingTimeConstant||0,this.includeSpectrogram=!1!==e.includeSpectrogram,this.includeWaveform=!0===e.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(e={}){if(!K().get("IS_BROWSER"))throw new Error("microphone API is only supported in browser environment.");const t=new lS(e);return await t.start(),t}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(e){throw new Error(`Error thrown while initializing video stream: ${e.message}`)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const e=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new e,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: ${this.audioContext.sampleRate}`)}else this.sampleRateHz=this.audioContext.sampleRate;const t=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,t.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let e,t;const n=await this.getAudioData();if(this.includeSpectrogram){const t=this.flattenQueue(n.freqDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const e=this.flattenQueue(n.timeDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:e,waveform:t},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const e=[],t=[];let n=0;return new Promise((s=>{const r=setInterval((()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:e,timeDataQueue:t}),e.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),t.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:e,timeDataQueue:t}))}),this.fftSize/this.sampleRateHz*1e3)}))}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(e){const t=e[0].length,n=new Float32Array(e.length*t);return e.forEach(((e,s)=>n.set(e,s*t))),n}getTensorFromAudioDataArray(e,t){const n=new Float32Array(p(t));return n.set(e,n.length-e.length),Ia(n,t)}}class uS extends DI{constructor(e,t){if(super(),this.webcamVideoElement=e,this.webcamConfig=t,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=yh([0],"int32"),this.webcamConfig.centerCrop){const e=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,t=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-e)/2,s=(1-t)/2,r=n+e,a=t+s;this.cropBox=bh([s,n,a,r],[1,4])}else this.cropBox=bh([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(e,t={}){if(!K().get("IS_BROWSER"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!e){if(e=document.createElement("video"),!t.resizeWidth||!t.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");e.width=t.resizeWidth,e.height=t.resizeHeight}const n=new uS(e,t);return await n.start(),n}async start(){this.webcamConfig.facingMode&&u("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,(()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`));try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(e){throw e.message=`Error thrown while initializing video stream: ${e.message}`,e}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(e){console.log(e),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise((e=>{this.webcamVideoElement.onloadedmetadata=()=>{e()}}))}async next(){if(this.isClosed)return{value:null,done:!0};let e;try{e=qd(this.webcamVideoElement)}catch(e){throw new Error(`Error thrown converting video to pixels: ${JSON.stringify(e)}`)}if(!this.resize)return{value:e,done:!1};try{return{value:this.cropAndResizeFrame(e),done:!1}}catch(e){throw new Error(`Error thrown cropping the video: ${e.message}`)}finally{e.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(e){return Oa((()=>{const t=Bl(Pi(e,"float32"),0);let n;n=sd.cropAndResize(t,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return vo(n,s.slice(1))}))}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach((e=>e.stop()));try{this.webcamVideoElement.srcObject=null}catch(e){console.log(e),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class cS{}class hS extends DI{split(e){return new pS(this,e)}}class pS extends hS{constructor(e,t){super(),this.upstream=e,this.impl=new dS(e,t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class dS extends HI{constructor(e,t){super(),this.upstream=e,this.separator=t,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const e=await this.upstream.next();if(e.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const t=e.value.split(this.separator);t[0]=this.carryover+t[0];for(const e of t.slice(0,-1))this.outputQueue.push(e);return this.carryover=t[t.length-1],!0}}class fS extends DI{decodeUTF8(){return new mS(this)}}class mS extends hS{constructor(e){super(),this.upstream=e,this.impl=new gS(e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class gS extends HI{constructor(e){if(super(),this.upstream=e,K().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:e}=require("string_decoder");this.decoder=new e("utf8")}}summary(){return`${this.upstream.summary()} -> Utf8`}async pump(){const e=await this.upstream.next();let t,n;return!e.done&&(t=e.value,n=K().get("IS_BROWSER")?this.decoder.decode(t,{stream:!0}):this.decoder.write(Buffer.from(t.buffer)),this.outputQueue.push(n),!0)}}class yS extends fS{constructor(e,t={}){super(),this.file=e,this.options=t,u(e instanceof Uint8Array||!!K().get("IS_BROWSER")&&(e instanceof File||e instanceof Blob),(()=>"FileChunkIterator only supports File, Blob and Uint8Array right now.")),this.offset=t.offset||0,this.chunkSize=t.chunkSize||1048576}summary(){return`FileChunks ${this.file}`}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const e=new Promise(((e,t)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)e(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return t(new TypeError("FileReader returned unknown type."));e(r)},s.onabort=e=>t(new Error("Aborted")),s.onerror=e=>t(new Error(e.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n}));return{value:await e,done:!1}}}const bS=e=>({method:e.method,headers:e.headers,body:e.body,mode:e.mode,credentials:e.credentials,cache:e.cache,redirect:e.redirect,referrer:e.referrer,integrity:e.integrity});function xS(e){return"string"==typeof e&&"file://"===e.slice(0,7)}class wS extends cS{constructor(e,t={}){super(),this.input=e,this.options=t}async iterator(){if(xS(this.input)&&K().get("IS_NODE")){const e=require("fs");this.input=e.readFileSync(this.input.slice(7))}return new yS(this.input,this.options)}}class vS extends cS{constructor(e,t={}){super(),this.url=e,this.fileOptions=t}async iterator(){return xS(this.url)?new wS(this.url,this.fileOptions).iterator():async function(e,t={},n){let s,r;"string"==typeof e?s=e:(s=e.url,r=bS(e));const a=await(n||vr)(s,r);if(a.ok){const e=new Uint8Array(await a.arrayBuffer());return new yS(e,t)}throw new Error(a.statusText)}(this.url,this.fileOptions)}}var kS=Object.freeze({__proto__:null,CSVDataset:oS,Dataset:JI,FileDataSource:wS,TextLineDataset:tS,URLDataSource:vS,array:function(e){return QI((async()=>RI(e)),e.length)},csv:function(e,t={}){return new oS(new vS(e),t)},func:function(e){const t=_I(e);return QI((async()=>t))},generator:function(e){return QI((async()=>{const t=await e();return _I((()=>t.next()))}))},microphone:async function(e){return lS.create(e)},version_data:"4.22.0",webcam:async function(e,t){return uS.create(e,t)},zip:function(e){if(!TI(e))throw new Error("The argument to zip() must be an object or array.");let t;if(Array.isArray(e))for(let n=0;n<e.length;n++)t=null==t?e[n].size:Math.min(t,e[n].size);else if(e instanceof Object)for(const n in e)t=null==t?e[n].size:Math.min(t,e[n].size);return QI((async()=>function(e,t=KI.FAIL){return new XI(e,t)}(await SI(e,(e=>{if(e instanceof JI)return{value:e.iterator(),recurse:!1};if(TI(e))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")})),KI.SHORTEST)),t)}});function NS(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&u("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the CPU backend.`))}))}const IS=Oh;class SS extends n{nextDataId(){return SS.nextDataId++}constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t(this,_a())}write(e,t,n){this.firstUse&&(this.firstUse=!1,K().get("IS_NODE")&&bs("\n============================\nHi, looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, visit https://github.com/tensorflow/tfjs-node for more details. \n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map((e=>kr(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return{dataId:s,shape:e,dtype:t}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,s,r){this.data.set(e,{values:t,dtype:s,refCount:r})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){return Df(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return z(this.data.get(e).values,t)}bufferSync(e){const t=this.readSync(e.dataId);if("string"===e.dtype)try{const n=t.map((e=>Nr(e)));return zi(e.shape,e.dtype,n)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return zi(e.shape,e.dtype,t)}makeOutput(e,t,n){return _a().makeTensorFromTensorInfo(this.makeTensorInfo(t,n,e),this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const t=wr();e();return{kernelMs:wr()-t}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){NS([e],"where");const t=this.readSync(e.dataId);return IS(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function TS(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}SS.nextDataId=0;const CS={kernelName:"Abs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend;NS(t,"abs");let s=new Float32Array(p(t.shape));return s=TS(n.data.get(t.dataId).values),n.makeOutput(s,t.shape,t.dtype)}};function $S(e){return(t,n,s,r,a)=>{const i=cl(t,n),o=i.length,l=O(i),u=k(a,p(i)),c=t.length,h=n.length,d=O(t),f=O(n),m=ll(t,i),g=ll(n,i);if(m.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],r[t%r.length]);else for(let t=0;t<u.length;++t){const n=G(t,o,l),a=n.slice(-c);m.forEach((e=>a[e]=0));const i=U(a,c,d),p=n.slice(-h);g.forEach((e=>p[e]=0));const y=U(p,h,f);u[t]=e(s[i],r[y])}return[u,i]}}function ES(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const AS={kernelName:"Complex",backendName:"cpu",kernelFunc:ES};function RS(e,t,n="float32"){if("complex64"===n){return ES({inputs:{real:RS(e,t,"float32"),imag:RS(e,t,"float32")},backend:e})}const s=B(p(t),n);return e.makeTensorInfo(t,n,s)}function _S(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const FS={kernelName:"Identity",backendName:"cpu",kernelFunc:_S};function DS(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const OS={kernelName:"Real",backendName:"cpu",kernelFunc:DS};function MS(e,t,n,s){if("int32"===s){return[t,"int32",Int32Array.from(e)]}if("bool"===s){const s=xr([0],n),[r,a]=$S(((e,t)=>e!==t?1:0))(t,[],e,s,"bool");return[a,"bool",r]}throw new Error(`Error in Cast: failed to cast ${n} to ${s}`)}function LS(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return _S({inputs:{x:r},backend:n});const e=RS(n,r.shape,r.dtype),t=LS({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=ES({inputs:{real:t,imag:e},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),s}if("complex64"===r.dtype){const e=DS({inputs:{input:r},backend:n}),t=LS({inputs:{x:e},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(e),t}if(!T(r.dtype,a)){const e=_S({inputs:{x:r},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:a}}const i=n.data.get(r.dataId).values,[o,l,u]=MS(i,r.shape,r.dtype,a);return n.makeTensorInfo(o,l,u)}const zS={kernelName:"Cast",backendName:"cpu",kernelFunc:LS};function PS(e,t,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;NS([a,i],e);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c="string"===a.dtype?pm(l):l,h="string"===a.dtype?pm(u):u,p=s||a.dtype,[d,f]=t(a.shape,i.shape,c,h,p);return o.makeTensorInfo(f,p,d)}:({inputs:e,backend:r})=>{const{a:a,b:i}=e,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const e=LS({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),t=o.data.get(e.dataId),s=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=LS({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),v=ES({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(e),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),v}{const e=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=t(a.shape,i.shape,e,n,r);return o.makeTensorInfo(u,r,l)}}}function BS(e){return(t,n,s,r,a,i)=>{const o=cl(t,n),l=p(o),u=o.length,c=O(o),h=k("float32",l),d=k("float32",l),f=ll(t,o),m=ll(n,o),g=Df(s,r),y=Df(a,i),b=t.length,x=O(t),w=n.length,v=O(n);if(f.length+m.length===0)for(let t=0;t<h.length;t++){const n=t%g.length,s=t%y.length,r=e(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);h[t]=r.real,d[t]=r.imag}else for(let t=0;t<h.length;t++){const n=G(t,u,c),s=n.slice(-b);f.forEach((e=>s[e]=0));const r=U(s,b,x),a=n.slice(-w);m.forEach((e=>a[e]=0));const i=U(a,w,v),o=e(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);h[t]=o.real,d[t]=o.imag}return[h,d,o]}}const WS=$S(((e,t)=>e+t)),VS=PS("Add",WS,BS(((e,t,n,s)=>({real:e+n,imag:t+s})))),US={kernelName:"Add",backendName:"cpu",kernelFunc:VS};function GS(e,t,n,s,r){const a=p(s),i=B(r,n);for(let n=0;n<e.length;n++){const s=e[n];if(s<0)throw new Error("Input x must be non-negative!");s>=r||(i[s]+=a>0?t[n]:1)}return i}function HS(e,t,n,s=!1){const r=e.shape[0],a=e.shape[1],i=zi([r,n],t.dtype);for(let o=0;o<r;o++)for(let r=0;r<a;r++){const a=e.get(o,r);if(a<0)throw new Error("Input x must be non-negative!");a>=n||(s?i.set(1,o,a):t.size>0?i.set(i.get(o,a)+t.get(o,r),o,a):i.set(i.get(o,a)+1,o,a))}return i}const jS=$S(((e,t)=>e&t)),qS={kernelName:"BitwiseAnd",backendName:"cpu",kernelFunc:PS("BitwiseAnd",jS)};function KS(e){return(t,n,s)=>{const r=N(n,t.length);for(let n=0;n<t.length;++n)r[n]=e(t[n],s);return r}}function XS(e,t,n){return YS(e,KS(t),n)}function YS(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;NS(i,e);const o=a,l=o.data.get(i.dataId).values;let u;if("string"===i.dtype){if(!Array.isArray(l))throw new Error("String tensor's value was not an instance of Array");u=pm(l)}else u=l;const c=n||i.dtype,h=t(u,c,r);return o.makeTensorInfo(i.shape,c,h)}}const ZS=KS((e=>Math.ceil(e))),JS={kernelName:"Ceil",backendName:"cpu",kernelFunc:YS("Ceil",ZS)};function QS(e,t,n,s){const r=N(n,p(t));if(s&&"string"!==n){let t=0;e.forEach((e=>{const n=p(e.shape);r.set(e.vals,t),t+=n}))}else{let s=0;e.forEach((e=>{const a="string"===n?pm(e.vals):e.vals;let i=0;for(let n=0;n<e.shape[0];++n){const o=n*t[1]+s;for(let t=0;t<e.shape[1];++t)r[o+t]=a[i++]}s+=e.shape[1]}))}return r}const eT=$S(((e,t)=>e===t?1:0)),tT=PS("Equal",eT,null,"bool"),nT={kernelName:"Equal",backendName:"cpu",kernelFunc:tT},sT=KS((e=>Math.exp(e))),rT=YS(nt,sT,"float32"),aT={kernelName:nt,backendName:"cpu",kernelFunc:rT},iT=KS((e=>Math.expm1(e))),oT={kernelName:"Expm1",backendName:"cpu",kernelFunc:YS("Expm1",iT)},lT=KS((e=>Math.floor(e))),uT={kernelName:"Floor",backendName:"cpu",kernelFunc:YS("Floor",lT)},cT=$S(((e,t)=>Math.floor(e/t))),hT={kernelName:"FloorDiv",backendName:"cpu",kernelFunc:PS("FloorDiv",cT,null,"int32")};function pT(e,t,n,s,r,a,i,o,l){const u=zi([s,a],n);for(let n=0;n<s;n++){const s=[];let c=0;for(let t=0;t<r;t++){const a=e[n*r+t];c+=a*i[t],s.push(a)}if(c<0||c>=l/a)throw new Error(`Invalid indices: ${s} does not index into ${o}`);for(let e=0;e<a;e++)u.values[n*a+e]=t.get(...t.indexToLoc(c*a+e))}return u}function dT(e,t,n){const s=zi(n,e.dtype);for(let n=0;n<s.size;++n){const r=s.indexToLoc(n).slice(),a=r[0],i=r[2],o=t.locToIndex([a,i]);r[2]=t.values[o];const l=e.locToIndex(r);0<=l&&l<e.values.length&&(s.values[n]=e.values[l])}return s}const fT=$S(((e,t)=>e>t?1:0)),mT={kernelName:"Greater",backendName:"cpu",kernelFunc:PS("Greater",fT,null,"bool")},gT=$S(((e,t)=>e>=t?1:0)),yT={kernelName:"GreaterEqual",backendName:"cpu",kernelFunc:PS("GreaterEqual",gT,null,"bool")},bT=$S(((e,t)=>e<t?1:0)),xT={kernelName:"Less",backendName:"cpu",kernelFunc:PS("Less",bT,null,"bool")},wT=$S(((e,t)=>e<=t?1:0)),vT={kernelName:"LessEqual",backendName:"cpu",kernelFunc:PS("LessEqual",wT,null,"bool")};function kT(e,t,n){const s=(t-e)/(n-1),r=B(n,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const NT=KS((e=>Math.log(e))),IT=YS(St,NT),ST={kernelName:St,backendName:"cpu",kernelFunc:IT};function TT(e,t,n,s){const r=k(s,p(n));for(let n=0;n<r.length;++n){const s=n*t;let a=e[s];for(let n=0;n<t;++n){const t=e[s+n];(Number.isNaN(t)||t>a)&&(a=t)}r[n]=a}return r}const CT=$S(((e,t)=>Math.max(e,t))),$T={kernelName:"Maximum",backendName:"cpu",kernelFunc:PS("Maximum",CT)},ET=$S(((e,t)=>Math.min(e,t))),AT={kernelName:"Minimum",backendName:"cpu",kernelFunc:PS("Minimum",ET)},RT=$S(((e,t)=>e*t)),_T=BS(((e,t,n,s)=>({real:e*n-t*s,imag:e*s+t*n}))),FT=PS("Multiply",RT,_T),DT={kernelName:"Multiply",backendName:"cpu",kernelFunc:FT};function OT(e,t,n){const s=br(-1,n);return RT([],t,s,e,n)}const MT={kernelName:"Neg",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;NS(s,"neg");const r=n.data.get(s.dataId).values,[a,i]=OT(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,a)}},LT=$S(((e,t)=>e!==t?1:0)),zT={kernelName:"NotEqual",backendName:"cpu",kernelFunc:PS("NotEqual",LT,null,"bool")};function PT(e,t,n,s,r){const a=t.length,i=p(t),o=O(t),l=O(r),u=k(n,p(r));for(let t=0;t<i;++t){const n=G(t,a,o),r=new Array(n.length);for(let e=0;e<r.length;e++)r[e]=n[s[e]];u[U(r,a,l)]=e[t]}return u}function BT(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:a}=n;NS(r,"transpose");const i=r.shape.length,o=new Array(i);for(let e=0;e<o.length;e++)o[e]=r.shape[a[e]];const l=PT(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const WT={kernelName:"Transpose",backendName:"cpu",kernelFunc:BT};function VT(e,t,n,s){const[r,a]=Nl(e,s),i=Kr(t,"int32"),o=B(p(r),i),l=p(a);for(let e=0;e<o.length;++e){const t=e*l;let s=1;for(let e=0;e<l;++e)s*=n[t+e];o[e]=s}return{outVals:o,outShape:r,outDtype:i}}const UT={kernelName:"Prod",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;NS(r,"prod");const o=r.shape.length,l=w(a,r.shape),u=Tl(l,o);let c=l,h=r;const p=[];null!=u&&(h=BT({inputs:{x:r},backend:n,attrs:{perm:u}}),p.push(h),c=$l(c.length,o));const d=n.data.get(h.dataId).values,{outVals:f,outShape:m,outDtype:g}=VT(h.shape,h.dtype,d,c);let y=m;return i&&(y=Il(m,l)),p.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(y,g,f)}};function GT(e,t,n,s){const r=[];let a=0;const i=t.length-1+n.length,o=new Array(i).fill(null).map((()=>[0]));!function(e,t){for(let n=0;n<e.length;++n){const s=e[n],r=n===e.length-1?t:e[n+1].length;if(0===s.length)throw new Error("Ragged splits may not be empty");if(s[0]<0)throw new Error("Ragged splits must be non-negative");if(s[s.length-1]>r)throw new Error("Ragged splits must not point past values");for(let e=1;e<s.length;++e)if(s[e-1]>s[e])throw new Error("Ragged splits must be sorted in ascending order")}}(n,s);let l=1;for(let e=0;e<t.length-1;++e){l*=t[e];const n=t[e+1];for(let t=1;t<l+1;++t)o[e].push(t*n)}for(let s=0;s<e.length;++s){let i=e[s],l=e[s]+1;for(let e=0;e<n.length;++e){const s=n[e],r=e+t.length-1;if(r>=0){const e=o[r],t=e[e.length-1]-s[i];for(let e=i;e<l;++e)o[r].push(s[e+1]+t)}i=s[i],l=s[l]}l!==i&&(r.push([i,l]),a+=l-i)}return{outSplits:o,valueSlices:r,numValues:a}}function HT(e,t){const n=e.slice(0,t);for(;n.length<t;)n.push(1);for(let s=t;s<e.length;s++)n[t-1]*=e[s];return n}function jT(e,t,n,s,r){const a=t.slice();a[0]=r;const i=N(n,p(a)),o=e.length;return function(e,t,n,s,r,a){const i=HT(t,2)[1],o=HT(a,2)[1];let l=0;for(const t of n)for(let n=t[0];n<t[1];++n){for(let t=0;t<s;++t)r[l*o+t]=e[n*i+t];++l}}(e,t,s,0===o?0:o/t[0],i,a),[i,a]}function qT(e,t,n,s,r,a,i,o){if(0===e.length)throw new Error("paramsNestedSplits must be non empty");if(0===t[0].length)throw new Error("Split tensors must not be scalars");if(function(e,t,n){e.forEach(((e,s)=>{if(e<0||e>=n){const r=G(s,t.length,O(t)).join(",");throw new Error(`indices[${r}] = ${e} is not in [0, ${n})`)}}))}(a,i,t[0][0]-1),0===s.length)throw new Error("params.rank must be nonzero");const l=s[0],{outSplits:u,valueSlices:c,numValues:h}=GT(a,i,e,l),p=function(e){const t=[];for(let n=0;n<e.length;++n){const s=N("int32",e[n].length);t.push(s),e[n].forEach(((e,t)=>s[t]=e))}return t}(u),d=jT(n,s,r,c,h);return[p,d[0],d[1]]}function KT(e,t,n,s,r,a,i){if(t.length>1)throw new Error("starts must be a scalar or vector");if(r.length>1)throw new Error("limits must be a scalar or vector");if(i.length>1)throw new Error("deltas must be a scalar or vector");const o=0===t.length,l=0===r.length,u=0===i.length,c=[];o||c.push(t[0]),l||c.push(r[0]),u||c.push(i[0]);for(let e=1;e<c.length;++e)if(c[e]!==c[e-1])throw new Error("starts, limits, and deltas must have the same shape");const h=0===c.length?1:c[0],p=N("int32",h+1);p[0]=0;for(let t=0;t<h;++t){const n=o?e[0]:e[t],r=l?s[0]:s[t],i=u?a[0]:a[t];if(0===i)throw new Error("Requires delta != 0");let c;if(i>0&&r<n||i<0&&r>n)c=0;else if(c=Math.ceil(Math.abs((r-n)/i)),c>2147483647)throw new Error("Requires ((limit - start) / delta) <= 2147483647");p[t+1]=p[t]+c}const d=N(n,p[h]);let f=0;for(let t=0;t<h;++t){const n=p[t+1]-p[t];let s=o?e[0]:e[t];const r=u?a[0]:a[t];for(let e=0;e<n;++e)d[f++]=s,s+=r}return[p,d]}var XT=vf;class YT{constructor(e,t,n,s,r,a,i,o,l,u){this.shape=e,this.shapeShape=t,this.values=n,this.valuesShape=s,this.valuesDType=r,this.defaultValue=a,this.defaultValueShape=i,this.rowPartitionValues=o,this.rowPartitionValuesShapes=l,this.rowPartitionTypes=Nf(u),this.raggedRank=If(this.rowPartitionTypes)}getRowPartitionTypeByDimension(e){return this.rowPartitionTypes[0]===XT.FIRST_DIM_SIZE?this.rowPartitionTypes[e+1]:this.rowPartitionTypes[e]}getRowPartitionTensor(e){return this.rowPartitionTypes[0]===XT.FIRST_DIM_SIZE?this.rowPartitionValues[e+1]:this.rowPartitionValues[e]}getMaxWidth(e){const t=this.getRowPartitionTensor(e-1);switch(this.getRowPartitionTypeByDimension(e-1)){case XT.VALUE_ROWIDS:return YT.getMaxWidthValueRowID(t);case XT.ROW_SPLITS:return YT.getMaxWidthRowSplit(t);default:throw new Error(`Cannot handle partition type ${XT[this.getRowPartitionTypeByDimension(e-1)]}`)}}static getMaxWidthRowSplit(e){const t=e.length;if(0===t||1===t)return 0;let n=0;for(let s=0;s<t-1;++s){const t=e[s+1]-e[s];t>n&&(n=t)}return n}static getMaxWidthValueRowID(e){const t=e.length;if(0===t)return 0;let n=0,s=e[0],r=0;for(let a=1;a<t;++a){const t=e[a];t!==s&&(s=t,r=Math.max(a-n,r),n=a)}return Math.max(t-n,r)}tensorShapeFromTensor(e,t,n=!0){if(0===t.length){if(-1===e[0])return[];throw new Error("The only valid scalar shape tensor is the fully unknown shape specified as -1.")}return JT(e,n)}calculateOutputSize(e){const t=this.valuesShape;Sf(this.defaultValueShape,t);const n=this.tensorShapeFromTensor(this.shape,this.shapeShape),s=kf(this.raggedRank,n,t);s[0]<0&&(s[0]=e);for(let e=1;e<=this.raggedRank;++e)s[e]<0&&(s[e]=this.getMaxWidth(e));return s}calculateFirstParentOutputIndex(e,t,n){const s=Math.min(e,n),r=[];let a=0;for(let e=0;e<s;++e,a+=t)r.push(a);for(let t=s;t<e;++t)r.push(-1);return u(r.length===e,(()=>"Final length of result must be equal to firstDimension.")),r}calculateOutputIndexRowSplit(e,t,n,s){const r=e.length,a=[];for(let i=0;i<r-1;++i){const r=e[i+1]-e[i];let o=Math.min(s,r),l=t[i];-1===l&&(o=0);for(let e=0;e<o;++e)a.push(l),l+=n;for(let e=0;e<r-o;++e)a.push(-1)}if(r>0&&a.length!==e[r-1])throw new Error("Invalid row split size.");return a}calculateOutputIndexValueRowID(e,t,n,s){const r=e.length,a=[];if(0===r)return[];let i=0,o=e[0];if(o>=t.length)throw new Error(`Got currentValueRowId=${o}, which is not less than ${t.length}`);let l=t[o];a.push(l);for(let u=1;u<r;++u){const r=e[u];if(r===o)l>=0&&(++i,i<s?l+=n:l=-1);else{if(i=0,o=r,r>=t.length)throw new Error(`Got nextValueRowId=${r} which is not less than ${t.length}`);l=t[r]}a.push(l)}if(a.length!==e.length)throw new Error("Invalid row ids.");return a}calculateOutputIndex(e,t,n,s){const r=this.getRowPartitionTensor(e),a=this.getRowPartitionTypeByDimension(e);switch(a){case XT.VALUE_ROWIDS:return this.calculateOutputIndexValueRowID(r,t,n,s);case XT.ROW_SPLITS:if(r.length-1>t.length)throw new Error(`Row partition size is greater than output size: ${r.length-1} > ${t.length}`);return this.calculateOutputIndexRowSplit(r,t,n,s);default:throw new Error(`Unsupported partition type: ${XT[a]}`)}}getFirstDimensionSize(){const e=this.rowPartitionValues[0];if(0===this.rowPartitionTypes.length)throw new Error("No row_partition_types given.");const t=this.rowPartitionTypes[0];switch(t){case XT.FIRST_DIM_SIZE:return e[0];case XT.VALUE_ROWIDS:throw new Error("Cannot handle VALUE_ROWIDS in first dimension.");case XT.ROW_SPLITS:return this.rowPartitionValuesShapes[0][0]-1;default:throw new Error(`Cannot handle type ${XT[t]}`)}}compute(){if(this.rowPartitionValues[0].length<=0)throw new Error("Invalid first partition input. Tensor requires at least one element.");const e=this.getFirstDimensionSize(),t=this.calculateOutputSize(e),n=new Array(this.raggedRank+1);n[n.length-1]=1;for(let e=n.length-2;e>=0;--e)n[e]=n[e+1]*t[e+1];const s=JT(t,!1),r=N(this.valuesDType,p(s));if(n[0]*t[0]>0){let a=this.calculateFirstParentOutputIndex(e,n[0],t[0]);for(let e=1;e<=this.raggedRank;++e){a=this.calculateOutputIndex(e-1,a,n[e],t[e])}this.setOutput(this.raggedRank,a,r,s)}return[s,r]}setOutput(e,t,n,s){if(0===n.length)return;const r=this.values,a=n;let i=s.slice();i=i.slice(e+1);const o=p(i),l=t.length;let u=this.defaultValue;if(u.length!==o&&1!==u.length){const e=this.defaultValueShape;Oa((()=>{const t=vo(u,e),n=zo(t,i);u=n.dataSync()}))}let c=0,h=0,d=0;for(let e=0;e<=l;++e){let s=e<l?t[e]:-1;if(s!==d){if(h<d){const e=r.subarray(c*o);ZT(a.subarray(h*o),e,(d-h)*o)}if(e>=l){const e=n.length;s=Math.floor(e/o)}if(s>d)if(1===this.defaultValue.length)a.subarray(d*o,s*o).fill(this.defaultValue[0]),d=s;else for(;s>d;){ZT(a.slice(d*o),u,o),++d}s<0?(c=e+1,h=d):(c=e,h=d,d=h+1)}else++d}}}function ZT(e,t,n){for(let s=0;s<n;s++)e[s]=t[s]}function JT(e,t){const n=[];for(let s of e){if(s<0){if(!t)throw new Error(`Dimension ${s} must be >= 0`);if(s<-1)throw new Error(`Dimension ${s} must be >= -1`);s=-1}n.push(s)}return n}function QT(e,t,n,s,r,a,i,o,l,u){return new YT(e,t,n,s,r,a,i,o,l,u).compute()}function eC(e,t,n,s){if(e===t||e<t&&n<0||t<e&&n>1)return B(0,s);const r=B(Math.abs(Math.ceil((t-e)/n)),s);t<e&&1===n&&(n=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+n;return r}const tC=KS((e=>1/Math.sqrt(e))),nC={kernelName:"Rsqrt",backendName:"cpu",kernelFunc:YS("Rsqrt",tC)};function sC(e,t,n,s,r,a,i,o,l,u){const c=[s/r,r],h=e.values,p=t.values;if(0===s)return zi(n,t.dtype);const d=l instanceof Or?l:zi(c,t.dtype);"string"==typeof l||"number"==typeof l?d.values.fill(l):"boolean"==typeof l&&d.values.fill(+l);for(let e=0;e<a;e++){const a=[];let l=0;for(let t=0;t<i;t++){const n=h[e*i+t];a.push(n),l+=n*o[t]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[e*r+n]:d.values[l*r+n]=0===t.rank?p[0]:p[e*r+n]}return d}const rC=KS((e=>1/(1+Math.exp(-e)))),aC=XS("Sigmoid",(e=>1/(1+Math.exp(-e)))),iC={kernelName:"Sigmoid",backendName:"cpu",kernelFunc:aC};function oC(e,t,n,s,r){const a=lf(s,t,n),i=p(n),o=O(s);if(a){const n=uf(t,o);return"string"===r?e.slice(n,n+i):e.subarray(n,n+i)}const l=zi(s,r,"string"===r?pm(e):e),u=zi(n,r);for(let e=0;e<u.size;++e){const n=u.indexToLoc(e),s=n.map(((e,n)=>e+t[n]));u.set(l.get(...s),...n)}return"string"===r?dm(u.values):u.values}function lC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s;NS(r,"slice");const[o,l]=cf(r,a,i);Zd(r,o,l);const u=oC(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const uC={kernelName:"Slice",backendName:"cpu",kernelFunc:lC};function cC(e,t,n,s,r,a,i){const o=t[0],l=a[0],u=new Array(l),c=new Array(o),h=t[1];if(0===l){if(0!==o)throw new Error(Yf(o));return[N(n,0),[0,h],N(r,0),u,c]}let p=!0,d=0;const f=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h];if(n<0)throw new Error(Zf(t,n));if(n>=l)throw new Error(Jf(t,n,l));++f[n],p=p&&n>=d,d=n}let m=!0;for(let e=0;e<l;++e){const t=0===f[e];u[e]=t,m=m&&!t,f[e]=Math.max(f[e],1),e>0&&(f[e]+=f[e-1])}if(m&&p){const t=e,n=s;for(let e=0;e<o;++e)c[e]=e;return[t,[o,h],n,u,c]}{const t=f[l-1],a=N(n,t*h),p=N(r,t),d=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h],r=d[n],i=(0===n?0:f[n-1])+r;d[n]++;for(let n=0;n<h;++n)a[i*h+n]=e[t*h+n];p[i]=s[t],c[t]=i}for(let e=0;e<l;++e){if(0===d[e]){const t=0===e?0:f[e-1];a[t*h+0]=e;for(let e=1;e<h;++e)a[t*h+e]=0;p[t]=i}}return[a,[t,h],p,u,c]}}function hC(e,t,n,s,r){const a=p(s),i=t[0],o=r.length,l=[];let u=1,c=-1;for(let e=0;e<o;++e){const t=r[e];if(-1===t){if(-1!==c)throw new Error(Qf(c,e));c=e,l.push(1)}else{if(t<0)throw new Error(em(e,t));u*=t,l.push(t)}}if(-1!==c){if(u<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(a/u);if(u*e!==a)throw new Error(nm(s,l));l[c]=e}if(p(l)!==a)throw new Error(sm(s,l));const h=s.length,d=[];if(h>0){d[h-1]=1;for(let e=h-2;e>=0;--e)d[e]=d[e+1]*s[e+1]}const f=[];if(o>0){f[o-1]=1;for(let e=o-2;e>=0;--e)f[e]=f[e+1]*l[e+1]}const m=N(n,i*o);for(let t=0;t<i;++t){let n=0;for(let s=0;s<h;++s)n+=e[t*h+s]*d[s];for(let e=0;e<o;++e)m[t*o+e]=Math.trunc(n/f[e]),n%=f[e]}return[m,[i,o],l]}function pC(e,t,n,s,r,a=!1,i=0){const o=s.length,l=[t[0],e.length/t[0]],u=l[1],c=o>0?r[o-1]+1:0;if(c<0)throw new Error("segment ids must be >= 0");const h=t.slice();h[0]=c;const p=N(n,h.reduce(((e,t)=>e*t),1));if(0===o)return c>0&&p.fill(i),[p,h];if(c<=0)throw new Error("segment ids must be >= 0");let d=0,f=1,m=0,g=r[d];for(;;){let t=0;if(f<o){if(t=r[f],g===t){++f;continue}if(g>=t)throw new Error("segment ids are not increasing")}if(g<0||g>=c)throw new Error(im(g,c));g>m&&p.fill(i,m*u,g*u);for(let t=d;t<f;++t){const n=s[t];if(n<0||n>=l[0])throw new Error(om(t,s[t],l[0]));for(let t=0;t<u;t++)p[g*u+t]+=e[n*u+t]}if(a)for(let e=0;e<u;e++)p[g*u+e]/=f-d;if(d=f,++f,m=g+1,g=t,f>o)break}return m<c&&p.fill(i,m*u,c*u),[p,h]}const dC=KS((e=>Math.sqrt(e))),fC={kernelName:"Sqrt",backendName:"cpu",kernelFunc:XS("Sqrt",(e=>Math.sqrt(e)))},mC=$S(((e,t)=>{const n=e-t;return n*n})),gC={kernelName:"SquaredDifference",backendName:"cpu",kernelFunc:PS("SquaredDifference",mC)},yC=KS(((e,t)=>{const{pattern:n,replaceGlobal:s,rewrite:r}=t;return e.replace(new RegExp(n,s?"g":""),r)})),bC={kernelName:"StaticRegexReplace",backendName:"cpu",kernelFunc:YS("StaticRegexReplace",yC)};function xC(e,t,n,s){const r=zi(e,t.dtype);for(let e=0;e<r.size;e++){const a=r.indexToLoc(e),i=new Array(a.length);for(let e=0;e<i.length;e++)i[e]=a[e]*n[e]+s[e];r.set(t.get(...i),...a)}return r}class wC{constructor(e,t,n,s,r,a){this.separator=kr(e),this.nGramWidths=t,this.leftPad=kr(n),this.rightPad=kr(s),this.padWidth=r,this.preserveShort=a}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,t){const n=this.getPadWidth(t);return Math.max(0,e+2*n-t+1)}createNGrams(e,t,n,s,r,a){for(let i=0;i<r;++i){const o=this.getPadWidth(a),l=Math.max(0,o-i),u=Math.max(0,o-(r-(i+1))),c=a-(l+u),h=t+(l>0?0:i-o);let p=0;p+=l*this.leftPad.length;for(let t=0;t<c;++t)p+=e[h+t].length;p+=u*this.rightPad.length;p+=(l+u+c-1)*this.separator.length,n[s+i]=new Uint8Array(p);const d=n[s+i];let f=0;const m=e=>e.forEach((e=>d[f++]=e));for(let e=0;e<l;++e)m(this.leftPad),m(this.separator);for(let t=0;t<c-1;++t)m(e[h+t]),m(this.separator);if(c>0){m(e[h+c-1]);for(let e=0;e<u;++e)m(this.separator),m(this.rightPad)}else{for(let e=0;e<u-1;++e)m(this.rightPad),m(this.separator);m(this.rightPad)}}}compute(e,t){const n=e.length,s=t.length;if(s>0){let e=t[0];if(0!==e)throw new Error(`First split value must be 0, got ${e}`);for(let r=1;r<s;++r){let s=t[r]>=e;if(s=s&&t[r]<=n,!s)throw new Error(`Invalid split value ${t[r]}, must be in [${e}, ${n}]`);e=t[r]}if(e!==n)throw new Error(`Last split value must be data size. Expected ${n}, got ${e}`)}const r=s-1,a=N("int32",s);if(0===n||0===s){const e=new Array(n);for(let e=0;e<=r;++e)a[e]=0;return[e,a]}a[0]=0;for(let e=1;e<=r;++e){const n=t[e]-t[e-1];let s=0;this.nGramWidths.forEach((e=>{s+=this.getNumNGrams(n,e)})),this.preserveShort&&n>0&&0===s&&(s=1),a[e]=a[e-1]+s}const i=new Array(a[r]);for(let n=0;n<r;++n){const s=t[n];let r=a[n];if(this.nGramWidths.forEach((a=>{const o=t[n+1]-t[n],l=this.getNumNGrams(o,a);this.createNGrams(e,s,i,r,l,a),r+=l})),this.preserveShort&&r===a[n]){const a=t[n+1]-t[n];if(0===a)continue;const o=a+2*this.padWidth,l=1;this.createNGrams(e,s,i,r,l,o)}}return[i,a]}}function vC(e,t,n,s,r,a,i,o){return new wC(n,s,r,a,i,o).compute(e,t)}function kC(e,t,n,s){if(!e.length)return;if(0===t.length){for(let t=0;t<e.length;++t)s.push(e.subarray(t,t+1));return}if(1===t.length){const r=t[0];let a=e.indexOf(r);for(;-1!==a;){const t=e.subarray(0,a);n&&0===t.length||s.push(t),a=(e=e.subarray(a+1)).indexOf(r)}return void(n&&0===e.length||s.push(e))}let r=0;for(let a=0;a<e.length+1;a++)if(a===e.length||-1!==t.indexOf(e[a])){const t=e.subarray(r,a);n&&0===t.length||s.push(t),r=a+1}}function NC(e,t,n){const s=e.length,r=[];let a=0,i=0;const o=new Array(s);for(let l=0;l<s;++l){const s=r.length;kC(e[l],t,n,r);const u=r.length-s;o[l]=u,a+=u,i=Math.max(i,u)}const l=N("int32",2*a),u=new Array(a),c=[s,i];let h=0;for(let e=0;e<s;++e)for(let t=0;t<o[e];++t)l[2*h]=e,l[2*h+1]=t,u[h]=r[h],++h;return[l,u,c]}function IC(e,t){const n=N("int32",e.length);for(let s=0;s<e.length;++s)n[s]=yr(e[s]).modulo(t).getLowBitsUnsigned();return n}const SC=$S(((e,t)=>e-t)),TC=BS(((e,t,n,s)=>({real:e-n,imag:t-s}))),CC=PS(es,SC,TC),$C={kernelName:es,backendName:"cpu",kernelFunc:CC};function EC(e,t){const n=new Array(e.rank);for(let s=0;s<n.length;s++)n[s]=e.shape[s]*t[s];const s=zi(n,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),r=new Array(e.rank);for(let t=0;t<r.length;t++)r[t]=n[t]%e.shape[t];const a=e.locToIndex(r);s.values[t]=e.values[a]}return s}const AC=(e,t)=>{const n=t.value-e.value;return 0===n?e.index-t.index:n};function RC(e,t,n=0,s=e.length-1){for(;s>n;){if(s-n>600){const r=s-n+1,a=t-n+1,i=Math.log(r),o=.5*Math.exp(2*i/3),l=.5*Math.sqrt(i*o*(r-o)/r)*Math.sign(a-r/2);RC(e,t,Math.max(n,Math.floor(t-a*o/r+l)),Math.min(s,Math.floor(t+(r-a)*o/r+l)))}const r=e[t];let a=n,i=s;for(o(e,n,t),AC(e[s],r)>0&&o(e,n,s);a<i;){for(o(e,a,i),a++,i--;AC(e[a],r)<0;)a+=1;for(;AC(e[i],r)>0;)i-=1}0===AC(e[n],r)?o(e,n,i):(i+=1,o(e,i,s)),i<=t&&(n=i+1),t<=i&&(s=i-1)}}function _C(e,t,n,s,r){const a=t[t.length-1],[i,o]=[e.length/a,a],l=k(n,i*s),u=k("int32",i*s);for(let t=0;t<i;t++){const n=t*o,a=e.subarray(n,n+o);let i=new Array(a.length);a.forEach(((e,t)=>i[t]={value:e,index:t})),s<i.length&&(RC(i,s),i=i.slice(0,s)),r&&i.sort(AC);const c=t*s,h=l.subarray(c,c+s),p=u.subarray(c,c+s);for(let e=0;e<s;e++)h[e]=i[e].value,p[e]=i[e].index}const c=t.slice();return c[c.length-1]=s,[zi(c,n,l),zi(c,"int32",u)]}function FC(e,t,n,s){const r=w(t,n)[0],a=[1,n[0],1];for(let e=0;e<r;e++)a[0]*=n[e];a[1]=n[r];for(let e=r+1;e<n.length;e++)a[2]*=n[e];const i=new Map,o=new Int32Array(n[r]),l=new Or(a,s,e),u=[],c=1===a[0]&&1===a[2];for(let t=0;t<n[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)e.push(l.get(n,t,s));n=e.join(",")}const s=i.get(n);if(null!=s)o[t]=s;else{const e=i.size;i.set(n,e),o[t]=e,u.push(t)}}const h=a.slice();h[1]=i.size;const p=new Or(h,s);u.forEach(((e,t)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,e,s),n,t,s)}));const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var DC=Object.freeze({__proto__:null,addImpl:WS,bincountImpl:GS,bincountReduceImpl:HS,bitwiseAndImpl:jS,castImpl:MS,ceilImpl:ZS,concatImpl:QS,equalImpl:eT,expImpl:sT,expm1Impl:iT,floorDivImpl:cT,floorImpl:lT,gatherNdImpl:pT,gatherV2Impl:dT,greaterEqualImpl:gT,greaterImpl:fT,lessEqualImpl:wT,lessImpl:bT,linSpaceImpl:kT,logImpl:NT,maxImpl:TT,maximumImpl:CT,minimumImpl:ET,multiplyImpl:RT,negImpl:OT,notEqualImpl:LT,prodImpl:VT,raggedGatherImpl:qT,raggedRangeImpl:KT,raggedTensorToTensorImpl:QT,rangeImpl:eC,rsqrtImpl:tC,scatterImpl:sC,sigmoidImpl:rC,simpleAbsImpl:TS,sliceImpl:oC,sparseFillEmptyRowsImpl:cC,sparseReshapeImpl:hC,sparseSegmentReductionImpl:pC,sqrtImpl:dC,squaredDifferenceImpl:mC,staticRegexReplaceImpl:yC,stridedSliceImpl:xC,stringNGramsImpl:vC,stringSplitImpl:NC,stringToHashBucketFastImpl:IC,subImpl:SC,tileImpl:EC,topKImpl:_C,transposeImpl:PT,uniqueImpl:FC});const OC="4.22.0";Ha("cpu",(()=>new SS),1);const MC=XS("Elu",(e=>e>=0?e:Math.exp(e)-1)),LC={kernelName:"Elu",backendName:"cpu",kernelFunc:MC};function zC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s;NS([r],"leakyRelu");const i=p(r.shape),o=n.data.get(r.dataId).values,l=k("float32",i);for(let e=0;e<o.length;e++)l[e]=o[e]<0?a*o[e]:o[e];return n.makeTensorInfo(r.shape,"float32",l)}const PC={kernelName:"LeakyRelu",backendName:"cpu",kernelFunc:zC},BC=$S(((e,t)=>e<0?t*e:e));function WC(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;NS([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=BC(s.shape,r.shape,a,i,"float32");return n.makeTensorInfo(l,"float32",o)}const VC={kernelName:"Prelu",backendName:"cpu",kernelFunc:WC},UC=XS("Relu",(e=>Math.max(0,e))),GC={kernelName:"Relu",backendName:"cpu",kernelFunc:UC},HC=XS("Relu6",(e=>Math.min(Math.max(0,e),6))),jC={kernelName:"Relu6",backendName:"cpu",kernelFunc:HC};function qC(e,t,n,s,r){if("linear"===n)return _S({inputs:{x:t},backend:e});if("relu"===n)return UC({inputs:{x:t},backend:e});if("elu"===n)return MC({inputs:{x:t},backend:e});if("relu6"===n)return HC({inputs:{x:t},backend:e});if("prelu"===n)return WC({inputs:{x:t,alpha:s},backend:e});if("leakyrelu"===n)return zC({inputs:{x:t},backend:e,attrs:{alpha:r}});if("sigmoid"===n)return aC({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function KC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=p(r.shape),o=x(a,i),l=p(o);u(i===l,(()=>`The new shape (${o}) has ${l} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`)),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=o,t.shape=o}return{dataId:r.dataId,shape:o,dtype:r.dtype}}const XC={kernelName:"Reshape",backendName:"cpu",kernelFunc:KC};function YC(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;NS([r,a],"matMul");const l=r.shape.length,c=a.shape.length,h=i?r.shape[l-2]:r.shape[l-1],d=o?a.shape[c-1]:a.shape[c-2],f=i?r.shape[l-1]:r.shape[l-2],m=o?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=p(g),x=p(y),w=cl(r.shape.slice(0,-2),a.shape.slice(0,-2)).concat([f,m]);u(h===d,(()=>`Error in matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`));const v=o?[x,m,d]:[x,d,m],k=KC({inputs:{x:r},backend:n,attrs:{shape:i?[b,h,f]:[b,f,h]}}),N=KC({inputs:{x:a},backend:n,attrs:{shape:v}}),I=i?k.shape[1]:k.shape[2],S=i?k.shape[2]:k.shape[1],T=o?N.shape[1]:N.shape[2],C=Math.max(b,x),$=n.data.get(k.dataId).values,E=n.data.get(N.dataId).values,A=O(k.shape),R=O(N.shape),[_,F,D]=i?[A[0],1,A[1]]:[A[0],A[1],1],[M,L,z]=o?[1,R[1],R[0]]:[R[1],1,R[0]],P=S*T,B=zi([C,S,T],k.dtype),W=B.values,V=n.blockSize;for(let e=0;e<C;e++){const t=e%b,n=e%x;for(let s=0;s<S;s+=V){const r=Math.min(s+V,S);for(let a=0;a<T;a+=V){const i=Math.min(a+V,T);for(let o=0;o<I;o+=V){const l=Math.min(o+V,I);for(let u=s;u<r;u++)for(let s=a;s<i;s++){let r=0;for(let e=o;e<l;e++){r+=$[t*_+u*F+e*D]*E[e*M+s*L+n*z]}W[e*P+(u*T+s)]+=r}}}}}return n.disposeIntermediateTensorInfo(k),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,B.dtype,B.values)}const ZC={kernelName:"BatchMatMul",backendName:"cpu",kernelFunc:YC};const JC={kernelName:"_FusedMatMul",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;let p,d,f;const m=[];p=YC({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(d=VS({inputs:{a:p,b:i},backend:n}),m.push(p),p=d),c&&(f=qC(n,p,c,o,h),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},QC={kernelName:"Acos",backendName:"cpu",kernelFunc:XS("Acos",(e=>Math.acos(e)))},e$={kernelName:"Acosh",backendName:"cpu",kernelFunc:XS("Acosh",(e=>Math.acosh(e)))};const t$={kernelName:"AddN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,s=t;NS(t,"addN");const r=s.map((e=>n.data.get(e.dataId).values)),a=zi(s[0].shape,s[0].dtype),i=a.values;for(let e=0;e<s.length;e++){const t=r[e];for(let e=0;e<i.length;e++)i[e]+=t[e]}return n.makeTensorInfo(a.shape,a.dtype,a.values)}};const n$={kernelName:"All",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;NS(r,"all");const o=w(a,r.shape);let l=o;const u=Tl(l,r.shape.length);let c=r;null!=u&&(c=BT({inputs:{x:r},backend:n,attrs:{perm:u}}),l=$l(l.length,r.shape.length)),Sl("all",l,c.shape.length);const[h,d]=Nl(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n&&s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=KC({inputs:{x:y},backend:n,attrs:{shape:Il(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const s$={kernelName:"Any",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;NS(r,"any");const o=w(a,r.shape);let l=o;const u=Tl(l,r.shape.length);let c=r;null!=u&&(c=BT({inputs:{x:r},backend:n,attrs:{perm:u}}),l=$l(l.length,r.shape.length)),Sl("any",l,c.shape.length);const[h,d]=Nl(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n||s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=KC({inputs:{x:y},backend:n,attrs:{shape:Il(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const r$={kernelName:"ArgMax",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;NS(r,"argMax");let i=w(a,r.shape);const o=Tl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=BT({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=$l(i.length,l.shape.length)),i=[i[0]],Sl("argMax",i,l.shape.length);const[c,h]=Nl(l.shape,i),d=B(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r>n&&(n=r,s=e)}d[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",d)}};const a$={kernelName:"ArgMin",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;NS(r,"argMin");let i=w(a,r.shape);const o=Tl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=BT({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=$l(i.length,l.shape.length)),i=[i[0]],Sl("argMin",i,l.shape.length);const[c,h]=Nl(l.shape,i),d=B(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r<n&&(n=r,s=e)}d[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",d)}},i$={kernelName:"Asin",backendName:"cpu",kernelFunc:XS("Asin",(e=>Math.asin(e)))},o$={kernelName:"Asinh",backendName:"cpu",kernelFunc:XS("Asinh",(e=>Math.asinh(e)))},l$={kernelName:"Atan",backendName:"cpu",kernelFunc:XS("Atan",(e=>Math.atan(e)))},u$={kernelName:"Atan2",backendName:"cpu",kernelFunc:PS("Atan2",$S(((e,t)=>Math.atan2(e,t))))},c$={kernelName:"Atanh",backendName:"cpu",kernelFunc:XS("Atanh",(e=>Math.atanh(e)))};function h$(e,t,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=zi(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*y,m=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outHeight;++y){const w=y*i-p,v=Math.max(0,w),k=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=v;n<k;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=e[r+n*s[2]+t];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+t]="avg"===a?b/w:y}}}return m}function p$(e,t,n,s,r=!1,a=!1){const i=zi(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=zi(t,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,v=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(e,n,o,t);u>w&&(w=u,v=r?a?((e*s.inHeight+n)*s.inWidth+o)*s.inChannels+t:(n*s.inWidth+o)*s.inChannels+t:i*p+l)}}i.set(v,e,n,o,t)}}return i}function d$(e,t,n,s,r,a){const i=r.strideDepth,o=r.strideHeight,l=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,h=r.dilationWidth,p=r.effectiveFilterDepth,d=r.effectiveFilterHeight,f=r.effectiveFilterWidth,m=r.padInfo.front,g=r.padInfo.top,y=r.padInfo.left,b="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,x=zi(r.outShape,n),w=x.values,v=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],k=r.outShape[2]*r.outShape[3]*r.outShape[4],N=r.outShape[3]*r.outShape[4],I=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*v,x=t*s[0];for(let t=0;t<r.inChannels;++t)for(let v=0;v<r.outDepth;++v){const S=v*i-m;let T=S;for(;T<0;)T+=u;const C=Math.min(r.inDepth,p+S),$=n+v*k;for(let n=0;n<r.outHeight;++n){const i=n*o-g;let p=i;for(;p<0;)p+=c;const m=Math.min(r.inHeight,d+i),v=$+n*N;for(let n=0;n<r.outWidth;++n){const i=n*l-y;let o=i;for(;o<0;)o+=h;const d=Math.min(r.inWidth,f+i),g=v+n*I;let k=b,N=0,S=0;for(let n=T;n<C;n+=u){const r=x+n*s[1];for(let n=p;n<m;n+=c){const i=r+n*s[2];for(let n=o;n<d;n+=h){const r=e[i+n*s[3]+t];if("max"===a&&r>k?k=r:"avg"===a&&(N+=r,S++),isNaN(k))break}if(isNaN(k))break}if(isNaN(k))break}w[g+t]="avg"===a?N/Math.max(S,1):k}}}}return x}const f$={kernelName:"AvgPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;NS(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(yo(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=io(r.shape,a,i,1,o,l);let h;if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))h=_S({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=h$(e,r.shape,r.dtype,t,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const m$={kernelName:"AvgPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;NS(r,"avgPool3d");const c=oo(r.shape,a,i,1,o,l,u),h=d$(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"avg");return n.makeTensorInfo(h.shape,"float32",h.values)}};const g$={kernelName:"AvgPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;NS([r,a],"avgPool3DGrad");const c=oo(a.shape,i,o,1,l,u),h=c.strideDepth,p=c.strideHeight,d=c.strideWidth,f=c.filterDepth,m=c.filterHeight,g=c.filterWidth,y=c.dilationDepth,b=c.dilationHeight,x=c.dilationWidth,w=c.effectiveFilterDepth,v=c.effectiveFilterHeight,k=c.effectiveFilterWidth,N=w-1-c.padInfo.front,I=k-1-c.padInfo.left,S=v-1-c.padInfo.top,T=zi(a.shape,"float32"),C=1/(f*m*g),$=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-N,i=s-S,o=r-I;let l=0;for(let n=0;n<w;n+=y){const s=(a+n)/h;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let n=0;n<v;n+=b){const r=(i+n)/p;if(!(r<0||r>=c.outHeight||Math.floor(r)!==r))for(let n=0;n<k;n+=x){const a=(o+n)/d;if(a<0||a>=c.outWidth||Math.floor(a)!==a)continue;l+=$.get(e,s,r,a,t)}}}T.set(l*C,e,n,s,r,t)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};const y$={kernelName:"AvgPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;NS([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=io(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,v=zi(i.shape,"float32"),k=1/(d*f),N=n.data.get(r.dataId).values,I=zi(r.shape,"float32",N);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;if(r<0||r>=c.outWidth||Math.floor(r)!==r)continue;i+=I.get(e,s,r,t)}}v.set(i*k,e,n,s,t)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const b$={kernelName:"FusedBatchNorm",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,scale:a,offset:i,mean:o,variance:l}=t;u(o.shape.length===l.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==i||o.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==a||o.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks.")),NS([r,o,l,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,d=n.data.get(l.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let v=0,k=0,N=0,I=0;for(let e=0;e<h.length;++e)g[e]=m[v++]+(h[e]-p[k++])*f[N++]/Math.sqrt(d[I++]+c),v>=y&&(v=0),k>=w&&(k=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}};const x$={kernelName:"BatchToSpaceND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;NS([r],"batchToSpaceND");const o=a.reduce(((e,t)=>e*t)),l=$f(r.shape,a,o),u=Ef(l.length,a.length),c=Af(r.shape,a,o),h=Rf(i,a.length),p=_f(c,i,a.length),d=KC({inputs:{x:r},backend:n,attrs:{shape:l}}),f=BT({inputs:{x:d},backend:n,attrs:{perm:u}}),m=KC({inputs:{x:f},backend:n,attrs:{shape:c}}),g=lC({inputs:{x:m},backend:n,attrs:{begin:h,size:p}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const w$={kernelName:"Bincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=GS(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,o)}};const v$={kernelName:"BroadcastArgs",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{s0:s,s1:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=cl(Array.from(a),Array.from(i));return n.makeTensorInfo([o.length],"int32",Int32Array.from(o))}},k$={kernelName:"ClipByValue",backendName:"cpu",kernelFunc:XS("ClipByValue",((e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e}))},N$={kernelName:"ComplexAbs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend,s=new Float32Array(p(t.shape)),r=n.data.get(t.dataId),a=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values;for(let e=0;e<o.length;e++){const t=o[e],n=l[e];s[e]=Math.hypot(t,n)}return n.makeOutput(s,t.shape,"float32")}};function I$(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const S$={kernelName:"Imag",backendName:"cpu",kernelFunc:I$};function T$(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=w(r,t[0].shape)[0];xf(t.map((e=>e.shape)),a);let i=wf(t.map((e=>e.shape)),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>p(e.shape)>0));if(1===o.length)return _S({inputs:{x:o[0]},backend:n});if("complex64"===o[0].dtype){const e=o.map((e=>DS({inputs:{input:e},backend:n}))),t=o.map((e=>I$({inputs:{input:e},backend:n}))),s=T$({inputs:e,backend:n,attrs:{axis:a}}),r=T$({inputs:t,backend:n,attrs:{axis:a}}),i=ES({inputs:{real:s,imag:r},backend:n});return e.forEach((e=>n.disposeIntermediateTensorInfo(e))),t.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map((e=>{const t=p(e.shape.slice(a));return KC({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})})),u=l.map((e=>({vals:n.data.get(e.dataId).values,shape:e.shape})));i=wf(l.map((e=>e.shape)),1);const c=1===l[0].shape[0],h=QS(u,i,t[0].dtype,c),d=wf(o.map((e=>e.shape)),a),f=n.makeTensorInfo(d,t[0].dtype,h);return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}const C$={kernelName:"Concat",backendName:"cpu",kernelFunc:T$};function $$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;NS([r,a],"conv2d");const h=xo(l),p=lo(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new Or(p.outShape,r.dtype),v=O(r.shape),k=O(a.shape),N=v[0],I=x?v[1]:v[2],S=x?v[2]:1,T=x?1:v[1],C=w.strides[0],$=x?w.strides[1]:w.strides[2],E=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,_=n.data.get(a.dataId).values,F=w.values;for(let e=0;e<p.batchSize;++e){const t=e*N,n=e*C;for(let e=0;e<p.outHeight;++e){const s=n+e*$,r=e*p.strideHeight-b;for(let e=0;e<d;++e){const n=r+e*m;if(n<0||n>=p.inHeight)continue;const a=e*k[0],i=t+n*I;for(let e=0;e<p.outWidth;++e){const t=s+e*E,n=e*p.strideWidth-y;for(let e=0;e<f;++e){const s=n+e*g;if(s<0||s>=p.inWidth)continue;const r=i+s*S;let o=a+e*k[1];for(let e=0;e<p.inChannels;++e){const n=R[r+e*T];for(let e=0;e<p.outChannels;++e)F[t+e*A]+=n*_[o+e];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,F)}const E$={kernelName:"Conv2D",backendName:"cpu",kernelFunc:$$};const A$={kernelName:"Conv2DBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;NS([r,a],"conv2dBackpropFilter");const h=xo(l),p=lo(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new Or(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=new Or(r.shape,r.dtype,v),I=new Or(a.shape,a.dtype,k);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((w-e)/d)),n=Math.min(p.outHeight,(p.inHeight+w-e)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=t;c<n;++c){const t=e+c*d-w;for(let e=r;e<a;++e){const n=s+e*f-x;l+=y?N.get(u,t,n,i)*I.get(u,c,e,o):N.get(u,i,t,n)*I.get(u,o,c,e)}}b.set(l,e,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const R$={kernelName:"Conv2DBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;NS([r,a],"conv2dBackpropInput");const h=O(a.shape),p=O(r.shape);let d=xo(u);const f=lo(i,a.shape,o,1,l,c,!1,d),m=new Or(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,v]=h,{batchSize:k,filterHeight:N,filterWidth:I,inChannels:S,inHeight:T,inWidth:C,outChannels:$,outHeight:E,outWidth:A,strideHeight:R,strideWidth:_}=f;d=f.dataFormat;const F=N-1-f.padInfo.top,D=I-1-f.padInfo.left,M="channelsLast"===d,L=m.strides[0],z=M?m.strides[1]:m.strides[2],P=M?m.strides[2]:1,B=M?1:m.strides[1],W=p[0],V=M?p[1]:p[2],U=M?p[2]:1,G=M?1:p[1];for(let e=0;e<k;++e)for(let t=0;t<S;++t)for(let n=0;n<T;++n){const s=n-F,r=Math.max(0,Math.ceil(s/R)),a=Math.min(E,(N+s)/R);for(let i=0;i<C;++i){const o=i-D,l=Math.max(0,Math.ceil(o/_)),u=Math.min(A,(I+o)/_);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*e+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*_-o))+v*t;for(let e=0;e<$;++e){c+=y[a+G*e]*b[i+e]}}}g[L*e+z*n+P*i+B*t]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const _$={kernelName:"Conv3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s;NS([r,a],"conv3d");const u=uo(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new Or(u.outShape,r.dtype),v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=w.values,I=O(r.shape),S=O(a.shape);for(let e=0;e<u.batchSize;++e){const t=e*I[0],n=e*w.strides[0];for(let e=0;e<u.outDepth;++e){const s=n+e*w.strides[1],r=e*u.strideDepth-y;for(let e=0;e<c;++e){const n=r+e*d;if(n<0||n>=u.inDepth)continue;const a=e*S[0],i=t+n*I[1];for(let e=0;e<u.outHeight;++e){const t=s+e*w.strides[2],n=e*u.strideHeight-x;for(let e=0;e<h;++e){const s=n+e*f;if(s<0||s>=u.inHeight)continue;const r=a+e*S[1],o=i+s*I[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,s=e*u.strideWidth-b;for(let e=0;e<p;++e){const t=s+e*m;if(t<0||t>=u.inWidth)continue;const a=r+e*S[2],i=o+t*u.inChannels;let l=a;for(let e=0;e<u.inChannels;++e){const t=v[i+e];for(let e=0;e<u.outChannels;++e)N[n+e]+=t*k[l+e];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const F$={kernelName:"Conv3DBackpropFilterV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s;NS([r,a],"conv3dBackpropFilterV2");const u=O(r.shape),c=O(a.shape),h=uo(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new Or(h.filterShape,"float32"),x=b.values,[w,v,k,N]=b.strides,I=n.data.get(a.dataId).values,[S,T,C,$]=c,E=n.data.get(r.dataId).values,[A,R,_,F]=u,D=h.padInfo.front,M=h.padInfo.left,L=h.padInfo.top;for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((D-e)/p)),n=Math.min(h.outDepth,(h.inDepth+D-e)/p),s=e*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*v+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((M-s)/f)),u=Math.min(h.outWidth,(h.inWidth+M-s)/f),c=s*k+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*S;for(let m=t;m<n;++m){const t=(e+m*p-D)*R+h,n=m*T+y;for(let e=a;e<i;++e){const a=(r+e*d-L)*_+t,i=e*C+n;for(let e=l;e<u;++e){const t=e*$+i;g+=E[(s+e*f-M)*F+a+o]*I[t+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const D$={kernelName:"Conv3DBackpropInputV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s;NS([r],"conv3dBackpropInputV2");const u=O(r.shape),c=O(a.shape),h=uo(l,a.shape,o,1,i),p=new Or(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,v,k]=u,N=n.data.get(a.dataId).values,[I,S,T,C]=c,{batchSize:$,filterDepth:E,filterHeight:A,filterWidth:R,inChannels:_,inDepth:F,inHeight:D,inWidth:M,outChannels:L,outDepth:z,outHeight:P,outWidth:B,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=E-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let e=0;e<$;++e)for(let t=0;t<_;++t)for(let n=0;n<F;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,(E+s)/W);for(let i=0;i<D;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(P,(A+o)/V);for(let c=0;c<M;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),$=Math.min(B,(R+h)/U);let _=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<$;++i){const o=x*e+w*n+v*s+k*i,l=I*(E-1-r)+S*(A-1-a)+T*(R-1-(i*U-h))+C*t;for(let e=0;e<L;++e){_+=b[o+e]*N[l+e]}}}}d[f*e+m*n+g*i+y*c+t]=_}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},O$=XS(Oe,(e=>Math.cos(e))),M$={kernelName:Oe,backendName:"cpu",kernelFunc:O$},L$={kernelName:"Cosh",backendName:"cpu",kernelFunc:XS("Cosh",(e=>Math.cosh(e)))};const z$={kernelName:"CropAndResize",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,[c,h,p,d]=r.shape,f=a.shape[0],[m,g]=o,y=zi([f,m,g,d],"float32"),b=n.data.get(a.dataId).values,x=n.data.get(i.dataId).values,w=n.data.get(r.dataId).values,v=O(r.shape),k=O(y.shape);for(let e=0;e<f;e++){const t=4*e,n=b[t],s=b[t+1],r=b[t+2],a=b[t+3],i=x[e];if(i>=c)continue;const o=m>1?(r-n)*(h-1)/(m-1):0,f=g>1?(a-s)*(p-1)/(g-1):0;for(let t=0;t<m;t++){const c=m>1?n*(h-1)+t*o:.5*(n+r)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let s=0;s<d;s++){const r=s+n*k[2]+t*k[1]+e*k[0];y.values[r]=u}else if("bilinear"===l){const n=Math.floor(c),r=Math.ceil(c),o=c-n;for(let l=0;l<g;l++){const c=g>1?s*(p-1)+l*f:.5*(s+a)*(p-1);if(c<0||c>p-1){for(let n=0;n<d;n++){const s=n+l*k[2]+t*k[1]+e*k[0];y.values[s]=u}continue}const h=Math.floor(c),m=Math.ceil(c),b=c-h;for(let s=0;s<d;s++){let a=s+h*v[2]+n*v[1]+i*v[0];const u=w[a];a=s+m*v[2]+n*v[1]+i*v[0];const c=w[a];a=s+h*v[2]+r*v[1]+i*v[0];const p=w[a];a=s+m*v[2]+r*v[1]+i*v[0];const d=u+(c-u)*b,f=p+(w[a]-p)*b;a=s+l*k[2]+t*k[1]+e*k[0],y.values[a]=d+(f-d)*o}}}else for(let n=0;n<g;++n){const r=g>1?s*(p-1)+n*f:.5*(s+a)*(p-1);if(r<0||r>p-1){for(let s=0;s<d;s++){const r=s+n*k[2]+t*k[1]+e*k[0];y.values[r]=u}continue}const o=Math.round(r),l=Math.round(c);for(let s=0;s<d;s++){const r=s+o*v[2]+l*v[1]+i*v[0],a=s+n*k[2]+t*k[1]+e*k[0];y.values[a]=w[r]}}}}return n.makeTensorInfo(y.shape,y.dtype,y.values)}};const P$={kernelName:"Cumprod",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;NS(r,"cumprod");const l=Tl([a],r.shape.length);let u=r;null!=l&&(u=BT({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=$l(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumprod in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=Kr(u.dtype,"int32"),d=P(p(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)d[n]=i?1:f[n];else{const s=g(e,t-1);d[n]=i?f[s]*d[s]:f[n]*d[s]}}const y=n.makeTensorInfo(u.shape,h,d);if(null!=l){const e=BT({inputs:{x:y},backend:n,attrs:{perm:Cl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const B$={kernelName:"Cumsum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;NS(r,"cumsum");const l=Tl([a],r.shape.length);let u=r;null!=l&&(u=BT({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=$l(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=Kr(u.dtype,"int32"),d=B(p(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)d[n]=i?0:f[n];else{const s=g(e,t-1);d[n]=i?f[s]+d[s]:f[n]+d[s]}}const y=n.makeTensorInfo(u.shape,h,d);if(null!=l){const e=BT({inputs:{x:y},backend:n,attrs:{perm:Cl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const W$={kernelName:"DenseBincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=GS(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,e)}if(2===r.shape.length){const e=HS(n.bufferSync(r),n.bufferSync(a),i,o);return n.makeTensorInfo(e.shape,a.dtype,e.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};const V$={kernelName:"DepthToSpace",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;u("NHWC"===i,(()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`));const o=r.shape[0],l=r.shape[1],c=r.shape[2],h=r.shape[3],p=l*a,d=c*a,f=h/(a*a),m=n.data.get(r.dataId).values,g=new Float32Array(o*p*d*f);let y=0;for(let e=0;e<o;++e)for(let t=0;t<p;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<d;++t){const r=Math.floor(t/a),i=(s*a+t%a)*f;for(let t=0;t<f;++t){const s=t+i+h*(r+c*(n+l*e));g[y++]=m[s]}}}return n.makeTensorInfo([o,p,d,f],r.dtype,g)}};function U$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l,dimRoundingMode:c}=s;NS([r,a],"depthwiseConv2DNative");const h=O(r.shape),p=O(a.shape);let d=l;null==d&&(d=[1,1]),u(yo(i,d),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`));const f=lo(r.shape,a.shape,i,d,o,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,v=x.top,k=f.outChannels/f.inChannels,N=new Or(f.outShape,r.dtype),I=n.data.get(r.dataId).values,S=n.data.get(a.dataId).values,T=N.values;for(let e=0;e<f.batchSize;++e){const t=e*h[0],n=e*N.strides[0];for(let e=0;e<f.outHeight;++e){const s=n+e*N.strides[1],r=e*f.strideHeight-v;for(let e=0;e<m;++e){const n=r+e*y;if(n<0||n>=f.inHeight)continue;const a=e*p[0],i=t+n*h[1];for(let e=0;e<f.outWidth;++e){const t=s+e*N.strides[2],n=e*f.strideWidth-w;for(let e=0;e<g;++e){const s=n+e*b;if(s<0||s>=f.inWidth)continue;const r=a+e*p[1],o=i+s*f.inChannels;let l=t,u=r;for(let e=0;e<f.inChannels;++e){const t=I[o+e];for(let e=0;e<k;++e)T[l+e]+=t*S[u+e];l+=k,u+=k}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const G$={kernelName:"DepthwiseConv2dNative",backendName:"cpu",kernelFunc:U$};const H$={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;NS([r,a],"depthwiseConv2dNativeBackpropFilter");const h=lo(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new Or(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,v=new Or(r.shape,r.dtype,w),k=n.data.get(a.dataId).values,N=new Or(a.shape,a.dtype,k);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/p)),n=Math.min(h.outHeight,(h.inHeight+b-e)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*p-b;for(let e=r;e<a;++e){const n=s+e*d-y;u+=v.get(l,t,n,o)*N.get(l,c,e,i)}}g.set(u,e,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const j$={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;NS([r,a],"depthwiseConv2DNativeBackpropInput");const h=O(r.shape),p=O(a.shape),d=lo(c,a.shape,i,o,l,u,!0),f=new Or(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,v,k]=h,N=n.data.get(a.dataId).values,[I,S,T]=p,{batchSize:C,filterHeight:$,filterWidth:E,inChannels:A,inHeight:R,inWidth:_,outChannels:F,outHeight:D,outWidth:M,strideHeight:L,strideWidth:z}=d,P=$-1-d.padInfo.top,B=E-1-d.padInfo.left,W=F/A;for(let e=0;e<C;++e)for(let t=0;t<A;++t)for(let n=0;n<R;++n){const s=n-P,r=Math.max(0,Math.ceil(s/L)),a=Math.min(D,($+s)/L);for(let i=0;i<_;++i){const o=i-B,l=Math.max(0,Math.ceil(o/z)),u=Math.min(M,(E+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*e+v*n+k*s,i=I*($-1-r)+S*(E-1-(s*z-o))+T*t;for(let e=0;e<W;++e){c+=x[a+(t*W+e)]*N[i+e]}}}m[g*e+y*n+b*i+t]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}};const q$={kernelName:"Diag",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=p(s.shape),a=n.data.get(s.dataId).values,i=zi([r,r],s.dtype),o=i.values;for(let e=0;e<a.length;e++)o[e*r+e]=a[e];const l=[...s.shape,...s.shape];return n.makeTensorInfo(l,i.dtype,i.values)}},K$={kernelName:"Dilation2D",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r}=e,{strides:a,pad:i,dilations:o}=n,l=t,u=l.data.get(s.dataId).values,c=s.shape.length,h=l.data.get(r.dataId).values,d=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:v,strideWidth:k,filterHeight:I,filterWidth:S,dilationHeight:T,dilationWidth:C,outShape:$}=ao(s.shape,r.shape,a,i,"NHWC",o),E=p($),A=$.length,R=N(s.dtype,E);for(let e=0;e<f;++e)for(let t=0;t<b;++t){const n=t*v-w.top;for(let a=0;a<x;++a){const i=a*k-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let t=0;t<I;++t){const a=n+t*T;if(a>=0&&a<m)for(let n=0;n<S;++n){const p=i+n*C;if(p>=0&&p<g){const i=U([e,a,p,o],c,O(s.shape)),f=U([t,n,o],d,O(r.shape)),m=u[i]+h[f];m>l&&(l=m)}}}R[U([e,t,a,o],A,O($))]=l}}}return{dataId:l.write(xr(R,s.dtype),$,s.dtype),shape:$,dtype:s.dtype}}},X$={kernelName:"Dilation2DBackpropFilter",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:l}=n,c=t,h=L(s.shape,c.data.get(s.dataId).values),p=L(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:S,outShape:T}=ao(s.shape,r.shape,i,o,"NHWC",l);u(a.rank===T.length,(()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${T.length}, but got ${a.rank}`));const C=L(T,c.data.get(a.dataId).values),$=W(r.shape,r.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let t=0;t<k;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*S;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=t,l=n)}}}$[o][l][a]+=C[e][t][s][a]}}}return{dataId:c.write(xr($,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Y$={kernelName:"Dilation2DBackpropInput",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:l}=n,c=t,h=L(s.shape,c.data.get(s.dataId).values),p=L(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:S,outShape:T}=ao(s.shape,r.shape,i,o,"NHWC",l);u(a.rank===T.length,(()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${T.length}, but got ${a.rank}`));const C=L(T,c.data.get(a.dataId).values),$=W(s.shape,s.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let t=0;t<k;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*S;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=s,l=u)}}}$[e][o][l][a]+=C[e][t][s][a]}}}return{dataId:c.write(xr($,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const Z$={kernelName:"Draw",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r}=t,{canvas:a,options:i}=s,{contextOptions:o,imageOptions:l}=i||{},u=(null==l?void 0:l.alpha)||1,c=(null==o?void 0:o.contextType)||"2d";if("2d"!==c)throw new Error(`Context type ${o.contextType} is not supported by the CPU backend.`);const h=a.getContext(c,(null==o?void 0:o.contextAttributes)||{});if(null==h)throw new Error(`Could not get the context with ${c} type.`);const[p,d]=r.shape.slice(0,2),f=2===r.shape.length?1:r.shape[2],m=n.data.get(r.dataId).values,g="float32"===r.dtype?255:1,y=new Uint8ClampedArray(d*p*4);for(let e=0;e<p*d;++e){const t=[0,0,0,255*u];for(let n=0;n<f;n++){const s=m[e*f+n];if("float32"===r.dtype){if(s<0||s>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${s}.`)}else if("int32"===r.dtype&&(s<0||s>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${s}.`);1===f?(t[0]=s*g,t[1]=s*g,t[2]=s*g):t[n]=s*g}const n=4*e;y[n+0]=Math.round(t[0]),y[n+1]=Math.round(t[1]),y[n+2]=Math.round(t[2]),y[n+3]=Math.round(t[3])}a.width=d,a.height=p;const b=new ImageData(y,d,p);return h.putImageData(b,0,0),r}};function J$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;let o;NS(r,"sum"),o="bool"===r.dtype?LS({inputs:{x:r},backend:n,attrs:{dtype:"int32"}}):_S({inputs:{x:r},backend:n});const l=o.shape.length,u=w(a,o.shape),c=Tl(u,l);let h=u,d=o;null!=c&&(d=BT({inputs:{x:o},backend:n,attrs:{perm:c}}),h=$l(h.length,l)),Sl("sum",h,d.shape.length);const[f,m]=Nl(d.shape,h);let g=RS(n,f,Kr(d.dtype,"int32"));const y=p(m),b=n.data.get(g.dataId).values,x=n.data.get(d.dataId).values;for(let e=0;e<b.length;++e){const t=e*y;let n=0;for(let e=0;e<y;++e)n+=x[t+e];b[e]=n}if(i){const e=g;g=KC({inputs:{x:g},backend:n,attrs:{shape:Il(g.shape,u)}}),n.disposeIntermediateTensorInfo(e)}return n.disposeIntermediateTensorInfo(o),null!=c&&n.disposeIntermediateTensorInfo(d),g}const Q$={kernelName:"Sum",backendName:"cpu",kernelFunc:J$};const eE={kernelName:"Einsum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=Uf(r,a.length);Hf(i.length,l,a);const{path:u,steps:c}=jf(o,l),h=c.length;let p=null,d=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=Gf(d,l[t]);let r;qf(e)?r=a[t]:(r=BT({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);f(r.shape,i)||(r=KC({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=FT({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=J$({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-d),keepDims:!1}}),m.push(p)),d--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}};const tE={kernelName:"EluGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{dy:s,y:r}=t;NS([s,r],"eluGrad");const a=new Float32Array(p(r.shape)),i=n.data.get(r.dataId).values,o=n.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];a[e]=t>=0?o[e]:o[e]*(t+1)}return n.makeTensorInfo(r.shape,"float32",a)}},nE=XS(et,(e=>{const t=Math.sign(e),n=Math.abs(e),s=1/(1+.3275911*n);return t*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))})),sE={kernelName:et,backendName:"cpu",kernelFunc:nE};function rE(e){const{inputs:t,backend:n,attrs:s}=e,{input:r}=t,{dim:a}=s,i=r.shape.length,o=r.shape.slice();let l=a;return a<0&&(u(-(i+1)<=a,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),l=i+a+1),o.splice(l,0,1),KC({inputs:{x:r},backend:n,attrs:{shape:o}})}const aE={kernelName:"ExpandDims",backendName:"cpu",kernelFunc:rE},iE=PS("RealDiv",$S(((e,t)=>e/t))),oE={kernelName:"RealDiv",backendName:"cpu",kernelFunc:iE};function lE(e,t,n){const s=e.shape,r=s[0],a=s[1],i=n.data.get(e.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=p(u),h=k("float32",c),d=k("float32",c);for(let e=0;e<r;e++){const s=lC({inputs:{x:o},backend:n,attrs:{begin:[e,0],size:[1,a]}}),r=lC({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,a]}}),i=ES({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=uE(i,t,n),p=Df(u,c);for(let t=0;t<a;t++){const n=zf(p,t);h[e*a+t]=n.real,d[e*a+t]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",h),m=n.makeTensorInfo(u,"float32",d),g=ES({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function uE(e,t,n){const s=p(e.shape),r=n.data.get(e.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=cE(a,i,s,t,n),o=[e.shape[0],e.shape[1]];if(t){const e=n.makeTensorInfo(o,"float32",r.real),t=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",br(s,"float32")),i=_S({inputs:{x:a},backend:n}),l=oE.kernelFunc({inputs:{a:e,b:a},backend:n}),u=oE.kernelFunc({inputs:{a:t,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}{const e=function(e,t,n){const s=new Float32Array(2*t);for(let r=0;r<t;r++){let a=0,i=0;for(let s=0;s<t;s++){const o=Wf(r*s,t,n),l=zf(e,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=t,i/=t),Pf(s,a,i,r)}return s}(Df(a,i),s,t);return Of(e)}var o}function cE(e,t,n,s,r){if(1===n)return{real:e,imag:t};const a=Df(e,t),i=n/2,o=Mf(a),l=o.real,u=o.imag,c=[l.length],h=r.makeTensorInfo(c,"float32",l),p=r.makeTensorInfo(c,"float32",u),d=ES({inputs:{real:h,imag:p},backend:r}),f=Lf(a),m=f.real,g=f.imag,y=[m.length],b=r.makeTensorInfo(y,"float32",m),x=r.makeTensorInfo(y,"float32",g),w=ES({inputs:{real:b,imag:x},backend:r}),v=cE(l,u,i,s,r),k=v.real,N=v.imag,I=[k.length],S=r.makeTensorInfo(I,"float32",k),T=r.makeTensorInfo(I,"float32",N),C=ES({inputs:{real:S,imag:T},backend:r}),$=cE(m,g,i,s,r),E=$.real,A=$.imag,R=[E.length],_=r.makeTensorInfo(R,"float32",E),F=r.makeTensorInfo(R,"float32",A),D=ES({inputs:{real:_,imag:F},backend:r}),O=Bf(n,s),M=[O.real.length],L=r.makeTensorInfo(M,"float32",O.real),z=r.makeTensorInfo(M,"float32",O.imag),P=ES({inputs:{real:L,imag:z},backend:r}),B=FT({inputs:{a:P,b:D},backend:r}),W=VS({inputs:{a:C,b:B},backend:r}),V=CC({inputs:{a:C,b:B},backend:r}),U=DS({inputs:{input:W},backend:r}),G=DS({inputs:{input:V},backend:r}),H=I$({inputs:{input:W},backend:r}),j=I$({inputs:{input:V},backend:r}),q=T$({inputs:[U,G],backend:r,attrs:{axis:0}}),K=T$({inputs:[H,j],backend:r,attrs:{axis:0}}),X=r.data.get(q.dataId).values,Y=r.data.get(K.dataId).values;return r.disposeIntermediateTensorInfo(h),r.disposeIntermediateTensorInfo(p),r.disposeIntermediateTensorInfo(d),r.disposeIntermediateTensorInfo(b),r.disposeIntermediateTensorInfo(x),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(T),r.disposeIntermediateTensorInfo(C),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(D),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(B),r.disposeIntermediateTensorInfo(W),r.disposeIntermediateTensorInfo(V),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(H),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(K),{real:X,imag:Y}}const hE={kernelName:"FFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=KC({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=lE(i,!1,n),l=KC({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};function pE(e){const{backend:t,attrs:n}=e,{shape:s,value:r,dtype:a}=n,i=a||_(r),o=N(i,p(s));return function(e,t,n){e.fill(t)}(o,r),t.makeTensorInfo(s,i,o)}const dE={kernelName:"Fill",backendName:"cpu",kernelFunc:pE};const fE={kernelName:"FlipLeftRight",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,r=n,a=k(s.dtype,p(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*o*u;for(let e=0;e<o;e++){const n=e*(l*u);for(let e=0;e<l;e++){const s=e*u;for(let r=0;r<u;r++){const i=Math.round(l-e-1),o=t+n+s+r;let h=c[o];if(i>=0&&i<l){h=c[t+n+i*u+r]}a[o]=h}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const mE={kernelName:"FusedConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=$$({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;if("NCHW"===c&&1===i.shape.length&&1!==i.shape[0]){const e=KC({inputs:{x:i},backend:n,attrs:{shape:[i.shape[0],1,1]}});m=VS({inputs:{a:m,b:e},backend:n}),n.disposeIntermediateTensorInfo(e)}else m=VS({inputs:{a:m,b:i},backend:n});n.disposeIntermediateTensorInfo(e)}if(d){const e=m;if("NCHW"===c&&"prelu"===d&&1===o.shape.length&&1!==o.shape[0]){const e=KC({inputs:{x:o},backend:n,attrs:{shape:[o.shape[0],1,1]}});m=qC(n,m,d,e,f),n.disposeIntermediateTensorInfo(e)}else m=qC(n,m,d,o,f);n.disposeIntermediateTensorInfo(e)}return m}};const gE={kernelName:"FusedDepthwiseConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=U$({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=VS({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=qC(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const yE={kernelName:"GatherNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=p(s.shape),i=r.shape,o=i[i.length-1],[l,u,c,h]=Xd(s,r);if(0===u)return n.makeTensorInfo(l,s.dtype,[]);const d=pT(n.data.get(r.dataId).values,n.bufferSync(s),s.dtype,u,o,c,h,s.shape,a);return n.makeTensorInfo(l,s.dtype,d.values)}};const bE={kernelName:"GatherV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s;NS([r,a],"gatherV2");const l=w(i,r.shape)[0],c=n.data.get(a.dataId).values,h=r.shape[l];for(let e=0;e<c.length;++e){const t=c[e];u(t<=h-1&&t>=0,(()=>`GatherV2: the index value ${t} is not in [0, ${h-1}]`))}let d=o;null==o&&(d=0);const f=p(a.shape),m=cm(r,a,l,d),g=KC({inputs:{x:r},backend:n,attrs:{shape:[m.batchSize,m.outerSize,m.dimSize,m.sliceSize]}}),y=KC({inputs:{x:a},backend:n,attrs:{shape:[m.batchSize,f/m.batchSize]}}),b=[m.batchSize,m.outerSize,f/m.batchSize,m.sliceSize],x=n.bufferSync(y),v=dT(n.bufferSync(g),x,b);return n.disposeIntermediateTensorInfo(g),n.disposeIntermediateTensorInfo(y),n.makeTensorInfo(m.outputShape,v.dtype,v.values)}};const xE={kernelName:"IFFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=KC({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=lE(i,!0,n),l=KC({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},wE={kernelName:"IsFinite",backendName:"cpu",kernelFunc:XS("IsFinite",(e=>Number.isFinite(e)?1:0),"bool")},vE={kernelName:"IsInf",backendName:"cpu",kernelFunc:XS("IsInf",(e=>Math.abs(e)===1/0?1:0),"bool")},kE={kernelName:"IsNan",backendName:"cpu",kernelFunc:XS("IsNan",(e=>Number.isNaN(e)?1:0),"bool")};const NE={kernelName:"LinSpace",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=kT(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},IE={kernelName:"Log1p",backendName:"cpu",kernelFunc:XS("Log1p",(e=>Math.log1p(e)))},SE={kernelName:"LogicalAnd",backendName:"cpu",kernelFunc:PS("LogicalAnd",$S(((e,t)=>e&&t)),null,"bool")},TE={kernelName:"LogicalNot",backendName:"cpu",kernelFunc:XS("LogicalNot",(e=>e?0:1),"bool")},CE={kernelName:"LogicalOr",backendName:"cpu",kernelFunc:PS("LogicalOr",$S(((e,t)=>e||t)),null,"bool")};const $E={kernelName:"LRN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s;NS(r,"LRN");const u=r.shape[3],c=u-1,h=n.data.get(r.dataId).values,d=p(r.shape),f=new Float32Array(d);function m(e){const t=e%u;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,c);let r=0;for(;n<=s;n++){const e=h[n];r+=e*e}return r}for(let e=0;e<d;e++){const t=m(e),n=h[e]*Math.pow(i+o*t,-l);f[e]=n}return n.makeTensorInfo(r.shape,r.dtype,f)}};const EE={kernelName:"LRNGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s;NS(i,"LRNGrad");const h=p(i.shape),d=i.shape[3],f=n.data.get(i.dataId).values,m=n.data.get(r.dataId).values,g=n.data.get(a.dataId).values,y=new Float32Array(h),b=h;for(let e=0;e<b;e++){const t=e%d,n=e-t+Math.max(0,t-o),s=e-t+Math.min(d,t+o+1);let r=0;for(let e=n;e<s;e++)r+=Math.pow(m[e],2);r=u*r+l;for(let t=n;t<s;t++){let n=-2*u*c*m[t]*g[e]/r;e===t&&(n+=Math.pow(r,-c)),n*=f[e],y[t]+=n}}return n.makeTensorInfo(i.shape,r.dtype,y)}};function AE(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=n;let l=r.shape;const u=l.length,c=w(a,l);let h=c;const d=Tl(h,u);let f=o.data.get(r.dataId).values;if(null!=d){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=l[d[t]];f=PT(f,l,r.dtype,d,e),h=$l(h.length,u),l=e}NS(r,"max"),Sl("max",h,u);const[m,g]=Nl(l,h),y=TT(f,p(g),m,r.dtype),b=o.write(y,m,r.dtype);let x=m;if(i){x=Il(m,c)}return{dataId:b,shape:x,dtype:r.dtype}}const RE={kernelName:"Max",backendName:"cpu",kernelFunc:AE};const _E={kernelName:"MaxPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;NS(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(yo(i,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=io(r.shape,a,i,1,o,l);let h;if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))h=_S({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=h$(e,r.shape,r.dtype,t,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const FE={kernelName:"MaxPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;NS(r,"maxPool3d");const c=oo(r.shape,a,i,1,o,l,u),h=d$(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"max");return n.makeTensorInfo(h.shape,"float32",h.values)}};const DE={kernelName:"MaxPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;NS([r,a],"maxPool3DGrad");const c=oo(a.shape,i,o,1,l,u),h=function(e,t){const n=zi(t.outShape,"int32"),s=t.strideDepth,r=t.strideHeight,a=t.strideWidth,i=t.dilationDepth,o=t.dilationHeight,l=t.dilationWidth,u=t.effectiveFilterDepth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.front,d=t.padInfo.top,f=t.padInfo.left;for(let m=0;m<t.batchSize;++m)for(let g=0;g<t.inChannels;++g)for(let y=0;y<t.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(t.inDepth,u+b);for(let s=0;s<t.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const v=Math.min(t.inHeight,c+u);for(let r=0;r<t.outWidth;++r){const d=r*a-f;let k=d;for(;k<0;)k+=l;const N=Math.min(t.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,S=-1;for(let t=x;t<w;t+=i){const n=t-b;for(let s=p;s<v;s+=o){const r=s-u;for(let a=k;a<N;a+=l){const i=a-d,o=e.get(m,t,s,a,g);o>=I&&(I=o,S=n*c*h+r*c+i)}}}n.set(S,m,y,s,r,g)}}}return n}(n.bufferSync(a),c),p=c.strideDepth,d=c.strideHeight,f=c.strideWidth,m=c.dilationDepth,g=c.dilationHeight,y=c.dilationWidth,b=c.effectiveFilterDepth,x=c.effectiveFilterHeight,w=c.effectiveFilterWidth,v=b-1-c.padInfo.front,k=w-1-c.padInfo.left,N=x-1-c.padInfo.top,I=zi(a.shape,"float32"),S=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-v,i=s-N,o=r-k;let l=0;for(let n=0;n<b;n+=m){const s=(a+n)/p;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let r=0;r<x;r+=g){const a=(i+r)/d;if(!(a<0||a>=c.outHeight||Math.floor(a)!==a))for(let i=0;i<w;i+=y){const u=(o+i)/f;if(u<0||u>=c.outWidth||Math.floor(u)!==u)continue;const p=b*x*w-1-h.get(e,s,a,u,t)===n*x*w+r*w+i?1:0;if(0===p)continue;l+=S.get(e,s,a,u,t)*p}}}I.set(l,e,n,s,r,t)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const OE={kernelName:"MaxPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;NS([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=io(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=zi(p.outShape,o.dtype,p$(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,v=w-1-p.padInfo.left,k=x-1-p.padInfo.top,N=zi(o.shape,"float32"),I=n.data.get(r.dataId).values,S=zi(r.shape,"float32",I);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-k,a=s-v;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(e,s,o,t)===n*w+r?1:0;if(0===l)continue;i+=S.get(e,s,o,t)*l}}N.set(i,e,n,s,t)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const ME={kernelName:"MaxPoolWithArgmax",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;NS(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=io(s.shape,r,a,[1,1],i),[h,p]=function(e,t,n,s,r){const a=h$(e,0,n,O(t),r,"max"),i=p$(e,t,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};const LE={kernelName:"Mean",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=w(a,r.shape),l=p(Nl(r.shape,o)[1]),u=[],c=n.makeTensorInfo([],"float32",new Float32Array([l]));u.push(c);const h=LS({inputs:{x:r},backend:n,attrs:{dtype:"float32"}});u.push(h);const d=iE({inputs:{a:h,b:c},backend:n});u.push(d);const f=J$({inputs:{x:d},backend:n,attrs:{axis:a,keepDims:i}});return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}};const zE={kernelName:"Min",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;NS(r,"min");const o=w(a,r.shape);let l=o;const u=Tl(l,r.shape.length);let c=r;null!=u&&(c=BT({inputs:{x:r},backend:n,attrs:{perm:u}}),l=$l(l.length,r.shape.length)),Sl("min",l,c.shape.length);const[h,d]=Nl(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];(Number.isNaN(s)||s<n)&&(n=s)}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=KC({inputs:{x:y},backend:n,attrs:{shape:Il(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const PE={kernelName:"MirrorPad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,mode:i}=s;NS(r,"mirrorPad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=a.map(((e,t)=>e[0]+r.shape[t])),c="reflect"===i?0:1,h=n.data.get(r.dataId).values,d=r.shape.length,f=O(r.shape),m=p(o),g=o.length,y=O(o),b=k(r.dtype,m);for(let e=0;e<m;e++){let t=G(e,g,y);for(let e=0;e<g;e++)t[e]<l[e]?t[e]=2*l[e]-t[e]-c:t[e]>=u[e]&&(t[e]=2*(u[e]-1)-t[e]+c);t=t.map(((e,t)=>e-l[t]));const n=U(t,d,f);b[e]=h[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},BE=$S(((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t})),WE=PS(qt,BE),VE={kernelName:qt,backendName:"cpu",kernelFunc:WE};function UE(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=r.shape.length;let o=a;if(-1===o&&(o=i-1),o!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);const l=w([o],r.shape),u=AE({inputs:{x:r},backend:n,attrs:{reductionIndices:l,keepDims:!1}}),c=Il(u.shape,l),h=KC({inputs:{x:u},backend:n,attrs:{shape:c}}),p=CC({inputs:{a:r,b:h},backend:n}),d=rT({inputs:{x:p},backend:n}),f=J$({inputs:{x:d},backend:n,attrs:{axis:l,keepDims:!1}}),m=KC({inputs:{x:f},backend:n,attrs:{shape:c}}),g=iE({inputs:{a:d,b:m},backend:n});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}const GE={kernelName:"Softmax",backendName:"cpu",kernelFunc:UE};const HE={kernelName:"Multinomial",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s;NS(r,"multinomial");const l=o?r:UE({inputs:{logits:r},backend:n,attrs:{dim:-1}}),u=l.shape[0],c=l.shape[1],h=n.data.get(l.dataId).values,d=[u,a],f=B(p(d),"int32");for(let e=0;e<u;++e){const t=e*c,n=new Float32Array(c-1);n[0]=h[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+h[t+e];const s=Nc.alea(i.toString()),r=e*a;for(let e=0;e<a;++e){const t=s();f[r+e]=n.length;for(let s=0;s<n.length;s++)if(t<n[s]){f[r+e]=s;break}}}return o||n.disposeIntermediateTensorInfo(l),n.makeTensorInfo(d,"int32",f)}},jE=yp;const qE={kernelName:"NonMaxSuppressionV3",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s;NS(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,{selectedIndices:h}=jE(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},KE=bp;const XE={kernelName:"NonMaxSuppressionV4",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s;NS(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,{selectedIndices:p,validOutputs:d}=KE(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},YE=xp;const ZE={kernelName:"NonMaxSuppressionV5",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s;NS(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=YE(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};const JE={kernelName:"OneHot",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{dtype:a,depth:i,onValue:o,offValue:l}=s;NS(r,"oneHot");const u=p(r.shape),c=new Float32Array(u*i);c.fill(l);const h=n.data.get(r.dataId).values;for(let e=0;e<u;++e)h[e]>=0&&h[e]<i&&(c[e*i+h[e]]=o);return n.makeTensorInfo([...r.shape,i],a,c)}};function QE(e){const{inputs:t,backend:n}=e,{x:s}=t;if("string"===s.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===s.dtype){const e=DS({inputs:{input:s},backend:n}),t=QE({inputs:{x:e},backend:n}),r=I$({inputs:{input:s},backend:n}),a=QE({inputs:{x:r},backend:n}),i=ES({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return pE({backend:n,attrs:{shape:s.shape,value:0,dtype:s.dtype}})}const eA={kernelName:"ZerosLike",backendName:"cpu",kernelFunc:QE};const tA={kernelName:"OnesLike",backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){const t=DS({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=I$({inputs:{input:r},backend:s}),i=QE({inputs:{x:a},backend:s}),o=ES({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return pE({backend:s,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function nA(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return rE({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach((e=>{c(a,e.shape,"All tensors passed to stack must have matching shapes"),u(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],l=T$({inputs:t.map((e=>{const t=rE({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t})),backend:n,attrs:{axis:r}});return o.forEach((e=>n.disposeIntermediateTensorInfo(e))),l}const sA={kernelName:"Pack",backendName:"cpu",kernelFunc:nA};const rA={kernelName:"PadV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;NS(r,"pad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=n.data.get(r.dataId).values,c=p(r.shape),h=r.shape.length,d=O(r.shape),f=p(o),m=o.length,g=O(o),y=k(r.dtype,f);0!==i&&y.fill(i);for(let e=0;e<c;e++){y[U(G(e,h,d).map(((e,t)=>e+l[t])),m,g)]=u[e]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},aA=$S(((e,t)=>Math.pow(e,t))),iA=PS(on,aA),oA={kernelName:on,backendName:"cpu",kernelFunc:iA};const lA={kernelName:"RaggedGather",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{paramsNestedSplits:r,paramsDenseValues:a,indices:i}=t,{outputRaggedRank:o}=s,l=r.map((e=>n.data.get(e.dataId).values)),u=r.map((e=>e.shape)),c=n.data.get(a.dataId).values,h=n.data.get(i.dataId).values,[p,d,f]=qT(l,u,c,a.shape,a.dtype,h,i.shape),m=p.map((e=>n.makeTensorInfo([e.length],"int32",e))),g=n.makeTensorInfo(f,a.dtype,d);return m.concat([g])}};const uA={kernelName:"RaggedRange",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{starts:s,limits:r,deltas:a}=t,i=n.data.get(s.dataId).values,o=n.data.get(r.dataId).values,l=n.data.get(a.dataId).values,[u,c]=KT(i,s.shape,s.dtype,o,r.shape,l,a.shape);return[n.makeTensorInfo([u.length],"int32",u),n.makeTensorInfo([c.length],s.dtype,c)]}};const cA={kernelName:"RaggedTensorToTensor",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{shape:r,values:a,defaultValue:i,rowPartitionTensors:o}=t,{rowPartitionTypes:l}=s,u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,h=n.data.get(i.dataId).values,p=o.map((e=>n.data.get(e.dataId).values)),d=o.map((e=>e.shape)),[f,m]=QT(u,r.shape,c,a.shape,a.dtype,h,i.shape,p,d,l);return n.makeTensorInfo(f,a.dtype,m)}};const hA={kernelName:"Range",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,dtype:a,step:i}=n,o=eC(s,r,i,a);return t.makeTensorInfo([o.length],a,o)}},pA={kernelName:"Reciprocal",backendName:"cpu",kernelFunc:XS("Reciprocal",(e=>1/e))};const dA={kernelName:"ResizeBilinear",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;NS(r,"resizeBilinear");const l=O(r.shape),[u,c]=o,[h,d,f,m]=r.shape,g=n.data.get(r.dataId).values,y=new Float32Array(p([h,u,c,m])),b=[a&&u>1?d-1:d,a&&c>1?f-1:f],x=[a&&u>1?u-1:u,a&&c>1?c-1:c];let w=0;const v=b[0]/x[0],k=b[1]/x[1];for(let e=0;e<h;e++)for(let t=0;t<u;t++){let n;n=i?v*(t+.5)-.5:v*t;const s=Math.max(0,Math.floor(n)),r=n-s,a=Math.min(d-1,Math.ceil(n)),o=e*l[0]+s*l[1],u=e*l[0]+a*l[1];for(let e=0;e<c;e++){let t;t=i?k*(e+.5)-.5:k*e;const n=Math.max(0,Math.floor(t)),s=t-n,a=Math.min(f-1,Math.ceil(t)),c=o+n*l[2],h=u+n*l[2],p=o+a*l[2],d=u+a*l[2];for(let e=0;e<m;e++){const t=g[c+e],n=g[h+e],a=t+(g[p+e]-t)*s,i=a+(n+(g[d+e]-n)*s-a)*r;y[w++]=i}}}return n.makeTensorInfo([h,u,c,m],"float32",y)}};const fA={kernelName:"ResizeBilinearGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;NS([a,r],"resizeBilinearGrad");const o=O(r.shape),[l,u,c,h]=r.shape,[,p,d]=a.shape,f=new Float32Array(l*u*c*h),m=[i&&p>1?u-1:u,i&&d>1?c-1:c],g=[i&&p>1?p-1:p,i&&d>1?d-1:d],y=m[0]/g[0],b=m[1]/g[1],x=n.data.get(a.dataId).values;let w=0;for(let e=0;e<l;e++){const t=e*o[0];for(let e=0;e<p;e++){const n=e*y,s=Math.floor(n),r=Math.min(Math.ceil(n),u-1),a=t+s*o[1],i=t+r*o[1],l=n-s,p=1-l;for(let e=0;e<d;e++){const t=e*b,n=Math.floor(t),s=Math.min(Math.ceil(t),c-1),r=t-n,u=1-r,d=a+n*o[2],m=a+s*o[2],g=i+n*o[2],y=i+s*o[2],v=p*u,k=p*r,N=l*u,I=l*r;for(let e=0;e<h;e++){const t=x[w++];f[d+e]+=t*v,f[m+e]+=t*k,f[g+e]+=t*N,f[y+e]+=t*I}}}}return n.makeTensorInfo([l,c,u,h],"float32",f)}};const mA={kernelName:"ResizeNearestNeighbor",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;NS(r,"resizeNearestNeighbor");const l=O(r.shape),[u,c]=o,[h,p,d,f]=r.shape,m=n.data.get(r.dataId).values,g=new Float32Array(h*u*c*f),y=[a&&u>1?p-1:p,a&&c>1?d-1:d],b=[a&&u>1?u-1:u,a&&c>1?c-1:c],x=y[0]/b[0],w=y[1]/b[1];let v=0;for(let e=0;e<h;e++){const t=e*l[0];for(let e=0;e<u;e++){const n=i?x*(e+.5):x*e;let s=Math.min(p-1,a?Math.round(n):Math.floor(n));i&&(s=Math.max(0,s));const r=t+s*l[1];for(let e=0;e<c;e++){const t=i?w*(e+.5):w*e;let n=Math.min(d-1,a?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const s=r+n*l[2];for(let e=0;e<f;e++){const t=m[s+e];g[v++]=t}}}}return n.makeTensorInfo([h,u,c,f],r.dtype,g)}};const gA={kernelName:"ResizeNearestNeighborGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;NS([a,r],"resizeNearestNeighborGrad");const o=O(r.shape),l=O(a.shape),[u,c,h,p]=r.shape,[,d,f]=a.shape,m=new Float32Array(u*c*h*p),g=n.data.get(a.dataId).values,y=[i&&d>1?c-1:c,i&&f>1?h-1:h],b=[i&&d>1?d-1:d,i&&f>1?f-1:f],x=y[0]/b[0],w=y[1]/b[1],v=1/x,k=1/w,N=2*Math.ceil(v)+2,I=2*Math.ceil(k)+2;for(let e=0;e<u;e++){const t=e*o[0];for(let e=0;e<c;e++){const n=t+e*o[1],s=Math.floor(e*v),r=Math.floor(s-N/2);for(let s=0;s<h;s++){const a=n+s*o[2],u=Math.floor(s*k),y=Math.floor(u-I/2);for(let n=0;n<p;n++){let o=0;for(let a=0;a<N;a++){const u=a+r;if(u<0||u>=d)continue;const p=t+u*l[1],m=u*x;if(e===Math.min(c-1,i?Math.round(m):Math.floor(m)))for(let e=0;e<I;e++){const t=e+y;if(t<0||t>=f)continue;const r=p+t*l[2],a=t*w;s===Math.min(h-1,i?Math.round(a):Math.floor(a))&&(o+=g[r+n])}}m[a+n]=o}}}}return n.makeTensorInfo(r.shape,r.dtype,m)}};const yA={kernelName:"Reverse",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s;NS(r,"reverse");const i=r.shape.length,o=w(a,r.shape);if(0===i)return _S({inputs:{x:r},backend:n});const l=new Or(r.shape,r.dtype),u=n.bufferSync(r);for(let e=0;e<l.size;e++){const t=l.indexToLoc(e),n=t.slice();o.forEach((e=>n[e]=r.shape[e]-1-n[e])),l.set(u.get(...n),...t)}return n.makeTensorInfo(l.shape,l.dtype,l.values)}},bA={kernelName:"RotateWithOffset",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=k(s.dtype,p(s.shape)),[u,c,h,d]=s.shape,[f,m]=Cf(i,c,h),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*h*c*d;for(let e=0;e<c;e++){const n=e*(h*d);for(let s=0;s<h;s++){const r=s*d;for(let i=0;i<d;i++){const o=[u,e,s,i],p=o[2],x=o[1];let w=(p-f)*y-(x-m)*g,v=(p-f)*g+(x-m)*y;w=Math.round(w+f),v=Math.round(v+m);let k=a;if("number"!=typeof a&&(k=3===i?255:a[i]),w>=0&&w<h&&v>=0&&v<c){k=b[t+v*(h*d)+w*d+i]}l[t+n+r+i]=k}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},xA={kernelName:"Round",backendName:"cpu",kernelFunc:XS("Round",(e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}))};const wA={kernelName:"ScatterNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Sh(0,r,i),p=sC(n.bufferSync(r),n.bufferSync(a),i,h,u,l,o,c,0,!0);return n.makeTensorInfo(i,p.dtype,p.values)}};function vA(e,t){let n=0,s=e.length,r=0;for(;n<s;)r=Math.floor((n+s)/2),e[r]<t?n=r+1:s=r;return s}function kA(e,t){let n=0,s=e.length,r=0;for(;n<s;)r=Math.floor((n+s)/2),e[r]<=t?n=r+1:s=r;return s}const NA={kernelName:"SearchSorted",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sortedSequence:r,values:a}=t,{side:i}=s,o=function(e,t,n,s,r,a){const i=N("int32",n*r);for(let o=0;o<n;++o){const n=e.slice(o*s,(o+1)*s),l=o*r;for(let e=0;e<r;++e)i[l+e]="left"===a?vA(n,t[e+l]):kA(n,t[e+l])}return i}(n.data.get(r.dataId).values,n.data.get(a.dataId).values,r.shape[0],r.shape[1],a.shape[1],i);return n.makeTensorInfo(a.shape,"int32",o)}};const IA={kernelName:"Select",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t;NS([s,r,a],"select");const i=s.shape.length,o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=Kr(r.dtype,a.dtype),h=B(p(r.shape),c);let d=0;const f=0===i||i>1||1===r.shape.length?1:p(r.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<f;t++)1===o[e]?h[d++]=l[e]:h[d++]=u[e];return n.makeTensorInfo(r.shape,c,h)}},SA={kernelName:"Selu",backendName:"cpu",kernelFunc:XS("Selu",(e=>e>=0?1.0507009873554805*e:1.7580993408473768*(Math.exp(e)-1)))},TA={kernelName:"Sign",backendName:"cpu",kernelFunc:XS("Sign",(e=>e<0?-1:e>0?1:0))},CA=XS(_n,(e=>Math.sin(e))),$A={kernelName:_n,backendName:"cpu",kernelFunc:CA},EA={kernelName:"Sinh",backendName:"cpu",kernelFunc:XS("Sinh",(e=>Math.sinh(e)))},AA=Math.log(1.1920928955078125e-7)+2,RA={kernelName:"Softplus",backendName:"cpu",kernelFunc:XS("Softplus",(e=>{const t=e>-AA,n=e<AA,s=Math.exp(e);let r;return r=n?s:t?e:Math.log(1+s),r}))};const _A={kernelName:"SpaceToBatchND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;NS([r],"spaceToBatchND");const o=p(a),l=[[0,0]];l.push(...i);for(let e=1+a.length;e<r.shape.length;++e)l.push([0,0]);const u=rA.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=$f(u.shape,a,o,!1),h=Ef(c.length,a.length,!1),d=Af(u.shape,a,o,!1),f=KC({inputs:{x:u},backend:n,attrs:{shape:c}}),m=BT({inputs:{x:f},backend:n,attrs:{perm:h}}),g=KC({inputs:{x:m},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const FA={kernelName:"SparseFillEmptyRows",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:s,values:r,denseShape:a,defaultValue:i}=t;if(1!==a.shape.length)throw new Error(`Dense shape must be a vector, saw:\n        ${a.shape}`);if(2!==s.shape.length)throw new Error(`Indices must be a matrix, saw:\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Values must be a vector, saw:\n        ${r.shape}`);if(0!==i.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${i.shape}`);const o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=n.data.get(i.dataId).values[0],[h,p,d,f,m]=cC(o,s.shape,s.dtype,l,r.dtype,u,c);return[n.makeTensorInfo(p,s.dtype,h),n.makeTensorInfo([p[0]],r.dtype,d),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],s.dtype,new Int32Array(m))]}};const DA={kernelName:"SparseReshape",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:s,inputShape:r,newShape:a}=t;if(2!==s.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${r.shape}`);if(1!==a.shape.length)throw new Error(`Target shape should be a vector but received shape ${a.shape}`);const i=Array.from(n.data.get(r.dataId).values),o=n.data.get(s.dataId).values,l=Array.from(n.data.get(a.dataId).values),[u,c,h]=hC(o,s.shape,s.dtype,i,l);return[n.makeTensorInfo(c,s.dtype,u),n.makeTensorInfo([h.length],a.dtype,new Int32Array(h))]}};const OA={kernelName:"SparseSegmentMean",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:s,indices:r,segmentIds:a}=t;if(s.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n          ${r.shape}`);if(1!==a.shape.length)throw new Error(`Segment ids should be a vector but received shape\n          ${a.shape}`);if(r.shape[0]!==a.shape[0])throw new Error("segmentIds and indices should have same size.");const i=n.data.get(s.dataId).values,o=n.data.get(r.dataId).values,l=n.data.get(a.dataId).values,[u,c]=pC(i,s.shape,s.dtype,o,l,!0);return n.makeTensorInfo(c,s.dtype,u)}};const MA={kernelName:"SparseSegmentSum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:s,indices:r,segmentIds:a}=t;if(s.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n         ${r.shape}`);if(1!==a.shape.length)throw new Error(`Segment ids should be a vector but received shape\n         ${a.shape}`);if(r.shape[0]!==a.shape[0])throw new Error("segmentIds and indices should have same size.");const i=n.data.get(s.dataId).values,o=n.data.get(r.dataId).values,l=n.data.get(a.dataId).values,[u,c]=pC(i,s.shape,s.dtype,o,l);return n.makeTensorInfo(c,s.dtype,u)}};const LA={kernelName:"SparseToDense",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,sliceSize:c,strides:h,outputSize:p}=Sh(0,r,o),d=!1,f=n.bufferSync(r);let m;switch(a.dtype){case"bool":m=sC(f,n.bufferSync(a),o,p,c,u,l,h,Boolean(n.data.get(i.dataId).values[0]),d);break;case"float32":m=sC(f,n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],d);break;case"int32":m=sC(f,n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],d);break;case"string":m=sC(f,n.bufferSync(a),o,p,c,u,l,h,Nr(n.data.get(i.dataId).values[0]),d);break;default:throw new Error(`Unsupported type ${a.dtype}`)}return n.makeTensorInfo(o,m.dtype,m.values)}};const zA={kernelName:"SplitV",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=w(i,r.shape)[0],l=Xf(r,a,o),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return l.map((e=>{const t=[...c];t[o]=e;const s=lC({inputs:{x:r},backend:n,attrs:{begin:u,size:t}});return u[o]+=e,s}))}},PA={kernelName:"Square",backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;NS(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];a[e]=t*t}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},BA={kernelName:"Step",backendName:"cpu",kernelFunc:XS("Step",((e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha}))};const WA={kernelName:"StridedSlice",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:c,ellipsisMask:h,newAxisMask:p,shrinkAxisMask:d}=s;NS(r,"stridedSlice");const{finalShapeSparse:f,finalShape:m,isIdentity:g,sliceDim0:y,isSimpleSlice:b,begin:x,end:w,strides:v}=hf(r.shape,a,i,o,l,c,h,p,d);let k;if(g)k=KC({inputs:{x:r},backend:n,attrs:{shape:m}});else if(y||b){u(r.shape.length>=1,(()=>`Input must have rank at least 1, got: ${r.shape.length}`));const e=Jd(x,w,v),t=lC({inputs:{x:r},backend:n,attrs:{begin:x,size:e}});k=KC({inputs:{x:t},backend:n,attrs:{shape:m}}),n.disposeIntermediateTensorInfo(t)}else{const e=xC(f,n.bufferSync(r),v,x);k=n.makeTensorInfo(m,e.dtype,e.values)}return k}};const VA={kernelName:"StringNGrams",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{separator:r,nGramWidths:a,leftPad:i,rightPad:o,padWidth:l,preserveShortSequences:u}=s,{data:c,dataSplits:h}=t,p=n.data.get(c.dataId).values,d=n.data.get(h.dataId).values,[f,m]=vC(p,d,r,a,i,o,l,u);return[n.makeTensorInfo([f.length],"string",f),n.makeTensorInfo(h.shape,"int32",m)]}};const UA={kernelName:"StringSplit",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{skipEmpty:r}=s,{input:a,delimiter:i}=t;if("string"!==a.dtype)throw new Error("Input must be of datatype string");if(1!==a.shape.length)throw new Error(`Input must be a vector, got shape: ${a.shape}`);if(0!==i.shape.length)throw new Error(`Delimiter must be a scalar, got shape: ${i.shape}`);const o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values[0],[u,c,h]=NC(o,l,r),p=c.length;return[n.makeTensorInfo([p,2],"int32",u),n.makeTensorInfo([p],"string",c),n.makeTensorInfo([2],"int32",new Int32Array(h))]}};const GA={kernelName:"StringToHashBucketFast",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{numBuckets:r}=s,{input:a}=t;if("string"!==a.dtype)throw new Error("Input must be of datatype string");if(r<=0)throw new Error("Number of buckets must be at least 1");const i=IC(n.data.get(a.dataId).values,r);return n.makeTensorInfo(a.shape,"int32",i)}},HA=XS(ts,(e=>Math.tan(e))),jA={kernelName:ts,backendName:"cpu",kernelFunc:HA},qA=XS("Tanh",(e=>Math.tanh(e)));const KA={kernelName:"TensorScatterUpdate",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{tensor:s,indices:r,updates:a}=t,{sliceRank:i,numUpdates:o,sliceSize:l,strides:u,outputSize:c}=Sh(0,r,s.shape),h=n.bufferSync(r),p=n.bufferSync(a),d=n.bufferSync(s),f=sC(h,p,s.shape,c,l,o,i,u,d,!1);return n.makeTensorInfo(s.shape,f.dtype,f.values)}};const XA={kernelName:"Tile",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;NS(r,"tile");const i=EC(n.bufferSync(r),a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const YA={kernelName:"TopK",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s;NS(r,"topk");const o=n.data.get(r.dataId).values,[l,u]=_C(o,r.shape,r.dtype,a,i);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const ZA={kernelName:"Transform",backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{image:r,transforms:a}=t,{interpolation:i,fillMode:o,fillValue:l,outputShape:u}=n,[c,h,d,f]=r.shape,[m,g]=null!=u?u:[h,d],y=[c,m,g,f],b=O(r.shape),x=b[0],w=b[1],v=b[2],N=O(y),I=N[0],S=N[1],T=N[2],C=k(r.dtype,p(y));C.fill(l);const $=s.data.get(r.dataId).values,E=s.data.get(a.dataId).values;for(let e=0;e<c;++e){const t=1===a.shape[0]?E:E.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let s=0;s<g;++s)for(let r=0;r<f;++r){let a;const u=t[6]*s+t[7]*n+1;if(0===u)continue;const c=(t[0]*s+t[1]*n+t[2])/u,p=(t[3]*s+t[4]*n+t[5])/u,f=JA(c,d,o),m=JA(p,h,o);switch(i){case"nearest":a=eR($,h,d,x,w,v,e,m,f,r,l);break;case"bilinear":a=tR($,h,d,x,w,v,e,m,f,r,l);break;default:throw new Error(`Error in Transform: Expect 'nearest' or 'bilinear', but got ${i}`)}C[e*I+n*S+s*T+r]=a}return s.makeTensorInfo(y,r.dtype,C)}return{dataId:s.write(C,y,r.dtype),shape:r.shape,dtype:r.dtype}}};function JA(e,t,n){switch(n){case"reflect":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=2*t;n<e&&(n=e*Math.trunc(-n/e)+n),n=n<-t?n+e:-n-1}else if(n>t-1)if(t<=1)n=0;else{const e=2*t;n-=e*Math.trunc(n/e),n>=t&&(n=e-n-1)}return a(0,n,t-1)}(e,t);case"wrap":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=t-1;n+=t*(Math.trunc(-n/e)+1)}else if(n>t-1)if(t<=1)n=0;else{const e=t-1;n-=t*Math.trunc(n/e)}return a(0,n,t-1)}(e,t);case"nearest":return function(e,t){return a(0,e,t-1)}(e,t);default:return function(e,t){return e}(e)}}function QA(e,t,n,s,r,a,i,o,l,u,c){return 0<=o&&o<t&&0<=l&&l<n?e[i*s+o*r+l*a+u]:c}function eR(e,t,n,s,r,a,i,o,l,u,c){return QA(e,t,n,s,r,a,i,Math.round(o),Math.round(l),u,c)}function tR(e,t,n,s,r,a,i,o,l,u,c){const h=Math.floor(o),p=Math.floor(l),d=h+1,f=p+1;return(d-o)*((f-l)*QA(e,t,n,s,r,a,i,h,p,u,c)+(l-p)*QA(e,t,n,s,r,a,i,h,f,u,c))+(o-h)*((f-l)*QA(e,t,n,s,r,a,i,d,p,u,c)+(l-p)*QA(e,t,n,s,r,a,i,d,f,u,c))}const nR={kernelName:"Unique",backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;NS(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=FC(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}};const sR={kernelName:"Unpack",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r.shape.length,o=r.shape[a],l=new Array(i-1);let u=0;for(let e=0;e<i;e++)e!==a&&(l[u++]=r.shape[e]);const c=new Array(i).fill(0),h=r.shape.slice();h[a]=1;const p=new Array(o);for(let e=0;e<p.length;e++){c[a]=e;const t=lC({inputs:{x:r},backend:n,attrs:{begin:c,size:h}});p[e]=KC({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const rR={kernelName:"UnsortedSegmentSum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s;NS(r,"unsortedSegmentSum");const o=[],l=[],u=r.shape.length-a.shape.length;let c=a;for(let e=0;e<u;++e){const t=rE({inputs:{input:c},backend:n,attrs:{dim:e+1}});c=t,l.push(t)}for(let e=0;e<i;++e){const t=br(e,"int32"),s=n.makeTensorInfo([],"int32",t),a=tT({inputs:{a:s,b:c},backend:n}),i=LS({inputs:{x:a},backend:n,attrs:{dtype:"float32"}}),u=FT({inputs:{a:i,b:r},backend:n}),h=J$({inputs:{x:u},backend:n,attrs:{axis:0,keepDims:!1}});o.push(h),l.push(s),l.push(a),l.push(i),l.push(u),l.push(h)}const h=nA({inputs:o,backend:n,attrs:{axis:0}});return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),h}},aR=[JC,CS,QC,e$,US,t$,n$,s$,r$,a$,i$,o$,l$,u$,c$,f$,m$,g$,y$,ZC,b$,x$,w$,qS,v$,zS,JS,k$,AS,N$,C$,E$,A$,R$,_$,F$,D$,M$,L$,z$,P$,B$,W$,V$,G$,H$,j$,q$,K$,X$,Y$,Z$,eE,LC,tE,nT,sE,aT,aE,oT,hE,dE,fE,uT,hT,mE,gE,yE,bE,mT,yT,FS,xE,S$,wE,vE,kE,PC,xT,vT,NE,ST,IE,SE,TE,CE,$E,EE,RE,$T,_E,FE,DE,OE,ME,LE,zE,AT,PE,VE,HE,DT,MT,qE,XE,ZE,zT,JE,tA,sA,rA,oA,VC,UT,lA,uA,cA,hA,OS,oE,pA,GC,jC,XC,dA,fA,mA,gA,yA,bA,xA,nC,wA,NA,IA,SA,iC,TA,$A,EA,uC,GE,RA,_A,FA,DA,OA,MA,LA,zA,fC,PA,gC,bC,BA,WA,VA,UA,GA,$C,Q$,jA,{kernelName:"Tanh",backendName:"cpu",kernelFunc:qA},KA,XA,YA,ZA,WT,nR,sR,rR,eA];for(const e of aR)Is(e);const iR={},oR={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function lR(e,t){iR[e]=t}function uR(e,t){if(!(e in iR)||null!=t){const n=function(e,t){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const n=null==t?function(e){if(K().getBool("IS_SAFARI")||"undefined"==typeof OffscreenCanvas||2!==e){if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}return new OffscreenCanvas(300,150)}(e):t;n.addEventListener("webglcontextlost",(t=>{t.preventDefault(),delete iR[e]}),!1),K().getBool("SOFTWARE_WEBGL_ENABLED")&&(oR.failIfMajorPerformanceCaveat=!1);if(1===e)return n.getContext("webgl",oR)||n.getContext("experimental-webgl",oR);return n.getContext("webgl2",oR)}(e,t);if(null===n)return console.log("Could not get context for WebGL version",e),null;iR[e]=n}const n=iR[e];return null==n||n.isContextLost()?(delete iR[e],uR(e)):(n.disable(n.DEPTH_TEST),n.disable(n.STENCIL_TEST),n.disable(n.BLEND),n.disable(n.DITHER),n.disable(n.POLYGON_OFFSET_FILL),n.disable(n.SAMPLE_COVERAGE),n.enable(n.SCISSOR_TEST),n.enable(n.CULL_FACE),n.cullFace(n.BACK),iR[e])}var cR,hR,pR;function dR(e,t){return[t,e]}function fR(e){const t=p(e);return g(Math.ceil(t/4))}function mR(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function gR(e,t){const n=e;let s,r,a,i,o,l,u,c,h,p;return 2===K().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT,l=n.RGBA8):(s=e.RGBA,r=e.RGBA,a=e.RGBA,i=n.RGBA,o=e.RGBA,u=4,c=4,h=null!=t?t.HALF_FLOAT_OES:null,p=e.FLOAT,l=e.RGBA),{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function yR(e,t){const n=t();return K().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+xR(e,t))}(e),n}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(cR||(cR={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(hR||(hR={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(pR||(pR={}));function bR(e){return!!(K().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function xR(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${t}`}}function wR(e,t){return VR(e,(()=>e.getExtension(t)),'Extension "'+t+'" not supported on this browser.')}function vR(e,t){const n=VR(e,(()=>e.createShader(e.VERTEX_SHADER)),"Unable to create vertex WebGLShader.");if(yR(e,(()=>e.shaderSource(n,t))),yR(e,(()=>e.compileShader(n))),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}function kR(e,t){const n=VR(e,(()=>e.createShader(e.FRAGMENT_SHADER)),"Unable to create fragment WebGLShader.");if(yR(e,(()=>e.shaderSource(n,t))),yR(e,(()=>e.compileShader(n))),K().get("ENGINE_COMPILE_ONLY"))return n;if(!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw IR(t,e.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}const NR=/ERROR: [0-9]+:([0-9]+):/g;function IR(e,t){const n=NR.exec(t);if(null==n)return console.log(`Couldn't parse line number in error: ${t}`),void console.log(e);const s=+n[1],r=e.split("\n"),a=r.length.toString().length+2,i=r.map(((e,t)=>y((t+1).toString(),a)+e));let o=0;for(let e=0;e<i.length;e++)o=Math.max(i[e].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log(`%c ${y(u[0],o)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}function SR(e){return VR(e,(()=>e.createProgram()),"Unable to create WebGLProgram.")}function TR(e,t){if(yR(e,(()=>e.linkProgram(t))),!K().get("ENGINE_COMPILE_ONLY")&&!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}function CR(e,t){if(yR(e,(()=>e.validateProgram(t))),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function $R(e,t){const n=VR(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return yR(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n))),yR(e,(()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW))),n}function ER(e,t){const n=VR(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return yR(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n))),yR(e,(()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW))),n}function AR(e){return VR(e,(()=>e.createTexture()),"Unable to create WebGLTexture.")}function RR(e,t){const n=K().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0){throw new Error("Requested texture size "+`[${e}x${t}]`+" is invalid.")}if(e>n||t>n){throw new Error("Requested texture size "+`[${e}x${t}]`+" greater than WebGL maximum on this browser / GPU "+`[${n}x${n}]`+".")}}function _R(e){return VR(e,(()=>e.createFramebuffer()),"Unable to create WebGLFramebuffer.")}function FR(e,t,n,s,r,a,i){const o=e.getAttribLocation(t,n);return-1!==o&&(yR(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,s))),yR(e,(()=>e.vertexAttribPointer(o,r,e.FLOAT,!1,a,i))),yR(e,(()=>e.enableVertexAttribArray(o))),!0)}function DR(e,t,n){UR(e,n),yR(e,(()=>e.activeTexture(e.TEXTURE0+n))),yR(e,(()=>e.bindTexture(e.TEXTURE_2D,t)))}function OR(e,t,n){return VR(e,(()=>e.getUniformLocation(t,n)),'uniform "'+n+'" not present in program.')}function MR(e,t,n){return e.getUniformLocation(t,n)}function LR(e,t,n,s){yR(e,(()=>DR(e,t,s))),yR(e,(()=>e.uniform1i(n,s)))}function zR(e,t,n){yR(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,n))),yR(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0)))}function PR(e,t){yR(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,t))),yR(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0)))}function BR(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+WR(e,t))}function WR(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${t}`}}function VR(e,t,n){const s=yR(e,(()=>t()));if(null==s)throw new Error(n);return s}function UR(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=t+e.TEXTURE0;if(s<e.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function GR(e,t=2){return p(e.slice(0,e.length-t))}function HR(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function jR(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[GR(e),...HR(e)]),t}function qR(e,t=!1){let n=K().getNumber("WEBGL_MAX_TEXTURE_SIZE"),s=K().getNumber("WEBGL_MAX_SIZE_FOR_NARROW_TEXTURE");if(s===1/0&&K().getBool("WEBGL_AUTO_SQUARIFY_NARROW_TEXTURE_SHAPE")&&(s=n/2),t&&(n*=2,s*=2,1===(e=e.map(((t,n)=>n>=e.length-2?i(e[n]):e[n]))).length&&(e=[2,e[0]])),2!==e.length){const t=v(e);e=t.newShape}let r=p(e),a=null;e.length<=1&&r<=n?a=[1,r]:2===e.length&&e[0]<=n&&e[1]<=n?a=e:3===e.length&&e[0]*e[1]<=n&&e[2]<=n?a=[e[0]*e[1],e[2]]:3===e.length&&e[0]<=n&&e[1]*e[2]<=n?a=[e[0],e[1]*e[2]]:4===e.length&&e[0]*e[1]*e[2]<=n&&e[3]<=n?a=[e[0]*e[1]*e[2],e[3]]:4===e.length&&e[0]<=n&&e[1]*e[2]*e[3]<=n&&(a=[e[0],e[1]*e[2]*e[3]]);const o=null!=a&&Math.max(...a)>s&&Math.min(...a)<=(t?2:1)&&Math.min(...a)>0;if(null==a||o)if(t){const t=GR(e);let n=2,s=2;e.length&&([n,s]=HR(e)),r=t*(n/2)*(s/2),a=g(r).map((e=>2*e))}else a=g(r);return a}function KR(e){return e%2==0}function XR(e,t){if(f(e=e.slice(-2),t=t.slice(-2)))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e[e.length-1],s=t[t.length-1];if(n===s)return!0;if(KR(n)&&KR(s)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&KR(e[0])&&KR(t[0])}let YR,ZR;function JR(e){if(null==YR){const t=uR(e);YR=t.getParameter(t.MAX_TEXTURE_SIZE)}return YR}function QR(e){if(null==ZR){const t=uR(e);ZR=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,ZR)}function e_(e){if(0===e)return 0;let t;const n=uR(e);return t=t_(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:t_(n,"EXT_disjoint_timer_query")?1:0,t}function t_(e,t){return null!=e.getExtension(t)}function n_(e){try{if(null!=uR(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function s_(e){if(0===e)return!1;const t=uR(e);if(1===e){if(!t_(t,"OES_texture_float"))return!1}else if(!t_(t,"EXT_color_buffer_float"))return!1;return a_(t)}function r_(e){if(0===e)return!1;const t=uR(e);if(1!==e){if(t_(t,"EXT_color_buffer_float"))return a_(t);const e="EXT_color_buffer_half_float";if(t_(t,e)){const n=t.getExtension(e);return function(e,t){const n=gR(e,t),s=e.createTexture();e.bindTexture(e.TEXTURE_2D,s);const r=1,a=1;e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,r,a,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const i=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,i),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,s,0);const o=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(s),e.deleteFramebuffer(i),o}(t,n)}return!1}if(!t_(t,"OES_texture_float"))return!1;if(!t_(t,"WEBGL_color_buffer_float"))return!1;return a_(t)}function a_(e){const t=gR(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const s=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,s),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(s),r}function i_(e){if(2!==e)return!1;return null!=uR(e).fenceSync}function o_(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&u("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the WebGL backend.`))}))}var l_=Object.freeze({__proto__:null,assertNotComplex:o_,bindCanvasToFramebuffer:function(e){yR(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),yR(e,(()=>e.viewport(0,0,e.canvas.width,e.canvas.height))),yR(e,(()=>e.scissor(0,0,e.canvas.width,e.canvas.height)))},bindColorTextureToFramebuffer:zR,bindTextureToProgramUniformSampler:LR,bindTextureUnit:DR,bindVertexBufferToProgramAttribute:FR,callAndCheck:yR,canBeRepresented:bR,createFragmentShader:kR,createFramebuffer:_R,createProgram:SR,createStaticIndexBuffer:ER,createStaticVertexBuffer:$R,createTexture:AR,createVertexShader:vR,getBatchDim:GR,getExtensionOrThrow:wR,getFramebufferErrorMessage:WR,getMaxTexturesInShader:QR,getNumChannels:function(){return 2===K().getNumber("WEBGL_VERSION")?1:4},getProgramUniformLocation:MR,getProgramUniformLocationOrThrow:OR,getRowsCols:HR,getShapeAs3D:jR,getTextureShapeFromLogicalShape:qR,getWebGLDisjointQueryTimerVersion:e_,getWebGLErrorMessage:xR,getWebGLMaxTextureSize:JR,hasExtension:t_,isCapableOfRenderingToFloatTexture:s_,isDownloadFloatTextureEnabled:r_,isReshapeFree:XR,isWebGLFenceEnabled:i_,isWebGLVersionEnabled:n_,linkProgram:TR,logShaderSourceAndInfoLog:IR,resetMaxTextureSize:function(){YR=null},resetMaxTexturesInShader:function(){ZR=null},unbindColorTextureFromFramebuffer:PR,unbindTextureUnit:function(e,t){UR(e,t),yR(e,(()=>e.activeTexture(e.TEXTURE0+t))),yR(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))},validateFramebuffer:BR,validateProgram:CR,validateTextureSize:RR});const u_=K();function c_(){let e,t,n,s,r,a,i,o,l,u;return 2===K().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o=K().getBool("WEBGL2_ISNAN_CUSTOM")?"\n      bool isnan_custom(float val) {\n        uint floatToUint = floatBitsToUint(val);\n        return (floatToUint & 0x7fffffffu) > 0x7f800000u;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ":"",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function h_(e,t,n="index"){const s=O(t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / ${t}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${t}`:`index -= ${e[r]} * ${t}`};`)).join("")}function p_(e,t,n="index"){const s=O(t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / outShapeStrides[${r}]`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * outShapeStrides[${r}]`:`index -= ${e[r]} * outShapeStrides[${r}]`};`)).join("")}function d_(e,t,n="index"){const s=function(e,t){const n=e.length,s=e.map((e=>`${t}[${e}]`)),r=new Array(n-1);r[n-2]=s[n-1];for(let e=n-3;e>=0;--e)r[e]=`(${r[e+1]} * ${s[e+1]})`;return r}(e.map(((e,t)=>t)),t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / ${s[r]}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${s[r]}`:`index -= ${e[r]} * ${s[r]}`};`)).join("")}function f_(e){const t=O(e).map((e=>e.toString()));return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}u_.registerFlag("HAS_WEBGL",(()=>u_.getNumber("WEBGL_VERSION")>0)),u_.registerFlag("WEBGL_VERSION",(()=>n_(2)?2:n_(1)?1:0)),u_.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",(()=>!1)),u_.registerFlag("WEBGL_BUFFER_SUPPORTED",(()=>2===u_.get("WEBGL_VERSION"))),u_.registerFlag("WEBGL_CPU_FORWARD",(()=>!0)),u_.registerFlag("WEBGL_FORCE_F16_TEXTURES",(()=>!1)),u_.registerFlag("WEBGL_PACK",(()=>u_.getBool("HAS_WEBGL"))),u_.registerFlag("WEBGL_PACK_NORMALIZATION",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_CLIP",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_DEPTHWISECONV",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_REDUCE",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_LAZILY_UNPACK",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_CONV_IM2COL",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_PACK_CONV2DTRANSPOSE",(()=>u_.getBool("WEBGL_PACK"))),u_.registerFlag("WEBGL_MAX_TEXTURE_SIZE",(()=>JR(u_.getNumber("WEBGL_VERSION")))),u_.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",(()=>QR(u_.getNumber("WEBGL_VERSION")))),u_.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",(()=>{const e=u_.getNumber("WEBGL_VERSION");return 0===e?0:e_(e)})),u_.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",(()=>u_.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!ha())),u_.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",(()=>s_(u_.getNumber("WEBGL_VERSION")))),u_.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",(()=>!u_.getBool("WEBGL_FORCE_F16_TEXTURES")&&u_.getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))),u_.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",(()=>r_(u_.getNumber("WEBGL_VERSION")))),u_.registerFlag("WEBGL_FENCE_API_ENABLED",(()=>i_(u_.getNumber("WEBGL_VERSION")))),u_.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",(()=>u_.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0)),u_.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",(()=>-1),(e=>{if("number"!=typeof e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be a number but got ${e}.`);if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)})),u_.registerFlag("WEBGL_FLUSH_THRESHOLD",(()=>ha()?1:-1),(e=>{if("number"!=typeof e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be a number but got ${e}.`);if(e<0&&-1!==e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be -1 (indicating never manual flush) or at least 0, but got ${e}.`)})),u_.registerFlag("CPU_HANDOFF_SIZE_THRESHOLD",(()=>128)),u_.registerFlag("WEBGL_USE_SHAPES_UNIFORMS",(()=>!1)),u_.registerFlag("TOPK_LAST_DIM_CPU_HANDOFF_SIZE_THRESHOLD",(()=>1e5)),u_.registerFlag("TOPK_K_CPU_HANDOFF_THRESHOLD",(()=>128)),u_.registerFlag("WEBGL_EXP_CONV",(()=>!1)),u_.registerFlag("SOFTWARE_WEBGL_ENABLED",(()=>u_.getBool("IS_TEST"))),u_.registerFlag("WEBGL_MAX_SIZE_FOR_NARROW_TEXTURE",(()=>1/0)),u_.registerFlag("WEBGL_AUTO_SQUARIFY_NARROW_TEXTURE_SHAPE",(()=>!1)),u_.registerFlag("WEBGL2_ISNAN_CUSTOM",(()=>!1)),u_.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const m_="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n",{getBroadcastDims:g_}=fm;function y_(e,t,n){const s=[];if(e.forEach((e=>{const t=p(e.shapeInfo.logicalShape);if(e.shapeInfo.isUniform?s.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(s.push(`uniform sampler2D ${e.name};`),s.push(`uniform int offset${e.name};`)),n.enableShapeUniforms){const{uniformShape:t}=$_(n.packedInputs,e.shapeInfo.logicalShape,e.shapeInfo.texShape);switch(t.length){case 1:s.push(`uniform int ${e.name}Shape;`);break;case 2:s.push(`uniform ivec2 ${e.name}Shape;`);break;case 3:s.push(`uniform ivec3 ${e.name}Shape;`);break;case 4:s.push(`uniform ivec4 ${e.name}Shape;`)}s.push(`uniform ivec2 ${e.name}TexShape;`)}})),n.enableShapeUniforms){switch(t.logicalShape.length){case 1:s.push("uniform int outShape;");break;case 2:s.push("uniform ivec2 outShape;"),s.push("uniform int outShapeStrides;");break;case 3:s.push("uniform ivec3 outShape;"),s.push("uniform ivec2 outShapeStrides;");break;case 4:s.push("uniform ivec4 outShape;"),s.push("uniform ivec3 outShapeStrides;")}s.push("uniform ivec2 outTexShape;")}n.customUniforms&&n.customUniforms.forEach((e=>{s.push(`uniform ${e.type} ${e.name}${e.arrayIndex?`[${e.arrayIndex}]`:""};`)}));const r=s.join("\n"),a=e.map((e=>function(e,t,n=!1,s){let r="";r+=n?x_(e,s):b_(e,s);const a=e.shapeInfo.logicalShape,i=t.logicalShape;a.length<=i.length&&(r+=n?function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.shapeInfo.logicalShape.length,i=t.logicalShape.length,o=g_(e.shapeInfo.logicalShape,t.logicalShape),l=C_(i),u=i-a;let c;const h=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map((e=>`coords.${h[e+u]} = 0;`)).join("\n");let d="";d=i<2&&a>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${h[t+u]}`)).join(", ");let f="return outputValue;";const m=1===p(e.shapeInfo.logicalShape),g=1===p(t.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const e=a-2,t=a-1;o.indexOf(e)>-1&&o.indexOf(t)>-1?f="return vec4(outputValue.x);":o.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${d});\n      ${f}\n    }\n  `}(e,t):function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.texShape,i=e.shapeInfo.texShape,o=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&o===l&&null==e.shapeInfo.flatOffset&&f(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=C_(l),c=g_(e.shapeInfo.logicalShape,t.logicalShape),h=l-o;let p;const d=["x","y","z","w","u","v"];p=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map((e=>`coords.${d[e+h]} = 0;`)).join("\n");let m="";m=l<2&&o>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${d[t+h]}`)).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${p}\n      return get${s}(${m});\n    }\n  `}(e,t));return r}(e,t,n.packedInputs,n.enableShapeUniforms))).join("\n"),i=t.texShape,o=c_(),l=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(o);let u,c,h=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${w_}\n    ${v_}\n    ${k_}\n  `}(o);t.isPacked?(u=function(e,t,n){switch(e.length){case 0:return I_();case 1:return function(e,t,n){const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===s[0])return n?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ceil(float(outTexShape[1]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${s[1]}.0);\n      }\n    `;if(1===s[1])return n?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ceil(float(outTexShape[0]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${s[0]}.0);\n      }\n    `;if(n)return"\n    int getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      return 2 * (resTexRC.x * packedTexShape[1] + resTexRC.y);\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      return 2 * (resTexRC.x * ${s[1]} + resTexRC.y);\n    }\n  `}(0,t,n);case 2:return function(e,t,n){const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(f(e,t))return n?"\n      ivec2 getOutputCoords() {\n        ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n        return 2 * ivec2(resultUV.yx * vec2(packedTexShape[0], packedTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${s[0]}, ${s[1]}));\n      }\n    `;const r=Math.ceil(e[1]/2);if(n)return"\n    ivec2 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t,n);case 3:return function(e,t,n){if(n)return"\n    ivec3 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec3(b, r, c);\n    }\n  ";const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[2]/2),a=r*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t,n);default:return function(e,t,n){if(n)return"\n    ivec4 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int texelsInLogicalRow = int(ceil(float(outShape[3]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatchN = texelsInBatch * outShape[1];\n\n      int b2 = index / texelsInBatchN;\n      index -= b2 * texelsInBatchN;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec4(b2, b, r, c);\n    }\n  ";const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[e.length-1]/2),a=r*Math.ceil(e[e.length-2]/2);let i=a,o="",l="b, r, c";for(let t=2;t<e.length-1;t++)i*=e[e.length-t-1],o=`\n      int b${t} = index / ${i};\n      index -= b${t} * ${i};\n    `+o,l=`b${t}, `+l;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n\n      ${o}\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec${e.length}(${l});\n    }\n  `}(e,t,n)}}(t.logicalShape,i,n.enableShapeUniforms),c=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(o)):(u=function(e,t,n){switch(e.length){case 0:return I_();case 1:return function(e,t,n){if(1===t[0])return n?"\n      int getOutputCoords() {\n        return int(resultUV.x * float(outTexShape[1]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return n?"\n      int getOutputCoords() {\n        return int(resultUV.y * float(outTexShape[0]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;if(n)return"\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      return resTexRC.x * outTexShape[1] + resTexRC.y;\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,t,n);case 2:return function(e,t,n){if(f(e,t))return n?"\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(outTexShape[0], outTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return n?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return n?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(0, index);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;if(n)return"\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      int r = index / outShape[1];\n      int c = index - r * outShape[1];\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t,n);case 3:return function(e,t,n){if(n){return`\n  ivec3 getOutputCoords() {\n    ivec2 resTexRC = ivec2(resultUV.yx *\n                           vec2(outTexShape[0], outTexShape[1]));\n    int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n    ${p_(["r","c","d"],e)}\n    return ivec3(r, c, d);\n  }\n`}const s=h_(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${s}\n      return ivec3(r, c, d);\n    }\n  `}(e,t,n);case 4:return function(e,t,n){if(n){return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      ${p_(["r","c","d","d2"],e)}\n      return ivec4(r, c, d, d2);\n    }\n  `}const s=h_(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${s}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t,n);case 5:return function(e,t){const n=h_(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,t){const n=h_(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(`${e.length}-D output sampling is not yet supported`)}}(t.logicalShape,i,n.enableShapeUniforms),c=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(o)),n.packedInputs&&(h+=N_);return[h,l,c,r,u,a,n.userCode].join("\n")}function b_(e,t=!1){const n=e.shapeInfo.logicalShape;switch(n.length){case 0:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`float ${s}() {return ${n};}`;const[r,a]=e.shapeInfo.texShape;if(1===r&&1===a)return`\n      float ${s}() {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const i=S_(n);if(t)return`\n    float ${s}() {\n      vec2 uv = uvFromFlat(${n}TexShape[0], ${n}TexShape[1], ${i});\n      return sampleTexture(${n}, uv);\n    }\n  `;const[o,l]=e.shapeInfo.texShape;return`\n    float ${s}() {\n      vec2 uv = uvFromFlat(${o}, ${l}, ${i});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e,t);case 1:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${s}(int index) {\n        ${T_(e)}\n      }\n    `;const r=e.shapeInfo.texShape,a=r[0],i=r[1];if(1===i&&1===a)return`\n      float ${s}(int index) {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const o=S_(n);if(1===i)return t?`\n      float ${s}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${o}) + 0.5) / float(${n}TexShape[0]));\n        return sampleTexture(${n}, uv);\n      }\n    `:`\n      float ${s}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${o}) + 0.5) / ${a}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(1===a)return t?`\n      float ${s}(int index) {\n        vec2 uv = vec2((float(index + ${o}) + 0.5) / float(${n}TexShape[1]), 0.5);\n        return sampleTexture(${n}, uv);\n      }\n    `:`\n      float ${s}(int index) {\n        vec2 uv = vec2((float(index + ${o}) + 0.5) / ${i}.0, 0.5);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(t)return`\n    float ${s}(int index) {\n      vec2 uv = uvFromFlat(${n}TexShape[0], ${n}TexShape[1], index + ${o});\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n    float ${s}(int index) {\n      vec2 uv = uvFromFlat(${a}, ${i}, index + ${o});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape;if(null!=a&&f(n,a)){if(t)return`\n      float ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `;const e=a[0];return`\n    float ${r}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${a[1]}.0, ${e}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `}const{newShape:i,keptDims:o}=v(n),l=i;if(l.length<n.length){const n=["row","col"];return`\n      ${b_(E_(e,l),t)}\n      float ${r}(int row, int col) {\n        return ${r}(${A_(n,o)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${n[1]}, 1)));\n        ${T_(e)}\n      }\n    `;const u=a[0],c=a[1],h=S_(s);if(1===c)return t?`\n      float ${r}(int row, int col) {\n        float index = dot(vec3(row, col, ${h}), vec3(${s}Shape[1], 1, 1));\n        vec2 uv = vec2(0.5, (index + 0.5) / float(${s}TexShape[0]));\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col) {\n      float index = dot(vec3(row, col, ${h}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${u}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `;if(1===u)return t?`\n      float ${r}(int row, int col) {\n        float index = dot(vec3(row, col, ${h}), vec3(${s}Shape[1], 1, 1));\n        vec2 uv = vec2((index + 0.5) / float(${s}TexShape[1]), 0.5);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col) {\n      float index = dot(vec3(row, col, ${h}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${c}.0, 0.5);\n      return sampleTexture(${s}, uv);\n    }\n  `;if(t)return`\n      float ${r}(int row, int col) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${s}Shape[1] + col + ${h};\n        vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index);\n        return sampleTexture(${s}, uv);\n      }\n    `;return`\n  float ${r}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${n[1]} + col + ${h};\n    vec2 uv = uvFromFlat(${u}, ${c}, index);\n    return sampleTexture(${s}, uv);\n  }\n`}(e,t);case 3:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=n[1]*n[2],i=n[2],{newShape:o,keptDims:l}=v(n),u=o;if(u.length<n.length){const n=["row","col","depth"];return`\n        ${b_(E_(e,u),t)}\n        float ${r}(int row, int col, int depth) {\n          return ${r}(${A_(n,l)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${a}, ${i}, 1)));\n        ${T_(e)}\n      }\n    `;const c=e.shapeInfo.texShape,h=c[0],p=c[1],d=e.shapeInfo.flatOffset;if(p===a&&null==d)return t?`\n      float ${r}(int row, int col, int depth) {\n        int stride1 = ${s}Shape[2];\n        float texR = float(row);\n        float texC = dot(vec2(col, depth), vec2(stride1, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n        float ${r}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${i}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${p}.0, ${h}.0);\n          return sampleTexture(${s}, uv);\n        }\n      `;if(p===i&&null==d)return t?`\n      float ${r}(int row, int col, int depth) {\n        float texR = dot(vec2(row, col), vec2(${s}Shape[1], 1));\n        float texC = float(depth);\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${n[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${p}.0, ${h}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `;const f=S_(s);if(t)return`\n    float ${r}(int row, int col, int depth) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int stride0 = ${s}Shape[1] * ${s}Shape[2];\n      int stride1 = ${s}Shape[2];\n      int index = row * stride0 + col * stride1 + depth + ${f};\n      vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index);\n      return sampleTexture(${s}, uv);\n    }\n    `;return`\n      float ${r}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${a} + col * ${i} + depth + ${f};\n        vec2 uv = uvFromFlat(${h}, ${p}, index);\n        return sampleTexture(${s}, uv);\n      }\n  `}(e,t);case 4:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=n[3],i=n[2]*a,o=n[1]*i,{newShape:l,keptDims:u}=v(n);if(l.length<n.length){const n=["row","col","depth","depth2"];return`\n      ${b_(E_(e,l),t)}\n      float ${r}(int row, int col, int depth, int depth2) {\n        return ${r}(${A_(n,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${o}, ${i}, ${a}, 1)));\n        ${T_(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1],f=`int stride2 = ${s}Shape[3];`,m=`int stride1 = ${s}Shape[2] * stride2;`,g=`int stride0 = ${s}Shape[1] * stride1;`;if(d===o&&null==c)return t?`\n      float ${r}(int row, int col, int depth, int depth2) {\n        ${f}\n        ${m}\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(stride1, stride2, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${i}, ${a}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${s}, uv);\n      }\n    `;if(d===a&&null==c)return t?`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${s}Shape[1] * ${s}Shape[2], ${s}Shape[2], 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${n[1]*n[2]}, ${n[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${s}, uv);\n      }\n    `;const y=S_(s);if(t)return`\n    float ${r}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      ${f}\n      ${m}\n      ${g}\n      int index = row * stride0 + col * stride1 +\n          depth * stride2 + depth2;\n      vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index + ${y});\n      return sampleTexture(${s}, uv);\n    }\n  `;return`\n    float ${r}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} +\n          depth * ${a} + depth2;\n      vec2 uv = uvFromFlat(${p}, ${d}, index + ${y});\n      return sampleTexture(${s}, uv);\n    }\n  `}(e,t);case 5:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[4],a=t[3]*r,i=t[2]*a,o=t[1]*i,{newShape:l,keptDims:u}=v(t);if(l.length<t.length){const t=["row","col","depth","depth2","depth3"];return`\n      ${b_(E_(e,l))}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${A_(t,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${T_(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=S_(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=v(t);if(r.length<t.length){const t=["row","col","depth","depth2","depth3","depth4"];return`\n      ${b_(E_(e,r))}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${A_(t,a)});\n      }\n    `}const i=t[5],o=t[4]*i,l=t[3]*o,u=t[2]*l,c=t[1]*u;if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${T_(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=S_(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);default:throw new Error(`${n.length}-D input sampling is not yet supported`)}}function x_(e,t){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=c_();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=c_();if(t)return`\n    vec4 ${s}(int index) {\n      ivec2 packedTexShape = ivec2(ceil(float(${n}TexShape[0]) / 2.0), ceil(float(${n}TexShape[1]) / 2.0));\n      vec2 uv = packedUVfrom1D(\n        packedTexShape[0], packedTexShape[1], index);\n      return ${a.texture2D}(${n}, uv);\n    }\n  `;const i=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];return`\n    vec4 ${s}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${i[0]}, ${i[1]}, index);\n      return ${a.texture2D}(${n}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=a[0],o=a[1],l=c_();if(null!=a&&f(n,a))return t?`\n      vec4 ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n\n        return ${l.texture2D}(${s}, uv);\n      }\n    `:`\n      vec4 ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${o}.0, ${i}.0);\n\n        return ${l.texture2D}(${s}, uv);\n      }\n    `;if(t)return`\n    vec4 ${r}(int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${s}TexShape[0]) / 2.0), ceil(float(${s}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${s}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom2D(valuesPerRow, packedTexShape[0], packedTexShape[1], row, col);\n      return ${l.texture2D}(${s}, uv);\n    }\n  `;const u=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],c=Math.ceil(n[1]/2);return`\n    vec4 ${r}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${c}, ${u[0]}, ${u[1]}, row, col);\n      return ${l.texture2D}(${s}, uv);\n    }\n  `}(e,t);case 3:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)];if(1===n[0]){const s=[1,2],a=["b","row","col"];return`\n        ${x_(E_(e,n.slice(1)),t)}\n        vec4 ${r}(int b, int row, int col) {\n          return ${r}(${A_(a,s)});\n        }\n      `}const o=c_();if(t)return`\n    vec4 ${r}(int b, int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${s}TexShape[0]) / 2.0), ceil(float(${s}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${s}Shape[2]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${s}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom3D(\n        packedTexShape[0], packedTexShape[1], texelsInBatch, valuesPerRow, b, row, col);\n      return ${o.texture2D}(${s}, uv);\n    }\n  `;const l=i[0],u=i[1],c=Math.ceil(n[2]/2),h=c*Math.ceil(n[1]/2);return`\n    vec4 ${r}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${l}, ${u}, ${h}, ${c}, b, row, col);\n      return ${o.texture2D}(${s}, uv);\n    }\n  `}(e,t);default:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=c_();if(t)return`\n    vec4 ${s}(int b2, int b, int row, int col) {\n      int valuesPerRow = int(ceil(float(${n}Shape[3]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${n}Shape[2]) / 2.0));\n      int index = b * texelsInBatch + (row / 2) * valuesPerRow + (col / 2);\n      texelsInBatch *= ${n}Shape[1];\n      index = b2 * texelsInBatch + index;\n      ivec2 packedTexShape = ivec2(ceil(float(${n}TexShape[0]) / 2.0), ceil(float(${n}TexShape[1]) / 2.0));\n      int texR = index / packedTexShape[1];\n      int texC = index - texR * packedTexShape[1];\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(packedTexShape[1], packedTexShape[0]); return ${r.texture2D}(${n}, uv);\n    }\n  `;const a=e.shapeInfo.logicalShape,i=a.length,o=e.shapeInfo.texShape,l=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)],u=l[0],c=l[1],h=Math.ceil(a[i-1]/2);let p=h*Math.ceil(a[i-2]/2),d="int b, int row, int col",f=`b * ${p} + (row / 2) * ${h} + (col / 2)`;for(let e=2;e<i-1;e++)d=`int b${e}, `+d,p*=a[i-e-1],f=`b${e} * ${p} + `+f;return`\n    vec4 ${s}(${d}) {\n      int index = ${f};\n      int texR = index / ${c};\n      int texC = index - texR * ${c};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${c}, ${u});\n      return ${r.texture2D}(${n}, uv);\n    }\n  `}(e,t)}}const w_="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",v_="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",k_="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",N_="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function I_(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function S_(e){return`offset${e}`}function T_(e){const t=e.name,n=p(e.shapeInfo.logicalShape);return n<2?`return ${t};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function C_(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function $_(e,t,n){const{newShape:s,keptDims:r}=v(t),a=t.length,i=e&&3===a&&1===t[0],o=i?t.slice(1):s,l=!e&&a>1&&!f(t,n)&&s.length<a||i;return{useSqueezeShape:l,uniformShape:l?o:t,keptDims:r}}function E_(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function A_(e,t){return t.map((t=>e[t])).join(", ")}function R_(e,t,n){const s=[],r=[];let a,i,o,l=null,u=null;u=e.getUniformLocation(n,"NAN",!1),1===K().getNumber("WEBGL_VERSION")&&(l=e.getUniformLocation(n,"INFINITY",!1));const c=!1;for(const r of t.variableNames){const a={name:r,uniform:e.getUniformLocation(n,r,c),offset:e.getUniformLocation(n,`offset${r}`,c)};t.enableShapeUniforms&&(a.shape=e.getUniformLocation(n,`${r}Shape`,c),a.texShape=e.getUniformLocation(n,`${r}TexShape`,c)),s.push(a)}if(t.enableShapeUniforms&&(a=e.getUniformLocation(n,"outShape",c),o=e.getUniformLocation(n,"outShapeStrides",c),i=e.getUniformLocation(n,"outTexShape",c)),t.customUniforms)for(const s of t.customUniforms)r.push(e.getUniformLocation(n,s.name,c));return{variablesLocations:s,customUniformLocations:r,infLoc:l,nanLoc:u,outShapeLocation:a,outShapeStridesLocation:o,outTexShapeLocation:i}}function __(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach(((e,n)=>{const s=e.logicalShape,r=t[n],a=r.shape;if(!f(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(e.isUniform&&r.isUniform)return;const i=e.texShape,o=r.isUniform?null:r.texData.texShape;if(!f(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)}))}function F_(e){return K().getBool("WEBGL_USE_SHAPES_UNIFORMS")&&e<=4}class D_{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=cR.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=c_();this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?p_(["r","c","d"],e):h_(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${t.output} = result;\n      }\n    `}}class O_{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=cR.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=c_();this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?p_(["r","c","d"],e):h_(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${t.output} = result;\n      }\n    `}}class M_{constructor(e){this.variableNames=["A"],this.outTexUsage=hR.DOWNLOAD;const t=c_();this.outputShape=e,this.userCode=`\n      ${m_}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class L_{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=hR.DOWNLOAD;const t=c_();this.outputShape=e,this.userCode=`\n      ${m_}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}const z_={R:0,G:1,B:2,A:3};class P_{constructor(e,t=!1,n="RGBA"){this.variableNames=["A"],this.customUniforms=[{name:"texShape",type:"ivec2"}];const s=c_();this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length);let r="result";t&&(r="floor(result * 255. + 0.5)");let a="";for(let e=0;e<n.length;e++){const t=n[e];a+=`\n          if(offset == ${e}) {\n            result = values[${z_[t]}];\n          }`}this.userCode=`\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":f_(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int flatIndex = getFlatIndex(coords);\n        float result = 0.;\n        int offset = imod(flatIndex, ${n.length});\n\n        flatIndex = idiv(flatIndex, ${n.length}, 1.);\n\n        int r = flatIndex / texShape[1];\n        if (r < texShape[0]) {\n          int c = imod(flatIndex, texShape[1]);\n          vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n          vec4 values = ${s.texture2D}(A, uv);\n          ${a}\n        }\n        ${s.output} = vec4(${r}, 0., 0., 0.);\n      }\n    `}}class B_{constructor(e,t=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.customUniforms=[{name:"texShape",type:"ivec2"}];const n=c_();this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length);let s="",r="result";t&&(r="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let r=0;r<=1;r++){const a=2*t+r;s+=`\n          localCoords = coords;\n          if(localCoords[2] + ${r} < ${this.enableShapeUniforms?"outShape[2]":`${e[2]}`}) {\n          localCoords[2] += ${r};\n          if (localCoords[1] + ${t} < ${this.enableShapeUniforms?"outShape[1]":`${e[1]}`}) {\n            localCoords[1] += ${t};\n\n            flatIndex = getFlatIndex(localCoords);\n            offset = imod(flatIndex, 4);\n\n            flatIndex = idiv(flatIndex, 4, 1.);\n\n            int r = flatIndex / texShape[1];\n            int c = imod(flatIndex, texShape[1]);\n            vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n            values = ${n.texture2D}(A, uv);\n\n            if (offset == 0) {\n              result[${a}] = values[0];\n            } else if (offset == 1) {\n              result[${a}] = values[1];\n            } else if (offset == 2) {\n              result[${a}] = values[2];\n            } else {\n              result[${a}] = values[3];\n            }\n          }\n        }\n        `}this.userCode=`\n        ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":f_(e)}\n\n        void main() {\n          ivec3 coords = getOutputCoords();\n\n          vec4 result = vec4(0.);\n          int flatIndex, r, c, offset;\n          ivec3 localCoords;\n          vec2 uv;\n          vec4 values;\n\n          ${s}\n\n          ${n.output} = ${r};\n        }\n    `}}function W_(e){const t=c_();return vR(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function V_(e){return $R(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function U_(e){return ER(e,new Uint16Array([0,1,2,2,1,3]))}function G_(e,t,n,s,r,a){RR(t,n);const i=AR(e),o=e.TEXTURE_2D;return yR(e,(()=>e.bindTexture(o,i))),yR(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE))),yR(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE))),yR(e,(()=>e.texParameteri(o,e.TEXTURE_MIN_FILTER,e.NEAREST))),yR(e,(()=>e.texParameteri(o,e.TEXTURE_MAG_FILTER,e.NEAREST))),1===K().getNumber("WEBGL_VERSION")?yR(e,(()=>e.texImage2D(o,0,s,t,n,0,r,a,null))):yR(e,(()=>e.texStorage2D(o,1,s,t,n))),yR(e,(()=>e.bindTexture(e.TEXTURE_2D,null))),{texture:i,texShape:[n,t]}}function H_(e){return e.internalFormatFloat}function j_(e,t,n,s){const[r,a]=dR(t,n);return G_(e,r,a,H_(s),s.textureFormatFloat,e.FLOAT)}function q_(e){return e.internalFormatHalfFloat}function K_(e,t,n,s){const[r,a]=dR(t,n);return G_(e,r,a,q_(s),s.textureFormatFloat,s.textureTypeHalfFloat)}function X_(e){return e.downloadTextureFormat}function Y_(e,t,n,s){const[r,a]=dR(t,n);return G_(e,r,a,X_(s),e.RGBA,e.UNSIGNED_BYTE)}function Z_(e){return e.internalFormatPackedFloat}function J_(e,t,n,s){const[r,a]=mR(t,n);return G_(e,r,a,Z_(s),e.RGBA,e.FLOAT)}function Q_(e){return e.internalFormatPackedHalfFloat}function eF(e,t,n,s){const[r,a]=mR(t,n);return G_(e,r,a,Q_(s),e.RGBA,s.textureTypeHalfFloat)}function tF(e,t,n){yR(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n)));return FR(e,t,"clipSpacePos",n,3,20,0)&&FR(e,t,"uv",n,2,20,12)}function nF(e,t,n,s,r,a){let i,o,l;yR(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=e.UNSIGNED_BYTE,l=e.RGBA):(i=new Float32Array(n*s*4),o=e.FLOAT,l=a.internalFormatPackedFloat),i.set(r),2===K().getNumber("WEBGL_VERSION")?yR(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,n,s,e.RGBA,o,i))):yR(e,(()=>e.texImage2D(e.TEXTURE_2D,0,l,n,s,0,e.RGBA,o,i))),yR(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}function sF(e,t,n){yR(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),n.data instanceof Uint8Array?2===K().getNumber("WEBGL_VERSION")?yR(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,n.width,n.height,e.RGBA,e.UNSIGNED_BYTE,n.data))):yR(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data))):2===K().getNumber("WEBGL_VERSION")?yR(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,n))):yR(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n))),yR(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}function rF(e,t,n,s){const r=e.createBuffer();yR(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r)));const a=16*t*n;return yR(e,(()=>e.bufferData(e.PIXEL_PACK_BUFFER,a,e.STREAM_READ))),yR(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0))),yR(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null))),r}function aF(e,t,n){const s=e,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,t),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}function iF(e,t,n,s){const[r,a]=dR(t,n),i=new Uint8Array(t*n*4);return yR(e,(()=>e.readPixels(0,0,r,a,s.downloadTextureFormat,e.UNSIGNED_BYTE,i))),new Float32Array(i.buffer)}function oF(e,t,n,s,r,a,i,o){const l=e,u=new Float32Array(function(e,t){const[n,s]=mR(e,t);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,t),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}function lF(e,t,n){const s=new Float32Array(t*n*4);return yR(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,s))),s}var uF=Object.freeze({__proto__:null,bindVertexProgramAttributeStreams:tF,createBufferFromOutputTexture:rF,createFloat16MatrixTexture:K_,createFloat16PackedMatrixTexture:eF,createFloat32MatrixTexture:j_,createIndexBuffer:U_,createPackedMatrixTexture:J_,createUnsignedBytesMatrixTexture:Y_,createVertexBuffer:V_,createVertexShader:W_,downloadByteEncodedFloatMatrixFromOutputTexture:iF,downloadFloat32MatrixFromBuffer:aF,downloadMatrixFromPackedOutputTexture:lF,downloadPackedMatrixFromBuffer:oF,getInternalFormatForFloat16MatrixTexture:q_,getInternalFormatForFloat16PackedMatrixTexture:Q_,getInternalFormatForFloat32MatrixTexture:H_,getInternalFormatForPackedMatrixTexture:Z_,getInternalFormatForUnsignedBytesMatrixTexture:X_,uploadDenseMatrixToTexture:nF,uploadPixelDataToTexture:sF});class cF{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.itemsToPoll=[];const t=K().getNumber("WEBGL_VERSION");if(null!=e?(this.gl=e,lR(t,e)):this.gl=uR(t),e=this.gl,2===K().getNumber("WEBGL_VERSION")){const t=e;this.createVertexArray=()=>yR(t,(()=>t.createVertexArray())),this.bindVertexArray=e=>yR(t,(()=>t.bindVertexArray(e))),this.deleteVertexArray=e=>yR(t,(()=>t.deleteVertexArray(e))),this.getVertexArray=()=>yR(t,(()=>t.getParameter(t.VERTEX_ARRAY_BINDING)))}else if(null!=e){const t=e.getExtension("OES_vertex_array_object");if(null==t)throw new Error("All WebGL1 implementations are expected to offer OES_vertex_array_object.");this.createVertexArray=()=>yR(e,(()=>t.createVertexArrayOES())),this.bindVertexArray=n=>yR(e,(()=>t.bindVertexArrayOES(n))),this.deleteVertexArray=n=>yR(e,(()=>t.deleteVertexArrayOES(n))),this.getVertexArray=()=>yR(e,(()=>e.getParameter(t.VERTEX_ARRAY_BINDING_OES)))}let n="WEBGL_color_buffer_float";const s="EXT_color_buffer_half_float";if(this.parallelCompilationExtension=this.gl.getExtension("KHR_parallel_shader_compile"),1===K().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=wR(this.gl,e),t_(this.gl,t))this.textureHalfFloatExtension=wR(this.gl,t);else if(K().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),t_(this.gl,s))this.colorBufferHalfFloatExtension=wR(this.gl,s);else if(K().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",t_(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!t_(this.gl,s))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension(s)}this.vertexBuffer=V_(this.gl),this.indexBuffer=U_(this.gl),this.framebuffer=_R(this.gl),this.textureConfig=gR(this.gl,this.textureHalfFloatExtension)}get debug(){return K().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;yR(e,(()=>e.finish())),yR(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),yR(e,(()=>e.deleteFramebuffer(this.framebuffer))),yR(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,null))),yR(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null))),yR(e,(()=>e.deleteBuffer(this.indexBuffer))),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),j_(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),K_(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),Y_(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),sF(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,s){this.throwIfDisposed(),nF(this.gl,e,t,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),eF(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),J_(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(PR(this.gl,this.framebuffer),this.outputTexture=null),yR(this.gl,(()=>this.gl.deleteTexture(e)))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>iF(this.gl,t,n,this.textureConfig)))}downloadPackedMatrixFromBuffer(e,t,n,s,r,a){return oF(this.gl,e,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return aF(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const s=rF(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,n;if(K().getBool("WEBGL_FENCE_API_ENABLED")){const s=e,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),n=()=>{const e=s.clientWaitSync(r,0,0);return e===s.ALREADY_SIGNALED||e===s.CONDITION_SATISFIED},t=r}else K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(t,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:t,isFencePassed:n}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>lF(this.gl,t,n)))}createProgram(e){this.throwIfDisposed();const t=this.gl;null==this.vertexShader&&(this.vertexShader=W_(t));const n=SR(t);yR(t,(()=>t.attachShader(n,this.vertexShader))),yR(t,(()=>t.attachShader(n,e))),TR(t,n);const s=Object.assign(n,{vao:this.createVertexArray()});return this.debug&&CR(t,s),s}buildVao(e){this.setProgram(e),this.bindVertexArray(e.vao);const t=this.gl;yR(t,(()=>t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,this.indexBuffer))),tF(t,e,this.vertexBuffer)}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&(yR(this.gl,(()=>this.gl.deleteProgram(e))),this.deleteVertexArray(e.vao))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&CR(this.gl,this.program),yR(this.gl,(()=>this.gl.useProgram(e)))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?OR(this.gl,e,t):MR(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),yR(this.gl,(()=>this.gl.getAttribLocation(e,t)))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),LR(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[s,r]=mR(t,n);this.setOutputMatrixTextureDriver(e,s,r)}setOutputMatrixWriteRegion(e,t,n,s){this.setOutputMatrixWriteRegionDriver(n,e,s,t)}setOutputPackedMatrixWriteRegion(e,t,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&CR(this.gl,this.program),BR(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;if(this.debug){const e=this.getVertexArray();console.assert(e===this.program.vao,"VAO changed between setProgram and executeProgram!"),this.debugValidate()}yR(e,(()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),yR(this.gl,(()=>this.gl.finish()))}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=wR(this.gl,2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await b((()=>this.disposed||this.isQueryAvailable(e,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")))),this.getQueryTime(e,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise((t=>{this.addItemToPoll((()=>e.isFencePassed()),(()=>t()))}))}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map((e=>e.isDoneFn)));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){if(this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1)return;let n;"setTimeoutCustom"in K().platform&&(n=K().platform.setTimeoutCustom.bind(K().platform)),b((()=>(this.pollItems(),0===this.itemsToPoll.length)),(()=>0),null,n)}bindTextureToFrameBuffer(e){this.throwIfDisposed(),zR(this.gl,e,this.framebuffer),this.debug&&BR(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(zR(this.gl,this.outputTexture,this.framebuffer),this.debug&&BR(this.gl)):PR(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const s=this.gl;zR(s,e,this.framebuffer),this.debug&&BR(s),this.outputTexture=e,yR(s,(()=>s.viewport(0,0,t,n))),yR(s,(()=>s.scissor(0,0,t,n)))}setOutputMatrixWriteRegionDriver(e,t,n,s){this.throwIfDisposed(),yR(this.gl,(()=>this.gl.scissor(e,t,n,s)))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{addImpl:hF,bincountImpl:pF,bincountReduceImpl:dF,bitwiseAndImpl:fF,castImpl:mF,ceilImpl:gF,concatImpl:yF,equalImpl:bF,expImpl:xF,expm1Impl:wF,floorImpl:vF,gatherNdImpl:kF,gatherV2Impl:NF,greaterImpl:IF,greaterEqualImpl:SF,lessImpl:TF,lessEqualImpl:CF,linSpaceImpl:$F,logImpl:EF,maxImpl:AF,maximumImpl:RF,minimumImpl:_F,multiplyImpl:FF,negImpl:DF,notEqualImpl:OF,prodImpl:MF,raggedGatherImpl:LF,raggedRangeImpl:zF,raggedTensorToTensorImpl:PF,rangeImpl:BF,rsqrtImpl:WF,scatterImpl:VF,sigmoidImpl:UF,simpleAbsImpl:GF,sliceImpl:HF,sparseFillEmptyRowsImpl:jF,sparseReshapeImpl:qF,sparseSegmentReductionImpl:KF,sqrtImpl:XF,staticRegexReplaceImpl:YF,stridedSliceImpl:ZF,stringNGramsImpl:JF,stringSplitImpl:QF,stringToHashBucketFastImpl:eD,subImpl:tD,tileImpl:nD,topKImpl:sD,transposeImpl:rD,uniqueImpl:aD}=DC;function iD(e,t){return["x","y","z","w","u","v"].slice(0,t).map((t=>`${e}.${t}`))}function oD(e,t){return 1===t?[e]:iD(e,t)}class lD{constructor(e){if(this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e,this.rank=e.length,this.enableShapeUniforms=F_(this.outputShape.length),0===this.rank)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const e=oD("rc",this.rank),t=C_(this.rank),n=this.getOutOfBoundsCondition(e),s=this.getSetup(e),r=this.getOutput(e);this.userCode=`\n        void main() {\n          ${t} rc = getOutputCoords();\n\n          if(${n}) {\n            setOutput(vec4(0));\n          } else {\n            ${s}\n\n            setOutput(vec4(${r}));\n          }\n        }\n      `}}getSourceCoordsArr(e){const t=[];for(let n=0;n<=1;n++)for(let s=0;s<=1;s++){let r=`${0===n?"r":"rp1"}, ${0===s?"c":"cp1"}`;for(let t=2;t<this.rank;t++)r=`${e[e.length-1-t]},`+r;t.push(r)}return t}getOutOfBoundsCondition(e){if(1===this.rank)return`rc > ${this.enableShapeUniforms?"outShape":this.outputShape[0]}`;let t="";for(let n=this.rank-2;n<this.rank;n++)t+=`${e[n]} >= ${this.enableShapeUniforms?`outShape[${n}]`:this.outputShape[n]}`,n<this.rank-1&&(t+="||");return t}getSetup(e){if(1===this.rank)return"";const t=e.slice(-2),n=this.enableShapeUniforms?`outShape[${this.rank} - 1]`:this.outputShape[this.rank-1],s=this.enableShapeUniforms?`outShape[${this.rank} - 2]`:this.outputShape[this.rank-2];return`\n      int r = ${t[0]};\n      int c = ${t[1]};\n      int rp1 = r + 1;\n      int cp1 = c + 1;\n\n      bool cEdge = cp1 >= ${n};\n      bool rEdge = rp1 >= ${s};\n    `}getOutput(e){const t=this.getSourceCoordsArr(e);if(1===this.rank){return`getA(rc), (rc + 1 >= ${this.enableShapeUniforms?"outShape":this.outputShape[0]} ? 0. : getA(rc + 1)), 0, 0`}return`getA(${t[0]}),\n            cEdge ? 0. : getA(${t[1]}),\n            rEdge ? 0. : getA(${t[2]}),\n            rEdge || cEdge ? 0. : getA(${t[3]})`}}class uD{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec3"}],this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length);let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var s,r;this.userCode=`\n      ${s=t,r=this.enableShapeUniforms,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${r?d_(["r","c","d"],"inputShape"):h_(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":f_(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${this.enableShapeUniforms?"outShape[1]":e[1]};\n        int cols = ${this.enableShapeUniforms?"outShape[2]":e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class cD{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.usedTextures={},this.logEnabled=!1}acquireTexture(e,t,n){const s=pD(t,n),r=dD(e,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=hD(e,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const e=this.freeTextures[r].pop();return this.usedTextures[r].push(e),e}let i;return s===pR.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):s===pR.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):s===pR.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):s===pR.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):s===pR.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(e,t,n,s){if(null==this.freeTextures)return;const r=pD(n,s),a=dD(t,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=hD(t,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=K().getNumber("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(e.texture),this._numBytesAllocated-=i):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l&&l.indexOf(e);if(null==u||u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l[u]=l[l.length-1],l.pop(),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e.texture)}));for(const e in this.usedTextures)this.usedTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e.texture)}));this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function hD(e,t,n,s,r){const a=function(e,t){switch(e){case pR.PACKED_2X2_FLOAT32:return Z_(t);case pR.PACKED_2X2_FLOAT16:return Q_(t);case pR.UNPACKED_FLOAT32:return H_(t);case pR.UNPACKED_FLOAT16:return q_(t);case pR.PACKED_4X1_UNSIGNED_BYTE:return X_(t);default:throw new Error(`Unknown physical texture type ${e}`)}}(t,s);let i;if(r){const[t,n]=mR(e[0],e[1]);i=t*n}else{const[t,n]=dR(e[0],e[1]);i=t*n}const o=function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;if(t===n.RGBA8)return 4;throw new Error(`Unknown internal format ${t}`)}(n,a);return i*o}function pD(e,t){if(e===hR.UPLOAD)return pR.PACKED_2X2_FLOAT32;if(e===hR.RENDER||null==e)return function(e){return K().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?pR.PACKED_2X2_FLOAT32:pR.UNPACKED_FLOAT32:e?pR.PACKED_2X2_FLOAT16:pR.UNPACKED_FLOAT16}(t);if(e===hR.DOWNLOAD||e===hR.PIXELS)return pR.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function dD(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class fD{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length),this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const mD="return x;";class gD{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length),this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class yD{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length);const t=e.length,n=oD("rc",t),s=C_(t),r=function(e,t){if(1===e)return"rc";let n="";for(let s=0;s<e;s++)n+=t[s],s<e-1&&(n+=",");return n}(t,n),a=n.slice(-2),i=t<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const bD=Oh,xD={};const wD=K().getNumber("CPU_HANDOFF_SIZE_THRESHOLD");class vD extends n{nextDataId(){return vD.nextDataId++}constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.pendingDeletes=0,this.disposed=!1,!K().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");let n;if(null!=e){if(e instanceof cF)n=e;else{const t=uR(K().getNumber("WEBGL_VERSION"),e);n=new cF(t)}this.binaryCache={},this.gpgpuCreatedLocally=!1}else{const e=uR(K().getNumber("WEBGL_VERSION"));n=new cF(e),this.binaryCache=((s=K().getNumber("WEBGL_VERSION"))in xD||(xD[s]={}),xD[s]),this.gpgpuCreatedLocally=!0}var s;this.gpgpu=n,this.canvas=this.gpgpu.gl.canvas,this.textureManager=new cD(this.gpgpu),this.numMBBeforeWarning=null==K().global.screen?1024:K().global.screen.height*K().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new t(this,_a())}numDataIds(){return this.texData.numDataIds()-this.pendingDeletes}writeTexture(e,t,n,s,r,a){const i=this.makeTensorInfo(t,n),o=this.texData.get(i.dataId);o.isPacked=!1,o.texture={texture:e,texShape:[s,r]},o.texShape=[s,r];const l=jR(t),u=new P_(l,!1,a),c=this.runWebGLProgram(u,[i],n,[[s,r]]);return c.shape=t,o.texture=null,this.disposeIntermediateTensorInfo(i),c.dataId}write(e,t,n){if((K().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||K().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===n&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={id:this.nextDataId()};return this.texData.set(s,{shape:t,dtype:n,values:e,usage:hR.UPLOAD,refCount:1}),s}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,n,s,r){if(K().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:n,dtype:s,values:t,usage:hR.UPLOAD,refCount:r})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(e){const t=this.texData.get(e),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=t;if(null!=a){let t;t=o?new gD(i,mD):new fD(i,mD);const n=this.runWebGLProgram(t,[{dataId:e,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=wr()),"complex64"===s){c=Df(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=wr()-u),this.convertAndCacheOnCPU(e,c)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise((e=>t.push(e)))}const t=this.texData.get(e),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=t;if(null!=r){let t;t=o?new gD(s,mD):new fD(s,mD);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if(K().getBool("DEBUG")&&!K().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===K().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&K().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(t.texture.texture,...fR(s))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=Df(e[0],e[1])}else if(null==c)u=this.getValuesFromTexture(e);else{const e=p(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,e)}if(null!=l&&this.disposeIntermediateTensorInfo(l),null!=c){const e=this.gpgpu.gl;yR(e,(()=>e.deleteBuffer(c)))}const h=this.convertAndCacheOnCPU(e,u),d=this.pendingRead.get(e);return this.pendingRead.delete(e),d.forEach((e=>e(h))),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e)&&_a().removeDataId(e,this),this.pendingDeletes--),h}readToGPU(e,t={}){const n=this.texData.get(e),{values:s,shape:r,slice:a,dtype:i,isPacked:o,texture:l}=n;if("complex64"===i)throw new Error("Does not support reading texture for complex64 dtype.");if(null!=a){let n;n=o?new gD(r,mD):new fD(r,mD);const s=this.runWebGLProgram(n,[{dataId:e,shape:r,dtype:i}],i),a=this.readToGPU(s,t);return this.disposeIntermediateTensorInfo(s),a}if(null==l)throw null!=s?new Error("Data is not on GPU but on CPU."):new Error("There is no data on GPU or CPU.");const u=this.decode(e,t.customTexShape),c=_a().makeTensorFromTensorInfo(u),h=this.texData.get(u.dataId);return Object.assign({tensorRef:c},h.texture)}bufferSync(e){const t=this.readSync(e.dataId);if("string"===e.dtype)try{const n=t.map((e=>Nr(e)));return zi(e.shape,e.dtype,n)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return zi(e.shape,e.dtype,t)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const n=e[t];if(!bR(n)){if(K().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:n,isPacked:s}=this.texData.get(e),r=p(t);if(K().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture.texture,...fR(t)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=K().getBool("WEBGL_PACK")&&!0===s,i=a?jR(t):t,o=a?new L_(i):new M_(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:e}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}timerAvailable(){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}time(e){const t=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,e();const r=Sr(this.activeTimers.map((e=>e.query))).filter((e=>null!=e)),a=Sr(this.activeTimers.map((e=>e.name))).filter((e=>null!=e));this.activeTimers=t,s&&(this.programTimersStack=null);const i={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};return(async()=>{if(K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(r);i.kernelMs=l(e),i.getExtraProfileInfo=()=>e.map(((e,t)=>({name:a[t],ms:e}))).map((e=>`${e.name}: ${e.ms}`)).join(", ")}else i.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,i})()}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:wr(),endMs:null}}endTimer(e){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=wr(),e)}async getQueryTime(e){if(K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,t=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(t?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!t&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:n}=this.texData.get(e);return null!=n&&(this.disposeData(n.real.dataId,t),this.disposeData(n.imag.dataId,t)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:t,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(e),o=i&&i.origDataId||e,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=t&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(t,s,r,a)));const u=this.texData.get(e);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture.texture}getDataInfo(e){return this.texData.get(e)}shouldExecuteOnCPU(e,t=wD){return K().getBool("WEBGL_CPU_FORWARD")&&e.every((e=>null==this.texData.get(e.dataId).texture&&p(e.shape)<t))}getGPGPUContext(){return this.gpgpu}where(e){bs("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return bD(e.shape,t)}packedUnaryOp(e,t,n){const s=new gD(e.shape,t),r=this.compileAndRun(s,[e],n);return _a().makeTensorFromTensorInfo(r)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=GF(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(K().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,"return abs(x);",e.dtype);const t=new fD(e.shape,"return abs(x);"),n=this.compileAndRun(t,[e]);return _a().makeTensorFromTensorInfo(n)}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map((e=>kr(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return this.texData.get(s).usage=null,{dataId:s,shape:e,dtype:t}}makeOutput(e,t,n){return _a().makeTensorFromTensorInfo(this.makeTensorInfo(e,t,n),this)}unpackTensor(e){const t=new yD(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new lD(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[GR(e.shape),...HR(e.shape)],s={dtype:e.dtype,shape:n,dataId:e.dataId},r=[GR(t),...HR(t)],a=new uD(r,n),i=[n],o=this.runWebGLProgram(a,[s],e.dtype,i,!0);return{dataId:o.dataId,shape:t,dtype:o.dtype}}decode(e,t){const n=this.texData.get(e),{isPacked:s,shape:r,dtype:a}=n;if(null!=t){u(p(r)<=t[0]*t[1]*4,(()=>"customTexShape is too small. Row * Column * 4 should be equal or larger than the size of the tensor data."))}const i=jR(r);let o;o=s?new O_(i):new D_(i);const l=[null!=t?t:fR(i)];return{dtype:a,shape:r,dataId:this.runWebGLProgram(o,[{shape:i,dtype:a,dataId:e}],a,l,!0,t).dataId}}runWebGLProgram(e,t,n,s,r=!1,a){const i=this.makeTensorInfo(e.outputShape,n),o=this.texData.get(i.dataId);if(e.packedOutput&&(o.isPacked=!0),e.outPackingScheme===cR.DENSE){const t=null!=a?a:fR(e.outputShape);o.texShape=t.map((e=>2*e))}if(null!=e.outTexUsage&&(o.usage=e.outTexUsage),0===p(i.shape))return o.values=k(i.dtype,0),i;const l=[],u=t.map((t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(t.dataId);if(null==n.texture){if(!e.packedInputs&&p(t.shape)<=K().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:n.values};e.packedInputs&&(n.isPacked=!0,n.shape=t.shape)}if(this.uploadToGPU(t.dataId),!!n.isPacked!=!!e.packedInputs)t=n.isPacked?this.unpackTensor(t):this.packTensor(t),l.push(t),n=this.texData.get(t.dataId);else if(n.isPacked&&!XR(n.shape,t.shape)){const e=t,s=t.shape;t.shape=n.shape,t=this.packedReshape(t,s),l.push(t),n=this.texData.get(t.dataId),e.shape=s}return{shape:t.shape,texData:n,isUniform:!1}}));this.uploadToGPU(i.dataId);const c={shape:i.shape,texData:o,isUniform:!1},h=function(e,t,n){let s="";t.concat(n).forEach((t=>{const r=null!=t.texData&&null!=t.texData.slice&&t.texData.slice.flatOffset>0;if(e.enableShapeUniforms&&!t.isUniform){const a=t.texData.texShape,{useSqueezeShape:i,uniformShape:o,keptDims:l}=$_(e.packedInputs,t.shape,a);let u="",c="",h="";if(1===o.length&&e.packedInputs){const e=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)];u=`${e[0]>1}_${e[1]>1}`}else if(2!==o.length||e.packedInputs){if(o.length>2&&!e.packedInputs){const e=O(o);h=`${e[0]===a[1]}_${e[e.length-1]===a[1]}`}}else c=`${o[0]>1}_${o[1]>1}`;const d=t.shape.length,m=2===o.length&&f(t.shape,a),g=1===p(t.shape),y=ll(t.shape,n.shape),b=!e.packedInputs&&d===n.shape.length&&f(a,n.texData.texShape),x=e.packedInputs||o.length>2?"":`${a[0]>1}_${a[1]>1}`;s+=`${d}_${b}_${i?l:""}_${o.length}_${g}_${y}_${m}_${u}_${c}_${h}_${x}_${r}`}else{const e=t.isUniform?"uniform":t.texData.texShape;s+=`${t.shape}_${e}_${r}`}}));const r=e.userCode;let a=e.constructor.name;return a+="_"+s+"_"+r+`${K().getNumber("WEBGL_VERSION")}`,a}(e,u,c),d=this.getAndSaveBinary(h,(()=>function(e,t,n,s){const r=n.map(((e,n)=>{const s={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(s.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:s}})),a=r.map((e=>e.shapeInfo)),i={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},o=y_(r,i,t),l=kR(e.gl,o),u=e.createProgram(l);return K().get("ENGINE_COMPILE_ONLY")?{program:t,fragmentShader:l,source:o,webGLProgram:u,inShapeInfos:a,outShapeInfo:i,variablesLocations:null,customUniformLocations:null,infLoc:null,nanLoc:null,outShapeLocation:null,outShapeStridesLocation:null,outTexShapeLocation:null}:(e.buildVao(u),Object.assign({program:t,fragmentShader:l,source:o,webGLProgram:u,inShapeInfos:a,outShapeInfo:i},R_(e,t,u)))}(this.gpgpu,e,u,c))),m=null!=this.activeTimers;let g;m&&(g=this.startTimer()),K().get("ENGINE_COMPILE_ONLY")||function(e,t,n,s,r){t.program.enableShapeUniforms||(__(t.inShapeInfos,n),__([t.outShapeInfo],[s]));const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?e.setOutputPackedMatrixTexture(a.texture,i[0],i[1]):e.setOutputMatrixTexture(a.texture,i[0],i[1]),e.setProgram(t.webGLProgram),e.bindVertexArray(t.webGLProgram.vao),1===K().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN);for(let s=0;s<n.length;++s){const r=n[s],{uniform:a,offset:i,shape:o,texShape:l}=t.variablesLocations[s];if(o){const{uniformShape:n}=$_(t.program.packedInputs,r.shape,r.texData.texShape);switch(n.length){case 1:e.gl.uniform1iv(o,new Int32Array(n));break;case 2:e.gl.uniform2iv(o,new Int32Array(n));break;case 3:e.gl.uniform3iv(o,new Int32Array(n));break;case 4:e.gl.uniform4iv(o,new Int32Array(n))}}if(l&&e.gl.uniform2i(l,r.texData.texShape[0],r.texData.texShape[1]),null!=a)if(r.isUniform)if(p(r.shape)<2)e.gl.uniform1f(a,r.uniformValues[0]);else{let t=r.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=r.texData.slice&&null!=i&&e.gl.uniform1i(i,r.texData.slice.flatOffset),e.setInputMatrixTexture(r.texData.texture.texture,a,s)}const o=t.outShapeLocation;if(o)switch(s.shape.length){case 1:e.gl.uniform1iv(o,new Int32Array(s.shape));break;case 2:e.gl.uniform2iv(o,new Int32Array(s.shape));break;case 3:e.gl.uniform3iv(o,new Int32Array(s.shape));break;case 4:e.gl.uniform4iv(o,new Int32Array(s.shape))}if(t.outShapeStridesLocation){const n=O(s.shape);switch(s.shape.length){case 2:e.gl.uniform1iv(t.outShapeStridesLocation,new Int32Array(n));break;case 3:e.gl.uniform2iv(t.outShapeStridesLocation,new Int32Array(n));break;case 4:e.gl.uniform3iv(t.outShapeStridesLocation,new Int32Array(n))}}if(t.outTexShapeLocation&&e.gl.uniform2i(t.outTexShapeLocation,s.texData.texShape[0],s.texData.texShape[1]),t.program.customUniforms&&r)for(let n=0;n<t.program.customUniforms.length;++n){const s=t.program.customUniforms[n],a=t.customUniformLocations[n],i=r[n];if("float"===s.type)e.gl.uniform1fv(a,i);else if("vec2"===s.type)e.gl.uniform2fv(a,i);else if("vec3"===s.type)e.gl.uniform3fv(a,i);else if("vec4"===s.type)e.gl.uniform4fv(a,i);else if("int"===s.type)e.gl.uniform1iv(a,i);else if("ivec2"===s.type)e.gl.uniform2iv(a,i);else if("ivec3"===s.type)e.gl.uniform3iv(a,i);else{if("ivec4"!==s.type)throw Error(`uniform type ${s.type} is not supported yet.`);e.gl.uniform4iv(a,i)}}e.executeProgram()}(this.gpgpu,d,u,c,s),l.forEach((e=>this.disposeIntermediateTensorInfo(e))),m&&(g=this.endTimer(g),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(g)}));const y=K().getNumber("WEBGL_FLUSH_THRESHOLD");if(y>0){const e=wr();e-this.lastGlFlushTime>y&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=e)}if(!K().getBool("WEBGL_LAZILY_UNPACK")&&o.isPacked&&!1===r){const e=this.unpackTensor(i);return this.disposeIntermediateTensorInfo(i),e}return i}compileAndRun(e,t,n,s,r=!1){n=n||t[0].dtype;return this.runWebGLProgram(e,t,n,s,r)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!K().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach((e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]}))}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=Oa((()=>{if(!K().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=K().getBool("DEBUG");K().set("DEBUG",!1);const t=this.abs(_l(1e-8)).dataSync()[0];if(K().set("DEBUG",e),t>0)return 32}return 16}))),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:n,dtype:s,values:r,texture:a,usage:i,isPacked:o}=t;if(null!=a)return;const l=null!=this.activeTimers;let u;l&&(u=wr());let c=t.texShape;if(null==c&&(c=qR(n,o),t.texShape=c),null!=r){const e=jR(n);let a,i=c[1],h=c[0];const p=r instanceof Uint8Array||r instanceof Uint8ClampedArray;!o&&p||([i,h]=mR(c[0],c[1])),a=o?new B_(e,p):new P_(e,p);const d=p?[h,i]:c,f=this.makeTensorInfo(d,s),m=this.texData.get(f.dataId);m.usage=p?hR.PIXELS:hR.UPLOAD,m.texShape=d,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(f.dataId),i,h,r);const g=[[h,i]],y=!0,b=this.runWebGLProgram(a,[f],s,g,y),x=this.texData.get(b.dataId);t.texShape=x.texShape,t.isPacked=x.isPacked,t.usage=x.usage,K().get("ENGINE_COMPILE_ONLY")?this.disposeData(b.dataId):(t.texture=x.texture,t.values=null,this.texData.delete(b.dataId)),this.disposeIntermediateTensorInfo(f),l&&(this.uploadWaitMs+=wr()-u)}else{const e=this.acquireTexture(c,i,s,o);t.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:s}=n;return null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error(`Unknown dtype ${t}`)}(t,s)),n.values}acquireTexture(e,t,n,s){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,t,s)}computeBytes(e,t){return e[0]*e[1]*C(t)}checkCompileCompletion(){for(const[,e]of Object.entries(this.binaryCache))this.checkCompletion_(e)}async checkCompileCompletionAsync(){const e=[];if(this.gpgpu.parallelCompilationExtension){for(const[,t]of Object.entries(this.binaryCache))e.push(this.checkCompletionAsync_(t));return Promise.all(e)}for(const[,t]of Object.entries(this.binaryCache)){const n=new Promise((e=>{try{this.checkCompletion_(t),e(!0)}catch(e){throw e}}));e.push(n)}return Promise.all(e)}async checkCompletionAsync_(e){return this.gpgpu.gl.getProgramParameter(e.webGLProgram,this.gpgpu.parallelCompilationExtension.COMPLETION_STATUS_KHR)?this.checkCompletion_(e):(await bf(),this.checkCompletionAsync_(e))}checkCompletion_(e){if(!1===this.gpgpu.gl.getProgramParameter(e.webGLProgram,this.gpgpu.gl.LINK_STATUS)){if(console.log(this.gpgpu.gl.getProgramInfoLog(e.webGLProgram)),!1===this.gpgpu.gl.getShaderParameter(e.fragmentShader,this.gpgpu.gl.COMPILE_STATUS))throw IR(e.source,this.gpgpu.gl.getShaderInfoLog(e.fragmentShader)),new Error("Failed to compile fragment shader.");throw new Error("Failed to link vertex and fragment shaders.")}return!0}getUniformLocations(){for(const e of Object.values(this.binaryCache)){this.gpgpu.buildVao(e.webGLProgram);const{variablesLocations:t,customUniformLocations:n,infLoc:s,nanLoc:r,outShapeLocation:a,outShapeStridesLocation:i,outTexShapeLocation:o}=R_(this.gpgpu,e.program,e.webGLProgram);e.variablesLocations=t,e.customUniformLocations=n,e.infLoc=s,e.nanLoc=r,e.outShapeLocation=a,e.outShapeStridesLocation=i,e.outTexShapeLocation=o}}createTensorFromGPUData(e,t,n){e.channels=e.channels||"RGBA";const{texture:s,height:r,width:a,channels:i}=e,o=_a().backend;if(!o.gpgpu.gl.isTexture(s))throw new Error("The texture is invalid. Also, please make sure the texture and the TFJS WebGL backend are using the same canvas. If you want to use your own custom canvas, you have to create and use the custom TFJS WebGL backend created from the canvas through 'new tf.MathBackendWebGL(customCanvas)'.");const l=o.writeTexture(s,t,n,r,a,i);return _a().makeTensorFromDataId(l,t,n,o)}}vD.nextDataId=0;const kD="4.22.0";function ND(){K().set("WEBGL_FORCE_F16_TEXTURES",!0)}pa()&&Ha("webgl",(()=>new vD),2);const ID={forceHalfFloat:ND};class SD{constructor(e,t,n){this.variableNames=["A","B"],this.outputShape=cl(t,n),this.enableShapeUniforms=F_(this.outputShape.length),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}const TD="\n  result.r = isNaN.r ? NAN : result.r;\n  result.g = isNaN.g ? NAN : result.g;\n  result.b = isNaN.b ? NAN : result.b;\n  result.a = isNaN.a ? NAN : result.a;\n";class CD{constructor(e,t,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=cl(t,n);const r=this.outputShape.length;this.enableShapeUniforms=F_(r);let a="";if(s)if(0===r||1===p(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${C_(r)} coords = getOutputCoords();\n        `,1===r)this.enableShapeUniforms?a+="\n            result.y = (coords + 1) >= outShape ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          ":a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=oD("coords",r);this.enableShapeUniforms?a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= outShape[${r} - 2];\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= outShape[${r} - 1];\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `:a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}function $D(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const ED={kernelName:"Identity",backendName:"webgl",kernelFunc:$D};function AD(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=$D({inputs:{x:s},backend:n}),l=$D({inputs:{x:r},backend:n});return i.complexTensorInfos={real:o,imag:l},a}const RD={kernelName:"Complex",backendName:"webgl",kernelFunc:AD},_D="return (a < 0.) ? b * a : a;",FD="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const DD={kernelName:"LeakyRelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s,i=n.makeTensorInfo([],"float32",br(a,"float32")),o=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new CD(FD,r.shape,i.shape):new SD(_D,r.shape,i.shape),l=n.runWebGLProgram(o,[r,i],"float32");return n.disposeIntermediateTensorInfo(i),l}},OD="return (a < 0.) ? b * a : a;",MD="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const LD={kernelName:"Prelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t,a=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new CD(MD,s.shape,r.shape):new SD(OD,s.shape,r.shape);return n.runWebGLProgram(a,[s,r],"float32")}};function zD({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:n,dtype:s}){return({inputs:r,backend:a})=>{const{x:i}=r,o=a,l=s||i.dtype;if(o.shouldExecuteOnCPU([i])&&null!=n){const e=o.texData.get(i.dataId),t=n(e.values,l);return o.makeTensorInfo(i.shape,l,t)}let u;return u=K().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new gD(i.shape,t):new fD(i.shape,e),o.runWebGLProgram(u,[i],l)}}function PD({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const t=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[t.complexTensorInfos.real,n.complexTensorInfos.real],[t.complexTensorInfos.imag,n.complexTensorInfos.imag]].map((t=>{const[n,s]=t,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new SD(e,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],Kr(n.dtype,s.dtype))})),a=AD({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||Kr(l.dtype,u.dtype);if(("string"===l.dtype||"string"===u.dtype||c.shouldExecuteOnCPU([l,u]))&&null!=r){const e=c.texData.get(l.dataId).values,t=c.texData.get(u.dataId).values,n="string"===l.dtype?pm(e):e,s="string"===l.dtype?pm(t):t,[a,i]=r(l.shape,u.shape,n,s,h),o=c.makeTensorInfo(i,h);return c.texData.get(o.dataId).values=a,o}let p;return p=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new CD(t,l.shape,u.shape,n):new SD(e,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}function BD(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return t?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return t?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return t?MD:OD;if("leakyrelu"===e)return t?FD:_D;if("sigmoid"===e)return"return 1.0 / (1.0 + exp(-1.0 * x));";throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class WD{constructor(e,t,n,s=!1,r=!1,a=!1,i=null,o=!1,l=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n,this.enableShapeUniforms=F_(this.outputShape.length);const u=s?e[1]:e[2],c=Math.ceil(u/2),h=s?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",d=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let m="",g="";i&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:l?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,g="result = activation(result);");const y=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),l&&this.variableNames.push("leakyreluAlpha");let b="rc.x",x="rc.x";e[0]<t[0]?b=`imod(rc.x, ${e[0]})`:t[0]<e[0]&&(x=`imod(rc.x, ${t[0]})`),this.userCode=`\n      ${m}\n      // Don't use uniform for sharedDimensionPacked for performance.\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        int batchA = ${b};\n        int batchB = ${x};\n        for (int i = 0; i < ${c}; i++) {\n          vec4 a = getMatrixA(batchA, ${h});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${d[0]} * ${f[0]});\n          result += (${d[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${y}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const VD="return areal * breal - aimag * bimag;",UD="return areal * bimag + aimag * breal;";class GD{constructor(e,t,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=cl(t,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const HD="return a * b;";function jD(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=Kr(s.dtype,r.dtype);if("complex64"===s.dtype){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),a=new GD(VD,s.shape,r.shape),i=new GD(UD,s.shape,r.shape),o=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:s.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:r.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=AD({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),[i,o]=FF(s.shape,r.shape,e.values,t.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new CD(HD,s.shape,r.shape):new SD(HD,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}const qD={kernelName:"Multiply",backendName:"webgl",kernelFunc:jD};function KD(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=n,o=p(r.shape),l=x(a,o),c=p(l);u(o===c,(()=>`The new shape (${l}) has ${c} elements and the old shape (${r.shape}) has ${o} elements. The new shape and old shape must have the same number of elements.`));const h=i.texData.get(r.dataId);return!h.isPacked||XR(r.shape,l)||null!==h.texture&&XR(h.shape,l)?(i.incRef(r.dataId),{dataId:r.dataId,shape:l,dtype:r.dtype}):function(e,t,n){const s=[GR(e.shape),...HR(e.shape)],r={dtype:e.dtype,shape:s,dataId:e.dataId},a=[GR(t),...HR(t)],i=new uD(a,s),o=[s],l=n.runWebGLProgram(i,[r],e.dtype,o,!0);return{dataId:l.dataId,shape:t,dtype:l.dtype}}(r,l,i)}const XD={kernelName:"Reshape",backendName:"webgl",kernelFunc:KD};class YD{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${m(e)?e.toPrecision(2):e}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class ZD{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];let i="0.0",o="";"prod"===t?i="1.0":"min"===t?(i="1.0 / 1e-20",o="min"):"max"===t&&(i="-1.0 / 1e-20",o="max");let l=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===t?l="sumValue":"prod"===t?l="prodValue":"all"===t?l="allValue":"any"===t&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n        if (${"min"===t} || ${"max"===t}) {\n          minMaxValue = ${o}(values, minMaxValue);\n          bvec4 isNaN = isnan(values);\n          if (isNaN.r || isNaN.g || isNaN.b || isNaN.a) {\n            minMaxValue = vec4(NAN);\n          }\n        }\n      }\n    `,p="vec4";"all"===t?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===t&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}function JD(e,t,n,s){const r=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const n=t.length?t[t.length-1].outSize:e[1],s=Tf(n);t.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return t}(e.shape);let a=e;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new YD({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},o):new YD({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u}):new ZD({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],t),h.dataId!==e.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class QD{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];this.outputShape=n,this.rank=n.length;const s=C_(this.rank),r=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(t);for(let t=0;t<e.length;t++)s[e[t]]=n[t];return s.join()}(t);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class eO{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=C_(this.rank),r=iD("rc",this.rank),a=new Array(this.rank);for(let e=0;e<t.length;e++)a[t[e]]=r[e];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function tO(e,t,n){const s=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new eO(e.shape,t):new QD(e.shape,t);return n.runWebGLProgram(s,[e],e.dtype)}function nO(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;return function(e,t,n,s){const r=t,a=e.shape.length,i=w(r,e.shape);let o=i;const l=Tl(o,a),u=null!=l;let c=e;u&&(c=tO(e,l,s),o=$l(o.length,a)),Sl("sum",o,a);const[h,d]=Nl(c.shape,o);let f=h;n&&(f=Il(h,i));const m=p(d),g=KD({inputs:{x:c},attrs:{shape:[p(e.shape)/m,m]},backend:s}),y=JD(g,Xr(e.dtype),"sum",s),b=KD({inputs:{x:y},attrs:{shape:f},backend:s});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(y),u&&s.disposeIntermediateTensorInfo(c),b}(r,a,i,n)}const sO={kernelName:"Sum",backendName:"webgl",kernelFunc:nO};function rO(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{perm:a}=s,i=n,o=r.shape.length,l=new Array(o);for(let e=0;e<l.length;e++)l[e]=r.shape[a[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=rD(e,r.shape,r.dtype,a,l);u=i.makeTensorInfo(l,r.dtype);i.texData.get(u.dataId).values=t}else u=tO(r,a,i);return u}const aO={kernelName:"Transpose",backendName:"webgl",kernelFunc:rO};function iO({a:e,b:t,transposeA:n,transposeB:s,backend:r,bias:a=null,preluActivationWeights:i=null,leakyreluAlpha:o=0,activation:l=null}){const c=e.shape.length,h=t.shape.length,d=n?e.shape[c-2]:e.shape[c-1],f=s?t.shape[h-1]:t.shape[h-2],m=n?e.shape[c-1]:e.shape[c-2],g=s?t.shape[h-2]:t.shape[h-1],y=e.shape.slice(0,-2),b=t.shape.slice(0,-2),x=p(y),w=p(b),v=cl(e.shape.slice(0,-2),t.shape.slice(0,-2)).concat([m,g]);u(d===f,(()=>`Error in matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${n} and transposeB=${s} must match.`));const k=n?[x,d,m]:[x,m,d],N=s?[w,g,f]:[w,f,g],I=KD({inputs:{x:e},backend:r,attrs:{shape:k}}),S=KD({inputs:{x:t},backend:r,attrs:{shape:N}}),T=[I,S],C=Math.max(x,w),$=n?I.shape[1]:I.shape[2],E=null!=a,A=null!=i,R="leakyrelu"===l,_=null!=l?BD(l,!0):null;let F;if((1===m||1===g)&&$>1e3&&!1===(E||A||R||null!=_)){let e=I,t=S;n&&(e=rO({inputs:{x:I},backend:r,attrs:{perm:[0,2,1]}}),T.push(e)),s&&(t=rO({inputs:{x:S},backend:r,attrs:{perm:[0,2,1]}}),T.push(t));const a=1===g;let i=e;1!==g&&(i=KD({inputs:{x:e},backend:r,attrs:{shape:[C,$,1]}}),T.push(i));const o=1===g?2:1;let l=t;a&&(l=KD({inputs:{x:t},backend:r,attrs:{shape:[C,1,$]}}),T.push(l));const u=jD({inputs:{a:i,b:l},backend:r});F=nO({inputs:{x:u},backend:r,attrs:{axis:o,keepDims:!0}}),T.push(u)}else{const l=Kr(e.dtype,t.dtype),u=new WD(k,N,[C,m,g],n,s,E,_,A,R),c=[I,S];if(null!=a&&c.push(a),A&&c.push(i),R){const e=r.makeTensorInfo([],"float32",br(o,"float32"));c.push(e),T.push(e)}F=r.runWebGLProgram(u,c,l)}const D=KD({inputs:{x:F},backend:r,attrs:{shape:v}});T.push(F);for(const e of T)r.disposeIntermediateTensorInfo(e);return D}const oO={kernelName:"_FusedMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;return iO({a:r,b:a,transposeA:l,transposeB:u,backend:n,bias:i,preluActivationWeights:o,leakyreluAlpha:h,activation:c})}},lO="return abs(x);";const uO={kernelName:"Abs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])&&"complex64"!==s.dtype){const e=n.texData.get(s.dataId),t=GF(e.values);return n.makeTensorInfo(s.shape,s.dtype,t)}let r;return r=K().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new gD(s.shape,lO):new fD(s.shape,lO),n.runWebGLProgram(r,[s],s.dtype)}},cO={kernelName:"Acos",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"})},hO={kernelName:"Acosh",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"})},pO="return a + b;",dO={kernelName:"Add",backendName:"webgl",kernelFunc:PD({opSnippet:pO,packedOpSnippet:pO,supportsComplex:!0,cpuKernelImpl:hF})};class fO{constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`float v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class mO{constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}const gO={kernelName:"AddN",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,r=n;if(1===r.length)return $D({inputs:{x:r[0]},backend:s});if(r.length>K().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(r.length/2),n=e({inputs:r.slice(0,t),backend:s}),a=e({inputs:r.slice(t),backend:s});return e({inputs:[n,a],backend:s})}const a=r.map((e=>e.dtype)).reduce(((e,t)=>Kr(e,t))),i=r.map((e=>e.shape)),o=K().getBool("WEBGL_PACK")?new mO(r[0].shape,i):new fO(r[0].shape,i);return s.runWebGLProgram(o,r,a)}};const yO={kernelName:"All",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=Tl(u,o);let h=r;null!=c&&(h=rO({inputs:{x:r},backend:n,attrs:{perm:c}}),u=$l(u.length,o)),Sl("all",u,o);const[d,f]=Nl(h.shape,u),m=KD({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=JD(m,m.dtype,"all",n);let y;if(i){y=KD({inputs:{x:g},backend:n,attrs:{shape:Il(d,l)}})}else y=KD({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};const bO={kernelName:"Any",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=Tl(u,o);let h=r;null!=c&&(h=rO({inputs:{x:r},backend:n,attrs:{perm:c}}),u=$l(u.length,o)),Sl("any",u,o);const[d,f]=Nl(h.shape,u),m=KD({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=JD(m,m.dtype,"any",n);let y;if(i){y=KD({inputs:{x:g},backend:n,attrs:{shape:Il(d,l)}})}else y=KD({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};class xO{constructor(e,t,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===t?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class wO{constructor(e,t,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,u(e.length>2,(()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`));const r=e[e.length-1],a=Math.ceil(r/t);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,o=i.length,l=C_(o),c=oD("coords",o);let h,p;if(1===a){p=o+1;const e=C_(p);h=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[o-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[o-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[o-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[o-2]};`}else p=o,h=`\n        ${l} sourceLocR = coords;\n        ++${c[o-1]};\n        ${l} sourceLocG = coords;\n        ++${c[o-2]};\n        ${l} sourceLocA = coords;\n        --${c[o-1]};\n        ${l} sourceLocB = coords;\n        --${c[o-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map((e=>"int "+e)),g=oD("sourceLocR",p-1).concat("inIdx.r"),y=oD("sourceLocG",p-1).concat("inIdx.g"),b=oD("sourceLocB",p-1).concat("inIdx.b"),x=oD("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",v=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,k=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${l} coords = getOutputCoords();\n        bool hasNextCol = ${c[o-1]} < ${i[o-1]-1};\n        bool hasNextRow = ${c[o-2]} < ${i[o-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${k};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${v}\n          vec4 candidate = ${k};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function vO(e,t,n,s=null){let r=t.shape[0],a=t.shape[1];null!=s&&(r=s.shape[0],a=s.shape[1]);const i=Tf(a),o={windowSize:i,inSize:a,batchSize:r,outSize:Math.ceil(a/i)},l=new xO(o,n,null==s),u=[t];null!=s&&u.push(s);const c=e.runWebGLProgram(l,u,"int32");if(1===c.shape[1])return c;const h=vO(e,t,n,c);return e.disposeIntermediateTensorInfo(c),h}function kO(e,t,n,s=null){const r=null!=s?s.shape:t.shape,a=Tf(r[r.length-1]),i=new wO(r,a,n,null==s),o=null==s?[t]:[t,s],l=e.runWebGLProgram(i,o,"int32");if(l.shape.length===t.shape.length){const s=kO(e,t,n,l);return e.disposeIntermediateTensorInfo(l),s}return l}function NO(e,t,n,s){const r=[n];if(Sl("arg"+s.charAt(0).toUpperCase()+s.slice(1),r,t.shape.length),!K().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const n=[],a=e.texData.get(t.dataId);let i=t;null!==a&&a.isPacked&&(i=e.unpackTensor(t),n.push(i));const[o,l]=Nl(i.shape,r),u=p(l),c=KD({inputs:{x:i},backend:e,attrs:{shape:[-1,u]}});n.push(c);const h=vO(e,c,s);n.push(h);const d=KD({inputs:{x:h},backend:e,attrs:{shape:o}});return n.forEach((t=>e.disposeIntermediateTensorInfo(t))),d}return kO(e,t,s)}const IO={kernelName:"ArgMax",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=w(a,r.shape);const o=Tl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=rO({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=$l(i.length,l.shape.length)),Sl("argMax",[i[0]],l.shape.length);const c=NO(n,l,i[0],"max");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}};const SO={kernelName:"ArgMin",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=w(a,r.shape);const o=Tl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=rO({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=$l(i.length,l.shape.length)),Sl("argMin",[i[0]],l.shape.length);const c=NO(n,l,i[0],"min");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}},TO={kernelName:"Asin",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"})},CO={kernelName:"Asinh",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"})},$O={kernelName:"Atan",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"})},EO={kernelName:"Atan2",backendName:"webgl",kernelFunc:PD({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  bvec4 isNaNA = isnan(a);\n  bvec4 isNaNB = isnan(b);\n  bvec4 isNaN = bvec4(isNaNA.x || isNaNB.x, isNaNA.y || isNaNB.y, isNaNA.z || isNaNB.z, isNaNA.w || isNaNB.w);\n  \n  result.r = isNaN.r ? NAN : result.r;\n  result.g = isNaN.g ? NAN : result.g;\n  result.b = isNaN.b ? NAN : result.b;\n  result.a = isNaN.a ? NAN : result.a;\n\n  return result;\n"})},AO={kernelName:"Atanh",backendName:"webgl",kernelFunc:zD({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"})};class RO{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideHeight,o=e.strideWidth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.top,d=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,m=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(b="avgValue / max(count, 1.0)");const x=4*Math.floor(a/4),w=a%4,v=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${v}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${v}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class _O{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideDepth,o=e.strideHeight,l=e.strideWidth,u=e.dilationDepth,c=e.dilationHeight,h=e.dilationWidth,p=e.effectiveFilterDepth,d=e.effectiveFilterHeight,f=e.effectiveFilterWidth,m=e.padInfo.front,g=e.padInfo.top,y=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===t;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(w="avgValue / max(count, 1.0)");const v=4*Math.floor(a/4),k=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${v}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${v};\n            if (${1===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n        }\n        setOutput(${w});\n      }\n    `}}const FO={kernelName:"AvgPool",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;o_(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(yo(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=io(r.shape,a,i,1,o,l);if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))return $D({inputs:{x:r},backend:n});const h=new RO(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const DO={kernelName:"AvgPool3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s,c=oo(r.shape,a,i,[1,1,1],o,l,u),h=new _O(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};class OO{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterHeight,l=e.effectiveFilterWidth,u=o-1-e.padInfo.top,c=l-1-e.padInfo.left,h=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class MO{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterDepth,h=e.effectiveFilterHeight,p=e.effectiveFilterWidth,d=c-1-e.padInfo.front,f=h-1-e.padInfo.top,m=p-1-e.padInfo.left,g=1/(t*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const LO={kernelName:"AvgPool3DGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=oo(i.shape,o,l,[1,1,1],u,c),p=new MO(h);return n.runWebGLProgram(p,[r],i.dtype)}};const zO={kernelName:"AvgPoolGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;o_([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=io(i.shape,o,l,1,u),h=new OO(c);return n.runWebGLProgram(h,[r],i.dtype)}};const PO={kernelName:"BatchMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;return iO({a:r,b:a,transposeA:i,transposeB:o,backend:n})}};class BO{constructor(e,t,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],cl(e,t),cl(e,n);let i="0.0";null!=s&&(cl(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(cl(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class WO{constructor(e,t,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],cl(e,t),cl(e,n);let i="vec4(0.0)";null!=s&&(cl(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(cl(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const VO={kernelName:"FusedBatchNorm",backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:o}=e;u(r.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==i||r.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==o||r.shape.length===o.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));let{varianceEpsilon:l}=n;null==l&&(l=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=o&&(p=o.shape,c.push(o));const d=K().getBool("WEBGL_PACK_NORMALIZATION")?new WO(s.shape,r.shape,a.shape,h,p,l):new BO(s.shape,r.shape,a.shape,h,p,l);return t.runWebGLProgram(d,c,c[0].dtype)}};class UO{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=C_(this.rank);this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const n=function(e){if(1===e)return"sourceLoc";if(e<=6)return GO.slice(0,e).map((e=>"sourceLoc."+e)).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let s;s=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map(((e,t)=>`sourceLoc.${GO[t]} = start[${t}] + coords.${GO[t]};`)).join("\n")}\n      `,this.userCode=`\n      void main() {\n        ${s}\n        setOutput(getSource(${n}));\n      }\n    `}}const GO=["x","y","z","w","u","v"];class HO{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length,this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const t=C_(this.rank),n=oD("coords",this.rank),s=oD("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map(((e,t)=>`start[${t}]`)).join()});`:e.map(((e,t)=>`${s[t]} = ${n[t]} + start[${t}];`)).join("\n");this.userCode=`\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}}function jO(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s,[o,l]=cf(r,a,i);if(Zd(r,o,l),0===p(l))return n.makeTensorInfo(l,r.dtype,[]);if(n.shouldExecuteOnCPU([r])||"string"===r.dtype){const e=n.texData.get(r.dataId),t=HF(e.values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,t)}const{isPacked:u}=n.texData.get(r.dataId),c=lf(r.shape,o,l);if(u||!c){const e=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new HO(l):new UO(l),t=[o];return n.runWebGLProgram(e,[r],r.dtype,t)}return n.uploadToGPU(r.dataId),function(e,t,n,s){const r=s.texData.get(e.dataId),a=s.makeTensorInfo(n,e.dtype),i=s.texData.get(a.dataId);Object.assign(i,r),i.refCount=1,i.shape=n,i.dtype=e.dtype;let o=uf(t,O(e.shape));r.slice&&(o+=r.slice.flatOffset),i.slice={flatOffset:o,origDataId:r.slice&&r.slice.origDataId||e.dataId};const l=s.dataRefCount.get(i.slice.origDataId)||1;return s.dataRefCount.set(i.slice.origDataId,l+1),a}(r,o,l,n)}const qO={kernelName:"Slice",backendName:"webgl",kernelFunc:jO},KO={kernelName:"BatchToSpaceND",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;u(r.shape.length<=4,(()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet"));const o=a.reduce(((e,t)=>e*t)),l=$f(r.shape,a,o),c=Ef(l.length,a.length),h=Af(r.shape,a,o),p=Rf(i,a.length),d=_f(h,i,a.length),f=[],m=KD({inputs:{x:r},backend:n,attrs:{shape:l}}),g=rO({inputs:{x:m},backend:n,attrs:{perm:c}}),y=KD({inputs:{x:g},backend:n,attrs:{shape:h}}),b=jO({inputs:{x:y},backend:n,attrs:{begin:p,size:d}});return f.push(m),f.push(g),f.push(y),f.forEach((e=>n.disposeIntermediateTensorInfo(e))),b}};const XO={kernelName:"Bincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=n.readSync(r.dataId),l=n.readSync(a.dataId),u=pF(o,l,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,u)}};const YO={kernelName:"BitwiseAnd",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=K().getBool("WEBGL_PACK_BINARY_OPERATIONS"),i=K().getNumber("WEBGL_VERSION");if(n.shouldExecuteOnCPU([s,r])||1===i){const e=n.texData.get(s.dataId).values,t=n.texData.get(r.dataId).values,[a,i]=fF(s.shape,r.shape,e,t,s.dtype),o=n.makeTensorInfo(i,s.dtype);return n.texData.get(o.dataId).values=a,o}let o;return o=a?new CD("\n  int r = int(a.r) & int(b.r);\n  int g = int(a.g) & int(b.g);\n  int rb = int(a.b) & int(b.b);\n  int ra = int(a.a) & int(b.a);\n  return vec4(r, g, rb, ra);\n",s.shape,r.shape,!1):new SD("\n  return float(int(a.r) & int(b.r));\n",s.shape,r.shape),n.runWebGLProgram(o,[s,r],s.dtype)}};const ZO={kernelName:"BroadcastArgs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{s0:s,s1:r}=t,a=n.readSync(s.dataId),i=n.readSync(r.dataId),o=cl(Array.from(a),Array.from(i));return n.makeTensorInfo([o.length],"int32",Int32Array.from(o))}},JO=PD({opSnippet:"return float(a != b);",cpuKernelImpl:OF,dtype:"bool"}),QO={kernelName:"NotEqual",backendName:"webgl",kernelFunc:JO};function eM(e){const{inputs:t,backend:n}=e,{input:s}=t;return $D({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const tM={kernelName:"Real",backendName:"webgl",kernelFunc:eM};const nM={kernelName:"Cast",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s,attrs:r}=t,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return $D({inputs:{x:a},backend:s});const t=Eu(a.shape),n=e({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=AD({inputs:{real:n,imag:t},backend:s});return t.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const t=eM({inputs:{input:a},backend:s}),n=e({inputs:{x:t},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(t),n}if(!T(a.dtype,i)){const e=$D({inputs:{x:a},backend:s});return{dataId:e.dataId,shape:e.shape,dtype:i}}if(s.shouldExecuteOnCPU([a])){const e=s.texData.get(a.dataId).values,[t,n,r]=mF(e,a.shape,a.dtype,i);return s.makeTensorInfo(t,n,r)}if("int32"===i)return function(e,t){const n=new fD(e.shape,"return float(int(x));"),s=t.runWebGLProgram(n,[e],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const e=s.makeTensorInfo([],"bool",k("bool",1)),t=JO({inputs:{a:a,b:e},backend:s});return s.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}},sM="return ceil(x);",rM={kernelName:"Ceil",backendName:"webgl",kernelFunc:zD({opSnippet:sM,packedOpSnippet:sM,cpuKernelImpl:gF})};class aM{constructor(e){this.variableNames=["A"],this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}}class iM{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}}const oM={kernelName:"ClipByValue",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{clipValueMin:a,clipValueMax:i}=s;let o;o=K().getBool("WEBGL_PACK_CLIP")?new iM(r.shape):new aM(r.shape);const l=[[a],[i]];return n.runWebGLProgram(o,[r],r.dtype,l)}};class lM{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function uM(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}const cM={kernelName:"ComplexAbs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=n.texData.get(s.dataId),a=new lM(s.shape),i=[uM(s,r.complexTensorInfos.real),uM(s,r.complexTensorInfos.imag)];return n.runWebGLProgram(a,i,i[0].dtype)}};class hM{constructor(e){this.outputShape=[],this.outputShape=wf(e,1),this.variableNames=e.map(((e,t)=>`T${t}`));const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const n=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const s=t[e-1];n.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${s}));`)}const s=t.length,r=t[t.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class pM{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=wf(e,t);const n=this.outputShape,s=n.length,r=C_(s),a=oD("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=e.map(((e,t)=>`T${t}`));const o=new Array(e.length-1);o[0]=e[0][t];for(let n=1;n<o.length;n++)o[n]=o[n-1]+e[n][t];const l=i[t],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let e=1;e<o.length;e++){const t=o[e-1];h+=`\n        if (${l} < ${o[e]}  && ${l} >= ${o[e-1]}) {\n          return getChannel(\n            getT${e}(${dM(i,l,t)}),\n            vec2(${dM(u,l,t)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${dM(i,l,d)}),\n          vec2(${dM(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map((e=>"int "+e))}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function dM(e,t,n){const s=e.indexOf(t);return e.map(((e,t)=>t===s?`${e} - ${n}`:e)).join()}function fM(e){const{inputs:t,backend:n}=e,{input:s}=t;return $D({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const mM={kernelName:"Imag",backendName:"webgl",kernelFunc:fM};function gM(e,t,n){const s=e[0].dtype;if("complex64"===s){const s=e.map((e=>eM({inputs:{input:e},backend:n}))),r=e.map((e=>fM({inputs:{input:e},backend:n}))),a=gM(s,t,n),i=gM(r,t,n),o=AD({inputs:{real:a,imag:i},backend:n});return s.forEach((e=>n.disposeIntermediateTensorInfo(e))),r.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),o}let r=n.shouldExecuteOnCPU(e);if("string"===s&&(r=!0),r){const r=e.map((e=>{const s=p(e.shape.slice(t));return KD({inputs:{x:e},backend:n,attrs:{shape:[-1,s]}})})),a=r.map((e=>({vals:n.readSync(e.dataId),shape:e.shape}))),i=wf(r.map((e=>e.shape)),1),o=1===r[0].shape[0],l=yF(a,i,s,o),u=wf(e.map((e=>e.shape)),t),c=n.makeTensorInfo(u,s,l);return r.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}const a=e.filter((e=>p(e.shape)>0)),i=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&a[0].shape.length>1;if(1===a.length){const t=i?new fD(e[0].shape,mD):new gD(e[0].shape,mD);return n.runWebGLProgram(t,e,s)}const o=K().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER");if(a.length>o){const e=[];for(let s=0;s<a.length;s+=o){const r=a.slice(s,s+o);e.push(gM(r,t,n))}const s=gM(e,t,n);for(const t of e)n.disposeIntermediateTensorInfo(t);return s}if(i){const e=new pM(a.map((e=>e.shape)),t);return n.runWebGLProgram(e,a,s)}const{tensors2D:l,outShape:u}=function(e,t,n){const s=wf(e.map((e=>e.shape)),t);return{tensors2D:e.map((e=>KD({inputs:{x:e},attrs:{shape:[-1,p(e.shape.slice(t))]},backend:n}))),outShape:s}}(a,t,n),c=new hM(l.map((e=>e.shape))),h=n.runWebGLProgram(c,l,s);l.forEach((e=>n.disposeIntermediateTensorInfo(e)));const d=KD({inputs:{x:h},attrs:{shape:u},backend:n});return n.disposeIntermediateTensorInfo(h),d}function yM(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=w(r,t[0].shape)[0];xf(t.map((e=>e.shape)),a);const i=wf(t.map((e=>e.shape)),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>p(e.shape)>0));return 1===o.length?$D({inputs:{x:o[0]},backend:n}):gM(o,a,n)}const bM={kernelName:"Concat",backendName:"webgl",kernelFunc:yM};class xM{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.padInfo.top,i=e.padInfo.left,o=e.strideHeight,l=e.strideWidth,u=e.dilationHeight,c=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4,m="channelsLast"===e.dataFormat,g=m?1:2,y=m?2:3,b=m?3:1;let x="",w="";n&&(x=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,w="result = activation(result);");const v=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${o}, ${l});\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${y}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${d}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${m}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${m}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${d}) *\n                    getW(wR, wC, ${d}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${d}, xR, xC) *\n                    getW(wR, wC, ${d}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2)\n              );\n\n              if (${m}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2),\n                getW(wR, wC, ${d} + 2, d2)\n              );\n\n              if (${m}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1),\n                  getX(batch, xR, xC, ${d} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC),\n                  getX(batch, ${d} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${v}\n        ${w}\n        setOutput(result);\n      }\n    `}}class wM{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,s=e.padInfo.left,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.filterDepth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${t}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class vM{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=F_(this.outputShape.length);const a=e.padInfo.left,o=e.strideWidth,l=e.dilationWidth,u=e.filterHeight,c=e.filterWidth,h=c;let p="\n       int xR; int xC; int xCOffset;\n       vec4 wTexel; vec4 previous; vec4 final;";for(let e=0;e<c;e++)p+=`\n           vec4 xTexelC${2*e};\n           int xTexelC${2*e}Ready;\n           vec4 xTexelC${2*e+1};\n           int xTexelC${2*e+1}Ready;\n           vec4 xC${e};`;p+=`\n     for (int r = 0; r < ${u}; r++) {\n      for (int d1 = 0; d1 < ${e.inChannels}; d1 += 2) {\n       `;for(let e=0;e<c;e++)p+=`\n           xTexelC${2*e} = vec4(0.0);\n           xTexelC${2*e}Ready = 0;\n           xTexelC${2*e+1} = vec4(0.0);\n           xTexelC${2*e+1}Ready = 0;\n           xC${e} = vec4(0.0);`;p+="\n         xR = xRCorner + r * dilations[0];\n         if (xR >=0 && xR < inDims[0]) {\n       ";for(let t=0;t<(h+1)/2;t++){const n=2*t;if(p+=`\n           xC = xCCorner + ${n*l};\n           `,1===o){if(n<c&&(a%2==1?(p+=`\n                 xCOffset = xC + 1;\n                 if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${n}Ready == 0) {\n                   xTexelC${n} = getX(batch, xR, xCOffset, d1);\n\n                   // Need to manually clear unused channels in case\n                   // we're reading from recycled texture.\n                   if (xCOffset + 1 >= inDims[1]) {\n                     xTexelC${n}.zw = vec2(0.0);\n                   }\n                   xTexelC${n}Ready = 1;\n                 }\n               `,p+=1===l&&n>0?`\n                 xC${n} = vec4(xTexelC${n-2}.zw, xTexelC${n}.xy);\n                 `:`\n                   xCOffset = xC + 1 - 2;\n\n                   if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                     previous = getX(batch, xR, xCOffset, d1);\n\n                     // Need to manually clear unused channels in case\n                     // we're reading from recycled texture.\n                     if (xCOffset + 1 >= inDims[1]) {\n                       previous.zw = vec2(0.0);\n                     }\n\n                     xC${n} = vec4(previous.zw, xTexelC${n}.xy);\n                   } else {\n                     xC${n} = vec4(0.0, 0.0, xTexelC${n}.xy);\n                   }\n                   `):p+=`\n                 if (xC >= 0 && xC < inDims[1] && xTexelC${n}Ready == 0) {\n                   xTexelC${n} = getX(batch, xR, xC, d1);\n                   if (xC + 1 >= inDims[1]) {\n                     xTexelC${n}.zw = vec2(0.0);\n                   }\n                   xTexelC${n}Ready = 1;\n                 }\n\n                 xC${n} = xTexelC${n};\n                 `,n+1<c)){const e=a%2==0?i(l):l;l%2==0&&a%2==1||l%2!=0&&a%2!=1?(p+=`\n                   xCOffset = xC + imod(pads[1], 2) + ${e};\n\n                   if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${n+1}Ready == 0) {\n                     xTexelC${n+1} = getX(batch, xR, xCOffset, d1);\n\n                     // Need to manually clear unused channels in case\n                     // we're reading from recycled texture.\n                     if (xCOffset + 1 >= inDims[1]) {\n                       xTexelC${n+1}.zw = vec2(0.0);\n                     }\n                     xTexelC${n+1}Ready = 1;\n                   }\n                   `,p+=l>1?`\n                     xCOffset -= 2;\n                     if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                      previous = getX(batch, xR, xCOffset, d1);\n                      xC${n+1} = vec4(previous.zw, xTexelC${n+1}.xy);\n                     } else {\n                      xC${n+1} = vec4(0.0, 0.0, xTexelC${n+1}.xy);\n                     }\n                     `:`\n                     xC${n+1} = vec4(xTexelC${n}.zw, xTexelC${n+1}.xy);\n                     `):p+=1===e?`\n                     xC${n+1} = xTexelC${n};\n                     `:`\n                     xCOffset = xC + ${e};\n\n                     if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${n+1}Ready == 0) {\n                       xTexelC${n+1} = getX(batch, xR, xCOffset, d1);\n                       if (xCOffset + 1 >= inDims[1]) {\n                         xTexelC${n+1}.zw = vec2(0.0);\n                       }\n                       xTexelC${n+1}Ready = 1;\n                     }\n\n                     xC${n+1} = xTexelC${n+1};\n                     `}}else n<c&&(a%2==1?(p+=`\n                 xCOffset = xC + 1 - strides[1];\n                 if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${n}Ready == 0) {\n                   xTexelC${n} = getX(batch, xR, xCOffset, d1);\n                   // Need to manually clear unused channels in case\n                   // we're reading from recycled texture.\n                   if (xCOffset + 1 >= inDims[1]) {\n                     xTexelC${n}.zw = vec2(0.0);\n                   }\n                   xTexelC${n}Ready = 1;\n                 }\n\n                 if(xC + 1 >= 0 && xC + 1 < inDims[1] && xTexelC${n+1}Ready == 0) {\n                   xTexelC${n+1} = getX(batch, xR, xC + 1, d1);\n                   // Need to manually clear unused channels in case\n                   // we're reading from recycled texture.\n                   if (xC + 2 >= inDims[1]) {\n                     xTexelC${n+1}.zw = vec2(0.0);\n                   }\n                   xTexelC${n+1}Ready = 1;\n                 }\n\n                 xC${n} = vec4(xTexelC${n}.zw, xTexelC${n+1}.zw);\n               `,n+1<c&&(p+=`\n                   final = vec4(0.0);\n                   xCOffset = xC + 1 + strides[1];\n                   if(xCOffset >= 0 && xCOffset < inDims[1]) {\n                     final = getX(batch, xR, xCOffset, d1);\n                   }\n                   xC${n+1} = vec4(xTexelC${n+1}.xy, final.xy);\n                 `)):(p+=`\n                 if(xC >= 0 && xC < inDims[1] && xTexelC${n}Ready == 0) {\n                   xTexelC${n} = getX(batch, xR, xC, d1);\n                   if (xC + 1 >= inDims[1]) {\n                     xTexelC${n}.zw = vec2(0.0);\n                   }\n                   xTexelC${n}Ready = 1;\n                 }\n\n                 xCOffset = xC + strides[1];\n                 if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${n+1}Ready == 0) {\n                   xTexelC${n+1} = getX(batch, xR, xCOffset, d1);\n                   if (xCOffset + 1 >= inDims[1]) {\n                     xTexelC${n+1}.zw = vec2(0.);\n                   }\n                   xTexelC${n+1}Ready = 1;\n                 }\n\n                 xC${n} = vec4(\n                   xTexelC${n}.xy, xTexelC${n+1}.xy);\n               `,n+1<c&&(p+=`\n                   xC${n+1} = vec4(xTexelC${n}.zw, xTexelC${n+1}.zw);\n                 `)));n<c&&(p+=`\n             wTexel = getW(r, ${n}, d1, d2);\n             dotProd += xC${n}.xxzz * vec4(wTexel.xy, wTexel.xy);\n             if(d1 + 1 < ${e.inChannels}) {\n               dotProd += xC${n}.yyww * vec4(wTexel.zw, wTexel.zw);\n             }\n           `,n+1<c&&(p+=`\n               wTexel = getW(r, ${n+1}, d1, d2);\n               dotProd += xC${n+1}.xxzz * vec4(wTexel.xy, wTexel.xy);\n               if(d1 + 1 < ${e.inChannels}) {\n                 dotProd += xC${n+1}.yyww * vec4(wTexel.zw, wTexel.zw);\n               }\n             `))}p+="\n     }\n   ",p+="\n     }\n   ",p+="\n     }\n   ";let d="",f="";n&&(d=s?`vec4 activation(vec4 a) {\n           vec4 b = getPreluActivationWeightsAtOutCoords();\n           ${n}\n         }`:r?`vec4 activation(vec4 a) {\n           vec4 b = getLeakyreluAlphaAtOutCoords();\n           ${n}\n         }`:`vec4 activation(vec4 x) {\n           ${n}\n         }`,f="result = activation(result);");const m=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n       ${d}\n\n       void main() {\n         ivec4 coords = getOutputCoords();\n         int batch = coords.x;\n         ivec2 xRCCorner = coords.yz * strides - pads;\n         int d2 = coords.w;\n         int xRCorner = xRCCorner.x;\n         int xCCorner = xRCCorner.y;\n\n         //intialize dotProd with a small epsilon seems to reduce GPU accuracy loss.\n         vec4 dotProd = vec4(0.000000000000001);\n\n         ${p}\n\n         vec4 result = dotProd - vec4(0.000000000000001);\n         ${m}\n         ${f}\n         setOutput(result);\n       }\n     `}}class kM{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec4"},{name:"pad",type:"ivec2"},{name:"stride",type:"ivec2"},{name:"dilation",type:"ivec2"},{name:"inChannels",type:"int"},{name:"itemsPerBlockRow",type:"int"},{name:"outWidth",type:"int"}],this.outputShape=e,this.enableShapeUniforms=F_(this.outputShape.length);const{dataFormat:n}=t,s=c_(),r="channelsLast"===n,a=r?1:2,i=r?2:3,o=this.enableShapeUniforms?"if(blockIndex < outShape[2] && pos < outShape[1]) {":`if(blockIndex < ${e[2]} && pos < ${e[1]}) {`;let l="";for(let e=0;e<=1;e++)for(let t=0;t<=1;t++)l+=`\n          blockIndex = rc.z + ${t};\n          pos = rc.y + ${e};\n\n          ${o}\n            offsetY = int(blockIndex / outWidth) * stride[0] - pad[0];\n            d0 = offsetY + dilation[0] * (pos / itemsPerBlockRow);\n\n            if(d0 < inputShape[${a}] && d0 >= 0) {\n              // Use custom imod instead mod. On Intel GPU, mod may generate\n              // unexpected value.\n              // https://github.com/tensorflow/tfjs/issues/5447\n              offsetX = imod(blockIndex, outWidth) * stride[1] - pad[1];\n              d1 = offsetX + dilation[1] * (imod(pos, itemsPerBlockRow) /\n                  inChannels);\n\n              if(d1 < inputShape[${i}] && d1 >= 0) {\n\n                ch = imod(pos, inChannels);\n\n                if (${r}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*e+t}] = getChannel(\n                    getA(rc.x, d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*e+t}] = getChannel(\n                    getA(rc.x, ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${l}\n\n        ${s.output} = result;\n      }\n    `}}function NM(e,t){const n=e.length;return n>=3?t?[...e.slice(0,-3),e[n-3]*e[n-2],e[n-1]]:[...e.slice(0,-3),e[n-3],e[n-2]*e[n-1]]:!t&&1===n&&e[0]>1?[e[0],1]:null}function IM({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const l=e.shape,c=s.texData.get(e.dataId),h=n.inChannels,p=l[0]*l[1]*l[2],d=n.outChannels,m="channelsLast"===n.dataFormat;let g;const y=[];if(null!=a){const e=NM(a.shape,m);null!=e&&(a=KD({inputs:{x:a},backend:s,attrs:{shape:e}}),y.push(a))}if(null!=r){const e=NM(r.shape,m);null!=e&&(r=KD({inputs:{x:r},backend:s,attrs:{shape:e}}),y.push(r))}if(!((1===p||1===d)&&h>1e3)&&c.isPacked&&m&&null!=c.texture&&l[2]%2!=0&&f(c.shape.slice(-3),l.slice(-3))){const h=l[0]*l[1]*(l[2]+1),p={dataId:e.dataId,shape:[1,h,n.inChannels],dtype:e.dtype},d=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,u(XR(c.shape,p.shape),(()=>`packed reshape ${c.shape} to ${p.shape} isn't free`));const f=KD({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}});y.push(f);const m=iO({a:p,b:f,backend:s,transposeA:false,transposeB:false,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i}),b=s.texData.get(m.dataId);u(b.isPacked,(()=>"batchMatMul result is expected to be packed")),c.shape=d,b.shape=n.outShape,g=$D({inputs:{x:m},backend:s}),g.shape=n.outShape,y.push(m)}else{const l=n.outHeight*n.outWidth,u=KD({inputs:{x:e},backend:s,attrs:{shape:m?[n.batchSize,l,n.inChannels]:[n.batchSize,n.inChannels,l]}}),c=KD({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}}),h=iO({a:m?u:c,b:m?c:u,transposeA:!m,transposeB:false,backend:s,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i});g=KD({inputs:{x:h},backend:s,attrs:{shape:n.outShape}}),y.push(u),y.push(c),y.push(h)}for(const e of y)s.disposeIntermediateTensorInfo(e);return g}function SM({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const{filterWidth:l,filterHeight:u,inChannels:c,outWidth:h,outHeight:d,dataFormat:f}=n,m="channelsLast"===f,g=l*u*c,y=d*h,b=[n.batchSize,g,y],x=[];if(null!=a){const e=NM(a.shape,m);null!=e&&(a=KD({inputs:{x:a},backend:s,attrs:{shape:e}}),x.push(a))}if(null!=r){const e=NM(r.shape,m);null!=e&&(r=KD({inputs:{x:r},backend:s,attrs:{shape:e}}),x.push(r))}const w=KD({inputs:{x:t},backend:s,attrs:{shape:[1,g,p(t.shape)/g]}});x.push(w);const v=new kM(b,n),k=[e.shape,[n.padInfo.top,n.padInfo.left],[n.strideHeight,n.strideWidth],[n.dilationHeight,n.dilationWidth],[n.inChannels],[n.filterWidth*n.inChannels],[n.outWidth]],N=s.runWebGLProgram(v,[e],"float32",k),I=KD({inputs:{x:N},backend:s,attrs:{shape:b}});x.push(N),x.push(I);const S=null!=r,T=null!=a,C="leakyrelu"===o,$=o?BD(o,!0):null,E=new WD(m?I.shape:w.shape,m?w.shape:I.shape,m?[n.batchSize,y,n.outChannels]:[n.batchSize,n.outChannels,y],!0,!1,S,$,T,C),A=m?[I,w]:[w,I];if(r&&A.push(r),T&&A.push(a),C){const e=s.makeTensorInfo([],"float32",br(i,"float32"));A.push(e),x.push(e)}const R=s.runWebGLProgram(E,A,"float32"),_=KD({inputs:{x:R},backend:s,attrs:{shape:n.outShape}});x.push(R);for(const e of x)s.disposeIntermediateTensorInfo(e);return _}const TM={kernelName:"Conv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s,h=xo(l),p=lo(r.shape,a.shape,i,u,o,c,!1,h);let d;if(1!==p.filterHeight||1!==p.filterWidth||1!==p.dilationHeight||1!==p.dilationWidth||1!==p.strideHeight||1!==p.strideWidth||"SAME"!==p.padInfo.type&&"VALID"!==p.padInfo.type)if(p.strideWidth<=2&&"channelsLast"===h&&K().getBool("WEBGL_EXP_CONV")){const e=new vM(p),t=[[p.padInfo.top,p.padInfo.left],[p.strideHeight,p.strideWidth],[p.dilationHeight,p.dilationWidth],[p.inHeight,p.inWidth]];d=n.runWebGLProgram(e,[r,a],"float32",t)}else if(K().getBool("WEBGL_CONV_IM2COL"))d=SM({x:r,filter:a,convInfo:p,backend:n});else{const e=new xM(p);d=n.runWebGLProgram(e,[r,a],"float32")}else d=IM({x:r,filter:a,convInfo:p,backend:n});const f=KD({inputs:{x:d},backend:n,attrs:{shape:p.outShape}});return n.disposeIntermediateTensorInfo(d),f}};class CM{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              ${a?"float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);":"float dyValue = getDy(b, d2, yR, yC);\n              float xValue = getX(b, d1, xR, xC);\n              dotProd += (xValue * dyValue);"}\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class $M{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a="channelsLast"===e.dataFormat,i=t-1-e.padInfo.top,o=n-1-e.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class EM{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.padInfo.front,a=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class AM{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=t-1-e.padInfo.front,l=n-1-e.padInfo.top,u=s-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const RM={kernelName:"Conv2DBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s,h=xo(l),p=lo(r.shape,c,i,1,o,u,!1,h),d=new CM(p);return n.runWebGLProgram(d,[r,a],"float32")}};class _M{constructor(e){this.variableNames=["dy","W"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"strides",type:"vec2"}],this.outputShape=e.inShape,this.enableShapeUniforms=F_(this.outputShape.length);const t=e.filterHeight,n=e.filterWidth,s=t-1-e.padInfo.top,r=n-1-e.padInfo.left;this.userCode=`\n      const ivec2 pads = ivec2(${s}, ${r});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n\n        ivec2 dyCorner = ivec2(coords[1], coords[2]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        vec4 result = vec4(0.);\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / strides[0];\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            int wCPerm = ${n} - 1 - wC;\n\n            float dyC = float(dyCCorner + wC) / strides[1];\n            bool idyCVal = (dyC >= 0.0) && (dyC < ${e.outWidth}.0)\n              && (fract(dyC) == 0.0);\n            int idyC = int(dyC);\n\n            float dyC2 = float(dyCCorner + wC + 1) / strides[1];\n            bool idyCVal2 = (dyC2 >= 0.0) && (dyC2 < ${e.outWidth}.0)\n              && (fract(dyC2) == 0.0);\n            int idyC2 = int(dyC2);\n\n            if (idyCVal && idyCVal2) {\n              for (int d2 = 0; d2 < ${e.outChannels}; d2 += 2) {\n                vec4 wValue = getW(wRPerm, wCPerm, d1, d2);\n                vec4 dySample = getDy(batch, idyR, idyC, d2);\n                vec4 dySample2 = (idyC / 2 == idyC2 / 2) ?\n                  dySample : getDy(batch, idyR, idyC2, d2);\n\n                vec2 dyValue = mod(float(idyC), 2.) == 0. ?\n                  dySample.xy : dySample.zw;\n                result.xy += vec2(dot(dyValue, wValue.xy),\n                  dot(dyValue, wValue.zw));\n\n                dyValue = mod(float(idyC2), 2.) == 0. ?\n                  dySample2.xy : dySample2.zw;\n                result.zw += vec2(dot(dyValue, wValue.xy),\n                  dot(dyValue, wValue.zw));\n              }\n            } else if (idyCVal) {\n              for (int d2 = 0; d2 < ${e.outChannels}; d2 += 2) {\n                vec4 wValue = getW(wRPerm, wCPerm, d1, d2);\n                vec4 dySample = getDy(batch, idyR, idyC, d2);\n                vec2 dyValue = mod(float(idyC), 2.) == 0. ?\n                  dySample.xy : dySample.zw;\n                result.xy += vec2(dot(dyValue, wValue.xy),\n                  dot(dyValue, wValue.zw));\n              }\n            } else if (idyCVal2) {\n              for (int d2 = 0; d2 < ${e.outChannels}; d2 += 2) {\n                vec4 wValue = getW(wRPerm, wCPerm, d1, d2);\n                vec4 dySample = getDy(batch, idyR, idyC2, d2);\n                vec2 dyValue = mod(float(idyC2), 2.) == 0. ?\n                  dySample.xy : dySample.zw;\n                result.zw += vec2(dot(dyValue, wValue.xy),\n                  dot(dyValue, wValue.zw));\n              }\n            }\n          }\n        }\n        setOutput(result);\n      }\n    `}}const FM={kernelName:"Conv2DBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s,h=xo(u),p=lo(i,a.shape,o,1,l,c,!1,h);if(K().getBool("WEBGL_PACK_CONV2DTRANSPOSE")&&"channelsLast"===h){const e=[[p.strideHeight,p.strideWidth]],t=new _M(p);return n.runWebGLProgram(t,[r,a],"float32",e)}{const e=new $M(p);return n.runWebGLProgram(e,[r,a],"float32")}}};const DM={kernelName:"Conv3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=uo(r.shape,a.shape,i,l,o),c=new wM(u);return n.runWebGLProgram(c,[r,a],"float32")}};const OM={kernelName:"Conv3DBackpropFilterV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s,u=uo(r.shape,l,i,1,o),c=new EM(u);return n.runWebGLProgram(c,[r,a],"float32")}};const MM={kernelName:"Conv3DBackpropInputV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s,u=uo(l,a.shape,o,1,i),c=new AM(u);return n.runWebGLProgram(c,[r,a],"float32")}},LM=zD({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n",packedOpSnippet:`\n  vec4 result = cos(x);\n  bvec4 isNaN = isnan(x);\n  ${TD}\n  return result;\n`}),zM={kernelName:Oe,backendName:"webgl",kernelFunc:LM},PM={kernelName:"Cosh",backendName:"webgl",kernelFunc:zD({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"})};class BM{constructor(e,t,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=e,[u]=t,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${d}`],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const WM={kernelName:"CropAndResize",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,c=new BM(r.shape,a.shape,o,l,u);return n.runWebGLProgram(c,[r,a,i],"float32")}};var VM;!function(e){e.Prod="*",e.Sum="+"}(VM||(VM={}));class UM{constructor(e,t,n,s){this.op=e,this.outputShape=t,this.variableNames=["x"],this.customUniforms=[{name:"index",type:"float"}];const r=this.outputShape.length,a=this.op===VM.Prod?"1.0":"0.0",i=n?a:`getX(${GM(r,"coords",this.op)})`,o=this.outputShape[this.outputShape.length-1];let l="",u="";n?(l=s?"end != "+(o-1):"end != 0",u=s?"end + 1":"end - 1"):(l=s?`end + pow2 < ${o}`:"end >= pow2",u=s?"end + pow2":"end - pow2"),this.userCode=`\n      void main() {\n        ${C_(r)} coords = getOutputCoords();\n        int end = ${HM(r,"coords",this.op)};\n        float val = ${i};\n        int pow2 = int(pow(2.0, index));\n        if (${l}) {\n          int idx = ${u};\n          ${HM(r,"coords",this.op)} = idx;\n          val ${this.op}= getX(${GM(r,"coords",this.op)});\n        }\n        setOutput(val);\n      }\n    `}}function GM(e,t,n){if(1===e)return`${t}`;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw new Error(`Cumulative ${n} for rank ${e} is not yet supported`)}function HM(e,t,n){if(1===e)return`${t}`;if(2===e)return`${t}.y`;if(3===e)return`${t}.z`;if(4===e)return`${t}.w`;throw new Error(`Cumulative ${n} for rank ${e} is not yet supported`)}function jM(e,t,n,s,r,a){const i=t.shape.length,o=Tl([s],i);let l=t;null!=o&&(l=rO({inputs:{x:t},backend:n,attrs:{perm:o}}));const u=$l(1,i)[0];if(u!==i-1)throw new Error(`WebGL cumprod shader expects an inner-most axis=${t.shape.length-1} but got axis=${s}`);const c=l.shape[u];let h=$D({inputs:{x:l},backend:n});for(let t=0;t<=Math.ceil(Math.log2(c))-1;t++){const s=new UM(e,l.shape,!1,a),r=[[t]],i=h;h=n.runWebGLProgram(s,[h],h.dtype,r),n.disposeIntermediateTensorInfo(i)}if(r){const t=new UM(e,l.shape,r,a),s=h;h=n.runWebGLProgram(t,[h],h.dtype),n.disposeIntermediateTensorInfo(s)}if(null!=o){const e=rO({inputs:{x:h},backend:n,attrs:{perm:Cl(o)}});return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(l),e}return h}const qM={kernelName:"Cumprod",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;return jM(VM.Prod,r,n,a,i,o)}};const KM={kernelName:"Cumsum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;return jM(VM.Sum,r,n,a,i,o)}};const XM={kernelName:"DenseBincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=n.readSync(r.dataId),t=n.readSync(a.dataId),s=pF(e,t,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,s)}if(2===r.shape.length){const e=n.bufferSync(r),t=n.bufferSync(a),s=dF(e,t,i,o);return n.makeTensorInfo(s.shape,a.dtype,s.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};class YM{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const ZM={kernelName:"DepthToSpace",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s,o=r.shape[0],l=("NHWC"===i?r.shape[1]:r.shape[2])*a,u=("NHWC"===i?r.shape[2]:r.shape[3])*a,c=("NHWC"===i?r.shape[3]:r.shape[1])/(a*a),h=new YM("NHWC"===i?[o,l,u,c]:[o,c,l,u],a,i);return n.runWebGLProgram(h,[r],r.dtype)}};class JM{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=F_(this.outputShape.length);const a=e.filterHeight,i=e.filterWidth,o=e.outChannels/e.inChannels;let l="",u="";n&&(l=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,u="result = activation(result);");const c=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${l}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${o};\n        int q = d2 - d1 * ${o};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${a}; wR++) {\n          int xR = xRCorner + wR * dilations[0];\n\n          if (xR < 0 || xR >= inDims[0]) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${i}; wC++) {\n            int xC = xCCorner + wC * dilations[1];\n\n            if (xC < 0 || xC >= inDims[1]) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${c}\n        ${u}\n        setOutput(result);\n      }\n    `}}class QM{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=F_(this.outputShape.length);const a=e.outChannels/e.inChannels,o=e.padInfo.left,l=e.strideWidth,u=e.dilationWidth,c=e.filterHeight,h=e.filterWidth,p=h;let d="\n      int xR; int xC; int xCOffset;\n      vec4 wTexel; vec4 previous; vec4 final;";for(let e=0;e<h;e++)d+=`\n          vec4 xTexelC${2*e};\n          int xTexelC${2*e}Ready;\n          vec4 xTexelC${2*e+1};\n          int xTexelC${2*e+1}Ready;\n          vec4 xC${e};`;d+=`\n    for (int r = 0; r < ${c}; r++) {\n      `;for(let e=0;e<h;e++)d+=`\n          xTexelC${2*e} = vec4(0.0);\n          xTexelC${2*e}Ready = 0;\n          xTexelC${2*e+1} = vec4(0.0);\n          xTexelC${2*e+1}Ready = 0;\n          xC${e} = vec4(0.0);`;d+="\n        xR = xRCorner + r * dilations[0];\n        if (xR >=0 && xR < inDims[0]) {\n      ";for(let e=0;e<(p+1)/2;e++){const t=2*e;if(d+=`\n          xC = xCCorner + ${t*u};\n          `,1===l){if(t<h&&(o%2==1?(d+=`\n                xCOffset = xC + 1;\n                if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n              `,d+=1===u&&t>0?`\n                xC${t} = vec4(xTexelC${t-2}.zw, xTexelC${t}.xy);\n                `:`\n                  xCOffset = xC + 1 - 2;\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                    previous = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      previous.zw = vec2(0.0);\n                    }\n\n                    xC${t} = vec4(previous.zw, xTexelC${t}.xy);\n                  } else {\n                    xC${t} = vec4(0.0, 0.0, xTexelC${t}.xy);\n                  }\n                  `):d+=`\n                if (xC >= 0 && xC < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                xC${t} = xTexelC${t};\n                `,t+1<h)){const e=o%2==0?i(u):u;u%2==0&&o%2==1||u%2!=0&&o%2!=1?(d+=`\n                  xCOffset = xC + imod(pads[1], 2) + ${e};\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                    xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      xTexelC${t+1}.zw = vec2(0.0);\n                    }\n                    xTexelC${t+1}Ready = 1;\n                  }\n                  `,d+=u>1?`\n                    xCOffset -= 2;\n                    if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                     previous = getX(batch, xR, xCOffset, d1);\n                     xC${t+1} = vec4(previous.zw, xTexelC${t+1}.xy);\n                    } else {\n                     xC${t+1} = vec4(0.0, 0.0, xTexelC${t+1}.xy);\n                    }\n                    `:`\n                    xC${t+1} = vec4(xTexelC${t}.zw, xTexelC${t+1}.xy);\n                    `):d+=1===e?`\n                    xC${t+1} = xTexelC${t};\n                    `:`\n                    xCOffset = xC + ${e};\n\n                    if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                      xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n                      if (xCOffset + 1 >= inDims[1]) {\n                        xTexelC${t+1}.zw = vec2(0.0);\n                      }\n                      xTexelC${t+1}Ready = 1;\n                    }\n\n                    xC${t+1} = xTexelC${t+1};\n                    `}}else t<h&&(o%2==1?(d+=`\n                xCOffset = xC + 1 - strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xCOffset, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < inDims[1] && xTexelC${t+1}Ready == 0) {\n                  xTexelC${t+1} = getX(batch, xR, xC + 1, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xC + 2 >= inDims[1]) {\n                    xTexelC${t+1}.zw = vec2(0.0);\n                  }\n                  xTexelC${t+1}Ready = 1;\n                }\n\n                xC${t} = vec4(xTexelC${t}.zw, xTexelC${t+1}.zw);\n              `,t+1<h&&(d+=`\n                  final = vec4(0.0);\n                  xCOffset = xC + 1 + strides[1];\n                  if(xCOffset >= 0 && xCOffset < inDims[1]) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xC${t+1} = vec4(xTexelC${t+1}.xy, final.xy);\n                `)):(d+=`\n                if(xC >= 0 && xC < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                xCOffset = xC + strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                  xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t+1}.zw = vec2(0.);\n                  }\n                  xTexelC${t+1}Ready = 1;\n                }\n\n                xC${t} = vec4(\n                  xTexelC${t}.xy, xTexelC${t+1}.xy);\n              `,t+1<h&&(d+=`\n                  xC${t+1} = vec4(xTexelC${t}.zw, xTexelC${t+1}.zw);\n                `)));t<h&&(d+=`\n            wTexel = getW(r, ${t}, d1, q);\n            dotProd += xC${t} * vec4(wTexel.xz, wTexel.xz);\n          `,t+1<h&&(d+=`\n              wTexel = getW(r, ${t+1}, d1, q);\n              dotProd += xC${t+1} * vec4(wTexel.xz, wTexel.xz);\n            `))}d+="\n    }\n  ",d+="\n      }\n    ";let f="",m="";n&&(f=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,m="result = activation(result);");const g=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${f}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${a};\n        int q = d2 - d1 * ${a};\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        //intialize dotProd with a small epsilon seems to reduce GPU accuracy loss.\n        vec4 dotProd = vec4(0.000000000000001);\n\n        ${d}\n\n        vec4 result = dotProd - vec4(0.000000000000001);\n        ${g}\n        ${m}\n        setOutput(result);\n      }\n    `}}const eL={kernelName:"DepthwiseConv2dNative",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l,dimRoundingMode:c}=s;let h=l;null==h&&(h=[1,1]),u(yo(i,h),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${h}'`));const p=lo(r.shape,a.shape,i,h,o,c,!0);let d;d=K().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new QM(p):new JM(p);const f=[[p.padInfo.top,p.padInfo.left],[p.strideHeight,p.strideWidth],[p.dilationHeight,p.dilationWidth],[p.inHeight,p.inWidth]];return n.runWebGLProgram(d,[r,a],"float32",f)}};class tL{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class nL{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=t-1-e.padInfo.top,i=n-1-e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const sL={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s,h=lo(r.shape,c,i,o,l,u,!0),p=new tL(h);return n.runWebGLProgram(p,[r,a],"float32")}};const rL={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s,h=lo(c,a.shape,i,o,l,u,!0),p=new nL(h);return n.runWebGLProgram(p,[r,a],"float32")}};class aL{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const iL={kernelName:"Diag",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=[...s.shape,...s.shape],a=p(s.shape),i=KD({inputs:{x:s},backend:n,attrs:{shape:[a]}}),o=new aL(a),l=n.runWebGLProgram(o,[i],i.dtype),u=KD({inputs:{x:l},backend:n,attrs:{shape:r}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),u}};class oL{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:t,inWidth:n,padInfo:s,strideHeight:r,strideWidth:a,filterHeight:i,filterWidth:o,dilationHeight:l,dilationWidth:u}=e,{top:c,left:h}=s;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${a});\n      const ivec2 pads = ivec2(${c}, ${h});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${l};\n\n          if (hIn >= 0 && hIn < ${t}) {\n            for (int w = 0; w < ${o}; w++) {\n              int wIn = wBeg + w * ${u};\n\n              if (wIn >= 0 && wIn < ${n}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const lL={kernelName:"Dilation2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=ao(r.shape,a.shape,i,o,"NHWC",l);let c;const h=new oL(u);c=n.runWebGLProgram(h,[r,a],"float32");const p=KD({inputs:{x:c},backend:n,attrs:{shape:u.outShape}});return n.disposeIntermediateTensorInfo(c),p}};const uL={kernelName:"Einsum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=Uf(r,a.length);Hf(i.length,l,a);const{path:u,steps:c}=jf(o,l),h=c.length;let p=null,d=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=Gf(d,l[t]);let r;qf(e)?r=a[t]:(r=rO({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);f(r.shape,i)||(r=KD({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=jD({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=nO({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-d),keepDims:!1}}),m.push(p)),d--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}},cL={kernelName:"Elu",backendName:"webgl",kernelFunc:zD({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"})},hL={kernelName:"EluGrad",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n}=e,{dy:s,y:r}=t,a=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new CD("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",s.shape,r.shape):new SD("return (b >= 0.0) ? a : a * (b + 1.0);",s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}},pL={kernelName:"Equal",backendName:"webgl",kernelFunc:PD({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool",cpuKernelImpl:bF})},dL=zD({opSnippet:'\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = 0.3275911;\n  float a1 = 0.254829592;\n  float a2 = -0.284496736;\n  float a3 = 1.421413741;\n  float a4 = -1.453152027;\n  float a5 = 1.061405429;\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n'}),fL={kernelName:et,backendName:"webgl",kernelFunc:dL},mL=zD({opSnippet:"if (isnan(x)) return x;\n  return exp(x);\n",packedOpSnippet:"\n  vec4 result = exp(x);\n  bvec4 isNaN = isnan(x);\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",cpuKernelImpl:xF,dtype:"float32"}),gL={kernelName:nt,backendName:"webgl",kernelFunc:mL};function yL(e){const{inputs:t,attrs:n,backend:s}=e,{dim:r}=n,{input:a}=t,i=a.shape.length